#ifndef __KK_DEVICE_MANAGER_H
#define __KK_DEVICE_MANAGER_H
#include "kk_test.h"
#include "kk_sub_tsl.h"
#include "kk_tsl_zigbee_map.h"
#include "kk_product_code.h"
#include "kk_zb_com.h"

/****************** ******************************************************************
* File Name			: kk_device_manager.h
* Author			: yjq
* data				: 2020/09/01
*************************************************************************************/


#define KK_MAX_SUPPORT_ENDPOINT_NUMBER				32
#define KK_MAX_READ_MODLE_ID_COUNT					30

#define KK_NETWORK_PARAMETER_TX_POWER						10
#define KK_NETWORK_PARAMETER_CHANNEL						0x0B



void kk_productCode_tick();
void kk_read_attr_response(EmberNodeId nodeId,
										uint8_t ep,
										EmberAfClusterId cluster,
										EmberAfAttributeId attribute,
										uint8_t status,
										uint8_t dataType,
										uint8_t dataSize,
										uint8_t *data);


int kk_permit_join(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data);



void kk_load_dev_map_table(void);
void kk_add_dev_map_table_to_list(cJSON * root);
char *kk_match_productCode(const char* modelId);


bool kk_device_config_map_add(const char *productCode);
typedef int (*kk_rpc_set)(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data);
typedef int(*kk_rpc_report)(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data);



typedef struct kk_dev_config_item{
	char * identity;
	char * reportFuncName;
	char * controlFuncName;
	kk_rpc_report * reportFunc;
	kk_rpc_set * controlFunc;
	uint8_t endpoint;
	uint16_t cluster;
	uint16_t attribute;
	struct kk_dev_config_item * next;
}kk_dev_config_item;


typedef struct kk_dev_config_map{
	char * productCode;
	kk_dev_config_item item;
	struct kk_dev_config_map *next;
}kk_dev_config_map;








#endif

