/*******************************************************************************
 * Copyright (c) 2012, 2020 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *   https://www.eclipse.org/legal/epl-2.0/
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial contribution
 *******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include "MQTTAsync.h"
#include "mqtt_api.h"
#include "com_api.h"
#include "kk_product.h"


static int mqtt_start(void)
{
	int count = 0;
	MQTTAsync mqttClient;
	int rc = 0;
	mqttClient = KK_MQTT_Connect();
	if(mqttClient == NULL)
	{
		WARNING_PRINT("KK_MQTT_Connect FAIL!!!\n");
	}
	else
	{
		INFO_PRINT("Waiting for publication of %s\n"
		           "on topic %s for client with ClientID: %s\n",
		           PAYLOAD, TOPIC, CLIENTID);
	}
	while(1)
	{
		usleep(100000L);
		count++;
		if(count>50)
		{
			count = 0;
			//INFO_PRINT("i am send now\n");
			//KK_MQTT_SendMsg(TOPIC,"hello my world",2);
		}

	}
	INFO_PRINT("MQTTAsync_destroy\n");
	MQTTAsync_destroy(&mqttClient);
	return rc;

}

int main(int argc, char* argv[])
{
	int rc = 0;
		
	//KK_Data_Hdl_Init();
	kk_zlog_init("kcloud");

	/*set the callback to get the device date to cloud*/
	kk_ipc_init(IPC_APP2MID,KK_Data_FromDev,NULL,NULL);
	rc = mqtt_start();

	return rc;
}

