#include "kk_tsl_zigbee_map.h"
#include "kk_test.h"
#include "kk_product_code.h"



kk_tsl_zigbee_map_t g_tsl_zigbee_map[] = {
	{"NetChannelState",KK_DUMMY_EP,rpc_nwkPermitJoin,0xffff,0xffff,NULL},
	{"OperationMode",KK_PRIMARY_EP,kk_tsl_set_windowCovering_OperationMode,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID,kk_tsl_report_global_onoff},//开
	{"WorkMode",KK_PRIMARY_EP,kk_tsl_set_windowCovering_mode,ZCL_WINDOW_COVERING_CLUSTER_ID,ZCL_MODE_ATTRIBUTE_ID,kk_tsl_report_windowCovering_mode},
	{"Position",KK_PRIMARY_EP,kk_tsl_set_windowCovering_position,ZCL_WINDOW_COVERING_CLUSTER_ID,ZCL_CURRENT_LIFT_PERCENTAGE_ATTRIBUTE_ID,kk_tsl_report_windowCovering_position},
};

int kk_get_tsl_index(unsigned char EP,unsigned short clusterId,unsigned short attributeId)
{
	int i;
	
	for(i=0;i<sizeof(g_tsl_zigbee_map)/sizeof(kk_tsl_zigbee_map_t);i++){
		if( EP == g_tsl_zigbee_map[i].endpoint &&
			clusterId == g_tsl_zigbee_map[i].clusterId &&
			attributeId == g_tsl_zigbee_map[i].attributeId){
			return i;
		}
	}
	return -1;
}
int kk_get_tsl_num(void)
{
	return sizeof(g_tsl_zigbee_map) / sizeof(kk_tsl_zigbee_map_t);
}



