#ifndef __KK_ZIGBEE_API_H
#define __KK_ZIGBEE_API_H
#include "kk_test.h"


EmberStatus kk_network_form(bool centralized,EmberPanId panId,int8_t radioTxPower,uint8_t channel);
void kk_print_network_info(void);


EmberStatus zclGRead(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				bool svr);
EmberStatus zclGWrite(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				uint8_t dataType,
				uint8_t dataLen,
				uint8_t *data,
				bool svr);



EmberStatus zclOnOff_On(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Off(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Toggle(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OffWithEffect(uint16_t node,uint8_t ep,uint8_t id,uint8_t var);
EmberStatus zclOnOff_OnWithRecallGlobalScene(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OnWithTimedOff(uint16_t node,uint8_t ep,uint8_t Control,uint16_t OnTime,uint16_t OffWaitTime);

EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep);
EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep);
EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep);
EmberStatus WindowCover_GotoLiftPercentage(uint16_t node,uint8_t ep,uint8_t position);

EmberStatus zclColorControlMovetohue(uint16_t node,
										uint8_t ep,
										uint8_t hue,
										uint8_t dir,
										uint16_t trsTime,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlMovehue(uint16_t node,
										uint8_t ep,
										uint8_t mode,
										uint8_t rate,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlStephue(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlMovetosat(uint16_t node,
												uint8_t ep,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlMovesat(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint8_t rate,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepsat(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);

EmberStatus zclColorControlMovetohueandsat(uint16_t node,
														uint8_t ep,
														uint8_t hue,
														uint8_t saturation,
														uint16_t trsTime,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlMovetocolor(uint16_t node,
													uint8_t ep,
													uint16_t colorX,
													uint16_t colorY,
													uint16_t trsTime,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolor(uint16_t node,
												uint8_t ep,
												uint16_t rateX,
												uint16_t rateY,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepcolor(uint16_t node,
												uint8_t ep,
												uint16_t stepX,
												uint16_t stepY,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlMovetocolortemp(uint16_t node,
															uint8_t ep,
															uint16_t colorTemp,
															uint16_t trsTime,
															bool options,
															uint8_t mask,
															uint8_t Override);

EmberStatus zclColorControlEmovetohue(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t dir,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlEmovehue( uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint16_t rate,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlEstephue(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint16_t size,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlEmovetohueandsat(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlLoopSet(uint16_t node,
											uint8_t ep,
											uint8_t flags,
											uint8_t action,
											uint8_t dir,
											uint16_t time,
											uint16_t sHue,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlStopmovestep(uint16_t node,
													uint8_t ep,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t rate,
														uint16_t Tmin,
														uint16_t Tmax,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlStepcolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t size,
														uint16_t trsTime,
														uint16_t minimum,
														uint16_t maximum,
														bool options,
														uint8_t mask,
														uint8_t Override);














#endif
