#include "kk_zigbee_api.h"


EmberStatus kk_network_form(bool centralized,EmberPanId panId,int8_t radioTxPower,uint8_t channel)
{
	EmberStatus status = emberAfPluginNetworkCreatorNetworkForm(centralized,
																panId,
																radioTxPower,
																channel);

																

	emberAfAppPrintln("[network form]centralized:%p,PAN ID:0x%2x,TxPower:%d,channel:0x%x,status=0x%x",
						(centralized==true)?"yes":"no",
						panId,
						radioTxPower,
						channel,
						status);
	return status;
}

void kk_print_network_info(void)
{
	emberAfAppPrint("\r\nMAC Address		= " );
	EmberEUI64 eui64;
	emberAfGetEui64(eui64);
	emberAfPrintBigEndianEui64(eui64);
	emberAfAppFlush();
	if (ezspNetworkState()== EMBER_JOINED_NETWORK ){
		emberAfAppPrintln("\r\nNode ID		= 0x%2x", 	emberAfGetNodeId() );
		emberAfAppPrintln("\r\nPANID		= 0x%2x", 	emberAfGetPanId() );
		emberAfAppPrintln("\r\nChannel		= 0x%x",		emberAfGetRadioChannel() );
		emberAfAppPrintln("\r\nTX Power(dBm)= %d", 	emberAfGetRadioChannel() );
		emberAfAppFlush();
	
		EmberKeyStruct nwkKey;
			
		if ( emberGetKey(EMBER_CURRENT_NETWORK_KEY,&nwkKey) == EMBER_SUCCESS )
		{
			emberAfAppPrintln("\r\nNetwork Key	 = " );
			emberAfPrintZigbeeKey(emberKeyContents(&nwkKey.key));
			emberAfAppFlush();
		}
		
	}else{
		emberAfAppPrintln( "\r\nNot joined network: Network Satus: 0x%x\r\n", emberNetworkState() );
	}
}


EmberStatus zclGRead(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				bool svr)
{
	EmberStatus status;

	zclBufferSetup(ZCL_GLOBAL_COMMAND | ((svr==true)?
											ZCL_FRAME_CONTROL_CLIENT_TO_SERVER
											:ZCL_FRAME_CONTROL_SERVER_TO_CLIENT),
					clusterId,
					ZCL_READ_ATTRIBUTES_COMMAND_ID);
	
	zclBufferAddByte(LOW_BYTE(attrId));
	zclBufferAddByte(HIGH_BYTE(attrId));

	rpcBufferPrint();
	status = rpcSendCommand(node,srcEP,dstEP,multicast);
	return status;
}

EmberStatus zclGWrite(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				uint8_t dataType,
				uint8_t dataLen,
				uint8_t *data,
				bool svr)
{
	EmberStatus status = EMBER_ERR_FATAL;
	int i;
	if(data==NULL||dataLen==0) return status;

	zclBufferSetup(ZCL_GLOBAL_COMMAND | ((svr==true)?
											ZCL_FRAME_CONTROL_CLIENT_TO_SERVER
											:ZCL_FRAME_CONTROL_SERVER_TO_CLIENT),
					clusterId,
					ZCL_WRITE_ATTRIBUTES_COMMAND_ID);
	
	zclBufferAddByte(LOW_BYTE(attrId));
	zclBufferAddByte(HIGH_BYTE(attrId));
	zclBufferAddByte(dataType);
	for(i=0;i<dataLen;i++){
		zclBufferAddByte(data[i]);
	}

	rpcBufferPrint();
	status = rpcSendCommand(node,srcEP,dstEP,multicast);
	return status;
}

//
EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_UP_OPEN_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Up/Open]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_DOWN_CLOSE_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Down/Close]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_STOP_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Stop]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus WindowCover_GotoLiftPercentage(uint16_t node,uint8_t ep,uint8_t position)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_WINDOW_COVERING_CLUSTER_ID,
									ZCL_WINDOW_COVERING_GO_TO_LIFT_PERCENTAGE_COMMAND_ID);
	zclBufferAddByte(position);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[GotoLiftPercentage]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_On(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_ON_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[On]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_Off(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_OFF_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Off]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus zclOnOff_Toggle(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_TOGGLE_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Toggle]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}
EmberStatus zclOnOff_OffWithEffect(uint16_t node,uint8_t ep,uint8_t id,uint8_t var)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_OFF_WITH_EFFECT_COMMAND_ID);

	zclBufferAddByte(id);
	zclBufferAddByte(var);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[off with effect]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_OnWithRecallGlobalScene(uint16_t node,uint8_t ep)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_ON_WITH_RECALL_GLOBAL_SCENE_COMMAND_ID);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[On with recall global scene]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclOnOff_OnWithTimedOff(uint16_t node,uint8_t ep,uint8_t Control,uint16_t OnTime,uint16_t OffWaitTime)
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_ON_OFF_CLUSTER_ID,
									ZCL_ON_WITH_TIMED_OFF_COMMAND_ID);

	zclBufferAddByte(Control);
	zclBufferAddWord(OnTime);
	zclBufferAddWord(OffWaitTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[on with timed off]node=0x%02X,ep=%d,status=0x%02X\n",node,ep,status);
	return status;
}

EmberStatus zclColorControlMovetohue(uint16_t node,
										uint8_t ep,
										uint8_t hue,
										uint8_t dir,
										uint16_t trsTime,
										bool options,
										uint8_t mask,
										uint8_t Override) {

	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_HUE_COMMAND_ID);
	zclBufferAddByte(hue);
	zclBufferAddByte(dir);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	kk_print_debug("hue=%d,dir=%d,trsTime=%d,mask=%d,Override=%d\r\n",
					hue,dir,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to hue]status=0x%02X\n",status);


	return status;
}
EmberStatus zclColorControlMovehue(uint16_t node,
										uint8_t ep,
										uint8_t mode,
										uint8_t rate,
										bool options,
										uint8_t mask,
										uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_HUE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(rate);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=0x%02x,rate=0x%02x,mask=0x%02x,Override=0x%02x\r\n",
						mode,rate,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move hue]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStephue(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STEP_HUE_COMMAND_ID);
	
	zclBufferAddByte(mode);
	zclBufferAddByte(size);
	zclBufferAddByte(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("step mode=%d,step size=%d,transition time=%d,mask=%d,override=%d\r\n",
					mode,size,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Step hue]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovetosat(uint16_t node,
												uint8_t ep,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_SATURATION_COMMAND_ID);
	zclBufferAddByte(saturation);
	zclBufferAddWord(trsTime); 
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}

	emberAfCorePrintln("saturation=%d,trsTime=%d,options mask=%d,options override=%d\r\n",
					saturation,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovesat(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint8_t rate,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_SATURATION_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(rate);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("move mode=0x%02x,rate=0x%02x,mask=0x%02x,Override=0x%02x\r\n",
					mode,rate,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStepsat(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
							ZCL_STEP_SATURATION_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddByte(size);
	zclBufferAddByte(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}

	emberAfCorePrintln("step mode=%d,step size=%d,transition time=%d,mask=%d,override=%d\r\n",
					mode,size,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovetohueandsat(uint16_t node,
														uint8_t ep,
														uint8_t hue,
														uint8_t saturation,
														uint16_t trsTime,
														bool options,
														uint8_t mask,
														uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
							ZCL_MOVE_TO_HUE_AND_SATURATION_COMMAND_ID);

	zclBufferAddByte(hue);
	zclBufferAddByte(saturation);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("hue=%d,saturation=%d,trsTime=%d,mask=%d,Override=%d\r\n",
					hue,saturation,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to hue and Saturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovetocolor(uint16_t node,
													uint8_t ep,
													uint16_t colorX,
													uint16_t colorY,
													uint16_t trsTime,
													bool options,
													uint8_t mask,
													uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_COLOR_COMMAND_ID);
	zclBufferAddWord(colorX);
	zclBufferAddWord(colorY);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override); 
	}

	emberAfCorePrintln("color x=%d,color y=%d,transition time=%d,options mask=0x%02x,options override=0x%02x\r\n",
					colorX,colorY,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to color]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlMovecolor(uint16_t node,
												uint8_t ep,
												uint16_t rateX,
												uint16_t rateY,
												bool options,
												uint8_t mask,
												uint8_t Override) 
{
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_COLOR_COMMAND_ID);
	zclBufferAddWord(rateX);
	zclBufferAddWord(rateY);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("rateX=%d,rateY=%d,mask=%d,override=%d\r\n",rateX,rateY,mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move color]status=0x%02X\n",status);
	return status;

}
EmberStatus zclColorControlStepcolor(uint16_t node,
												uint8_t ep,
												uint16_t stepX,
												uint16_t stepY,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STEP_COLOR_COMMAND_ID);
	
	zclBufferAddWord(stepX);
	zclBufferAddWord(stepY);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}

	emberAfCorePrintln("step x=%d,step y=%d,transition time=%d,options mask=%d,options override=%d\r\n",
		stepX,stepY,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Step color]status=0x%02X\n",status);
	return status;
}

EmberStatus zclColorControlMovetocolortemp(uint16_t node,
															uint8_t ep,
															uint16_t colorTemp,
															uint16_t trsTime,
															bool options,
															uint8_t mask,
															uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_TO_COLOR_TEMPERATURE_COMMAND_ID);
	zclBufferAddWord(colorTemp);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	
	emberAfCorePrintln("colorTemp=%d,trsTime=%d,mask=%d,Override=%d\r\n",
					colorTemp,trsTime,mask,Override);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Move to color temperature]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlEmovetohue(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t dir,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									 ZCL_ENHANCED_MOVE_TO_HUE_COMMAND_ID);
	zclBufferAddWord(hue);
	zclBufferAddByte(dir);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("hue=%d,dir=%d,trsTime=%d\r\n",hue,dir,trsTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced Move to hue]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlEmovehue( uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint16_t rate,
											bool options,
											uint8_t mask,
											uint8_t Override){
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup(ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_ENHANCED_MOVE_HUE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddWord(rate);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=%d,rate=%d\r\n",mode,rate);
	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced Move hue]status=0x%02X\n",status);
	return status;
}

EmberStatus zclColorControlEstephue(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint16_t size,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_ENHANCED_STEP_HUE_COMMAND_ID);	
	zclBufferAddByte(mode);
	zclBufferAddWord(size);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=%d,size=%d,trsTime=%d\r\n",mode,size,trsTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced step hue]status=0x%02X\n",status);
	return status;
}

EmberStatus zclColorControlEmovetohueandsat(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_ENHANCED_MOVE_TO_HUE_AND_SATURATION_COMMAND_ID);
	zclBufferAddWord(hue);
	zclBufferAddByte(saturation);
	zclBufferAddWord(trsTime);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("hue=%d,saturation=%d,trsTime=%d\r\n",hue,saturation,trsTime);

	status = rpcSendCommand(node,1,ep,false);
	kk_print_debug("[Enhanced move hue and sauturation]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlLoopSet(uint16_t node,
											uint8_t ep,
											uint8_t flags,
											uint8_t action,
											uint8_t dir,
											uint16_t time,
											uint16_t sHue,
											bool options,
											uint8_t mask,
											uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_COLOR_LOOP_SET_COMMAND_ID);
	zclBufferAddByte(flags);
	zclBufferAddByte(action);
	zclBufferAddByte(dir);
	zclBufferAddWord(time);
	zclBufferAddWord(sHue);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("update flags=%d,action=%d,direction=%d,time=%d,start hue=%d\r\n",
						flags,action,dir,time,sHue);
	status = rpcSendCommand(node,1,ep,false);

	emberAfCorePrintln("[Color loop set]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStopmovestep(uint16_t node,
													uint8_t ep,
													bool options,
													uint8_t mask,
													uint8_t Override) {
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STOP_MOVE_STEP_COMMAND_ID);

	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("options mask=%d,options override=%d\r\n",mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Stop Move step]status=0x%02X\n",status);
	return status;

}
EmberStatus zclColorControlMovecolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t rate,
														uint16_t Tmin,
														uint16_t Tmax,
														bool options,
														uint8_t mask,
														uint8_t Override)
{
	EmberStatus status;

	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_MOVE_COLOR_TEMPERATURE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddWord(rate);
	zclBufferAddWord(Tmin);
	zclBufferAddWord(Tmax);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("mode=%d,rate=%d,Tmin=%d,Tmax=%d,mask=%d,Override=%d\r\n",
						mode,rate,Tmin,Tmax,mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Move color temperature]status=0x%02X\n",status);
	return status;
}
EmberStatus zclColorControlStepcolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t size,
														uint16_t trsTime,
														uint16_t minimum,
														uint16_t maximum,
														bool options,
														uint8_t mask,
														uint8_t Override) {
	EmberStatus status;
	zcl_clu_client_cmd_buffer_setup( ZCL_COLOR_CONTROL_CLUSTER_ID,
									ZCL_STEP_COLOR_TEMPERATURE_COMMAND_ID);
	zclBufferAddByte(mode);
	zclBufferAddWord(size);
	zclBufferAddWord(trsTime);
	zclBufferAddWord(minimum);
	zclBufferAddWord(maximum);
	if(options==true){
		zclBufferAddByte(mask);
		zclBufferAddByte(Override);
	}
	emberAfCorePrintln("step mode=%d,step size=%d,transition time=%d,minimum=%d,maximum=%d,mask=%d,override=%d\r\n",
						mode,size,trsTime,minimum,maximum,mask,Override);

	status = rpcSendCommand(node,1,ep,false);
	emberAfCorePrintln("[Step color temperature]status=0x%02X\n",status);
	return status;
}

