#include "kk_tsl_property_set.h"


//emberAfAppPrintln("[tsl report:Gloabl] OnOff~~~~~~~~~");

//cJSON *rpc_Control(jrpc_context * ctx, cJSON *params, cJSON *id,cJSON *mac)
cJSON *kk_tsl_property_operation(jrpc_context * ctx, cJSON *params, cJSON *id,cJSON *mac)
{
    sub_dev_node_t *node = NULL;
	int res = 0;
	rpc_nwk_info_s info;
	EmberStatus status;
	int index = 0;
	int num;
    cJSON *propertyItem = NULL;
	EmberEUI64 eui64;
	EmberNodeId nodeId = EMBER_AF_PLUGIN_DEVICE_TABLE_NULL_NODE_ID;
	UTIL_LOG_INFO("\n********************kk tsl property operation********************\n");

	if(params == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		res = kk_sub_tsl_get_device_by_mac(mac->valuestring, &node);
		if (res != SUCCESS_RETURN) {
			printf("[%s][%d]\n",__FUNCTION__,__LINE__);
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
		
		num = kk_get_tsl_num();
		for(index = 0; index < num; index++){	
			propertyItem = rpc_cJSON_GetObjectItem(params, g_tsl_zigbee_map[index].Identity);
			if(propertyItem != NULL)
			{		
				int value = 0;
				if(propertyItem->type != cJSON_Number){
					value = rpc_get_u8(propertyItem->valuestring);
				}else{
					value = propertyItem->valueint;
				}
				
				if(rpc_get_mac(mac->valuestring,eui64)==false){
					set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
					goto error_return;
				}
				nodeId = emberAfDeviceTableGetNodeIdFromEui64(eui64);

				emberAfDebugPrint("mac:");
				emberAfPrintBigEndianEui64(eui64);
				emberAfDebugPrintln(",node:0x%04X",nodeId);
				
				res = g_tsl_zigbee_map[index].zigbee_set(ctx,mac->valuestring,g_tsl_zigbee_map[index].endpoint,&value);
				if(res < 0)
				{
					set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
					goto error_return;
				}
				else{
					return rpc_cJSON_CreateNumber(res);
				}			
			}
		}
	}
error_return:
	return rpc_cJSON_CreateNull();
}



int kk_tsl_set_windowCovering_OperationMode(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data)
{
	uint8_t Operation	= 0;
	EmberStatus status = 0;

	Operation = *(uint8_t*)data;
	emberAfAppPrintln("[tsl set:Window Covering Operation Mode],mode=0x%02x",Operation);

	if(node==EMBER_AF_PLUGIN_DEVICE_TABLE_NULL_NODE_ID){
		if(ctx)
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}
	
	if(Operation==0){
		status = WindowCover_UpOpen(node,ep);
		emberAfAppPrintln("Up/Open");
	}else if(Operation==1){
		status = WindowCover_DownClose(node,ep);
		emberAfAppPrintln("Down/Close");
	}else if(Operation==2){
		status = WindowCover_Stop(node,ep);
		emberAfAppPrintln("Stop");
	}else{
		if(ctx)
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}

	emberAfAppPrintln("status=0x%02x",status);
	return status;
error_return:
	return -1;
}

int kk_tsl_set_windowCovering_mode(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data)
{
	uint8_t mode	= 0;
	uint8_t WCmode	= 0;
	EmberStatus status = 0;

	mode = *(uint8_t*)data;
	emberAfAppPrintln("[tsl set:Window Covering Run Mode],mode=0x%02x",mode);

	if(mode==WC_calibration_mode){
		WCmode |= BIT(1);
	
		status = zclGWrite(node,1,ep,false,ZCL_WINDOW_COVERING_CLUSTER_ID,
					ZCL_MODE_ATTRIBUTE_ID,
					ZCL_BITMAP8_ATTRIBUTE_TYPE,
					1,
					WCmode,
					true);
		emberAfAppPrintln("Calibration Mode");
	}else if(mode==WC_reversed_dir){
		WCmode |= BIT(0);
		status = zclGWrite(node,1,ep,false,ZCL_WINDOW_COVERING_CLUSTER_ID,
							ZCL_MODE_ATTRIBUTE_ID,
							ZCL_BITMAP8_ATTRIBUTE_TYPE,
							1,
							WCmode,
							true);
		emberAfAppPrintln("Dir:reversed");
	}else if(mode==WC_normal_dir){
		WCmode = 0;
		status = zclGWrite(node,1,ep,false,ZCL_WINDOW_COVERING_CLUSTER_ID,
						ZCL_MODE_ATTRIBUTE_ID,
						ZCL_BITMAP8_ATTRIBUTE_TYPE,
						1,
						WCmode,
						true);
		emberAfAppPrintln("Dir:Normal");
	}else{
		if(ctx)
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}
	emberAfAppPrintln("status=0x%02x",status);
	return status;
error_return:
	return -1;
}
int kk_tsl_set_windowCovering_position(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data)
{
	uint8_t position	= 0;
	EmberStatus status = 0;

	position = *(uint8_t*)data;
	emberAfAppPrintln("[tsl set:Window Covering Position],position=0x%02x",position);

	status = WindowCover_GotoLiftPercentage(node,ep,position);

	emberAfAppPrintln("status=0x%02x",status);
	return status;
error_return:
	return -1;
}






















