#include "kk_tsl_property_report.h"


const char *kk_tsl_rpt_status_string[] = {
	"Success",
	"Error",
	"Invaild Value",
	"Invaild Len",
	"Invaild Type"
};
static int kk_tsl_report(EmberEUI64 mac,uint8_t EP,int status,uint16_t clusterId,uint16_t attributeId)
{
	cJSON* root;
	int index;
	sub_dev_node_t *node = NULL;
	char macString[RPC_EUI64_STRING_LENGTH];
	rpc_eui64ToString(mac,macString);

	root = rpc_cJSON_CreateObject();
	
	index = kk_get_tsl_index(EP,clusterId,attributeId);
	
	if(index < 0) return tsl_rpt_err;

	rpc_cJSON_AddNumberToObject(root, g_tsl_zigbee_map[index].Identity,status);
	kk_rpc_report_status(root,mac);
	return tsl_rpt_success;
}



void kk_tsl_report_attribute(EmberEUI64 eui64,
									uint8_t EP,
									EmberAfClusterId clusterId,
									EmberAfAttributeId attributeId,
									uint8_t dataType,
									uint8_t len,
									uint8_t *data)
{
	int i,j,num,status;

	UTIL_LOG_INFO("\n********************kk tsl report attribute********************\n");
	emberAfDebugPrint("mac:");
	emberAfGetEui64(eui64);
	emberAfPrintBigEndianEui64(eui64);
	emberAfDebugPrintln(",ep:%d,clu:0x%04X,attr:0x%04X,dataType=0x%02x,len=%d,data:",
						EP,clusterId,attributeId,dataType,len);
	emberAfDebugPrintBuffer(data,len,true);

	num = kk_get_tsl_num();
	for(i=0;i<num;i++){
		if( g_tsl_zigbee_map[i].clusterId == clusterId &&
			g_tsl_zigbee_map[i].attributeId == attributeId &&
			g_tsl_zigbee_map[i].zigbee_report!=NULL){
			status = g_tsl_zigbee_map[i].zigbee_report(eui64,EP,clusterId,attributeId,dataType,len,data);
			emberAfDebugPrintln("report status:%s",kk_tsl_rpt_status_string[status]);
			return ;
		}
	}
}


int kk_tsl_report_global_onoff(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t OnOff;
	emberAfAppPrintln("[tsl report:Gloabl] OnOff~~~~~~~~~");
	if(dataType == ZCL_BOOLEAN_ATTRIBUTE_TYPE){
		if(len==1){
			OnOff = data[0];
			if(OnOff==0 || OnOff==1){
				kk_tsl_report(eui64,EP,OnOff,clusterId,attributeId);
				return tsl_rpt_success;
			}
			return tsl_rpt_invaild_val;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

int kk_tsl_report_windowCovering_mode(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t mode;
	emberAfAppPrintln("[tsl report:Window Covering] Mode~~~~~~~~~");

	if(dataType == ZCL_BITMAP8_ATTRIBUTE_TYPE){
		if(len==1){
			if(data[0]&BIT(1)){
				mode = WC_calibration_mode;
			}else if(data[0]&BIT(0)){
				mode = WC_reversed_dir;
			}else{
				mode = WC_normal_dir;
			}

			kk_tsl_report(eui64,EP,mode,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}
int kk_tsl_report_windowCovering_position(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data)
{
	uint8_t position;
	emberAfAppPrintln("[tsl report:Window Covering] Position~~~~~~~~~");

	if(dataType == ZCL_INT8U_ATTRIBUTE_TYPE){
		if(len==1){
			position = data[0];
			kk_tsl_report(eui64,EP,position,clusterId,attributeId);
			return tsl_rpt_success;
		}
		return tsl_rpt_invaild_len;
	}
	return tsl_rpt_invaild_type;
}

















