#ifndef __KK_DEVICE_MANAGER_H
#define __KK_DEVICE_MANAGER_H
#include "kk_test.h"
#include "kk_sub_tsl.h"
#include "kk_tsl_zigbee_map.h"
#include "kk_product_code.h"
/****************** ******************************************************************
* File Name			: kk_device_manager.h
* Author			: yjq
* data				: 2020/09/01
*************************************************************************************/

typedef struct kk_device_table_s{
	EmberEUI64 mac;
	EmberNodeId nodeId;
	uint16_t deviceId;
	uint16_t identifyCnt;
	char *productCode;
	struct kk_device_table_s *next;
}kk_device_table_s;
#define KK_MAX_SUPPORT_ENDPOINT_NUMBER				32
#define KK_MAX_READ_MODLE_ID_COUNT					30


void kk_print_device_table(void);
kk_device_table_s * kk_device_find_by_mac(EmberEUI64 mac);
void kk_device_table_add(EmberEUI64 mac,EmberNodeId nodeId,const char *productCode,uint16_t deviceId);

void kk_device_table_delete(EmberEUI64 mac);

void kk_add_device_to_table(EmberEUI64 mac,EmberNodeId nodeId,uint16_t deviceId);

void kk_productCode_tick();
void kk_read_attr_response(EmberNodeId nodeId,
										uint8_t ep,
										EmberAfClusterId cluster,
										EmberAfAttributeId attribute,
										uint8_t status,
										uint8_t dataType,
										uint8_t dataSize,
										uint8_t *data);


















#endif

