#ifndef __KK_DM_MNG__
#define __KK_DM_MNG__
#include "com_api.h"
#include "kk_tsl_common.h"
#include "klist.h"

#include "iotx_dm.h"

#define KK_DM_DEVICE_CCU  (0x01)
#define KK_DM_DEVICE_SUBDEV  (0x02)
#define KK_DM_DEVICE_GATEWAY (0x04)
#define KK_MID_SYNC_DEFAULT_TIMEOUT_MS (200)
#define IDENTIFY_MAXLEN      (64 + 1)
#define KK_DM_CCU_DEVICE_PRODUCT_TYPE "ccu"
#define KK_DM_CCU_DEVICE_PRODUCT_CODE "15"
#define KK_DM_GW_DEVICE_PRODUCT_TYPE "gw"
#define KK_DM_GW_DEVICE_PRODUCT_CODE "2"

typedef struct {
    int devid;
    int dev_type;
    kk_tsl_t *dev_shadow;
    char mac[DEVICE_MAC_MAXLEN];
    char productCode[PRODUCT_CODE_MAXLEN];
    char deviceCode[DEVICE_CODE_MAXLEN];
	char fatherDeviceCode[DEVICE_CODE_MAXLEN];
	char isOffline;
	int hb_timeout; //heartbeat time
	uint64_t timestamp;
    struct list_head linked_list;
} dm_mgr_dev_node_t;

typedef struct {
    void *mutex;
    int global_devid;
    struct list_head dev_list;
} dm_mgr_ctx;

typedef struct {
    int msgid;
    int devid;
    //const char *service_prefix;
    //const char *service_name;
    char *msgTypeStr;
    char identity[IDENTIFY_MAXLEN];	
    char productCode[PRODUCT_CODE_MAXLEN];
    char deviceCode[DEVICE_CODE_MAXLEN];
    char *params;
    int params_len;
    char *method;
    //iotx_cm_data_handle_cb callback;
} dm_msg_request_t;
typedef struct {
	char *msgTypeStr;
    char productCode[PRODUCT_CODE_MAXLEN];
    char deviceCode[DEVICE_CODE_MAXLEN];

	iotx_dm_error_code_t code;
} kk_msg_response_t;

#endif
