// This file is generated by Simplicity Studio.  Please do not edit manually.
//
//

// Enclosing macro to prevent multiple inclusion
#ifndef SILABS_EMBER_AF_CALLBACK_PROTOTYPES
#define SILABS_EMBER_AF_CALLBACK_PROTOTYPES


/**
 * @addtogroup callback Application Framework V2 callback interface Reference
 * This header provides callback function prototypes to interface the
 * developer's application code with the Ember Application Framework.
 * @{
 */


#include "app/framework/include/af-types.h"
#include "app/framework/util/util.h"    // emberAfGetPageFrom8bitEncodedChanPg()
#include PLATFORM_HEADER
#include "app/framework/plugin/ota-server-policy/ota-server-policy.h"
#include CONFIGURATION_HEADER
//#include EMBER_AF_API_TRANSPORT_MQTT




/** @name Non-Cluster Related Callbacks */
// @{
/** @brief Add To Current App Tasks
 *
 * This function is only useful to sleepy end devices.  This function will note
 * the passed item as part of a set of tasks the application has outstanding
 * (e.g. message sent requiring APS acknwoledgement).  This will affect how the
 * application behaves with regard to sleeping and polling.  Until the
 * outstanding task is completed, the device may poll more frequently and sleep
 * less often.
 *
 * @param tasks   Ver.: always
 */
void emberAfAddToCurrentAppTasksCallback(EmberAfApplicationTask tasks);
/** @brief Allow Network Write Attribute
 *
 * This function is called by the application framework before it writes an
 * attribute in response to a write attribute request from an external device.
 * The value passed into this callback is the value to which the attribute is to
 * be set by the framework.
        Example:	In mirroring simple metering data
 * on an Energy Services Interface (ESI) (formerly called Energy Service Portal
 * (ESP) in SE 1.0).), a mirrored simple meter needs to write read-only
 * attributes on its mirror. The-meter-mirror sample application, located in
 * app/framework/sample-apps, uses this callback to allow the mirrored device to
 * write simple metering attributes on the mirror regardless of the fact that
 * most simple metering attributes are defined as read-only by the ZigBee
 * specification.
        Note:	The ZCL specification does not (as of this
 * writing) specify any permission-level security for writing writeable
 * attributes. As far as the ZCL specification is concerned, if an attribute is
 * writeable, any device that has a link key for the device should be able to
 * write that attribute. Furthermore if an attribute is read only, it should not
 * be written over the air. Thus, if you implement permissions for writing
 * attributes as a feature, you MAY be operating outside the specification. This
 * is unlikely to be a problem for writing read-only attributes, but it may be a
 * problem for attributes that are writeable according to the specification but
 * restricted by the application implementing this callback.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param attributeId   Ver.: always
 * @param mask   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param value   Ver.: always
 * @param type   Ver.: always
 */
EmberAfAttributeWritePermission emberAfAllowNetworkWriteAttributeCallback(uint8_t endpoint,
                                                                          EmberAfClusterId clusterId,
                                                                          EmberAfAttributeId attributeId,
                                                                          uint8_t mask,
                                                                          uint16_t manufacturerCode,
                                                                          uint8_t* value,
                                                                          uint8_t type);
/** @brief Attribute Read Access
 *
 * This function is called whenever the Application Framework needs to check
 * access permission for an attribute read.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param attributeId   Ver.: always
 */
bool emberAfAttributeReadAccessCallback(uint8_t endpoint,
                                        EmberAfClusterId clusterId,
                                        uint16_t manufacturerCode,
                                        uint16_t attributeId);
/** @brief Attribute Write Access
 *
 * This function is called whenever the Application Framework needs to check
 * access permission for an attribute write.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param attributeId   Ver.: always
 */
bool emberAfAttributeWriteAccessCallback(uint8_t endpoint,
                                         EmberAfClusterId clusterId,
                                         uint16_t manufacturerCode,
                                         uint16_t attributeId);
/** @brief Clear Report Table
 *
 * This function is called by the framework when the application should clear
 * the report table.
 *
 */
EmberStatus emberAfClearReportTableCallback(void);
/** @brief Cluster Init
 *
 * This function is called when a specific cluster is initialized. It gives the
 * application an opportunity to take care of cluster initialization procedures.
 * It is called exactly once for each endpoint where cluster is present.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 */
void emberAfClusterInitCallback(uint8_t endpoint,
                                EmberAfClusterId clusterId);
/** @brief Cluster Security Custom
 *
 * This callback is fired when determining if APS encryption is required for a
 * cluster outside of the specification's required clusters.  In other words,
 * for the Smart Energy profile this would be a cluster beyond the list that
 * normally requires APS encryption.
 *
 * @param profileId The profile ID  Ver.: always
 * @param clusterId The cluster ID  Ver.: always
 * @param incoming Whether this is an incoming or outgoing message.  Ver.:
 * always
 * @param commandId The ZCL command ID being sent/received.  Ver.: always
 */
bool emberAfClusterSecurityCustomCallback(EmberAfProfileId profileId,
                                          EmberAfClusterId clusterId,
                                          bool incoming,
                                          uint8_t commandId);
/** @brief Configure Reporting Command
 *
 * This function is called by the application framework when a Configure
 * Reporting command is received from an external device.  The Configure
 * Reporting command contains a series of attribute reporting configuration
 * records.  The application should return true if the message was processed or
 * false if it was not.
 *
 * @param cmd   Ver.: always
 */
bool emberAfConfigureReportingCommandCallback(const EmberAfClusterCommand *cmd);
/** @brief Configure Reporting Response
 *
 * This function is called by the application framework when a Configure
 * Reporting Response command is received from an external device.  The
 * application should return true if the message was processed or false if it
 * was not.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param buffer Buffer containing the list of attribute status records.  Ver.:
 * always
 * @param bufLen The length in bytes of the list.  Ver.: always
 */
//bool emberAfConfigureReportingResponseCallback(EmberAfClusterId clusterId,
                                              // uint8_t *buffer,
                                              // uint16_t bufLen);
/** @brief Default Response
 *
 * This function is called by the application framework when a Default Response
 * command is received from an external device.  The application should return
 * true if the message was processed or false if it was not.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param commandId The command identifier to which this is a response.  Ver.:
 * always
 * @param status Specifies either SUCCESS or the nature of the error that was
 * detected in the received command.  Ver.: always
 */
bool emberAfDefaultResponseCallback(EmberAfClusterId clusterId,
                                    uint8_t commandId,
                                    EmberAfStatus status);
/** @brief Discover Attributes Response
 *
 * This function is called by the application framework when a Discover
 * Attributes Response or Discover Attributes Extended Response command is
 * received from an external device.  The Discover Attributes Response command
 * contains a bool indicating if discovery is complete and a list of zero or
 * more attribute identifier/type records. The final argument indicates whether
 * the response is in the extended format or not.  The application should return
 * true if the message was processed or false if it was not.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param discoveryComplete Indicates whether there are more attributes to be
 * discovered.  true if there are no more attributes to be discovered.  Ver.:
 * always
 * @param buffer Buffer containing the list of attribute identifier/type
 * records.  Ver.: always
 * @param bufLen The length in bytes of the list.  Ver.: always
 * @param extended Indicates whether the response is in the extended format or
 * not.  Ver.: always
 */
bool emberAfDiscoverAttributesResponseCallback(EmberAfClusterId clusterId,
                                               bool discoveryComplete,
                                               uint8_t *buffer,
                                               uint16_t bufLen,
                                               bool extended);
/** @brief Discover Commands Generated Response
 *
 * This function is called by the framework when Discover Commands Generated
 * Response is received.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param manufacturerCode Manufacturer code  Ver.: always
 * @param discoveryComplete Indicates whether there are more commands to be
 * discovered.  Ver.: always
 * @param commandIds Buffer containing the list of command identifiers.  Ver.:
 * always
 * @param commandIdCount The length of bytes of the list, whish is the same as
 * the number of identifiers.  Ver.: always
 */
bool emberAfDiscoverCommandsGeneratedResponseCallback(EmberAfClusterId clusterId,
                                                      uint16_t manufacturerCode,
                                                      bool discoveryComplete,
                                                      uint8_t *commandIds,
                                                      uint16_t commandIdCount);
/** @brief Discover Commands Received Response
 *
 * This function is called by the framework when Discover Commands Received
 * Response is received.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param manufacturerCode Manufacturer code  Ver.: always
 * @param discoveryComplete Indicates whether there are more commands to be
 * discovered.  Ver.: always
 * @param commandIds Buffer containing the list of command identifiers.  Ver.:
 * always
 * @param commandIdCount The length of bytes of the list, whish is the same as
 * the number of identifiers.  Ver.: always
 */
bool emberAfDiscoverCommandsReceivedResponseCallback(EmberAfClusterId clusterId,
                                                     uint16_t manufacturerCode,
                                                     bool discoveryComplete,
                                                     uint8_t *commandIds,
                                                     uint16_t commandIdCount);
/** @brief Eeprom Init
 *
 * Tells the system to initialize the EEPROM if it is not already initialized.
 *
 */
void emberAfEepromInitCallback(void);
/** @brief Eeprom Note Initialized State
 *
 * Records the state of the EEPROM so that an intelligent driver (like the
 * EEPROM plugin) can re-initialize the driver prior to any calls to it.
 *
 * @param state The state of the EEPROM, false=re-initalization needed,
 * true=no-re-init needed  Ver.: always
 */
void emberAfEepromNoteInitializedStateCallback(bool state);
/** @brief Eeprom Shutdown
 *
 * Tells the system to shutdown the EEPROM if it is not already shutdown.
 *
 */
void emberAfEepromShutdownCallback(void);
/** @brief Energy Scan Result
 *
 * This is called by the low-level stack code when an 802.15.4 energy scan
 * completes.
 *
 * @param channel The channel where the energy scan took place.  Ver.: always
 * @param rssi The receive signal strength indicator for the channel.  Ver.:
 * always
 */
void emberAfEnergyScanResultCallback(uint8_t channel,
                                     int8_t rssi);
/** @brief External Attribute Read
 *
 * Like emberAfExternalAttributeWriteCallback above, this function is called
 * when the framework needs to read an attribute that is not stored within the
 * Application Framework's data structures.
        All of the important
 * information about the attribute itself is passed as a pointer to an
 * EmberAfAttributeMetadata struct, which is stored within the application and
 * used to manage the attribute. A complete description of the
 * EmberAfAttributeMetadata struct is provided in
 * app/framework/include/af-types.h
        This function assumes that the
 * application is able to read the attribute, write it into the passed buffer,
 * and return immediately. Any attributes that require a state machine for
 * reading and writing are not really candidates for externalization at the
 * present time. The Application Framework does not currently include a state
 * machine for reading or writing attributes that must take place across a
 * series of application ticks. Attributes that cannot be read in a timely
 * manner should be stored within the Application Framework and updated
 * occasionally by the application code from within the
 * emberAfMainTickCallback.
        If the application was successfully able to
 * read the attribute and write it into the passed buffer, it should return a
 * value of EMBER_ZCL_STATUS_SUCCESS. Any other return value indicates the
 * application was not able to read the attribute.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param attributeMetadata   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param buffer   Ver.: always
 */
EmberAfStatus emberAfExternalAttributeReadCallback(uint8_t endpoint,
                                                   EmberAfClusterId clusterId,
                                                   EmberAfAttributeMetadata *attributeMetadata,
                                                   uint16_t manufacturerCode,
                                                   uint8_t *buffer);
/** @brief External Attribute Write
 *
 * This function is called whenever the Application Framework needs to write an
 * attribute which is not stored within the data structures of the Application
 * Framework itself. One of the new features in Version 2 is the ability to
 * store attributes outside the Framework. This is particularly useful for
 * attributes that do not need to be stored because they can be read off the
 * hardware when they are needed, or are stored in some central location used by
 * many modules within the system. In this case, you can indicate that the
 * attribute is stored externally. When the framework needs to write an external
 * attribute, it makes a call to this callback.
        This callback is very
 * useful for host micros which need to store attributes in persistent memory.
 * Because each host micro (used with an Ember NCP) has its own type of
 * persistent memory storage, the Application Framework does not include the
 * ability to mark attributes as stored in flash the way that it does for Ember
 * SoCs like the EM35x. On a host micro, any attributes that need to be stored
 * in persistent memory should be marked as external and accessed through the
 * external read and write callbacks. Any host code associated with the
 * persistent storage should be implemented within this callback.
        All of
 * the important information about the attribute itself is passed as a pointer
 * to an EmberAfAttributeMetadata struct, which is stored within the application
 * and used to manage the attribute. A complete description of the
 * EmberAfAttributeMetadata struct is provided in
 * app/framework/include/af-types.h.
        This function assumes that the
 * application is able to write the attribute and return immediately. Any
 * attributes that require a state machine for reading and writing are not
 * candidates for externalization at the present time. The Application Framework
 * does not currently include a state machine for reading or writing attributes
 * that must take place across a series of application ticks. Attributes that
 * cannot be written immediately should be stored within the Application
 * Framework and updated occasionally by the application code from within the
 * emberAfMainTickCallback.
        If the application was successfully able to
 * write the attribute, it returns a value of EMBER_ZCL_STATUS_SUCCESS. Any
 * other return value indicates the application was not able to write the
 * attribute.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param attributeMetadata   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param buffer   Ver.: always
 */
EmberAfStatus emberAfExternalAttributeWriteCallback(uint8_t endpoint,
                                                    EmberAfClusterId clusterId,
                                                    EmberAfAttributeMetadata *attributeMetadata,
                                                    uint16_t manufacturerCode,
                                                    uint8_t *buffer);
/** @brief Find Unused Pan Id And Form
 *
 * This function is called by the framework to search for an unused PAN id and
 * form a new network.  The application should return EMBER_SUCCESS if the
 * operation was initiated successfully.
 *
 */
EmberStatus emberAfFindUnusedPanIdAndFormCallback(void);
/** @brief Get Current App Tasks
 *
 * This function is only useful to sleepy end devices.  This function will
 * return the set of tasks the application has outstanding.  These tasks affect
 * how the application behaves with regard to sleeping and polling.
 *
 */
EmberAfApplicationTask emberAfGetCurrentAppTasksCallback(void);
/** @brief Get Current Poll Control
 *
 * This function will retrieve the current poll control that the system is using
 * for the current network.  This is determined by examining all the scheduled
 * events and obtaining the most restrictive poll control context across all
 * events.  The most restrictive poll control is EMBER_AF_SHORT_POLL followed by
 * EMBER_AF_LONG_POLL.
 *
 */
EmberAfEventPollControl emberAfGetCurrentPollControlCallback(void);
/** @brief Get Current Poll Interval Ms
 *
 * This function is only useful to end devices.  This function will return the
 * current poll interval (in milliseconds) for the current network.  This
 * interval is the maximum amount of time a child is currently waiting between
 * polls of its parent.
 *
 */
uint32_t emberAfGetCurrentPollIntervalMsCallback(void);
/** @brief Get Current Poll Interval Qs
 *
 * This function is only useful to end devices.  This function will return the
 * current poll interval (in quarter seconds) for the current network.  This
 * interval is the maximum amount of time a child is currently waiting between
 * polls of its parent.
 *
 */
uint32_t emberAfGetCurrentPollIntervalQsCallback(void);
/** @brief Get Current Sleep Control
 *
 * This function will retrieve the current sleep control that the system is
 * using.  This is determined by examining all the scheduled events and
 * obtaining the most restrictive sleep control context across all events.  The
 * most restrictive sleep control is EMBER_AF_STAY_AWAKE followed by
 * EMBER_AF_OK_TO_SLEEP.
 *
 */
EmberAfEventSleepControl emberAfGetCurrentSleepControlCallback(void);
/** @brief Get Current Time
 *
 * This callback is called when device attempts to get current time from the
 * hardware. If this device has means to retrieve exact time, then this method
 * should implement it. If the callback can't provide the exact time it should
 * return 0 to indicate failure. Default action is to return 0, which indicates
 * that device does not have access to real time.
 *
 */
uint32_t emberAfGetCurrentTimeCallback(void);
/** @brief Get Default Poll Control
 *
 * This function will retrieve the default poll control for the current network
 * as previously set by emberAfSetDefaultPollControlCallback().  The default
 * poll control will limit whether the network can long poll.
 *
 */
EmberAfEventPollControl emberAfGetDefaultPollControlCallback(void);
/** @brief Get Default Sleep Control
 *
 * This function will retrieve the default sleep control the system is using as
 * previously set by emberAfSetDefaultSleepControlCallback().  The default sleep
 * control will limit whether the device can sleep.
 *
 */
EmberAfEventSleepControl emberAfGetDefaultSleepControlCallback(void);
/** @brief Get Endpoint By Index
 *
 * Get the endpoint number based on the passed index.  By default the framework
 * handles this by managing endpoints based on the precompiled configuration
 * defined in AppBuilder.  This callback can override this behavior at runtime
 * and provide additional endpoints or different data than the compiled values. 
 * If the index is overridden than the callback shall return true and set the
 * endpointReturn parameter accordingly. A value of 0xFF means the endpoint
 * doesn't exist at that index.
        Otherwise false must be returned by the
 * callback and the default framework behavior will be executed.  This is only
 * applicable to the SOC devices.
 *
 * @param index The index of the endpoint.  Ver.: always
 * @param endpointReturn The value of endpoint.  Ver.: always
 */
bool emberAfGetEndpointByIndexCallback(uint8_t index,
                                       uint8_t* endpointReturn);
/** @brief Get Endpoint Description
 *
 * This callback is called by the framework whenever it receives a ZDO request
 * to enumerate the details about an endpoint.  By default the framework
 * provides the information based on the precompiled endpoint information as
 * defined in AppBuilder.  This callback can override that behavior at runtime
 * and return different information.  If the endpoint information is being
 * overridden then the callback must return true.  Otherwise it should return
 * false, which allows the framework to perform its default behavior.  This is
 * only applicable to SOC devices.
 *
 * @param endpoint The endpoint number that is being queried.  Ver.: always
 * @param result This is a pointer to a data structure where the endpoint
 * information is written if the callback is providing the information.  Ver.:
 * always
 */
bool emberAfGetEndpointDescriptionCallback(uint8_t endpoint,
                                           EmberEndpointDescription* result);
/** @brief Get Endpoint Info
 *
 * This function is a callback to an application implemented endpoint that
 * operates outside the normal application framework.  When the framework wishes
 * to perform operations with that endpoint it uses this callback to retrieve
 * the endpoint's information.  If the endpoint exists and the application can
 * provide data then true shall be returned.  Otherwise the callback must return
 * false.
 *
 * @param endpoint The endpoint to retrieve data for.  Ver.: always
 * @param returnNetworkIndex The index corresponding to the ZigBee network the
 * endpoint belongs to.  If not using a multi-network device, 0 must be
 * returned.  Otherwise on a multi-network device the stack will switch to this
 * network before sending the message.  Ver.: always
 * @param returnEndpointInfo A pointer to a data struct that will be written
 * with information about the endpoint.  Ver.: always
 */
bool emberAfGetEndpointInfoCallback(uint8_t endpoint,
                                    uint8_t* returnNetworkIndex,
                                    EmberAfEndpointInfoStruct* returnEndpointInfo);
/** @brief Get Form And Join Extended Pan Id
 *
 * This callback is called by the framework to get the extended PAN ID used by
 * the current network for forming and joining.  The extended PAN ID used for
 * forming and joining is not necessarily the same extended PAN ID actually in
 * use on the network.
 *
 * @param resultLocation   Ver.: always
 */
void emberAfGetFormAndJoinExtendedPanIdCallback(uint8_t *resultLocation);
/** @brief Get Long Poll Interval Ms
 *
 * This function is only useful to end devices.  This function will return the
 * long poll interval (in milliseconds) for the current network.  This interval
 * is the maximum amount of time a child will wait between polls of its parent
 * when it is not expecting data.
 *
 */
uint32_t emberAfGetLongPollIntervalMsCallback(void);
/** @brief Get Long Poll Interval Qs
 *
 * This function is only useful to end devices.  This function will return the
 * long poll interval (in quarter seconds) for the current network.  This
 * interval is the maximum amount of time a child will wait between polls of its
 * parent when it is not expecting data.
 *
 */
uint32_t emberAfGetLongPollIntervalQsCallback(void);
/** @brief Get Short Poll Interval Ms
 *
 * This function is only useful to sleepy end devices.  This function will
 * return the short poll interval (in milliseconds) for the current network. 
 * This interval is the maximum amount of time a child will wait between polls
 * of its parent when it is expecting data.
 *
 */
uint16_t emberAfGetShortPollIntervalMsCallback(void);
/** @brief Get Short Poll Interval Qs
 *
 * This function is only useful to sleepy end devices.  This function will
 * return the short poll interval (in quarter seconds) for the current network. 
 * This interval is the maximum amount of time a child will wait between polls
 * of its parent when it is expecting data.
 *
 */
uint16_t emberAfGetShortPollIntervalQsCallback(void);
/** @brief Get Source Route Overhead
 *
 * This function is called by the framework to determine the overhead required
 * in the network frame for source routing to a particular destination.
 *
 * @param destination The node id of the destination  Ver.: always
 */
uint8_t emberAfGetSourceRouteOverheadCallback(EmberNodeId destination);
/** @brief Get Wake Timeout Bitmask
 *
 * This function is only useful to sleepy end devices.  This function will
 * return the wake timeout bitmask for the current network.  The bitmask
 * determines which tasks will timeout automatically and which tasks require
 * manual removal from the task list.
 *
 */
EmberAfApplicationTask emberAfGetWakeTimeoutBitmaskCallback(void);
/** @brief Get Wake Timeout Ms
 *
 * This function is only useful to sleepy end devices.  This function will
 * return the wake timeout (in milliseconds) for the current network.  This
 * timeout is the maximum amount of time a child will wait for a task in the
 * wake bitmask to finish.  While waiting, the device will short poll.
 *
 */
uint16_t emberAfGetWakeTimeoutMsCallback(void);
/** @brief Get Wake Timeout Qs
 *
 * This function is only useful to sleepy end devices.  This function will
 * return the wake timeout (in quarter seconds) for the current network.  This
 * timeout is the maximum amount of time a child will wait for a task in the
 * wake bitmask to finish.  While waiting, the device will short poll.
 *
 */
uint16_t emberAfGetWakeTimeoutQsCallback(void);
/** @brief Hal Button Isr
 *
 * This callback is called by the framework whenever a button is pressed on the
 * device. This callback is called within ISR context.
 *
 * @param button The button which has changed state, either BUTTON0 or BUTTON1
 * as defined in the appropriate BOARD_HEADER.  Ver.: always
 * @param state The new state of the button referenced by the button parameter,
 * either ::BUTTON_PRESSED if the button has been pressed or ::BUTTON_RELEASED
 * if the button has been released.  Ver.: always
 */
void emberAfHalButtonIsrCallback(uint8_t button,
                                 uint8_t state);
/** @brief Initiate Inter Pan Key Establishment
 *
 * This function is called by the framework to initiate key establishment with a
 * remote device on a different PAN.  The application should return
 * EMBER_SUCCESS if key establishment was initiated successfully.  The
 * application should call ::emberAfInterPanKeyEstablishmentCallback as events
 * occur.
 *
 * @param panId The PAN id of the remote device.  Ver.: always
 * @param eui64 The EUI64 of the remote device.  Ver.: always
 */
EmberStatus emberAfInitiateInterPanKeyEstablishmentCallback(EmberPanId panId,
                                                            const EmberEUI64 eui64);
/** @brief Initiate Key Establishment
 *
 * This function is called by the framework to initiate key establishment with a
 * remote device.  The application should return EMBER_SUCCESS if key
 * establishment was initiated successfully.  The application should call
 * ::emberAfKeyEstablishmentCallback as events occur.
 *
 * @param nodeId The node id of the remote device.  Ver.: always
 * @param endpoint The endpoint on the remote device.  Ver.: always
 */
EmberStatus emberAfInitiateKeyEstablishmentCallback(EmberNodeId nodeId,
                                                    uint8_t endpoint);
/** @brief Initiate Partner Link Key Exchange
 *
 * This function is called by the framework to initiate a partner link key
 * exchange with a remote device.  The application should return EMBER_SUCCESS
 * if the partner link key exchange was initiated successfully.  When the
 * partner link key exchange completes, the application should call the given
 * callback.
 *
 * @param target The node id of the remote device.  Ver.: always
 * @param endpoint The key establishment endpoint of the remote device.  Ver.:
 * always
 * @param callback The callback that should be called when the partner link key
 * exchange completse.  Ver.: always
 */
EmberStatus emberAfInitiatePartnerLinkKeyExchangeCallback(EmberNodeId target,
                                                          uint8_t endpoint,
                                                          EmberAfPartnerLinkKeyExchangeCallback *callback);
/** @brief Inter Pan Key Establishment
 *
 * A callback by the key-establishment code to indicate an event has occurred. 
 * For error codes this is purely a notification.  For non-error status codes
 * (besides LINK_KEY_ESTABLISHED), it is the application's chance to allow or
 * disallow the operation.  If the application returns true then the key
 * establishment is allowed to proceed.  If it returns false, then key
 * establishment is aborted.  LINK_KEY_ESTABLISHED is a notification of success.
 *
 * @param status   Ver.: always
 * @param amInitiator   Ver.: always
 * @param panId   Ver.: always
 * @param eui64   Ver.: always
 * @param delayInSeconds   Ver.: always
 */
bool emberAfInterPanKeyEstablishmentCallback(EmberAfKeyEstablishmentNotifyMessage status,
                                             bool amInitiator,
                                             EmberPanId panId,
                                             const EmberEUI64 eui64,
                                             uint8_t delayInSeconds);
/** @brief Interpan Send Message
 *
 * This function will send a raw MAC message with interpan frame format using
 * the passed parameters.
 *
 * @param header Interpan header info  Ver.: always
 * @param messageLength The length of the message received or to send  Ver.:
 * always
 * @param message The message data received or to send.  Ver.: always
 */
EmberStatus emberAfInterpanSendMessageCallback(EmberAfInterpanHeader* header,
                                               uint16_t messageLength,
                                               uint8_t* message);
/** @brief Key Establishment
 *
 * A callback by the key-establishment code to indicate an event has occurred. 
 * For error codes this is purely a notification.  For non-error status codes
 * (besides LINK_KEY_ESTABLISHED), it is the application's chance to allow or
 * disallow the operation.  If the application returns true then the key
 * establishment is allowed to proceed.  If it returns false, then key
 * establishment is aborted.  LINK_KEY_ESTABLISHED is a notification of success.
 *
 * @param status   Ver.: always
 * @param amInitiator   Ver.: always
 * @param partnerShortId   Ver.: always
 * @param delayInSeconds   Ver.: always
 */
bool emberAfKeyEstablishmentCallback(EmberAfKeyEstablishmentNotifyMessage status,
                                     bool amInitiator,
                                     EmberNodeId partnerShortId,
                                     uint8_t delayInSeconds);
/** @brief Main Init
 *
 * This function is called from the application's main function. It gives the
 * application a chance to do any initialization required at system startup. Any
 * code that you would normally put into the top of the application's main()
 * routine should be put into this function. This is called before the clusters,
 * plugins, and the network are initialized so some functionality is not yet
 * available.
        Note: No callback in the Application Framework is
 * associated with resource cleanup. If you are implementing your application on
 * a Unix host where resource cleanup is a consideration, we expect that you
 * will use the standard Posix system calls, including the use of atexit() and
 * handlers for signals such as SIGTERM, SIGINT, SIGCHLD, SIGPIPE and so on. If
 * you use the signal() function to register your signal handler, please mind
 * the returned value which may be an Application Framework function. If the
 * return value is non-null, please make sure that you call the returned
 * function from your handler to avoid negating the resource cleanup of the
 * Application Framework itself.
 *
 */
void emberAfMainInitCallback(void);
/** @brief Main Start
 *
 * This function is called at the start of main after the HAL has been
 * initialized.  The standard main function arguments of argc and argv are
 * passed in.  However not all platforms have support for main() function
 * arguments.  Those that do not are passed NULL for argv, therefore argv should
 * be checked for NULL before using it.  If the callback determines that the
 * program must exit, it should return true.  The value returned by main() will
 * be the value written to the returnCode pointer.  Otherwise the callback
 * should return false to let normal execution continue.
 *
 * @param returnCode   Ver.: always
 * @param argc   Ver.: always
 * @param argv   Ver.: always
 */
bool emberAfMainStartCallback(int* returnCode,
                              int argc,
                              char** argv);
/** @brief Main Tick
 *
 * Whenever main application tick is called, this callback will be called at the
 * end of the main tick execution.
 *
 */
void emberAfMainTickCallback(void);
/** @brief Message Sent
 *
 * This function is called by the application framework from the message sent
 * handler, when it is informed by the stack regarding the message sent status.
 * All of the values passed to the emberMessageSentHandler are passed on to this
 * callback. This provides an opportunity for the application to verify that its
 * message has been sent successfully and take the appropriate action. This
 * callback should return a bool value of true or false. A value of true
 * indicates that the message sent notification has been handled and should not
 * be handled by the application framework.
 *
 * @param type   Ver.: always
 * @param indexOrDestination   Ver.: always
 * @param apsFrame   Ver.: always
 * @param msgLen   Ver.: always
 * @param message   Ver.: always
 * @param status   Ver.: always
 */
//bool emberAfMessageSentCallback(EmberOutgoingMessageType type,
                               // uint16_t indexOrDestination,
                               // EmberApsFrame* apsFrame,
                               // uint16_t msgLen,
                               // uint8_t* message,
                               // EmberStatus status);
/** @brief Ncp Init
 *
 * This function is called when the network coprocessor is being initialized,
 * either at startup or upon reset.  It provides applications on opportunity to
 * perform additional configuration of the NCP.  The function is always called
 * twice when the NCP is initialized.  In the first invocation, memoryAllocation
 * will be true and the application should only issue EZSP commands that affect
 * memory allocation on the NCP.  For example, tables on the NCP can be resized
 * in the first call.  In the second invocation, memoryAllocation will be false
 * and the application should only issue EZSP commands that do not affect memory
 * allocation.  For example, tables on the NCP can be populated in the second
 * call.  This callback is not called on SoCs.
 *
 * @param memoryAllocation   Ver.: always
 */
void emberAfNcpInitCallback(bool memoryAllocation);
/** @brief Ncp Is Awake Isr
 *
 * This function is called IN ISR CONTEXT.  It notes that the NCP is awake after
 * sleeping.  Care should be taken to do minimal processing in this ISR handler
 * function.
 *
 */
void emberAfNcpIsAwakeIsrCallback(void);
/** @brief Network Found
 *
 * This callback is generated when an active scan finds a 802.15.4 network.
 *
 * @param networkFound A struct containing information about the network found. 
 * Ver.: always
 * @param lqi The link quality indication of the network found.  Ver.: always
 * @param rssi The received signal strength indication of the network found. 
 * Ver.: always
 */
void emberAfNetworkFoundCallback(EmberZigbeeNetwork* networkFound,
                                 uint8_t lqi,
                                 int8_t rssi);
/** @brief Network Key Update Complete
 *
 * This is called by the framework when a network key update operation started
 * by the trust center is complete.
 *
 * @param status   Ver.: always
 */
void emberAfNetworkKeyUpdateCompleteCallback(EmberStatus status);
/** @brief Ota Bootload
 *
 * The platform specific routine to bootload the device from a ZigBee
 * over-the-air upgrade file.
 *
 * @param id A pointer to the structure that contains the information about what
 * OTA image to bootload.  Ver.: always
 * @param ncpUpgradeTagId The tag ID of the upgrade data that will be used to
 * bootload the device.  Ver.: always
 */
uint8_t emberAfOtaBootloadCallback(const EmberAfOtaImageId* id,
                                   uint16_t ncpUpgradeTagId);
/** @brief Ota Client Bootload
 *
 * This callback is fired when the OTA Client recevies a command to bootload the
 * newly downloaded OTA image.  This callback will perform the platform specific
 * to bootload their device.
 *
 * @param id This is the identifier relating to the image that has been
 * downloaded and is ready for bootload.  Ver.: always
 */
void emberAfOtaClientBootloadCallback(const EmberAfOtaImageId* id);
/** @brief Ota Client Custom Verify
 *
 * This callback is executed by the OTA client after the signature verification
 * has successfully completed.  It allows the device to do its own custom
 * verification of the image (such as verifying that the EBL is intact).
 *
 * @param newVerification This indicates if a new verification should be
 * started.  Ver.: always
 * @param id This is ID of the image to be verified.  Ver.: always
 */
EmberAfImageVerifyStatus emberAfOtaClientCustomVerifyCallback(bool newVerification,
                                                              const EmberAfOtaImageId* id);
/** @brief Ota Client Download Complete
 *
 * This callback indicates that the OTA client has completed the download of a
 * file.  If the file has been completely downloaded and cryptographic checks
 * have been turned on, then those will be performed prior to this callback and
 * that outcome included in the 'success' result.  On failure, this callback is
 * merely informative, and the return type is ignored.  On succesful download,
 * this callback allows the client to perform any additional verification of the
 * downloaded image and return that result to the OTA server.
 *
 * @param success This indicates the success or failure of the download and
 * cryptographic verification process (if applicable).  Ver.: always
 * @param id This is the image identifier information that corresponds to the
 * download result.  Ver.: always
 */
bool emberAfOtaClientDownloadCompleteCallback(EmberAfOtaDownloadResult success,
                                              const EmberAfOtaImageId* id);
/** @brief Ota Client Incoming Message Raw
 *
 * This callback is for processing incoming messages for the Over-the-air
 * bootload cluster client.  ZCL will not process the message and instead hand
 * the raw over the air data to the callback for its own processing.
 *
 * @param message A pointer to the structure containing the message buffer and
 * other information about it.  Ver.: always
 */
bool emberAfOtaClientIncomingMessageRawCallback(EmberAfClusterCommand *message);
/** @brief Ota Client Start
 *
 * This callback should be called when the profile specific registration has
 * completed successfully.  It will start the client's state machine that will
 * find the OTA server, query it for the next image, download the image, wait
 * for the bootload message, and kick off the bootload.
 *
 */
void emberAfOtaClientStartCallback(void);
/** @brief Ota Client Version Info
 *
 * This function is called by the OTA client when a new query will occur to the
 * server asking what the next version of firmware is.  The client can inform
 * the cluster software as to what information to use in the query (and
 * subsequent download).
 *
 * @param currentImageInfo This is the information to use in the next query by
 * the client cluster code.  It contains the manufacturer ID, image type ID, and
 * the firmware version to be specified in the query message sent to the server.
 *  Ver.: always
 * @param hardwareVersion This is a pointer to the hardware version to use in
 * the query.  If no hardware version should be used, then
 * EMBER_AF_INVALID_HARDWARE_VERSION should be used.  Ver.: always
 */
void emberAfOtaClientVersionInfoCallback(EmberAfOtaImageId* currentImageInfo,
                                         uint16_t* hardwareVersion);
/** @brief Ota Page Request Server Policy
 *
 * This callback is called by the OTA server page request code when it wants to
 * determine if it is allowed for an OTA client to make a page request.  It is
 * only called if page request support has been enabled on the server.  It
 * should return EMBER_ZCL_STATUS_SUCCESS if it allows the page request, and
 * EMBER_ZCL_STATUS_UNSUP_CLUSTER_COMMAND if it does not want to allow it.
 *
 */
uint8_t emberAfOtaPageRequestServerPolicyCallback(void);
/** @brief Ota Server Block Size
 *
 * This function provides a way for the server to adjust the block size of its
 * response to an Image block request by a client.
 *
 * @param clientNodeId The node Id of OTA client making an image block request. 
 * Ver.: always
 */
uint8_t emberAfOtaServerBlockSizeCallback(EmberNodeId clientNodeId);
/** @brief Ota Server Incoming Message Raw
 *
 * This callback is for processing incoming messages for the Over-the-air
 * bootload cluster server.  ZCL will not process the message and instead hand
 * the raw over the air data to the callback for its own processing.
 *
 * @param message A pointer to the structure containing the message buffer and
 * other information about it.  Ver.: always
 */
bool emberAfOtaServerIncomingMessageRawCallback(EmberAfClusterCommand *message);
/** @brief Ota Server Query
 *
 * This callback is fired when the OTA server receives a query request by the
 * client.  The callback lets the server application indicate to the client what
 * the 'next' version of software is for the device, or if there is not one
 * available.
 *
 * @param currentImageId This is the current software image that the client
 * hase.  Ver.: always
 * @param hardwareVersion If this value is non-NULL, it indicates the hardware
 * version of the client device.  If NULL, the client did not specify a hardware
 * version.  Ver.: always
 * @param nextUpgradeImageId This is a pointer to a data structure containing
 * the 'next' software version for the client to download.  Ver.: always
 */
uint8_t emberAfOtaServerQueryCallback(const EmberAfOtaImageId* currentImageId,
                                      uint16_t* hardwareVersion,
                                      EmberAfOtaImageId* nextUpgradeImageId);
/** @brief Ota Server Send Image Notify
 *
 * This callback is an indication to the OTA server that it should send out
 * notification about an OTA file that is available for download.
 *
 * @param dest The destination of the image notify message.  May be a broadcast
 * address.  Ver.: always
 * @param endpoint The destination endpoint of the image notify message.  May be
 * a broadcast endpoint.  Ver.: always
 * @param payloadType The type of data the image notify message will contain.  0
 * = no data.  1 = Manufacturer ID.  2 = Manufacturer ID and the image type ID. 
 * 3 = Manufacturer ID, image type ID, and firmware version.  Ver.: always
 * @param queryJitter The percentage of nodes that should respond to this
 * message, from 1-100.  On receipt of this message, each recipient will
 * randomly choose a percentage and only query the server if their percentage is
 * below this value.  Ver.: always
 * @param id The image information that will be put in the message.  The data
 * within this struct that will be appended to the message is determined by the
 * previous 'payloadType' argument.  Ver.: always
 */
bool emberAfOtaServerSendImageNotifyCallback(EmberNodeId dest,
                                             uint8_t endpoint,
                                             uint8_t payloadType,
                                             uint8_t queryJitter,
                                             const EmberAfOtaImageId* id);
/** @brief Ota Server Upgrade End Request
 *
 * This function is called when the OTA server receives a request an upgrade end
 * request.  If the request indicated a successful download by the client, the
 * server must tell the client when and if to upgrade to the downloaded image.
 *
 * @param source The node ID of the device that sent the upgrade end request. 
 * Ver.: always
 * @param status This is the ZCL status sent by the client indicating the result
 * of its attempt to download the new upgrade image.  If the status is not
 * EMBER_ZCL_STATUS_SUCCESS then this callback is merely informative and no
 * response mesasge will be generated by the server.  Ver.: always
 * @param returnValue If the server returns true indicating that the client
 * should apply the upgrade, this time value indicates when in the future the
 * client should apply the upgrade.  Ver.: always
 * @param imageId This variable indicates the software version that the client
 * successfully downloaded and is asking to upgrade to.  Ver.: always
 */
bool emberAfOtaServerUpgradeEndRequestCallback(EmberNodeId source,
                                               uint8_t status,
                                               uint32_t* returnValue,
                                               const EmberAfOtaImageId* imageId);
/** @brief Ota Storage Check Temp Data
 *
 * This callback will validate temporary data in the storage device to determine
 * whether it is a complete file, a partially downloaded file, or there is no
 * file present.  When a complete or partial file is found it will return
 * EMBER_AF_OTA_STORAGE_SUCCESS or EMBER_AF_OTA_STORAGE_PARTIAL_FILE_FOUND,
 * respectively.  In that case, the currentOffset, totalImageSize, and
 * newFileInfo will be populated with data.  When EMBER_AF_OTA_STORAGE_ERROR is
 * returned, no temporary data is present.
 *
 * @param currentOffset A pointer to a value that will be written with the
 * offset within the total file size that has been successfully stored in the
 * storage device.  This will indicate how much data has been currently
 * dowloaded.  Ver.: always
 * @param totalImageSize A pointer to a value that will be written with the
 * total image size of the OTA file when a download has completed.  This does
 * not indicate how much data has actually been downloaded currently.  Ver.:
 * always
 * @param newFileInfo This is the image id of the temporary file data stored in
 * the storage device.  Ver.: always
 */
EmberAfOtaStorageStatus emberAfOtaStorageCheckTempDataCallback(uint32_t* currentOffset,
                                                               uint32_t* totalImageSize,
                                                               EmberAfOtaImageId* newFileInfo);
/** @brief Ota Storage Clear Temp Data
 *
 * This function clears any existing temp data that was downloaed.  It is used
 * immediately prior to downloading a raw image over the air.
 *
 */
EmberAfOtaStorageStatus emberAfOtaStorageClearTempDataCallback(void);
/** @brief Ota Storage Close
 *
 * This callback shuts down the ZigBee Over-the-air storage module.
 *
 */
void emberAfOtaStorageCloseCallback(void);
/** @brief Ota Storage Driver Download Finish
 *
 * This callback defines the low-level means by which a device records the final
 * offset value of the download image.
 *
 * @param offset The value of the final offset of the image download.  Ver.:
 * always
 */
void emberAfOtaStorageDriverDownloadFinishCallback(uint32_t offset);
/** @brief Ota Storage Driver Init
 *
 * The initialization code for the OTA storage driver.
 *
 */
bool emberAfOtaStorageDriverInitCallback(void);
/** @brief Ota Storage Driver Invalidate Image
 *
 * This callback invalidates the image stored on disk so that it will not be
 * bootloaded, and it will not be a valid image that is in the middle of
 * downloading.
 *
 */
EmberAfOtaStorageStatus emberAfOtaStorageDriverInvalidateImageCallback(void);
/** @brief Ota Storage Driver Prepare To Resume Download
 *
 * This callback allows the underlying storage driver to prepare to resume the
 * OTA file download.  For example, the driver may exceute a page erase to
 * insure the next page is ready to be written to.
 *
 */
EmberAfOtaStorageStatus emberAfOtaStorageDriverPrepareToResumeDownloadCallback(void);
/** @brief Ota Storage Driver Read
 *
 * This callback defines the low-level means by which a device reads from the
 * OTA storage device.
 *
 * @param offset The address offset from the start of the storage device where
 * data is to be read.  Ver.: always
 * @param length The length of the data to be read from the storage device. 
 * Ver.: always
 * @param returnData A pointer where the data read from the device should be
 * written to.  Ver.: always
 */
bool emberAfOtaStorageDriverReadCallback(uint32_t offset,
                                         uint32_t length,
                                         uint8_t* returnData);
/** @brief Ota Storage Driver Retrieve Last Stored Offset
 *
 * This callback defines the low-level means by which a device retrieves the
 * last persistently recorded download offset.  This may be different than last
 * actual download offset.
 *
 */
uint32_t emberAfOtaStorageDriverRetrieveLastStoredOffsetCallback(void);
/** @brief Ota Storage Driver Write
 *
 * This callback defines the low-level means by which a device reads from the
 * OTA storage device.
 *
 * @param dataToWrite A pointer to the data that will be written to the storage
 * device.  Ver.: always
 * @param offset The address offset from the start of the storage device where
 * data will be written.  Ver.: always
 * @param length The length of the data to be written to the storage device. 
 * Ver.: always
 */
bool emberAfOtaStorageDriverWriteCallback(const uint8_t* dataToWrite,
                                          uint32_t offset,
                                          uint32_t length);
/** @brief Ota Storage Finish Download
 *
 * This function indicates to the storage module that the download has finished.
 *
 * @param offset The final offset of the downloaded file (i.e. the total size) 
 * Ver.: always
 */
EmberAfOtaStorageStatus emberAfOtaStorageFinishDownloadCallback(uint32_t offset);
/** @brief Ota Storage Get Count
 *
 * This callback returns the total number of ZigBee Over-the-air upgrade images
 * stored in the storage module.
 *
 */
uint8_t emberAfOtaStorageGetCountCallback(void);
/** @brief Ota Storage Get Full Header
 *
 * This callback populates the EmberAfOtaHeader structure pointed to by the
 * returnData with data about the OTA file stored in the storage module.
 *
 * @param id This is a pointer to the image id for the OTA file to retrieve
 * information about.  Ver.: always
 * @param returnData This is a pointer to the location of the structure that
 * will be populated with data.  Ver.: always
 */
EmberAfOtaStorageStatus emberAfOtaStorageGetFullHeaderCallback(const EmberAfOtaImageId* id,
                                                               EmberAfOtaHeader* returnData);
/** @brief Ota Storage Get Total Image Size
 *
 * This function returns the total size of the ZigBee Over-the-air file with the
 * passed parameters.  If no file is found with those parameters, 0 is returned.
 *
 * @param id A pointer to the image identifier for the OTA file to retrieve
 * information for.  Ver.: always
 */
uint32_t emberAfOtaStorageGetTotalImageSizeCallback(const EmberAfOtaImageId* id);
/** @brief Ota Storage Init
 *
 * This callback initializes the ZigBee Over-the-air storage module.
 *
 */
EmberAfOtaStorageStatus emberAfOtaStorageInitCallback(void);
/** @brief Ota Storage Iterator First
 *
 * This callback lets you walk through the list of all OTA files by jumping to
 * the first file in the list maintained by the storage module.  If there is no
 * file then emberAfOtaInvalidImageId is returned.
 *
 */
EmberAfOtaImageId emberAfOtaStorageIteratorFirstCallback(void);
/** @brief Ota Storage Iterator Next
 *
 * This callback lets you walk through the list of all OTA files by jumping to
 * the next file in the list maintained by the storage module.  If there is no
 * next file then emberAfOtaInvalidImageId is returned.
 *
 */
EmberAfOtaImageId emberAfOtaStorageIteratorNextCallback(void);
/** @brief Ota Storage Read Image Data
 *
 * This callback reads data from the specified OTA file and returns that data to
 * the caller.
 *
 * @param id This is a pointer to the image id for the OTA file to retrieve data
 * from.  Ver.: always
 * @param offset This is the offset relative to the start of the image where the
 * data should be read from.  Ver.: always
 * @param length This is the length of data that will be read.  Ver.: always
 * @param returnData This is a pointer to where the data read out of the file
 * will be written to  Ver.: always
 * @param returnedLength This is a pointer to a variable where the actual length
 * of data read will be written to.  A short read may occur if the end of file
 * was reached.  Ver.: always
 */
EmberAfOtaStorageStatus emberAfOtaStorageReadImageDataCallback(const EmberAfOtaImageId* id,
                                                               uint32_t offset,
                                                               uint32_t length,
                                                               uint8_t* returnData,
                                                               uint32_t* returnedLength);
/** @brief Ota Storage Search
 *
 * This callback searches through the list of all images for one that matches
 * the passed parameters.  On success an image identifier is returned with a
 * matching image.  On failure emberAfInvalidImageId is returned.
 *
 * @param manufacturerId The ZigBee assigned identifier of the manufacturer
 * contained in the OTA image being searched for.  Ver.: always
 * @param imageTypeId The image type identifier contained in the OTA image being
 * searched for.  Ver.: always
 * @param hardwareVersion This is a pointer to the hardware version that will be
 * used in the search.  If the pointer is NULL, hardware version will not be
 * considered when searching for matching images.  If it points to a value, the
 * search will only consider images where that value falls between the minimum
 * and maxmimum hardware version specified in the OTA file.  If no hardware
 * version is present in an OTA file but the other parameters match, the file
 * will be considered a match  Ver.: always
 */
EmberAfOtaImageId emberAfOtaStorageSearchCallback(uint16_t manufacturerId,
                                                  uint16_t imageTypeId,
                                                  const uint16_t* hardwareVersion);
/** @brief Ota Storage Write Temp Data
 *
 * This function writes to the temporary data in the storage device at the
 * specified offset.  It is used when downloading a raw image over the air.
 *
 * @param offset The location within the download image file where to write the
 * data.  Ver.: always
 * @param length The length of data to write.  Ver.: always
 * @param data A pointer to the temporary data that will be written to the
 * storage device.  Ver.: always
 */
EmberAfOtaStorageStatus emberAfOtaStorageWriteTempDataCallback(uint32_t offset,
                                                               uint32_t length,
                                                               const uint8_t* data);
/** @brief Partner Link Key Exchange Request
 *
 * This function is called by the framework on SOC platforms when a remote node
 * requests a partner link key exchange.  The application should return
 * EMBER_SUCCESS to accept the request or any other status to reject it.  On
 * network coprocessor platforms, this function will not be called because the
 * NCP handles partner link key exchange requests based on the binding policy.
 *
 * @param partner The EUI of the remote node.  Ver.: always
 */
EmberStatus emberAfPartnerLinkKeyExchangeRequestCallback(EmberEUI64 partner);
/** @brief Partner Link Key Exchange Response
 *
 * This function is called by the framework when a remote node requests a
 * partner link key exchange.  The application should return true to accept the
 * request or false to reject it.  On network coprocessor platforms, this
 * function will not be called because the NCP handles partner link key exchange
 * requests based on the binding policy.
 *
 * @param sender The EUI of the remote node.  Ver.: always
 * @param status The ZDO response status.  Ver.: always
 */
void emberAfPartnerLinkKeyExchangeResponseCallback(EmberNodeId sender,
                                                   EmberZdoStatus status);
/** @brief Performing Key Establishment
 *
 * This function is called by the framework to determine if the device is
 * performing key establishment.  The application should return true if key
 * establishment is in progress.
 *
 */
bool emberAfPerformingKeyEstablishmentCallback(void);
/** @brief Post Attribute Change
 *
 * This function is called by the application framework after it changes an
 * attribute value. The value passed into this callback is the value to which
 * the attribute was set by the framework.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param attributeId   Ver.: always
 * @param mask   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param type   Ver.: always
 * @param size   Ver.: always
 * @param value   Ver.: always
 */
void emberAfPostAttributeChangeCallback(uint8_t endpoint,
                                        EmberAfClusterId clusterId,
                                        EmberAfAttributeId attributeId,
                                        uint8_t mask,
                                        uint16_t manufacturerCode,
                                        uint8_t type,
                                        uint8_t size,
                                        uint8_t* value);
/** @brief Pre Attribute Change
 *
 * This function is called by the application framework before it changes an
 * attribute value.  The value passed into this callback is the value to which
 * the attribute is to be set by the framework.  The application should return
 * ::EMBER_ZCL_STATUS_SUCCESS to permit the change or any other ::EmberAfStatus
 * to reject it.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param attributeId   Ver.: always
 * @param mask   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param type   Ver.: always
 * @param size   Ver.: always
 * @param value   Ver.: always
 */
EmberAfStatus emberAfPreAttributeChangeCallback(uint8_t endpoint,
                                                EmberAfClusterId clusterId,
                                                EmberAfAttributeId attributeId,
                                                uint8_t mask,
                                                uint16_t manufacturerCode,
                                                uint8_t type,
                                                uint8_t size,
                                                uint8_t* value);
/** @brief Pre Cli Send
 *
 * This function is called by the framework when it is about to pass a message
 * constructed over CLI to the stack primitives for sending. If the function
 * returns true it is assumed that the callback has consumed and processed the
 * message. The framework will not do any further processing on the message.
   
 *     If the function returns false then it is assumed that the callback has
 * not processed the message and the framework will continue to process
 * accordingly.
 *
 * @param apsFrame The structure containing the APS frame  Ver.: always
 * @param source Source Node Id  Ver.: always
 * @param destination Destintion Node Id  Ver.: always
 * @param message Pointer to the message payload  Ver.: always
 * @param messageLength Length of the message payload  Ver.: always
 */
bool emberAfPreCliSendCallback(EmberApsFrame* apsFrame,
                               EmberNodeId source,
                               EmberNodeId destination,
                               uint8_t* message,
                               uint16_t messageLength);
/** @brief Pre Command Received
 *
 * This callback is the second in the Application Framework's message processing
 * chain. At this point in the processing of incoming over-the-air messages, the
 * application has determined that the incoming message is a ZCL command. It
 * parses enough of the message to populate an EmberAfClusterCommand struct. The
 * Application Framework defines this struct value in a local scope to the
 * command processing but also makes it available through a global pointer
 * called emberAfCurrentCommand, in app/framework/util/util.c. When command
 * processing is complete, this pointer is cleared.
 *
 * @param cmd   Ver.: always
 */
bool emberAfPreCommandReceivedCallback(EmberAfClusterCommand* cmd);
/** @brief Pre Message Received
 *
 * This callback is the first in the Application Framework's message processing
 * chain. The Application Framework calls it when a message has been received
 * over the air but has not yet been parsed by the ZCL command-handling code. If
 * you wish to parse some messages that are completely outside the ZCL
 * specification or are not handled by the Application Framework's command
 * handling code, you should intercept them for parsing in this callback. 
     
 *   This callback returns a Boolean value indicating whether or not the message
 * has been handled. If the callback returns a value of true, then the
 * Application Framework assumes that the message has been handled and it does
 * nothing else with it. If the callback returns a value of false, then the
 * application framework continues to process the message as it would with any
 * incoming message.
        Note: 	This callback receives a pointer to an
 * incoming message struct. This struct allows the application framework to
 * provide a unified interface between both Host devices, which receive their
 * message through the ezspIncomingMessageHandler, and SoC devices, which
 * receive their message through emberIncomingMessageHandler.
 *
 * @param incomingMessage   Ver.: always
 */
//bool emberAfPreMessageReceivedCallback(EmberAfIncomingMessage* incomingMessage);
/** @brief Pre Message Send
 *
 * This function is called by the framework when it is about to pass a message
 * to the stack primitives for sending.   This message may or may not be ZCL,
 * ZDO, or some other protocol.  This is called prior to
        any ZigBee
 * fragmentation that may be done.  If the function returns true it is assumed
 * the callback has consumed and processed the message.  The callback must also
 * set the EmberStatus status code to be passed back to the caller.  The
 * framework will do no further processing on the message.
        If the
 * function returns false then it is assumed that the callback has not processed
 * the mesasge and the framework will continue to process accordingly.
 *
 * @param messageStruct The structure containing the parameters of the APS
 * message to be sent.  Ver.: always
 * @param status A pointer to the status code value that will be returned to the
 * caller.  Ver.: always
 */
//bool emberAfPreMessageSendCallback(EmberAfMessageStruct* messageStruct,
                                   //EmberStatus* status);
/** @brief Pre Ncp Reset
 *
 * This function will be called prior to the reset of the NCP by the host.
 *
 */
void emberAfPreNcpResetCallback(void);
/** @brief Pre ZDO Message Received
 *
 * This function passes the application an incoming ZDO message and gives the
 * appictation the opportunity to handle it. By default, this callback returns
 * false indicating that the incoming ZDO message has not been handled and
 * should be handled by the Application Framework.
 *
 * @param emberNodeId   Ver.: always
 * @param apsFrame   Ver.: always
 * @param message   Ver.: always
 * @param length   Ver.: always
 */
bool emberAfPreZDOMessageReceivedCallback(EmberNodeId emberNodeId,
                                          EmberApsFrame* apsFrame,
                                          uint8_t* message,
                                          uint16_t length);
/** @brief Read Attributes Response
 *
 * This function is called by the application framework when a Read Attributes
 * Response command is received from an external device.  The application should
 * return true if the message was processed or false if it was not.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param buffer Buffer containing the list of read attribute status records. 
 * Ver.: always
 * @param bufLen The length in bytes of the list.  Ver.: always
 */
bool emberAfReadAttributesResponseCallback(EmberAfClusterId clusterId,
                                           uint8_t *buffer,
                                           uint16_t bufLen);
/** @brief Read Reporting Configuration Command
 *
 * This function is called by the application framework when a Read Reporting
 * Configuration command is received from an external device.  The application
 * should return true if the message was processed or false if it was not.
 *
 * @param cmd   Ver.: always
 */
bool emberAfReadReportingConfigurationCommandCallback(const EmberAfClusterCommand *cmd);
/** @brief Read Reporting Configuration Response
 *
 * This function is called by the application framework when a Read Reporting
 * Configuration Response command is received from an external device.  The
 * application should return true if the message was processed or false if it
 * was not.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param buffer Buffer containing the list of attribute reporting configuration
 * records.  Ver.: always
 * @param bufLen The length in bytes of the list.  Ver.: always
 */
//bool emberAfReadReportingConfigurationResponseCallback(EmberAfClusterId clusterId,
                                                      // uint8_t *buffer,
                                                      // uint16_t bufLen);
/** @brief Registration Abort
 *
 * This callback is called when the device should abort the registration
 * process.
 *
 */
void emberAfRegistrationAbortCallback(void);
/** @brief Registration
 *
 * This callback is called when the device joins a network and the process of
 * registration is complete. This callback provides a success value of true if
 * the registration process was successful and a value of false if registration
 * failed.
 *
 * @param success true if registration succeeded, false otherwise.  Ver.: always
 */
void emberAfRegistrationCallback(bool success);
/** @brief Registration Start
 *
 * This callback is called when the device joins a network and the registration
 * process should begin.  The application should return EMBER_SUCCESS if the
 * registration process started successfully.  When registration is complete,
 * the application should call emberAfRegistrationCallback with an indication of
 * success or failure.
 *
 */
EmberStatus emberAfRegistrationStartCallback(void);
/** @brief Remote Delete Binding Permission
 *
 * This function is called by the framework to request permission to service the
 * remote delete binding request. Return EMBER_SUCCESS to allow request,
 * anything else to disallow request.
 *
 * @param index index to an Ember binding table entry  Ver.: always
 */
EmberStatus emberAfRemoteDeleteBindingPermissionCallback(uint8_t index);
/** @brief Remote Set Binding Permission
 *
 * This function is called by the framework to request permission to service the
 * remote set binding request. Return EMBER_SUCCESS to allow request, anything
 * else to disallow request.
 *
 * @param entry Ember Binding Tablet Entry  Ver.: always
 */
EmberStatus emberAfRemoteSetBindingPermissionCallback(const EmberBindingTableEntry *entry);
/** @brief Remove From Current App Tasks
 *
 * This function is only useful to sleepy end devices.  This function will
 * remove the passed item from the set of tasks the application has outstanding
 * (e.g. message sent requiring APS acknwoledgement).  This will affect how the
 * application behaves with regard to sleeping and polling.  Removing the item
 * from the list of outstanding tasks may allow the device to sleep longer and
 * poll less frequently.  If there are other outstanding tasks the system may
 * still have to stay away and poll more often.
 *
 * @param tasks   Ver.: always
 */
void emberAfRemoveFromCurrentAppTasksCallback(EmberAfApplicationTask tasks);
/** @brief Report Attributes
 *
 * This function is called by the application framework when a Report Attributes
 * command is received from an external device.  The application should return
 * true if the message was processed or false if it was not.
 *
 * @param clusterId The cluster identifier of this command.  Ver.: always
 * @param buffer Buffer containing the list of attribute report records.  Ver.:
 * always
 * @param bufLen The length in bytes of the list.  Ver.: always
 */
bool emberAfReportAttributesCallback(EmberAfClusterId clusterId,
                                     uint8_t *buffer,
                                     uint16_t bufLen);
/** @brief Reporting Attribute Change
 *
 * This function is called by the framework when an attribute managed by the
 * framework changes.  The application should call this function when an
 * externally-managed attribute changes.  The application should use the change
 * notification to inform its reporting decisions.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 * @param attributeId   Ver.: always
 * @param mask   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param type   Ver.: always
 * @param data   Ver.: always
 */
void emberAfReportingAttributeChangeCallback(uint8_t endpoint,
                                             EmberAfClusterId clusterId,
                                             EmberAfAttributeId attributeId,
                                             uint8_t mask,
                                             uint16_t manufacturerCode,
                                             EmberAfAttributeType type,
                                             uint8_t *data);
/** @brief Scan Complete
 *
 * This is called by the low-level stack code when an 802.15.4 active scan
 * completes.
 *
 * @param channel If the status indicates an error, the channel on which the
 * error occurred.  Otherwise it is undefined for EMBER_SUCCESS.  Ver.: always
 * @param status The status of the scan.  Ver.: always
 */
void emberAfScanCompleteCallback(uint8_t channel,
                                 EmberStatus status);
/** @brief Scan Error
 *
 * This is called by the framework on behalf of the form-and-join library to
 * notify the application if an error occurs while scanning.  See form-and-join
 * documentation for more information.
 *
 * @param status The status of the scan.  Ver.: always
 */
void emberAfScanErrorCallback(EmberStatus status);
/** @brief Security Init
 *
 * This callback is called by the framework to give the application a chance to
 * modify the security settings of the node during network initialization. 
 * Depending on the context when this callback is called, the pointer to the
 * initial security state may be NULL, which means the initial security state
 * can no longer be modified as the node is already operating on the network.
 *
 * @param state   Ver.: always
 * @param extended   Ver.: always
 * @param trustCenter   Ver.: always
 */
void emberAfSecurityInitCallback(EmberInitialSecurityState *state,
                                 EmberExtendedSecurityBitmask *extended,
                                 bool trustCenter);
/** @brief Set Default Poll Control
 *
 * This function will set the default poll control for the current network to
 * control whether or not it can long poll.
 *
 * @param control   Ver.: always
 */
void emberAfSetDefaultPollControlCallback(EmberAfEventPollControl control);
/** @brief Set Default Sleep Control
 *
 * This function will set the default behavior of a sleeping device to control
 * whether or not it must stay awake.  A device that stays awake does not sleep
 * at all.  Otherwise, the device can sleep between events when appropriate.
 *
 * @param control   Ver.: always
 */
void emberAfSetDefaultSleepControlCallback(EmberAfEventSleepControl control);
/** @brief Set Form And Join Extended Pan Id
 *
 * This callback is called by the framework to set the extended PAN ID used by
 * the current network for forming and joining.  The extended PAN ID used for
 * forming and joining is not necessarily the same extended PAN ID actually in
 * use on the network.
 *
 * @param extendedPanId   Ver.: always
 */
void emberAfSetFormAndJoinExtendedPanIdCallback(const uint8_t *extendedPanId);
/** @brief Set Long Poll Interval Ms
 *
 * This function is only useful to end devices.  This function will set the long
 * poll interval (in milliseconds) for the current network.  This interval is
 * the maximum amount of time a child will wait between polls of its parent when
 * it is not expecting data.
 *
 * @param longPollIntervalMs   Ver.: always
 */
void emberAfSetLongPollIntervalMsCallback(uint32_t longPollIntervalMs);
/** @brief Set Long Poll Interval Qs
 *
 * This function is only useful to end devices.  This function will set the long
 * poll interval (in quarter seconds) for the current network.  This interval is
 * the maximum amount of time a child will wait between polls of its parent when
 * it is not expecting data.
 *
 * @param longPollIntervalQs   Ver.: always
 */
void emberAfSetLongPollIntervalQsCallback(uint32_t longPollIntervalQs);
/** @brief Set Short Poll Interval Ms
 *
 * This function is only useful to sleepy end devices.  This function will set
 * the short poll interval (in milliseconds) for the current network.  This
 * interval is the maximum amount of time a child will wait between polls of its
 * parent when it is expecting data.
 *
 * @param shortPollIntervalMs   Ver.: always
 */
void emberAfSetShortPollIntervalMsCallback(uint16_t shortPollIntervalMs);
/** @brief Set Short Poll Interval Qs
 *
 * This function is only useful to sleepy end devices.  This function will set
 * the short poll interval (in quarter seconds) for the current network.  This
 * interval is the maximum amount of time a child will wait between polls of its
 * parent when it is expecting data.
 *
 * @param shortPollIntervalQs   Ver.: always
 */
void emberAfSetShortPollIntervalQsCallback(uint16_t shortPollIntervalQs);
/** @brief Set Source Route Overhead
 *
 * This function is called by the framework when it has information about the
 * source route overhead to a particular destination. The application may use
 * this information to cache the source route overhead.
 *
 * @param destination The node id of the destination  Ver.: always
 * @param overhead The overhead in bytes  Ver.: always
 */
void emberAfSetSourceRouteOverheadCallback(EmberNodeId destination,
                                           uint8_t overhead);
/** @brief Set Time
 *
 * This callback should be implemented, if the device has access to real time
 * clock, and has an ability to update that clock. The application framework
 * expects to be passed the utcTime which is the number of seconds since the
 * year 2000. Default implementation does nothing. Note: This function used to
 * take time in year, month, day, hour, min, sec. We have changed this to
 * utcTime in order to conserve code space.
 *
 * @param utcTime   Ver.: always
 */
void emberAfSetTimeCallback(uint32_t utcTime);
/** @brief Set Wake Timeout Bitmask
 *
 * This function is only useful to sleepy end devices.  This function will set
 * the wake timeout bitmask for the current network.  The bitmask determines
 * which tasks will timeout automatically and which tasks require manual removal
 * from the task list.
 *
 * @param tasks   Ver.: always
 */
void emberAfSetWakeTimeoutBitmaskCallback(EmberAfApplicationTask tasks);
/** @brief Set Wake Timeout Ms
 *
 * This function is only useful to sleepy end devices.  This function will set
 * the wake timeout (in milliseconds) for the current network.  This timeout is
 * the maximum amount of time a child will wait for a task in the wake bitmask
 * to finish.  While waiting, the device will short poll.
 *
 * @param wakeTimeoutMs   Ver.: always
 */
void emberAfSetWakeTimeoutMsCallback(uint16_t wakeTimeoutMs);
/** @brief Set Wake Timeout Qs
 *
 * This function is only useful to sleepy end devices.  This function will set
 * the wake timeout (in quarter seconds) for the current network.  This timeout
 * is the maximum amount of time a child will wait for a task in the wake
 * bitmask to finish.  While waiting, the device will short poll.
 *
 * @param wakeTimeoutQs   Ver.: always
 */
void emberAfSetWakeTimeoutQsCallback(uint16_t wakeTimeoutQs);
/** @brief Stack Status
 *
 * This function is called by the application framework from the stack status
 * handler.  This callbacks provides applications an opportunity to be notified
 * of changes to the stack status and take appropriate action.  The return code
 * from this callback is ignored by the framework.  The framework will always
 * process the stack status after the callback returns.
 *
 * @param status   Ver.: always
 */
bool emberAfStackStatusCallback(EmberStatus status);
/** @brief Start Move
 *
 * This function is called to initiate the process for a device to move (rejoin)
 * to a new parent.
 *
 */
bool emberAfStartMoveCallback(void);
/** @brief Start Search For Joinable Network
 *
 * This function is called by the framework to search for joinable networks and
 * join a network.  The application should return EMBER_SUCCESS if the operation
 * was initiated successfully.
 *
 */
EmberStatus emberAfStartSearchForJoinableNetworkCallback(void);
/** @brief Stop Move
 *
 * This function is called to cancel a previously scheduled move (rejoin) to a
 * new parent.
 *
 */
void emberAfStopMoveCallback(void);
/** @brief Trust Center Join
 *
 * This callback is called from within the application framework's
 * implementation of emberTrustCenterJoinHandler or ezspTrustCenterJoinHandler.
 * This callback provides the same arguments passed to the
 * TrustCenterJoinHandler. For more information about the TrustCenterJoinHandler
 * please see documentation included in stack/include/trust-center.h.
 *
 * @param newNodeId   Ver.: always
 * @param newNodeEui64   Ver.: always
 * @param parentOfNewNode   Ver.: always
 * @param status   Ver.: always
 * @param decision   Ver.: always
 */
void emberAfTrustCenterJoinCallback(EmberNodeId newNodeId,
                                    EmberEUI64 newNodeEui64,
                                    EmberNodeId parentOfNewNode,
                                    EmberDeviceUpdate status,
                                    EmberJoinDecision decision);
/** @brief Trust Center Keepalive Abort
 *
 * This callback is called when the device should abort the trust center
 * keepalive process.
 *
 */
void emberAfTrustCenterKeepaliveAbortCallback(void);
/** @brief Trust Center Keepalive Update
 *
 * This callback is called when the device finishes registration (successfully
 * or otherwise) and the trust center keepalive process must be updated.  If the
 * keepalive process has not been started, then it is started.  Otherwise if the
 * keepalive is in the process of searching for the TC, it will process the
 * result of that Trust Center search operation.
 *
 * @param registrationComplete   Ver.: always
 */
void emberAfTrustCenterKeepaliveUpdateCallback(bool registrationComplete);
/** @brief Unused Pan Id Found
 *
 * This is called by the framework on behalf of the form-and-join library to
 * notify the application of the PAN id and channel found following a call to
 * ::emberScanForUnusedPanId().  See form-and-join documentation for more
 * information.
 *
 * @param panId   Ver.: always
 * @param channel   Ver.: always
 */
void emberAfUnusedPanIdFoundCallback(EmberPanId panId,
                                     uint8_t channel);
/** @brief Write Attributes Response
 *
 * This function is called by the application framework when a Write Attributes
 * Response command is received from an external device.  The application should
 * return true if the message was processed or false if it was not.
 *
 * @param clusterId The cluster identifier of this response.  Ver.: always
 * @param buffer Buffer containing the list of write attribute status records. 
 * Ver.: always
 * @param bufLen The length in bytes of the list.  Ver.: always
 */
bool emberAfWriteAttributesResponseCallback(EmberAfClusterId clusterId,
                                            uint8_t *buffer,
                                            uint16_t bufLen);
/** @brief Zigbee Key Establishment
 *
 * A callback to the application to notify it of the status of the request for a
 * Link Key.
 *
 * @param partner partner The IEEE address of the partner device.  Or all zeros
 * if the Key establishment failed.  Ver.: always
 * @param status The status of the key establishment.  Ver.: always
 */
void emberAfZigbeeKeyEstablishmentCallback(EmberEUI64 partner,
                                           EmberKeyStatus status);
/** @brief came back from EM4
 *
 * This callback would be implemented in idle/sleep
            plugin by the
 * name emberAfCameBackFromEM4Callback and
            will be called by the
 * framework. It lets the
            plugin/app know the board is back from
 * EM4. So if the
            app wants to restore something, it can do it.
 *
 */
void emberAfcamebackfromEM4Callback(void);
/** @} END Non-Cluster Related Callbacks */

/** @name Basic Cluster Callbacks */
// @{

/** @brief Basic Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBasicClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief Basic Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBasicClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief Basic Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBasicClusterClientInitCallback(uint8_t endpoint);
/** @brief Basic Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBasicClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief Basic Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBasicClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief Basic Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBasicClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief Basic Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBasicClusterClientTickCallback(uint8_t endpoint);
/** @brief Basic Cluster Get Locales Supported
 *
 * 
 *
 * @param startLocale   Ver.: always
 * @param maxLocalesRequested   Ver.: always
 */
bool emberAfBasicClusterGetLocalesSupportedCallback(uint8_t* startLocale,
                                                       uint8_t maxLocalesRequested);
/** @brief Basic Cluster Get Locales Supported Response
 *
 * 
 *
 * @param discoveryComplete   Ver.: always
 * @param localeSupported   Ver.: always
 */
bool emberAfBasicClusterGetLocalesSupportedResponseCallback(uint8_t discoveryComplete,
                                                               uint8_t* localeSupported);
/** @brief Basic Cluster Reset To Factory Defaults
 *
 * 
 *
 */
bool emberAfBasicClusterResetToFactoryDefaultsCallback(void);
/** @brief Basic Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBasicClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief Basic Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBasicClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief Basic Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBasicClusterServerInitCallback(uint8_t endpoint);
/** @brief Basic Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBasicClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief Basic Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBasicClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief Basic Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBasicClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief Basic Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBasicClusterServerTickCallback(uint8_t endpoint);

/** @} END Basic Cluster Callbacks */

/** @name Power Configuration Cluster Callbacks */
// @{

/** @brief Power Configuration Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPowerConfigClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Power Configuration Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPowerConfigClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Power Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPowerConfigClusterClientInitCallback(uint8_t endpoint);
/** @brief Power Configuration Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPowerConfigClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Power Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPowerConfigClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Power Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPowerConfigClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Power Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPowerConfigClusterClientTickCallback(uint8_t endpoint);
/** @brief Power Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPowerConfigClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Power Configuration Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPowerConfigClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Power Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPowerConfigClusterServerInitCallback(uint8_t endpoint);
/** @brief Power Configuration Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPowerConfigClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Power Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPowerConfigClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Power Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPowerConfigClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Power Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPowerConfigClusterServerTickCallback(uint8_t endpoint);

/** @} END Power Configuration Cluster Callbacks */

/** @name Device Temperature Configuration Cluster Callbacks */
// @{

/** @brief Device Temperature Configuration Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDeviceTempClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Device Temperature Configuration Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDeviceTempClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Device Temperature Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDeviceTempClusterClientInitCallback(uint8_t endpoint);
/** @brief Device Temperature Configuration Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDeviceTempClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Device Temperature Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDeviceTempClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Device Temperature Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDeviceTempClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Device Temperature Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDeviceTempClusterClientTickCallback(uint8_t endpoint);
/** @brief Device Temperature Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDeviceTempClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Device Temperature Configuration Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDeviceTempClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Device Temperature Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDeviceTempClusterServerInitCallback(uint8_t endpoint);
/** @brief Device Temperature Configuration Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDeviceTempClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Device Temperature Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDeviceTempClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Device Temperature Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDeviceTempClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Device Temperature Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDeviceTempClusterServerTickCallback(uint8_t endpoint);

/** @} END Device Temperature Configuration Cluster Callbacks */

/** @name Identify Cluster Callbacks */
// @{

/** @brief Identify Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIdentifyClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                          EmberAfAttributeId attributeId);
/** @brief Identify Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIdentifyClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                         uint8_t commandId,
                                                         EmberAfStatus status);
/** @brief Identify Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIdentifyClusterClientInitCallback(uint8_t endpoint);
/** @brief Identify Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIdentifyClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              uint16_t manufacturerCode);
/** @brief Identify Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIdentifyClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                     uint16_t indexOrDestination,
                                                     EmberApsFrame *apsFrame,
                                                     uint16_t msgLen,
                                                     uint8_t *message,
                                                     EmberStatus status);
/** @brief Identify Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIdentifyClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId,
                                                                      EmberAfAttributeType attributeType,
                                                                      uint8_t size,
                                                                      uint8_t *value);
/** @brief Identify Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIdentifyClusterClientTickCallback(uint8_t endpoint);
/** @brief Identify Cluster E Z Mode Invoke
 *
 * 
 *
 * @param action   Ver.: always
 */
bool emberAfIdentifyClusterEZModeInvokeCallback(uint8_t action);
/** @brief Identify Cluster Identify
 *
 * 
 *
 * @param identifyTime   Ver.: always
 */
bool emberAfIdentifyClusterIdentifyCallback(uint16_t identifyTime);
/** @brief Identify Cluster Identify Query
 *
 * 
 *
 */
bool emberAfIdentifyClusterIdentifyQueryCallback(void);
/** @brief Identify Cluster Identify Query Response
 *
 * 
 *
 * @param timeout   Ver.: always
 */
bool emberAfIdentifyClusterIdentifyQueryResponseCallback(uint16_t timeout);
/** @brief Identify Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIdentifyClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                          EmberAfAttributeId attributeId);
/** @brief Identify Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIdentifyClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                         uint8_t commandId,
                                                         EmberAfStatus status);
/** @brief Identify Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIdentifyClusterServerInitCallback(uint8_t endpoint);
/** @brief Identify Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIdentifyClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              uint16_t manufacturerCode);
/** @brief Identify Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIdentifyClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                     uint16_t indexOrDestination,
                                                     EmberApsFrame *apsFrame,
                                                     uint16_t msgLen,
                                                     uint8_t *message,
                                                     EmberStatus status);
/** @brief Identify Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIdentifyClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId,
                                                                      EmberAfAttributeType attributeType,
                                                                      uint8_t size,
                                                                      uint8_t *value);
/** @brief Identify Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIdentifyClusterServerTickCallback(uint8_t endpoint);
/** @brief Identify Cluster Trigger Effect
 *
 * 
 *
 * @param effectId   Ver.: always
 * @param effectVariant   Ver.: always
 */
bool emberAfIdentifyClusterTriggerEffectCallback(uint8_t effectId,
                                                    uint8_t effectVariant);
/** @brief Identify Cluster Update Commission State
 *
 * 
 *
 * @param action   Ver.: always
 * @param commissionStateMask   Ver.: always
 */
bool emberAfIdentifyClusterUpdateCommissionStateCallback(uint8_t action,
                                                            uint8_t commissionStateMask);

/** @} END Identify Cluster Callbacks */

/** @name Groups Cluster Callbacks */
// @{

/** @brief Groups Cluster Clear Group Table
 *
 * This function is called by the framework when the application should clear
 * the group table.
 *
 * @param endpoint The endpoint.  Ver.: always
 */
void emberAfGroupsClusterClearGroupTableCallback(uint8_t endpoint);
/** @brief Groups Cluster Endpoint In Group
 *
 * This function is called by the framework when it needs to determine if an
 * endpoint is a member of a group.  The application should return true if the
 * endpoint is a member of the group and false otherwise.
 *
 * @param endpoint The endpoint.  Ver.: always
 * @param groupId The group identifier.  Ver.: always
 */
bool emberAfGroupsClusterEndpointInGroupCallback(uint8_t endpoint,
                                                 uint16_t groupId);
/** @brief Groups Cluster Add Group
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param groupName   Ver.: always
 */
bool emberAfGroupsClusterAddGroupCallback(uint16_t groupId,
                                             uint8_t* groupName);
/** @brief Groups Cluster Add Group If Identifying
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param groupName   Ver.: always
 */
bool emberAfGroupsClusterAddGroupIfIdentifyingCallback(uint16_t groupId,
                                                          uint8_t* groupName);
/** @brief Groups Cluster Add Group Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 */
bool emberAfGroupsClusterAddGroupResponseCallback(uint8_t status,
                                                     uint16_t groupId);
/** @brief Groups Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfGroupsClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief Groups Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfGroupsClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief Groups Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfGroupsClusterClientInitCallback(uint8_t endpoint);
/** @brief Groups Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfGroupsClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief Groups Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfGroupsClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief Groups Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfGroupsClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief Groups Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfGroupsClusterClientTickCallback(uint8_t endpoint);
/** @brief Groups Cluster Get Group Membership
 *
 * 
 *
 * @param groupCount   Ver.: always
 * @param groupList   Ver.: always
 */
bool emberAfGroupsClusterGetGroupMembershipCallback(uint8_t groupCount,
                                                       uint8_t* groupList);
/** @brief Groups Cluster Get Group Membership Response
 *
 * 
 *
 * @param capacity   Ver.: always
 * @param groupCount   Ver.: always
 * @param groupList   Ver.: always
 */
bool emberAfGroupsClusterGetGroupMembershipResponseCallback(uint8_t capacity,
                                                               uint8_t groupCount,
                                                               uint8_t* groupList);
/** @brief Groups Cluster Remove All Groups
 *
 * 
 *
 */
bool emberAfGroupsClusterRemoveAllGroupsCallback(void);
/** @brief Groups Cluster Remove Group
 *
 * 
 *
 * @param groupId   Ver.: always
 */
bool emberAfGroupsClusterRemoveGroupCallback(uint16_t groupId);
/** @brief Groups Cluster Remove Group Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 */
bool emberAfGroupsClusterRemoveGroupResponseCallback(uint8_t status,
                                                        uint16_t groupId);
/** @brief Groups Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfGroupsClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief Groups Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfGroupsClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief Groups Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfGroupsClusterServerInitCallback(uint8_t endpoint);
/** @brief Groups Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfGroupsClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief Groups Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfGroupsClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief Groups Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfGroupsClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief Groups Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfGroupsClusterServerTickCallback(uint8_t endpoint);
/** @brief Groups Cluster View Group
 *
 * 
 *
 * @param groupId   Ver.: always
 */
bool emberAfGroupsClusterViewGroupCallback(uint16_t groupId);
/** @brief Groups Cluster View Group Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 * @param groupName   Ver.: always
 */
bool emberAfGroupsClusterViewGroupResponseCallback(uint8_t status,
                                                      uint16_t groupId,
                                                      uint8_t* groupName);

/** @} END Groups Cluster Callbacks */

/** @name Scenes Cluster Callbacks */
// @{

/** @brief Scenes Cluster ClearSceneTable
 *
 * This function is called by the framework when the application should clear
 * the scene table.
 *
 * @param endpoint The endpoint.  Ver.: always
 */
void emberAfScenesClusterClearSceneTableCallback(uint8_t endpoint);
/** @brief Scenes Cluster Make Invalid
 *
 * This function is called to invalidate the valid attribute in the Scenes
 * cluster.
 *
 * @param endpoint   Ver.: always
 */
EmberAfStatus emberAfScenesClusterMakeInvalidCallback(uint8_t endpoint);
/** @brief Scenes Cluster Recall Saved Scene
 *
 * This function is called by the framework when the application should recall a
 * saved scene.
 *
 * @param endpoint The endpoint.  Ver.: always
 * @param groupId The group identifier.  Ver.: always
 * @param sceneId The scene identifier.  Ver.: always
 */
EmberAfStatus emberAfScenesClusterRecallSavedSceneCallback(uint8_t endpoint,
                                                           uint16_t groupId,
                                                           uint8_t sceneId);
/** @brief Scenes Cluster Remove Scenes In Group
 *
 * This function removes the scenes from a specified group.
 *
 * @param endpoint Endpoint  Ver.: always
 * @param groupId Group ID  Ver.: always
 */
void emberAfScenesClusterRemoveScenesInGroupCallback(uint8_t endpoint,
                                                     uint16_t groupId);
/** @brief Scenes Cluster Add Scene
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 * @param transitionTime   Ver.: always
 * @param sceneName   Ver.: always
 * @param extensionFieldSets   Ver.: always
 */
bool emberAfScenesClusterAddSceneCallback(uint16_t groupId,
                                             uint8_t sceneId,
                                             uint16_t transitionTime,
                                             uint8_t* sceneName,
                                             uint8_t* extensionFieldSets);
/** @brief Scenes Cluster Add Scene Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterAddSceneResponseCallback(uint8_t status,
                                                     uint16_t groupId,
                                                     uint8_t sceneId);
/** @brief Scenes Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfScenesClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief Scenes Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfScenesClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief Scenes Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfScenesClusterClientInitCallback(uint8_t endpoint);
/** @brief Scenes Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfScenesClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief Scenes Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfScenesClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief Scenes Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfScenesClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief Scenes Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfScenesClusterClientTickCallback(uint8_t endpoint);
/** @brief Scenes Cluster Copy Scene
 *
 * 
 *
 * @param mode   Ver.: always
 * @param groupIdFrom   Ver.: always
 * @param sceneIdFrom   Ver.: always
 * @param groupIdTo   Ver.: always
 * @param sceneIdTo   Ver.: always
 */
bool emberAfScenesClusterCopySceneCallback(uint8_t mode,
                                              uint16_t groupIdFrom,
                                              uint8_t sceneIdFrom,
                                              uint16_t groupIdTo,
                                              uint8_t sceneIdTo);
/** @brief Scenes Cluster Copy Scene Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupIdFrom   Ver.: always
 * @param sceneIdFrom   Ver.: always
 */
bool emberAfScenesClusterCopySceneResponseCallback(uint8_t status,
                                                      uint16_t groupIdFrom,
                                                      uint8_t sceneIdFrom);
/** @brief Scenes Cluster Enhanced Add Scene
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 * @param transitionTime   Ver.: always
 * @param sceneName   Ver.: always
 * @param extensionFieldSets   Ver.: always
 */
bool emberAfScenesClusterEnhancedAddSceneCallback(uint16_t groupId,
                                                     uint8_t sceneId,
                                                     uint16_t transitionTime,
                                                     uint8_t* sceneName,
                                                     uint8_t* extensionFieldSets);
/** @brief Scenes Cluster Enhanced Add Scene Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterEnhancedAddSceneResponseCallback(uint8_t status,
                                                             uint16_t groupId,
                                                             uint8_t sceneId);
/** @brief Scenes Cluster Enhanced View Scene
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterEnhancedViewSceneCallback(uint16_t groupId,
                                                      uint8_t sceneId);
/** @brief Scenes Cluster Enhanced View Scene Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 * @param transitionTime   Ver.: always
 * @param sceneName   Ver.: always
 * @param extensionFieldSets   Ver.: always
 */
bool emberAfScenesClusterEnhancedViewSceneResponseCallback(uint8_t status,
                                                              uint16_t groupId,
                                                              uint8_t sceneId,
                                                              uint16_t transitionTime,
                                                              uint8_t* sceneName,
                                                              uint8_t* extensionFieldSets);
/** @brief Scenes Cluster Get Scene Membership
 *
 * 
 *
 * @param groupId   Ver.: always
 */
bool emberAfScenesClusterGetSceneMembershipCallback(uint16_t groupId);
/** @brief Scenes Cluster Get Scene Membership Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param capacity   Ver.: always
 * @param groupId   Ver.: always
 * @param sceneCount   Ver.: always
 * @param sceneList   Ver.: always
 */
bool emberAfScenesClusterGetSceneMembershipResponseCallback(uint8_t status,
                                                               uint8_t capacity,
                                                               uint16_t groupId,
                                                               uint8_t sceneCount,
                                                               uint8_t* sceneList);
/** @brief Scenes Cluster Recall Scene
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterRecallSceneCallback(uint16_t groupId,
                                                uint8_t sceneId);
/** @brief Scenes Cluster Remove All Scenes
 *
 * 
 *
 * @param groupId   Ver.: always
 */
bool emberAfScenesClusterRemoveAllScenesCallback(uint16_t groupId);
/** @brief Scenes Cluster Remove All Scenes Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 */
bool emberAfScenesClusterRemoveAllScenesResponseCallback(uint8_t status,
                                                            uint16_t groupId);
/** @brief Scenes Cluster Remove Scene
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterRemoveSceneCallback(uint16_t groupId,
                                                uint8_t sceneId);
/** @brief Scenes Cluster Remove Scene Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterRemoveSceneResponseCallback(uint8_t status,
                                                        uint16_t groupId,
                                                        uint8_t sceneId);
/** @brief Scenes Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfScenesClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief Scenes Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfScenesClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief Scenes Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfScenesClusterServerInitCallback(uint8_t endpoint);
/** @brief Scenes Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfScenesClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief Scenes Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfScenesClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief Scenes Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfScenesClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief Scenes Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfScenesClusterServerTickCallback(uint8_t endpoint);
/** @brief Scenes Cluster Store Scene
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterStoreSceneCallback(uint16_t groupId,
                                               uint8_t sceneId);
/** @brief Scenes Cluster Store Scene Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterStoreSceneResponseCallback(uint8_t status,
                                                       uint16_t groupId,
                                                       uint8_t sceneId);
/** @brief Scenes Cluster View Scene
 *
 * 
 *
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 */
bool emberAfScenesClusterViewSceneCallback(uint16_t groupId,
                                              uint8_t sceneId);
/** @brief Scenes Cluster View Scene Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param groupId   Ver.: always
 * @param sceneId   Ver.: always
 * @param transitionTime   Ver.: always
 * @param sceneName   Ver.: always
 * @param extensionFieldSets   Ver.: always
 */
bool emberAfScenesClusterViewSceneResponseCallback(uint8_t status,
                                                      uint16_t groupId,
                                                      uint8_t sceneId,
                                                      uint16_t transitionTime,
                                                      uint8_t* sceneName,
                                                      uint8_t* extensionFieldSets);
/** @brief Scenes Cluster Store Current Scene
 *
 * This function is called by the framework when the application should store
 * the current scene.  If an entry already exists in the scene table with the
 * same scene and group ids, the application should update the entry with the
 * current scene.  Otherwise, a new entry should be adde to the scene table, if
 * possible.
 *
 * @param endpoint The endpoint.  Ver.: always
 * @param groupId The group identifier.  Ver.: always
 * @param sceneId The scene identifier.  Ver.: always
 */
EmberAfStatus emberAfScenesClusterStoreCurrentSceneCallback(uint8_t endpoint,
                                                            uint16_t groupId,
                                                            uint8_t sceneId);

/** @} END Scenes Cluster Callbacks */

/** @name On/off Cluster Callbacks */
// @{

/** @brief On/off Cluster Level Control Effect
 *
 * This is called by the framework when the on/off cluster initiates a command
 * that must effect a level control change. The implementation assumes that the
 * client will handle any effect on the On/Off Cluster.
 *
 * @param endpoint   Ver.: always
 * @param newValue   Ver.: always
 */
void emberAfOnOffClusterLevelControlEffectCallback(uint8_t endpoint,
                                                   bool newValue);
/** @brief On/off Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOnOffClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief On/off Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOnOffClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief On/off Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOnOffClusterClientInitCallback(uint8_t endpoint);
/** @brief On/off Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOnOffClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief On/off Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOnOffClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief On/off Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOnOffClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief On/off Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOnOffClusterClientTickCallback(uint8_t endpoint);
/** @brief On/off Cluster Off
 *
 * 
 *
 */
bool emberAfOnOffClusterOffCallback(void);
/** @brief On/off Cluster Off With Effect
 *
 * 
 *
 * @param effectId   Ver.: always
 * @param effectVariant   Ver.: always
 */
bool emberAfOnOffClusterOffWithEffectCallback(uint8_t effectId,
                                                 uint8_t effectVariant);
/** @brief On/off Cluster On
 *
 * 
 *
 */
bool emberAfOnOffClusterOnCallback(void);
/** @brief On/off Cluster On With Recall Global Scene
 *
 * 
 *
 */
bool emberAfOnOffClusterOnWithRecallGlobalSceneCallback(void);
/** @brief On/off Cluster On With Timed Off
 *
 * 
 *
 * @param onOffControl   Ver.: always
 * @param onTime   Ver.: always
 * @param offWaitTime   Ver.: always
 */
bool emberAfOnOffClusterOnWithTimedOffCallback(uint8_t onOffControl,
                                                  uint16_t onTime,
                                                  uint16_t offWaitTime);
/** @brief On/off Cluster Sample Mfg Specific Off With Transition
 *
 * 
 *
 */
bool emberAfOnOffClusterSampleMfgSpecificOffWithTransitionCallback(void);
/** @brief On/off Cluster Sample Mfg Specific On With Transition
 *
 * 
 *
 */
bool emberAfOnOffClusterSampleMfgSpecificOnWithTransitionCallback(void);
/** @brief On/off Cluster Sample Mfg Specific Toggle With Transition
 *
 * 
 *
 */
bool emberAfOnOffClusterSampleMfgSpecificToggleWithTransitionCallback(void);
/** @brief On/off Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOnOffClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief On/off Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOnOffClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief On/off Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOnOffClusterServerInitCallback(uint8_t endpoint);
/** @brief On/off Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOnOffClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief On/off Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOnOffClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief On/off Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOnOffClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief On/off Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOnOffClusterServerTickCallback(uint8_t endpoint);
/** @brief On/off Cluster Toggle
 *
 * 
 *
 */
bool emberAfOnOffClusterToggleCallback(void);
/** @brief On/off Cluster Set Value
 *
 * This function is called when the on/off value needs to be set, either through
 * normal channels or as a result of a level change.
 *
 * @param endpoint   Ver.: always
 * @param command   Ver.: always
 * @param initiatedByLevelChange   Ver.: always
 */
EmberAfStatus emberAfOnOffClusterSetValueCallback(uint8_t endpoint,
                                                  uint8_t command,
                                                  bool initiatedByLevelChange);

/** @} END On/off Cluster Callbacks */

/** @name On/off Switch Configuration Cluster Callbacks */
// @{

/** @brief On/off Switch Configuration Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId);
/** @brief On/off Switch Configuration Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                  uint8_t commandId,
                                                                  EmberAfStatus status);
/** @brief On/off Switch Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterClientInitCallback(uint8_t endpoint);
/** @brief On/off Switch Configuration Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOnOffSwitchConfigClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       uint16_t manufacturerCode);
/** @brief On/off Switch Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                              uint16_t indexOrDestination,
                                                              EmberApsFrame *apsFrame,
                                                              uint16_t msgLen,
                                                              uint8_t *message,
                                                              EmberStatus status);
/** @brief On/off Switch Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOnOffSwitchConfigClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               EmberAfAttributeType attributeType,
                                                                               uint8_t size,
                                                                               uint8_t *value);
/** @brief On/off Switch Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterClientTickCallback(uint8_t endpoint);
/** @brief On/off Switch Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId);
/** @brief On/off Switch Configuration Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                  uint8_t commandId,
                                                                  EmberAfStatus status);
/** @brief On/off Switch Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterServerInitCallback(uint8_t endpoint);
/** @brief On/off Switch Configuration Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOnOffSwitchConfigClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       uint16_t manufacturerCode);
/** @brief On/off Switch Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                              uint16_t indexOrDestination,
                                                              EmberApsFrame *apsFrame,
                                                              uint16_t msgLen,
                                                              uint8_t *message,
                                                              EmberStatus status);
/** @brief On/off Switch Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOnOffSwitchConfigClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               EmberAfAttributeType attributeType,
                                                                               uint8_t size,
                                                                               uint8_t *value);
/** @brief On/off Switch Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOnOffSwitchConfigClusterServerTickCallback(uint8_t endpoint);

/** @} END On/off Switch Configuration Cluster Callbacks */

/** @name Level Control Cluster Callbacks */
// @{

/** @brief Level Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfLevelControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief Level Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfLevelControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief Level Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfLevelControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Level Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfLevelControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief Level Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfLevelControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief Level Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfLevelControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief Level Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfLevelControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Level Control Cluster Move
 *
 * 
 *
 * @param moveMode   Ver.: always
 * @param rate   Ver.: always
 * @param optionMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfLevelControlClusterMoveCallback(uint8_t moveMode,
                                               uint8_t rate,
                                               uint8_t optionMask,
                                               uint8_t optionOverride);
/** @brief Level Control Cluster Move To Level
 *
 * 
 *
 * @param level   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfLevelControlClusterMoveToLevelCallback(uint8_t level,
                                                      uint16_t transitionTime,
                                                      uint8_t optionMask,
                                                      uint8_t optionOverride);
/** @brief Level Control Cluster Move To Level With On Off
 *
 * 
 *
 * @param level   Ver.: always
 * @param transitionTime   Ver.: always
 */
bool emberAfLevelControlClusterMoveToLevelWithOnOffCallback(uint8_t level,
                                                               uint16_t transitionTime);
/** @brief Level Control Cluster Move With On Off
 *
 * 
 *
 * @param moveMode   Ver.: always
 * @param rate   Ver.: always
 */
bool emberAfLevelControlClusterMoveWithOnOffCallback(uint8_t moveMode,
                                                        uint8_t rate);
/** @brief Level Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfLevelControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief Level Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfLevelControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief Level Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfLevelControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Level Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfLevelControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief Level Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfLevelControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief Level Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfLevelControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief Level Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfLevelControlClusterServerTickCallback(uint8_t endpoint);
/** @brief Level Control Cluster Step
 *
 * 
 *
 * @param stepMode   Ver.: always
 * @param stepSize   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfLevelControlClusterStepCallback(uint8_t stepMode,
                                               uint8_t stepSize,
                                               uint16_t transitionTime,
                                               uint8_t optionMask,
                                               uint8_t optionOverride);
/** @brief Level Control Cluster Step With On Off
 *
 * 
 *
 * @param stepMode   Ver.: always
 * @param stepSize   Ver.: always
 * @param transitionTime   Ver.: always
 */
bool emberAfLevelControlClusterStepWithOnOffCallback(uint8_t stepMode,
                                                        uint8_t stepSize,
                                                        uint16_t transitionTime);
/** @brief Level Control Cluster Stop
 *
 * 
 *
 * @param optionMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfLevelControlClusterStopCallback(uint8_t optionMask,
                                               uint8_t optionOverride);
/** @brief Level Control Cluster Stop With On Off
 *
 * 
 *
 */
bool emberAfLevelControlClusterStopWithOnOffCallback(void);

/** @} END Level Control Cluster Callbacks */

/** @name Alarms Cluster Callbacks */
// @{

/** @brief Alarms Cluster Alarm
 *
 * 
 *
 * @param alarmCode   Ver.: always
 * @param clusterId   Ver.: always
 */
bool emberAfAlarmClusterAlarmCallback(uint8_t alarmCode,
                                         uint16_t clusterId);
/** @brief Alarms Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfAlarmClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief Alarms Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfAlarmClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief Alarms Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfAlarmClusterClientInitCallback(uint8_t endpoint);
/** @brief Alarms Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfAlarmClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief Alarms Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfAlarmClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief Alarms Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfAlarmClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief Alarms Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfAlarmClusterClientTickCallback(uint8_t endpoint);
/** @brief Alarms Cluster Get Alarm
 *
 * 
 *
 */
bool emberAfAlarmClusterGetAlarmCallback(void);
/** @brief Alarms Cluster Get Alarm Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param alarmCode   Ver.: always
 * @param clusterId   Ver.: always
 * @param timeStamp   Ver.: always
 */
bool emberAfAlarmClusterGetAlarmResponseCallback(uint8_t status,
                                                    uint8_t alarmCode,
                                                    uint16_t clusterId,
                                                    uint32_t timeStamp);
/** @brief Alarms Cluster Reset Alarm
 *
 * 
 *
 * @param alarmCode   Ver.: always
 * @param clusterId   Ver.: always
 */
bool emberAfAlarmClusterResetAlarmCallback(uint8_t alarmCode,
                                              uint16_t clusterId);
/** @brief Alarms Cluster Reset Alarm Log
 *
 * 
 *
 */
bool emberAfAlarmClusterResetAlarmLogCallback(void);
/** @brief Alarms Cluster Reset All Alarms
 *
 * 
 *
 */
bool emberAfAlarmClusterResetAllAlarmsCallback(void);
/** @brief Alarms Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfAlarmClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief Alarms Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfAlarmClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief Alarms Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfAlarmClusterServerInitCallback(uint8_t endpoint);
/** @brief Alarms Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfAlarmClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief Alarms Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfAlarmClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief Alarms Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfAlarmClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief Alarms Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfAlarmClusterServerTickCallback(uint8_t endpoint);

/** @} END Alarms Cluster Callbacks */

/** @name Time Cluster Callbacks */
// @{

/** @brief Time Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTimeClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                      EmberAfAttributeId attributeId);
/** @brief Time Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTimeClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                     uint8_t commandId,
                                                     EmberAfStatus status);
/** @brief Time Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTimeClusterClientInitCallback(uint8_t endpoint);
/** @brief Time Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTimeClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          uint16_t manufacturerCode);
/** @brief Time Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTimeClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                 uint16_t indexOrDestination,
                                                 EmberApsFrame *apsFrame,
                                                 uint16_t msgLen,
                                                 uint8_t *message,
                                                 EmberStatus status);
/** @brief Time Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTimeClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId,
                                                                  EmberAfAttributeType attributeType,
                                                                  uint8_t size,
                                                                  uint8_t *value);
/** @brief Time Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTimeClusterClientTickCallback(uint8_t endpoint);
/** @brief Time Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTimeClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                      EmberAfAttributeId attributeId);
/** @brief Time Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTimeClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                     uint8_t commandId,
                                                     EmberAfStatus status);
/** @brief Time Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTimeClusterServerInitCallback(uint8_t endpoint);
/** @brief Time Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTimeClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          uint16_t manufacturerCode);
/** @brief Time Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTimeClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                 uint16_t indexOrDestination,
                                                 EmberApsFrame *apsFrame,
                                                 uint16_t msgLen,
                                                 uint8_t *message,
                                                 EmberStatus status);
/** @brief Time Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTimeClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId,
                                                                  EmberAfAttributeType attributeType,
                                                                  uint8_t size,
                                                                  uint8_t *value);
/** @brief Time Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTimeClusterServerTickCallback(uint8_t endpoint);

/** @} END Time Cluster Callbacks */

/** @name RSSI Location Cluster Callbacks */
// @{

/** @brief RSSI Location Cluster Anchor Node Announce
 *
 * 
 *
 * @param anchorNodeIeeeAddress   Ver.: always
 * @param coordinate1   Ver.: always
 * @param coordinate2   Ver.: always
 * @param coordinate3   Ver.: always
 */
bool emberAfRssiLocationClusterAnchorNodeAnnounceCallback(uint8_t* anchorNodeIeeeAddress,
                                                             int16_t coordinate1,
                                                             int16_t coordinate2,
                                                             int16_t coordinate3);
/** @brief RSSI Location Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfRssiLocationClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief RSSI Location Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfRssiLocationClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief RSSI Location Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfRssiLocationClusterClientInitCallback(uint8_t endpoint);
/** @brief RSSI Location Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfRssiLocationClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief RSSI Location Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfRssiLocationClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief RSSI Location Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfRssiLocationClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief RSSI Location Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfRssiLocationClusterClientTickCallback(uint8_t endpoint);
/** @brief RSSI Location Cluster Compact Location Data Notification
 *
 * 
 *
 * @param locationType   Ver.: always
 * @param coordinate1   Ver.: always
 * @param coordinate2   Ver.: always
 * @param coordinate3   Ver.: always
 * @param qualityMeasure   Ver.: always
 * @param locationAge   Ver.: always
 */
bool emberAfRssiLocationClusterCompactLocationDataNotificationCallback(uint8_t locationType,
                                                                          int16_t coordinate1,
                                                                          int16_t coordinate2,
                                                                          int16_t coordinate3,
                                                                          uint8_t qualityMeasure,
                                                                          uint16_t locationAge);
/** @brief RSSI Location Cluster Device Configuration Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param power   Ver.: always
 * @param pathLossExponent   Ver.: always
 * @param calculationPeriod   Ver.: always
 * @param numberRssiMeasurements   Ver.: always
 * @param reportingPeriod   Ver.: always
 */
bool emberAfRssiLocationClusterDeviceConfigurationResponseCallback(uint8_t status,
                                                                      int16_t power,
                                                                      uint16_t pathLossExponent,
                                                                      uint16_t calculationPeriod,
                                                                      uint8_t numberRssiMeasurements,
                                                                      uint16_t reportingPeriod);
/** @brief RSSI Location Cluster Get Device Configuration
 *
 * 
 *
 * @param targetAddress   Ver.: always
 */
bool emberAfRssiLocationClusterGetDeviceConfigurationCallback(uint8_t* targetAddress);
/** @brief RSSI Location Cluster Get Location Data
 *
 * 
 *
 * @param flags   Ver.: always
 * @param numberResponses   Ver.: always
 * @param targetAddress   Ver.: always
 */
bool emberAfRssiLocationClusterGetLocationDataCallback(uint8_t flags,
                                                          uint8_t numberResponses,
                                                          uint8_t* targetAddress);
/** @brief RSSI Location Cluster Location Data Notification
 *
 * 
 *
 * @param locationType   Ver.: always
 * @param coordinate1   Ver.: always
 * @param coordinate2   Ver.: always
 * @param coordinate3   Ver.: always
 * @param power   Ver.: always
 * @param pathLossExponent   Ver.: always
 * @param locationMethod   Ver.: always
 * @param qualityMeasure   Ver.: always
 * @param locationAge   Ver.: always
 */
bool emberAfRssiLocationClusterLocationDataNotificationCallback(uint8_t locationType,
                                                                   int16_t coordinate1,
                                                                   int16_t coordinate2,
                                                                   int16_t coordinate3,
                                                                   int16_t power,
                                                                   uint16_t pathLossExponent,
                                                                   uint8_t locationMethod,
                                                                   uint8_t qualityMeasure,
                                                                   uint16_t locationAge);
/** @brief RSSI Location Cluster Location Data Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param locationType   Ver.: always
 * @param coordinate1   Ver.: always
 * @param coordinate2   Ver.: always
 * @param coordinate3   Ver.: always
 * @param power   Ver.: always
 * @param pathLossExponent   Ver.: always
 * @param locationMethod   Ver.: always
 * @param qualityMeasure   Ver.: always
 * @param locationAge   Ver.: always
 */
bool emberAfRssiLocationClusterLocationDataResponseCallback(uint8_t status,
                                                               uint8_t locationType,
                                                               int16_t coordinate1,
                                                               int16_t coordinate2,
                                                               int16_t coordinate3,
                                                               int16_t power,
                                                               uint16_t pathLossExponent,
                                                               uint8_t locationMethod,
                                                               uint8_t qualityMeasure,
                                                               uint16_t locationAge);
/** @brief RSSI Location Cluster Report Rssi Measurements
 *
 * 
 *
 * @param measuringDevice   Ver.: always
 * @param neighbors   Ver.: always
 * @param neighborsInfo   Ver.: always
 */
bool emberAfRssiLocationClusterReportRssiMeasurementsCallback(uint8_t* measuringDevice,
                                                                 uint8_t neighbors,
                                                                 uint8_t* neighborsInfo);
/** @brief RSSI Location Cluster Request Own Location
 *
 * 
 *
 * @param blindNode   Ver.: always
 */
bool emberAfRssiLocationClusterRequestOwnLocationCallback(uint8_t* blindNode);
/** @brief RSSI Location Cluster Rssi Ping
 *
 * 
 *
 * @param locationType   Ver.: always
 */
bool emberAfRssiLocationClusterRssiPingCallback(uint8_t locationType);
/** @brief RSSI Location Cluster Rssi Request
 *
 * 
 *
 */
bool emberAfRssiLocationClusterRssiRequestCallback(void);
/** @brief RSSI Location Cluster Rssi Response
 *
 * 
 *
 * @param replyingDevice   Ver.: always
 * @param coordinate1   Ver.: always
 * @param coordinate2   Ver.: always
 * @param coordinate3   Ver.: always
 * @param rssi   Ver.: always
 * @param numberRssiMeasurements   Ver.: always
 */
bool emberAfRssiLocationClusterRssiResponseCallback(uint8_t* replyingDevice,
                                                       int16_t coordinate1,
                                                       int16_t coordinate2,
                                                       int16_t coordinate3,
                                                       int8_t rssi,
                                                       uint8_t numberRssiMeasurements);
/** @brief RSSI Location Cluster Send Pings
 *
 * 
 *
 * @param targetAddress   Ver.: always
 * @param numberRssiMeasurements   Ver.: always
 * @param calculationPeriod   Ver.: always
 */
bool emberAfRssiLocationClusterSendPingsCallback(uint8_t* targetAddress,
                                                    uint8_t numberRssiMeasurements,
                                                    uint16_t calculationPeriod);
/** @brief RSSI Location Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfRssiLocationClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief RSSI Location Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfRssiLocationClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief RSSI Location Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfRssiLocationClusterServerInitCallback(uint8_t endpoint);
/** @brief RSSI Location Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfRssiLocationClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief RSSI Location Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfRssiLocationClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief RSSI Location Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfRssiLocationClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief RSSI Location Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfRssiLocationClusterServerTickCallback(uint8_t endpoint);
/** @brief RSSI Location Cluster Set Absolute Location
 *
 * 
 *
 * @param coordinate1   Ver.: always
 * @param coordinate2   Ver.: always
 * @param coordinate3   Ver.: always
 * @param power   Ver.: always
 * @param pathLossExponent   Ver.: always
 */
bool emberAfRssiLocationClusterSetAbsoluteLocationCallback(int16_t coordinate1,
                                                              int16_t coordinate2,
                                                              int16_t coordinate3,
                                                              int16_t power,
                                                              uint16_t pathLossExponent);
/** @brief RSSI Location Cluster Set Device Configuration
 *
 * 
 *
 * @param power   Ver.: always
 * @param pathLossExponent   Ver.: always
 * @param calculationPeriod   Ver.: always
 * @param numberRssiMeasurements   Ver.: always
 * @param reportingPeriod   Ver.: always
 */
bool emberAfRssiLocationClusterSetDeviceConfigurationCallback(int16_t power,
                                                                 uint16_t pathLossExponent,
                                                                 uint16_t calculationPeriod,
                                                                 uint8_t numberRssiMeasurements,
                                                                 uint16_t reportingPeriod);

/** @} END RSSI Location Cluster Callbacks */

/** @name Binary Input (Basic) Cluster Callbacks */
// @{

/** @brief Binary Input (Basic) Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBinaryInputBasicClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Binary Input (Basic) Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBinaryInputBasicClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Binary Input (Basic) Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBinaryInputBasicClusterClientInitCallback(uint8_t endpoint);
/** @brief Binary Input (Basic) Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBinaryInputBasicClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Binary Input (Basic) Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBinaryInputBasicClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Binary Input (Basic) Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBinaryInputBasicClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Binary Input (Basic) Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBinaryInputBasicClusterClientTickCallback(uint8_t endpoint);
/** @brief Binary Input (Basic) Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBinaryInputBasicClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Binary Input (Basic) Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBinaryInputBasicClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Binary Input (Basic) Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBinaryInputBasicClusterServerInitCallback(uint8_t endpoint);
/** @brief Binary Input (Basic) Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBinaryInputBasicClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Binary Input (Basic) Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBinaryInputBasicClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Binary Input (Basic) Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBinaryInputBasicClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Binary Input (Basic) Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBinaryInputBasicClusterServerTickCallback(uint8_t endpoint);

/** @} END Binary Input (Basic) Cluster Callbacks */

/** @name Commissioning Cluster Callbacks */
// @{

/** @brief Commissioning Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCommissioningClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                               EmberAfAttributeId attributeId);
/** @brief Commissioning Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCommissioningClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                              uint8_t commandId,
                                                              EmberAfStatus status);
/** @brief Commissioning Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCommissioningClusterClientInitCallback(uint8_t endpoint);
/** @brief Commissioning Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCommissioningClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId,
                                                                                   uint16_t manufacturerCode);
/** @brief Commissioning Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCommissioningClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                          uint16_t indexOrDestination,
                                                          EmberApsFrame *apsFrame,
                                                          uint16_t msgLen,
                                                          uint8_t *message,
                                                          EmberStatus status);
/** @brief Commissioning Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCommissioningClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           EmberAfAttributeType attributeType,
                                                                           uint8_t size,
                                                                           uint8_t *value);
/** @brief Commissioning Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCommissioningClusterClientTickCallback(uint8_t endpoint);
/** @brief Commissioning Cluster Reset Startup Parameters
 *
 * 
 *
 * @param options   Ver.: always
 * @param index   Ver.: always
 */
bool emberAfCommissioningClusterResetStartupParametersCallback(uint8_t options,
                                                                  uint8_t index);
/** @brief Commissioning Cluster Reset Startup Parameters Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfCommissioningClusterResetStartupParametersResponseCallback(uint8_t status);
/** @brief Commissioning Cluster Restart Device
 *
 * 
 *
 * @param options   Ver.: always
 * @param delay   Ver.: always
 * @param jitter   Ver.: always
 */
bool emberAfCommissioningClusterRestartDeviceCallback(uint8_t options,
                                                         uint8_t delay,
                                                         uint8_t jitter);
/** @brief Commissioning Cluster Restart Device Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfCommissioningClusterRestartDeviceResponseCallback(uint8_t status);
/** @brief Commissioning Cluster Restore Startup Parameters
 *
 * 
 *
 * @param options   Ver.: always
 * @param index   Ver.: always
 */
bool emberAfCommissioningClusterRestoreStartupParametersCallback(uint8_t options,
                                                                    uint8_t index);
/** @brief Commissioning Cluster Restore Startup Parameters Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfCommissioningClusterRestoreStartupParametersResponseCallback(uint8_t status);
/** @brief Commissioning Cluster Save Startup Parameters
 *
 * 
 *
 * @param options   Ver.: always
 * @param index   Ver.: always
 */
bool emberAfCommissioningClusterSaveStartupParametersCallback(uint8_t options,
                                                                 uint8_t index);
/** @brief Commissioning Cluster Save Startup Parameters Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfCommissioningClusterSaveStartupParametersResponseCallback(uint8_t status);
/** @brief Commissioning Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCommissioningClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                               EmberAfAttributeId attributeId);
/** @brief Commissioning Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCommissioningClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                              uint8_t commandId,
                                                              EmberAfStatus status);
/** @brief Commissioning Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCommissioningClusterServerInitCallback(uint8_t endpoint);
/** @brief Commissioning Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCommissioningClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId,
                                                                                   uint16_t manufacturerCode);
/** @brief Commissioning Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCommissioningClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                          uint16_t indexOrDestination,
                                                          EmberApsFrame *apsFrame,
                                                          uint16_t msgLen,
                                                          uint8_t *message,
                                                          EmberStatus status);
/** @brief Commissioning Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCommissioningClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           EmberAfAttributeType attributeType,
                                                                           uint8_t size,
                                                                           uint8_t *value);
/** @brief Commissioning Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCommissioningClusterServerTickCallback(uint8_t endpoint);

/** @} END Commissioning Cluster Callbacks */

/** @name Partition Cluster Callbacks */
// @{

/** @brief Partition Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPartitionClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Partition Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPartitionClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Partition Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPartitionClusterClientInitCallback(uint8_t endpoint);
/** @brief Partition Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPartitionClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Partition Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPartitionClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Partition Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPartitionClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Partition Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPartitionClusterClientTickCallback(uint8_t endpoint);
/** @brief Partition Cluster Multiple Ack
 *
 * 
 *
 * @param ackOptions   Ver.: always
 * @param firstFrameIdAndNackList   Ver.: always
 */
bool emberAfPartitionClusterMultipleAckCallback(uint8_t ackOptions,
                                                   uint8_t* firstFrameIdAndNackList);
/** @brief Partition Cluster Read Handshake Param
 *
 * 
 *
 * @param partitionedClusterId   Ver.: always
 * @param attributeList   Ver.: always
 */
bool emberAfPartitionClusterReadHandshakeParamCallback(uint16_t partitionedClusterId,
                                                          uint8_t* attributeList);
/** @brief Partition Cluster Read Handshake Param Response
 *
 * 
 *
 * @param partitionedClusterId   Ver.: always
 * @param readAttributeStatusRecords   Ver.: always
 */
bool emberAfPartitionClusterReadHandshakeParamResponseCallback(uint16_t partitionedClusterId,
                                                                  uint8_t* readAttributeStatusRecords);
/** @brief Partition Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPartitionClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Partition Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPartitionClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Partition Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPartitionClusterServerInitCallback(uint8_t endpoint);
/** @brief Partition Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPartitionClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Partition Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPartitionClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Partition Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPartitionClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Partition Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPartitionClusterServerTickCallback(uint8_t endpoint);
/** @brief Partition Cluster Transfer Partitioned Frame
 *
 * 
 *
 * @param fragmentationOptions   Ver.: always
 * @param partitionedIndicatorAndFrame   Ver.: always
 */
bool emberAfPartitionClusterTransferPartitionedFrameCallback(uint8_t fragmentationOptions,
                                                                uint8_t* partitionedIndicatorAndFrame);
/** @brief Partition Cluster Write Handshake Param
 *
 * 
 *
 * @param partitionedClusterId   Ver.: always
 * @param writeAttributeRecords   Ver.: always
 */
bool emberAfPartitionClusterWriteHandshakeParamCallback(uint16_t partitionedClusterId,
                                                           uint8_t* writeAttributeRecords);

/** @} END Partition Cluster Callbacks */

/** @name Over the Air Bootloading Cluster Callbacks */
// @{

/** @brief Over the Air Bootloading Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOtaBootloadClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Over the Air Bootloading Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOtaBootloadClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Over the Air Bootloading Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOtaBootloadClusterClientInitCallback(uint8_t endpoint);
/** @brief Over the Air Bootloading Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOtaBootloadClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Over the Air Bootloading Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOtaBootloadClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Over the Air Bootloading Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOtaBootloadClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Over the Air Bootloading Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOtaBootloadClusterClientTickCallback(uint8_t endpoint);
/** @brief Over the Air Bootloading Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOtaBootloadClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Over the Air Bootloading Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOtaBootloadClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Over the Air Bootloading Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOtaBootloadClusterServerInitCallback(uint8_t endpoint);
/** @brief Over the Air Bootloading Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOtaBootloadClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Over the Air Bootloading Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOtaBootloadClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Over the Air Bootloading Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOtaBootloadClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Over the Air Bootloading Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOtaBootloadClusterServerTickCallback(uint8_t endpoint);

/** @} END Over the Air Bootloading Cluster Callbacks */

/** @name Power Profile Cluster Callbacks */
// @{

/** @brief Power Profile Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPowerProfileClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief Power Profile Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPowerProfileClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief Power Profile Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPowerProfileClusterClientInitCallback(uint8_t endpoint);
/** @brief Power Profile Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPowerProfileClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief Power Profile Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPowerProfileClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief Power Profile Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPowerProfileClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief Power Profile Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPowerProfileClusterClientTickCallback(uint8_t endpoint);
/** @brief Power Profile Cluster Energy Phases Schedule Notification
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param numOfScheduledPhases   Ver.: always
 * @param scheduledPhases   Ver.: always
 */
bool emberAfPowerProfileClusterEnergyPhasesScheduleNotificationCallback(uint8_t powerProfileId,
                                                                           uint8_t numOfScheduledPhases,
                                                                           uint8_t* scheduledPhases);
/** @brief Power Profile Cluster Energy Phases Schedule Request
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 */
bool emberAfPowerProfileClusterEnergyPhasesScheduleRequestCallback(uint8_t powerProfileId);
/** @brief Power Profile Cluster Energy Phases Schedule Response
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param numOfScheduledPhases   Ver.: always
 * @param scheduledPhases   Ver.: always
 */
bool emberAfPowerProfileClusterEnergyPhasesScheduleResponseCallback(uint8_t powerProfileId,
                                                                       uint8_t numOfScheduledPhases,
                                                                       uint8_t* scheduledPhases);
/** @brief Power Profile Cluster Energy Phases Schedule State Notification
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param numOfScheduledPhases   Ver.: always
 * @param scheduledPhases   Ver.: always
 */
bool emberAfPowerProfileClusterEnergyPhasesScheduleStateNotificationCallback(uint8_t powerProfileId,
                                                                                uint8_t numOfScheduledPhases,
                                                                                uint8_t* scheduledPhases);
/** @brief Power Profile Cluster Energy Phases Schedule State Request
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 */
bool emberAfPowerProfileClusterEnergyPhasesScheduleStateRequestCallback(uint8_t powerProfileId);
/** @brief Power Profile Cluster Energy Phases Schedule State Response
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param numOfScheduledPhases   Ver.: always
 * @param scheduledPhases   Ver.: always
 */
bool emberAfPowerProfileClusterEnergyPhasesScheduleStateResponseCallback(uint8_t powerProfileId,
                                                                            uint8_t numOfScheduledPhases,
                                                                            uint8_t* scheduledPhases);
/** @brief Power Profile Cluster Get Overall Schedule Price
 *
 * 
 *
 */
bool emberAfPowerProfileClusterGetOverallSchedulePriceCallback(void);
/** @brief Power Profile Cluster Get Overall Schedule Price Response
 *
 * 
 *
 * @param currency   Ver.: always
 * @param price   Ver.: always
 * @param priceTrailingDigit   Ver.: always
 */
bool emberAfPowerProfileClusterGetOverallSchedulePriceResponseCallback(uint16_t currency,
                                                                          uint32_t price,
                                                                          uint8_t priceTrailingDigit);
/** @brief Power Profile Cluster Get Power Profile Price
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 */
bool emberAfPowerProfileClusterGetPowerProfilePriceCallback(uint8_t powerProfileId);
/** @brief Power Profile Cluster Get Power Profile Price Extended
 *
 * 
 *
 * @param options   Ver.: always
 * @param powerProfileId   Ver.: always
 * @param powerProfileStartTime   Ver.: always
 */
bool emberAfPowerProfileClusterGetPowerProfilePriceExtendedCallback(uint8_t options,
                                                                       uint8_t powerProfileId,
                                                                       uint16_t powerProfileStartTime);
/** @brief Power Profile Cluster Get Power Profile Price Extended Response
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param currency   Ver.: always
 * @param price   Ver.: always
 * @param priceTrailingDigit   Ver.: always
 */
bool emberAfPowerProfileClusterGetPowerProfilePriceExtendedResponseCallback(uint8_t powerProfileId,
                                                                               uint16_t currency,
                                                                               uint32_t price,
                                                                               uint8_t priceTrailingDigit);
/** @brief Power Profile Cluster Get Power Profile Price Response
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param currency   Ver.: always
 * @param price   Ver.: always
 * @param priceTrailingDigit   Ver.: always
 */
bool emberAfPowerProfileClusterGetPowerProfilePriceResponseCallback(uint8_t powerProfileId,
                                                                       uint16_t currency,
                                                                       uint32_t price,
                                                                       uint8_t priceTrailingDigit);
/** @brief Power Profile Cluster Power Profile Notification
 *
 * 
 *
 * @param totalProfileNum   Ver.: always
 * @param powerProfileId   Ver.: always
 * @param numOfTransferredPhases   Ver.: always
 * @param transferredPhases   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfileNotificationCallback(uint8_t totalProfileNum,
                                                                   uint8_t powerProfileId,
                                                                   uint8_t numOfTransferredPhases,
                                                                   uint8_t* transferredPhases);
/** @brief Power Profile Cluster Power Profile Request
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfileRequestCallback(uint8_t powerProfileId);
/** @brief Power Profile Cluster Power Profile Response
 *
 * 
 *
 * @param totalProfileNum   Ver.: always
 * @param powerProfileId   Ver.: always
 * @param numOfTransferredPhases   Ver.: always
 * @param transferredPhases   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfileResponseCallback(uint8_t totalProfileNum,
                                                               uint8_t powerProfileId,
                                                               uint8_t numOfTransferredPhases,
                                                               uint8_t* transferredPhases);
/** @brief Power Profile Cluster Power Profile Schedule Constraints Notification
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param startAfter   Ver.: always
 * @param stopBefore   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfileScheduleConstraintsNotificationCallback(uint8_t powerProfileId,
                                                                                      uint16_t startAfter,
                                                                                      uint16_t stopBefore);
/** @brief Power Profile Cluster Power Profile Schedule Constraints Request
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfileScheduleConstraintsRequestCallback(uint8_t powerProfileId);
/** @brief Power Profile Cluster Power Profile Schedule Constraints Response
 *
 * 
 *
 * @param powerProfileId   Ver.: always
 * @param startAfter   Ver.: always
 * @param stopBefore   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfileScheduleConstraintsResponseCallback(uint8_t powerProfileId,
                                                                                  uint16_t startAfter,
                                                                                  uint16_t stopBefore);
/** @brief Power Profile Cluster Power Profile State Request
 *
 * 
 *
 */
bool emberAfPowerProfileClusterPowerProfileStateRequestCallback(void);
/** @brief Power Profile Cluster Power Profile State Response
 *
 * 
 *
 * @param powerProfileCount   Ver.: always
 * @param powerProfileRecords   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfileStateResponseCallback(uint8_t powerProfileCount,
                                                                    uint8_t* powerProfileRecords);
/** @brief Power Profile Cluster Power Profiles State Notification
 *
 * 
 *
 * @param powerProfileCount   Ver.: always
 * @param powerProfileRecords   Ver.: always
 */
bool emberAfPowerProfileClusterPowerProfilesStateNotificationCallback(uint8_t powerProfileCount,
                                                                         uint8_t* powerProfileRecords);
/** @brief Power Profile Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPowerProfileClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief Power Profile Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPowerProfileClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief Power Profile Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPowerProfileClusterServerInitCallback(uint8_t endpoint);
/** @brief Power Profile Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPowerProfileClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief Power Profile Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPowerProfileClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief Power Profile Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPowerProfileClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief Power Profile Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPowerProfileClusterServerTickCallback(uint8_t endpoint);

/** @} END Power Profile Cluster Callbacks */

/** @name Appliance Control Cluster Callbacks */
// @{

/** @brief Appliance Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfApplianceControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Appliance Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfApplianceControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Appliance Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfApplianceControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Appliance Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfApplianceControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Appliance Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfApplianceControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Appliance Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfApplianceControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Appliance Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfApplianceControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Appliance Control Cluster Execution Of A Command
 *
 * 
 *
 * @param commandId   Ver.: always
 */
bool emberAfApplianceControlClusterExecutionOfACommandCallback(uint8_t commandId);
/** @brief Appliance Control Cluster Overload Pause
 *
 * 
 *
 */
bool emberAfApplianceControlClusterOverloadPauseCallback(void);
/** @brief Appliance Control Cluster Overload Pause Resume
 *
 * 
 *
 */
bool emberAfApplianceControlClusterOverloadPauseResumeCallback(void);
/** @brief Appliance Control Cluster Overload Warning
 *
 * 
 *
 * @param warningEvent   Ver.: always
 */
bool emberAfApplianceControlClusterOverloadWarningCallback(uint8_t warningEvent);
/** @brief Appliance Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfApplianceControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Appliance Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfApplianceControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Appliance Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfApplianceControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Appliance Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfApplianceControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Appliance Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfApplianceControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Appliance Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfApplianceControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Appliance Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfApplianceControlClusterServerTickCallback(uint8_t endpoint);
/** @brief Appliance Control Cluster Signal State
 *
 * 
 *
 */
bool emberAfApplianceControlClusterSignalStateCallback(void);
/** @brief Appliance Control Cluster Signal State Notification
 *
 * 
 *
 * @param applianceStatus   Ver.: always
 * @param remoteEnableFlagsAndDeviceStatus2   Ver.: always
 * @param applianceStatus2   Ver.: always
 */
bool emberAfApplianceControlClusterSignalStateNotificationCallback(uint8_t applianceStatus,
                                                                      uint8_t remoteEnableFlagsAndDeviceStatus2,
                                                                      uint32_t applianceStatus2);
/** @brief Appliance Control Cluster Signal State Response
 *
 * 
 *
 * @param applianceStatus   Ver.: always
 * @param remoteEnableFlagsAndDeviceStatus2   Ver.: always
 * @param applianceStatus2   Ver.: always
 */
bool emberAfApplianceControlClusterSignalStateResponseCallback(uint8_t applianceStatus,
                                                                  uint8_t remoteEnableFlagsAndDeviceStatus2,
                                                                  uint32_t applianceStatus2);
/** @brief Appliance Control Cluster Write Functions
 *
 * 
 *
 * @param functionId   Ver.: always
 * @param functionDataType   Ver.: always
 * @param functionData   Ver.: always
 */
bool emberAfApplianceControlClusterWriteFunctionsCallback(uint16_t functionId,
                                                             uint8_t functionDataType,
                                                             uint8_t* functionData);

/** @} END Appliance Control Cluster Callbacks */

/** @name Poll Control Cluster Callbacks */
// @{

/** @brief Poll Control Cluster Check In
 *
 * 
 *
 */
bool emberAfPollControlClusterCheckInCallback(void);
/** @brief Poll Control Cluster Check In Response
 *
 * 
 *
 * @param startFastPolling   Ver.: always
 * @param fastPollTimeout   Ver.: always
 */
bool emberAfPollControlClusterCheckInResponseCallback(uint8_t startFastPolling,
                                                         uint16_t fastPollTimeout);
/** @brief Poll Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPollControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Poll Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPollControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Poll Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPollControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Poll Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPollControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Poll Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPollControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Poll Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPollControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Poll Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPollControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Poll Control Cluster Fast Poll Stop
 *
 * 
 *
 */
bool emberAfPollControlClusterFastPollStopCallback(void);
/** @brief Poll Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPollControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Poll Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPollControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Poll Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPollControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Poll Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPollControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Poll Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPollControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Poll Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPollControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Poll Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPollControlClusterServerTickCallback(uint8_t endpoint);
/** @brief Poll Control Cluster Set Long Poll Interval
 *
 * 
 *
 * @param newLongPollInterval   Ver.: always
 */
bool emberAfPollControlClusterSetLongPollIntervalCallback(uint32_t newLongPollInterval);
/** @brief Poll Control Cluster Set Short Poll Interval
 *
 * 
 *
 * @param newShortPollInterval   Ver.: always
 */
bool emberAfPollControlClusterSetShortPollIntervalCallback(uint16_t newShortPollInterval);

/** @} END Poll Control Cluster Callbacks */

/** @name Green Power Cluster Callbacks */
// @{

/** @brief Green Power Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfGreenPowerClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Green Power Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfGreenPowerClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Green Power Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfGreenPowerClusterClientInitCallback(uint8_t endpoint);
/** @brief Green Power Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfGreenPowerClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Green Power Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfGreenPowerClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Green Power Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfGreenPowerClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Green Power Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfGreenPowerClusterClientTickCallback(uint8_t endpoint);
/** @brief Green Power Cluster Gp Commissioning Notification
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: since gp-1.0-09-5499-24
 * @param gpdSecurityFrameCounter   Ver.: since gp-1.0-09-5499-24
 * @param gpdCommandId   Ver.: since gp-1.0-09-5499-24
 * @param gpdCommandPayload   Ver.: since gp-1.0-09-5499-24
 * @param gppShortAddress   Ver.: since gp-1.0-09-5499-24
 * @param gppLink   Ver.: since gp-1.0-09-5499-24
 * @param mic   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpCommissioningNotificationCallback(uint16_t options,
                                                                    uint32_t gpdSrcId,
                                                                    uint8_t* gpdIeee,
                                                                    uint8_t endpoint,
                                                                    uint32_t gpdSecurityFrameCounter,
                                                                    uint8_t gpdCommandId,
                                                                    uint8_t* gpdCommandPayload,
                                                                    uint16_t gppShortAddress,
                                                                    uint8_t gppLink,
                                                                    uint32_t mic);
/** @brief Green Power Cluster Gp Notification
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param gpdEndpoint   Ver.: since gp-1.0-09-5499-24
 * @param gpdSecurityFrameCounter   Ver.: since gp-1.0-09-5499-24
 * @param gpdCommandId   Ver.: since gp-1.0-09-5499-24
 * @param gpdCommandPayload   Ver.: since gp-1.0-09-5499-24
 * @param gppShortAddress   Ver.: since gp-1.0-09-5499-24
 * @param gppDistance   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpNotificationCallback(uint16_t options,
                                                       uint32_t gpdSrcId,
                                                       uint8_t* gpdIeee,
                                                       uint8_t gpdEndpoint,
                                                       uint32_t gpdSecurityFrameCounter,
                                                       uint8_t gpdCommandId,
                                                       uint8_t* gpdCommandPayload,
                                                       uint16_t gppShortAddress,
                                                       uint8_t gppDistance);
/** @brief Green Power Cluster Gp Notification Response
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: since gp-1.0-09-5499-24
 * @param gpdSecurityFrameCounter   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpNotificationResponseCallback(uint8_t options,
                                                               uint32_t gpdSrcId,
                                                               uint8_t* gpdIeee,
                                                               uint8_t endpoint,
                                                               uint32_t gpdSecurityFrameCounter);
/** @brief Green Power Cluster Gp Pairing
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: since gp-1.0-09-5499-24
 * @param sinkIeeeAddress   Ver.: since gp-1.0-09-5499-24
 * @param sinkNwkAddress   Ver.: since gp-1.0-09-5499-24
 * @param sinkGroupId   Ver.: since gp-1.0-09-5499-24
 * @param deviceId   Ver.: since gp-1.0-09-5499-24
 * @param gpdSecurityFrameCounter   Ver.: since gp-1.0-09-5499-24
 * @param gpdKey   Ver.: since gp-1.0-09-5499-24
 * @param assignedAlias   Ver.: since gp-1.0-09-5499-24
 * @param groupcastRadius   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpPairingCallback(uint32_t options,
                                                  uint32_t gpdSrcId,
                                                  uint8_t* gpdIeee,
                                                  uint8_t endpoint,
                                                  uint8_t* sinkIeeeAddress,
                                                  uint16_t sinkNwkAddress,
                                                  uint16_t sinkGroupId,
                                                  uint8_t deviceId,
                                                  uint32_t gpdSecurityFrameCounter,
                                                  uint8_t* gpdKey,
                                                  uint16_t assignedAlias,
                                                  uint8_t groupcastRadius);
/** @brief Green Power Cluster Gp Pairing Configuration
 *
 * 
 *
 * @param actions   Ver.: since gp-1.0-09-5499-24
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: since gp-1.0-09-5499-24
 * @param deviceId   Ver.: since gp-1.0-09-5499-24
 * @param groupListCount   Ver.: since gp-1.0-09-5499-24
 * @param groupList   Ver.: since gp-1.0-09-5499-24
 * @param gpdAssignedAlias   Ver.: since gp-1.0-09-5499-24
 * @param groupcastRadius   Ver.: since gp-1.0-15-2014-05-CCB2180
 * @param securityOptions   Ver.: since gp-1.0-09-5499-24
 * @param gpdSecurityFrameCounter   Ver.: since gp-1.0-09-5499-24
 * @param gpdSecurityKey   Ver.: since gp-1.0-09-5499-24
 * @param numberOfPairedEndpoints   Ver.: since gp-1.0-09-5499-24
 * @param pairedEndpoints   Ver.: since gp-1.0-09-5499-24
 * @param applicationInformation   Ver.: always
 * @param manufacturerId   Ver.: always
 * @param modeId   Ver.: always
 * @param numberOfGpdCommands   Ver.: always
 * @param gpdCommandIdList   Ver.: always
 * @param clusterIdListCount   Ver.: always
 * @param clusterListServer   Ver.: always
 * @param clusterListClient   Ver.: always
 * @param switchInformationLength   Ver.: always
 * @param switchConfiguration   Ver.: always
 * @param currentContactStatus   Ver.: always
 * @param totalNumberOfReports   Ver.: always
 * @param numberOfReports   Ver.: always
 * @param reportDescriptor   Ver.: always
 */
bool emberAfGreenPowerClusterGpPairingConfigurationCallback(uint8_t actions,
                                                               uint16_t options,
                                                               uint32_t gpdSrcId,
                                                               uint8_t* gpdIeee,
                                                               uint8_t endpoint,
                                                               uint8_t deviceId,
                                                               uint8_t groupListCount,
                                                               uint8_t* groupList,
                                                               uint16_t gpdAssignedAlias,
                                                               uint8_t groupcastRadius,
                                                               uint8_t securityOptions,
                                                               uint32_t gpdSecurityFrameCounter,
                                                               uint8_t* gpdSecurityKey,
                                                               uint8_t numberOfPairedEndpoints,
                                                               uint8_t* pairedEndpoints,
                                                               uint8_t applicationInformation,
                                                               uint16_t manufacturerId,
                                                               uint16_t modeId,
                                                               uint8_t numberOfGpdCommands,
                                                               uint8_t* gpdCommandIdList,
                                                               uint8_t clusterIdListCount,
                                                               uint8_t* clusterListServer,
                                                               uint8_t* clusterListClient,
                                                               uint8_t switchInformationLength,
                                                               uint8_t switchConfiguration,
                                                               uint8_t currentContactStatus,
                                                               uint8_t totalNumberOfReports,
                                                               uint8_t numberOfReports,
                                                               uint8_t* reportDescriptor);
/** @brief Green Power Cluster Gp Pairing Search
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: always
 */
bool emberAfGreenPowerClusterGpPairingSearchCallback(uint16_t options,
                                                        uint32_t gpdSrcId,
                                                        uint8_t* gpdIeee,
                                                        uint8_t endpoint);
/** @brief Green Power Cluster Gp Proxy Commissioning Mode
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param commissioningWindow   Ver.: since gp-1.0-15-02014-011
 * @param channel   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpProxyCommissioningModeCallback(uint8_t options,
                                                                 uint16_t commissioningWindow,
                                                                 uint8_t channel);
/** @brief Green Power Cluster Gp Proxy Table Request
 *
 * 
 *
 * @param options   Ver.: always
 * @param gpdSrcId   Ver.: always
 * @param gpdIeee   Ver.: always
 * @param endpoint   Ver.: always
 * @param index   Ver.: always
 */
bool emberAfGreenPowerClusterGpProxyTableRequestCallback(uint8_t options,
                                                            uint32_t gpdSrcId,
                                                            uint8_t* gpdIeee,
                                                            uint8_t endpoint,
                                                            uint8_t index);
/** @brief Green Power Cluster Gp Proxy Table Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param totalNumberOfNonEmptyProxyTableEntries   Ver.: always
 * @param startIndex   Ver.: always
 * @param entriesCount   Ver.: always
 * @param proxyTableEntries   Ver.: always
 */
bool emberAfGreenPowerClusterGpProxyTableResponseCallback(uint8_t status,
                                                             uint8_t totalNumberOfNonEmptyProxyTableEntries,
                                                             uint8_t startIndex,
                                                             uint8_t entriesCount,
                                                             uint8_t* proxyTableEntries);
/** @brief Green Power Cluster Gp Response
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param tempMasterShortAddress   Ver.: since gp-1.0-09-5499-24
 * @param tempMasterTxChannel   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: always
 * @param gpdCommandId   Ver.: since gp-1.0-09-5499-24
 * @param gpdCommandPayload   Ver.: always
 */
bool emberAfGreenPowerClusterGpResponseCallback(uint8_t options,
                                                   uint16_t tempMasterShortAddress,
                                                   uint8_t tempMasterTxChannel,
                                                   uint32_t gpdSrcId,
                                                   uint8_t* gpdIeee,
                                                   uint8_t endpoint,
                                                   uint8_t gpdCommandId,
                                                   uint8_t* gpdCommandPayload);
/** @brief Green Power Cluster Gp Sink Commissioning Mode
 *
 * 
 *
 * @param options   Ver.: always
 * @param gpmAddrForSecurity   Ver.: always
 * @param gpmAddrForPairing   Ver.: always
 * @param sinkEndpoint   Ver.: always
 */
bool emberAfGreenPowerClusterGpSinkCommissioningModeCallback(uint8_t options,
                                                                uint16_t gpmAddrForSecurity,
                                                                uint16_t gpmAddrForPairing,
                                                                uint8_t sinkEndpoint);
/** @brief Green Power Cluster Gp Sink Table Request
 *
 * 
 *
 * @param options   Ver.: always
 * @param gpdSrcId   Ver.: always
 * @param gpdIeee   Ver.: always
 * @param endpoint   Ver.: always
 * @param index   Ver.: always
 */
bool emberAfGreenPowerClusterGpSinkTableRequestCallback(uint8_t options,
                                                           uint32_t gpdSrcId,
                                                           uint8_t* gpdIeee,
                                                           uint8_t endpoint,
                                                           uint8_t index);
/** @brief Green Power Cluster Gp Sink Table Response
 *
 * 
 *
 * @param status   Ver.: always
 * @param totalNumberofNonEmptySinkTableEntries   Ver.: always
 * @param startIndex   Ver.: always
 * @param sinkTableEntriesCount   Ver.: always
 * @param sinkTableEntries   Ver.: always
 */
bool emberAfGreenPowerClusterGpSinkTableResponseCallback(uint8_t status,
                                                            uint8_t totalNumberofNonEmptySinkTableEntries,
                                                            uint8_t startIndex,
                                                            uint8_t sinkTableEntriesCount,
                                                            uint8_t* sinkTableEntries);
/** @brief Green Power Cluster Gp Translation Table Request
 *
 * 
 *
 * @param startIndex   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpTranslationTableRequestCallback(uint8_t startIndex);
/** @brief Green Power Cluster Gp Translation Table Response
 *
 * 
 *
 * @param status   Ver.: since gp-1.0-09-5499-24
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param totalNumberOfEntries   Ver.: since gp-1.0-09-5499-24
 * @param startIndex   Ver.: since gp-1.0-09-5499-24
 * @param entriesCount   Ver.: since gp-1.0-09-5499-24
 * @param translationTableList   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpTranslationTableResponseCallback(uint8_t status,
                                                                   uint8_t options,
                                                                   uint8_t totalNumberOfEntries,
                                                                   uint8_t startIndex,
                                                                   uint8_t entriesCount,
                                                                   uint8_t* translationTableList);
/** @brief Green Power Cluster Gp Translation Table Update
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: since gp-1.0-09-5499-24
 * @param translations   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpTranslationTableUpdateCallback(uint16_t options,
                                                                 uint32_t gpdSrcId,
                                                                 uint8_t* gpdIeee,
                                                                 uint8_t endpoint,
                                                                 uint8_t* translations);
/** @brief Green Power Cluster Gp Tunneling Stop
 *
 * 
 *
 * @param options   Ver.: since gp-1.0-09-5499-24
 * @param gpdSrcId   Ver.: since gp-1.0-09-5499-24
 * @param gpdIeee   Ver.: since gp-1.0-09-5499-24
 * @param endpoint   Ver.: since gp-1.0-09-5499-24
 * @param gpdSecurityFrameCounter   Ver.: since gp-1.0-09-5499-24
 * @param gppShortAddress   Ver.: since gp-1.0-09-5499-24
 * @param gppDistance   Ver.: since gp-1.0-09-5499-24
 */
bool emberAfGreenPowerClusterGpTunnelingStopCallback(uint8_t options,
                                                        uint32_t gpdSrcId,
                                                        uint8_t* gpdIeee,
                                                        uint8_t endpoint,
                                                        uint32_t gpdSecurityFrameCounter,
                                                        uint16_t gppShortAddress,
                                                        int8_t gppDistance);
/** @brief Green Power Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfGreenPowerClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Green Power Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfGreenPowerClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Green Power Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfGreenPowerClusterServerInitCallback(uint8_t endpoint);
/** @brief Green Power Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfGreenPowerClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Green Power Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfGreenPowerClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Green Power Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfGreenPowerClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Green Power Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfGreenPowerClusterServerTickCallback(uint8_t endpoint);

/** @} END Green Power Cluster Callbacks */

/** @name Keep-Alive Cluster Callbacks */
// @{

/** @brief Keep-Alive Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfKeepaliveClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Keep-Alive Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfKeepaliveClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Keep-Alive Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfKeepaliveClusterClientInitCallback(uint8_t endpoint);
/** @brief Keep-Alive Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfKeepaliveClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Keep-Alive Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfKeepaliveClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Keep-Alive Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfKeepaliveClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Keep-Alive Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfKeepaliveClusterClientTickCallback(uint8_t endpoint);
/** @brief Keep-Alive Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfKeepaliveClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Keep-Alive Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfKeepaliveClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Keep-Alive Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfKeepaliveClusterServerInitCallback(uint8_t endpoint);
/** @brief Keep-Alive Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfKeepaliveClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Keep-Alive Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfKeepaliveClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Keep-Alive Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfKeepaliveClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Keep-Alive Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfKeepaliveClusterServerTickCallback(uint8_t endpoint);

/** @} END Keep-Alive Cluster Callbacks */

/** @name Shade Configuration Cluster Callbacks */
// @{

/** @brief Shade Configuration Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfShadeConfigClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Shade Configuration Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfShadeConfigClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Shade Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfShadeConfigClusterClientInitCallback(uint8_t endpoint);
/** @brief Shade Configuration Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfShadeConfigClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Shade Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfShadeConfigClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Shade Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfShadeConfigClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Shade Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfShadeConfigClusterClientTickCallback(uint8_t endpoint);
/** @brief Shade Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfShadeConfigClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                             EmberAfAttributeId attributeId);
/** @brief Shade Configuration Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfShadeConfigClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                            uint8_t commandId,
                                                            EmberAfStatus status);
/** @brief Shade Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfShadeConfigClusterServerInitCallback(uint8_t endpoint);
/** @brief Shade Configuration Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfShadeConfigClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 uint16_t manufacturerCode);
/** @brief Shade Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfShadeConfigClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                        uint16_t indexOrDestination,
                                                        EmberApsFrame *apsFrame,
                                                        uint16_t msgLen,
                                                        uint8_t *message,
                                                        EmberStatus status);
/** @brief Shade Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfShadeConfigClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                         EmberAfAttributeId attributeId,
                                                                         EmberAfAttributeType attributeType,
                                                                         uint8_t size,
                                                                         uint8_t *value);
/** @brief Shade Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfShadeConfigClusterServerTickCallback(uint8_t endpoint);

/** @} END Shade Configuration Cluster Callbacks */

/** @name Door Lock Cluster Callbacks */
// @{

/** @brief Door Lock Cluster Clear All Pins
 *
 * 
 *
 */
bool emberAfDoorLockClusterClearAllPinsCallback(void);
/** @brief Door Lock Cluster Clear All Pins Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterClearAllPinsResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Clear All Rfids
 *
 * 
 *
 */
bool emberAfDoorLockClusterClearAllRfidsCallback(void);
/** @brief Door Lock Cluster Clear All Rfids Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterClearAllRfidsResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Clear Holiday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 */
bool emberAfDoorLockClusterClearHolidayScheduleCallback(uint8_t scheduleId);
/** @brief Door Lock Cluster Clear Holiday Schedule Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterClearHolidayScheduleResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Clear Pin
 *
 * 
 *
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterClearPinCallback(uint16_t userId);
/** @brief Door Lock Cluster Clear Pin Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterClearPinResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Clear Rfid
 *
 * 
 *
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterClearRfidCallback(uint16_t userId);
/** @brief Door Lock Cluster Clear Rfid Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterClearRfidResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Clear Weekday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterClearWeekdayScheduleCallback(uint8_t scheduleId,
                                                           uint16_t userId);
/** @brief Door Lock Cluster Clear Weekday Schedule Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterClearWeekdayScheduleResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Clear Yearday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterClearYeardayScheduleCallback(uint8_t scheduleId,
                                                           uint16_t userId);
/** @brief Door Lock Cluster Clear Yearday Schedule Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterClearYeardayScheduleResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDoorLockClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                          EmberAfAttributeId attributeId);
/** @brief Door Lock Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDoorLockClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                         uint8_t commandId,
                                                         EmberAfStatus status);
/** @brief Door Lock Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDoorLockClusterClientInitCallback(uint8_t endpoint);
/** @brief Door Lock Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDoorLockClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              uint16_t manufacturerCode);
/** @brief Door Lock Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDoorLockClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                     uint16_t indexOrDestination,
                                                     EmberApsFrame *apsFrame,
                                                     uint16_t msgLen,
                                                     uint8_t *message,
                                                     EmberStatus status);
/** @brief Door Lock Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDoorLockClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId,
                                                                      EmberAfAttributeType attributeType,
                                                                      uint8_t size,
                                                                      uint8_t *value);
/** @brief Door Lock Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDoorLockClusterClientTickCallback(uint8_t endpoint);
/** @brief Door Lock Cluster Get Holiday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 */
bool emberAfDoorLockClusterGetHolidayScheduleCallback(uint8_t scheduleId);
/** @brief Door Lock Cluster Get Holiday Schedule Response
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param status   Ver.: always
 * @param localStartTime   Ver.: since ha-1.2-05-3520-29
 * @param localEndTime   Ver.: since ha-1.2-05-3520-29
 * @param operatingModeDuringHoliday   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterGetHolidayScheduleResponseCallback(uint8_t scheduleId,
                                                                 uint8_t status,
                                                                 uint32_t localStartTime,
                                                                 uint32_t localEndTime,
                                                                 uint8_t operatingModeDuringHoliday);
/** @brief Door Lock Cluster Get Log Record
 *
 * 
 *
 * @param logIndex   Ver.: always
 */
bool emberAfDoorLockClusterGetLogRecordCallback(uint16_t logIndex);
/** @brief Door Lock Cluster Get Log Record Response
 *
 * 
 *
 * @param logEntryId   Ver.: always
 * @param timestamp   Ver.: always
 * @param eventType   Ver.: always
 * @param source   Ver.: always
 * @param eventIdOrAlarmCode   Ver.: always
 * @param userId   Ver.: always
 * @param pin   Ver.: always
 */
bool emberAfDoorLockClusterGetLogRecordResponseCallback(uint16_t logEntryId,
                                                           uint32_t timestamp,
                                                           uint8_t eventType,
                                                           uint8_t source,
                                                           uint8_t eventIdOrAlarmCode,
                                                           uint16_t userId,
                                                           uint8_t* pin);
/** @brief Door Lock Cluster Get Pin
 *
 * 
 *
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterGetPinCallback(uint16_t userId);
/** @brief Door Lock Cluster Get Pin Response
 *
 * 
 *
 * @param userId   Ver.: always
 * @param userStatus   Ver.: always
 * @param userType   Ver.: always
 * @param pin   Ver.: always
 */
bool emberAfDoorLockClusterGetPinResponseCallback(uint16_t userId,
                                                     uint8_t userStatus,
                                                     uint8_t userType,
                                                     uint8_t* pin);
/** @brief Door Lock Cluster Get Rfid
 *
 * 
 *
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterGetRfidCallback(uint16_t userId);
/** @brief Door Lock Cluster Get Rfid Response
 *
 * 
 *
 * @param userId   Ver.: always
 * @param userStatus   Ver.: always
 * @param userType   Ver.: always
 * @param rfid   Ver.: always
 */
bool emberAfDoorLockClusterGetRfidResponseCallback(uint16_t userId,
                                                      uint8_t userStatus,
                                                      uint8_t userType,
                                                      uint8_t* rfid);
/** @brief Door Lock Cluster Get User Status
 *
 * 
 *
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterGetUserStatusCallback(uint16_t userId);
/** @brief Door Lock Cluster Get User Status Response
 *
 * 
 *
 * @param userId   Ver.: always
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterGetUserStatusResponseCallback(uint16_t userId,
                                                            uint8_t status);
/** @brief Door Lock Cluster Get User Type
 *
 * 
 *
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterGetUserTypeCallback(uint16_t userId);
/** @brief Door Lock Cluster Get User Type Response
 *
 * 
 *
 * @param userId   Ver.: always
 * @param userType   Ver.: always
 */
bool emberAfDoorLockClusterGetUserTypeResponseCallback(uint16_t userId,
                                                          uint8_t userType);
/** @brief Door Lock Cluster Get Weekday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterGetWeekdayScheduleCallback(uint8_t scheduleId,
                                                         uint16_t userId);
/** @brief Door Lock Cluster Get Weekday Schedule Response
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 * @param status   Ver.: always
 * @param daysMask   Ver.: since ha-1.2-05-3520-29
 * @param startHour   Ver.: since ha-1.2-05-3520-29
 * @param startMinute   Ver.: since ha-1.2-05-3520-29
 * @param endHour   Ver.: since ha-1.2-05-3520-29
 * @param endMinute   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterGetWeekdayScheduleResponseCallback(uint8_t scheduleId,
                                                                 uint16_t userId,
                                                                 uint8_t status,
                                                                 uint8_t daysMask,
                                                                 uint8_t startHour,
                                                                 uint8_t startMinute,
                                                                 uint8_t endHour,
                                                                 uint8_t endMinute);
/** @brief Door Lock Cluster Get Yearday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 */
bool emberAfDoorLockClusterGetYeardayScheduleCallback(uint8_t scheduleId,
                                                         uint16_t userId);
/** @brief Door Lock Cluster Get Yearday Schedule Response
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 * @param status   Ver.: always
 * @param localStartTime   Ver.: since ha-1.2-05-3520-29
 * @param localEndTime   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterGetYeardayScheduleResponseCallback(uint8_t scheduleId,
                                                                 uint16_t userId,
                                                                 uint8_t status,
                                                                 uint32_t localStartTime,
                                                                 uint32_t localEndTime);
/** @brief Door Lock Cluster Lock Door
 *
 * 
 *
 * @param PIN   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterLockDoorCallback(uint8_t* PIN);
/** @brief Door Lock Cluster Lock Door Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterLockDoorResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Operation Event Notification
 *
 * 
 *
 * @param source   Ver.: always
 * @param eventCode   Ver.: always
 * @param userId   Ver.: always
 * @param pin   Ver.: always
 * @param timeStamp   Ver.: always
 * @param data   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterOperationEventNotificationCallback(uint8_t source,
                                                                 uint8_t eventCode,
                                                                 uint16_t userId,
                                                                 uint8_t* pin,
                                                                 uint32_t timeStamp,
                                                                 uint8_t* data);
/** @brief Door Lock Cluster Programming Event Notification
 *
 * 
 *
 * @param source   Ver.: always
 * @param eventCode   Ver.: always
 * @param userId   Ver.: always
 * @param pin   Ver.: always
 * @param userType   Ver.: always
 * @param userStatus   Ver.: always
 * @param timeStamp   Ver.: always
 * @param data   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterProgrammingEventNotificationCallback(uint8_t source,
                                                                   uint8_t eventCode,
                                                                   uint16_t userId,
                                                                   uint8_t* pin,
                                                                   uint8_t userType,
                                                                   uint8_t userStatus,
                                                                   uint32_t timeStamp,
                                                                   uint8_t* data);
/** @brief Door Lock Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDoorLockClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                          EmberAfAttributeId attributeId);
/** @brief Door Lock Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDoorLockClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                         uint8_t commandId,
                                                         EmberAfStatus status);
/** @brief Door Lock Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDoorLockClusterServerInitCallback(uint8_t endpoint);
/** @brief Door Lock Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDoorLockClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              uint16_t manufacturerCode);
/** @brief Door Lock Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDoorLockClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                     uint16_t indexOrDestination,
                                                     EmberApsFrame *apsFrame,
                                                     uint16_t msgLen,
                                                     uint8_t *message,
                                                     EmberStatus status);
/** @brief Door Lock Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDoorLockClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId,
                                                                      EmberAfAttributeType attributeType,
                                                                      uint8_t size,
                                                                      uint8_t *value);
/** @brief Door Lock Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDoorLockClusterServerTickCallback(uint8_t endpoint);
/** @brief Door Lock Cluster Set Holiday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param localStartTime   Ver.: always
 * @param localEndTime   Ver.: always
 * @param operatingModeDuringHoliday   Ver.: always
 */
bool emberAfDoorLockClusterSetHolidayScheduleCallback(uint8_t scheduleId,
                                                         uint32_t localStartTime,
                                                         uint32_t localEndTime,
                                                         uint8_t operatingModeDuringHoliday);
/** @brief Door Lock Cluster Set Holiday Schedule Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterSetHolidayScheduleResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Set Pin
 *
 * 
 *
 * @param userId   Ver.: always
 * @param userStatus   Ver.: always
 * @param userType   Ver.: always
 * @param pin   Ver.: always
 */
bool emberAfDoorLockClusterSetPinCallback(uint16_t userId,
                                             uint8_t userStatus,
                                             uint8_t userType,
                                             uint8_t* pin);
/** @brief Door Lock Cluster Set Pin Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterSetPinResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Set Rfid
 *
 * 
 *
 * @param userId   Ver.: always
 * @param userStatus   Ver.: always
 * @param userType   Ver.: always
 * @param id   Ver.: always
 */
bool emberAfDoorLockClusterSetRfidCallback(uint16_t userId,
                                              uint8_t userStatus,
                                              uint8_t userType,
                                              uint8_t* id);
/** @brief Door Lock Cluster Set Rfid Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterSetRfidResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Set User Status
 *
 * 
 *
 * @param userId   Ver.: always
 * @param userStatus   Ver.: always
 */
bool emberAfDoorLockClusterSetUserStatusCallback(uint16_t userId,
                                                    uint8_t userStatus);
/** @brief Door Lock Cluster Set User Status Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterSetUserStatusResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Set User Type
 *
 * 
 *
 * @param userId   Ver.: always
 * @param userType   Ver.: always
 */
bool emberAfDoorLockClusterSetUserTypeCallback(uint16_t userId,
                                                  uint8_t userType);
/** @brief Door Lock Cluster Set User Type Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterSetUserTypeResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Set Weekday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 * @param daysMask   Ver.: always
 * @param startHour   Ver.: always
 * @param startMinute   Ver.: always
 * @param endHour   Ver.: always
 * @param endMinute   Ver.: always
 */
bool emberAfDoorLockClusterSetWeekdayScheduleCallback(uint8_t scheduleId,
                                                         uint16_t userId,
                                                         uint8_t daysMask,
                                                         uint8_t startHour,
                                                         uint8_t startMinute,
                                                         uint8_t endHour,
                                                         uint8_t endMinute);
/** @brief Door Lock Cluster Set Weekday Schedule Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterSetWeekdayScheduleResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Set Yearday Schedule
 *
 * 
 *
 * @param scheduleId   Ver.: always
 * @param userId   Ver.: always
 * @param localStartTime   Ver.: always
 * @param localEndTime   Ver.: always
 */
bool emberAfDoorLockClusterSetYeardayScheduleCallback(uint8_t scheduleId,
                                                         uint16_t userId,
                                                         uint32_t localStartTime,
                                                         uint32_t localEndTime);
/** @brief Door Lock Cluster Set Yearday Schedule Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterSetYeardayScheduleResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Toggle
 *
 * 
 *
 * @param pin   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterToggleCallback(uint8_t* pin);
/** @brief Door Lock Cluster Toggle Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterToggleResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Unlock Door
 *
 * 
 *
 * @param PIN   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterUnlockDoorCallback(uint8_t* PIN);
/** @brief Door Lock Cluster Unlock Door Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterUnlockDoorResponseCallback(uint8_t status);
/** @brief Door Lock Cluster Unlock With Timeout
 *
 * 
 *
 * @param timeoutInSeconds   Ver.: always
 * @param pin   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfDoorLockClusterUnlockWithTimeoutCallback(uint16_t timeoutInSeconds,
                                                        uint8_t* pin);
/** @brief Door Lock Cluster Unlock With Timeout Response
 *
 * 
 *
 * @param status   Ver.: always
 */
bool emberAfDoorLockClusterUnlockWithTimeoutResponseCallback(uint8_t status);

/** @} END Door Lock Cluster Callbacks */

/** @name Window Covering Cluster Callbacks */
// @{

/** @brief Window Covering Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfWindowCoveringClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Window Covering Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfWindowCoveringClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Window Covering Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfWindowCoveringClusterClientInitCallback(uint8_t endpoint);
/** @brief Window Covering Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfWindowCoveringClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Window Covering Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfWindowCoveringClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Window Covering Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfWindowCoveringClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Window Covering Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfWindowCoveringClusterClientTickCallback(uint8_t endpoint);
/** @brief Window Covering Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfWindowCoveringClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Window Covering Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfWindowCoveringClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Window Covering Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfWindowCoveringClusterServerInitCallback(uint8_t endpoint);
/** @brief Window Covering Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfWindowCoveringClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Window Covering Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfWindowCoveringClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Window Covering Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfWindowCoveringClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Window Covering Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfWindowCoveringClusterServerTickCallback(uint8_t endpoint);
/** @brief Window Covering Cluster Window Covering Down Close
 *
 * 
 *
 */
bool emberAfWindowCoveringClusterWindowCoveringDownCloseCallback(void);
/** @brief Window Covering Cluster Window Covering Go To Lift Percentage
 *
 * 
 *
 * @param percentageLiftValue   Ver.: always
 */
bool emberAfWindowCoveringClusterWindowCoveringGoToLiftPercentageCallback(uint8_t percentageLiftValue);
/** @brief Window Covering Cluster Window Covering Go To Lift Value
 *
 * 
 *
 * @param liftValue   Ver.: always
 */
bool emberAfWindowCoveringClusterWindowCoveringGoToLiftValueCallback(uint16_t liftValue);
/** @brief Window Covering Cluster Window Covering Go To Tilt Percentage
 *
 * 
 *
 * @param percentageTiltValue   Ver.: always
 */
bool emberAfWindowCoveringClusterWindowCoveringGoToTiltPercentageCallback(uint8_t percentageTiltValue);
/** @brief Window Covering Cluster Window Covering Go To Tilt Value
 *
 * 
 *
 * @param tiltValue   Ver.: always
 */
bool emberAfWindowCoveringClusterWindowCoveringGoToTiltValueCallback(uint16_t tiltValue);
/** @brief Window Covering Cluster Window Covering Stop
 *
 * 
 *
 */
bool emberAfWindowCoveringClusterWindowCoveringStopCallback(void);
/** @brief Window Covering Cluster Window Covering Up Open
 *
 * 
 *
 */
bool emberAfWindowCoveringClusterWindowCoveringUpOpenCallback(void);

/** @} END Window Covering Cluster Callbacks */

/** @name Barrier Control Cluster Callbacks */
// @{

/** @brief Barrier Control Cluster Barrier Control Go To Percent
 *
 * 
 *
 * @param percentOpen   Ver.: always
 */
bool emberAfBarrierControlClusterBarrierControlGoToPercentCallback(uint8_t percentOpen);
/** @brief Barrier Control Cluster Barrier Control Stop
 *
 * 
 *
 */
bool emberAfBarrierControlClusterBarrierControlStopCallback(void);
/** @brief Barrier Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBarrierControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Barrier Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBarrierControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Barrier Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBarrierControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Barrier Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBarrierControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Barrier Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBarrierControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Barrier Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBarrierControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Barrier Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBarrierControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Barrier Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBarrierControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Barrier Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBarrierControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Barrier Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBarrierControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Barrier Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBarrierControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Barrier Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBarrierControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Barrier Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBarrierControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Barrier Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBarrierControlClusterServerTickCallback(uint8_t endpoint);

/** @} END Barrier Control Cluster Callbacks */

/** @name Pump Configuration and Control Cluster Callbacks */
// @{

/** @brief Pump Configuration and Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPumpConfigControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId);
/** @brief Pump Configuration and Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPumpConfigControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                  uint8_t commandId,
                                                                  EmberAfStatus status);
/** @brief Pump Configuration and Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPumpConfigControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Pump Configuration and Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPumpConfigControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       uint16_t manufacturerCode);
/** @brief Pump Configuration and Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPumpConfigControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                              uint16_t indexOrDestination,
                                                              EmberApsFrame *apsFrame,
                                                              uint16_t msgLen,
                                                              uint8_t *message,
                                                              EmberStatus status);
/** @brief Pump Configuration and Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPumpConfigControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               EmberAfAttributeType attributeType,
                                                                               uint8_t size,
                                                                               uint8_t *value);
/** @brief Pump Configuration and Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPumpConfigControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Pump Configuration and Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPumpConfigControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId);
/** @brief Pump Configuration and Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPumpConfigControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                  uint8_t commandId,
                                                                  EmberAfStatus status);
/** @brief Pump Configuration and Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPumpConfigControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Pump Configuration and Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPumpConfigControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       uint16_t manufacturerCode);
/** @brief Pump Configuration and Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPumpConfigControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                              uint16_t indexOrDestination,
                                                              EmberApsFrame *apsFrame,
                                                              uint16_t msgLen,
                                                              uint8_t *message,
                                                              EmberStatus status);
/** @brief Pump Configuration and Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPumpConfigControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               EmberAfAttributeType attributeType,
                                                                               uint8_t size,
                                                                               uint8_t *value);
/** @brief Pump Configuration and Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPumpConfigControlClusterServerTickCallback(uint8_t endpoint);

/** @} END Pump Configuration and Control Cluster Callbacks */

/** @name Thermostat Cluster Callbacks */
// @{

/** @brief Thermostat Cluster Clear Weekly Schedule
 *
 * 
 *
 */
bool emberAfThermostatClusterClearWeeklyScheduleCallback(void);
/** @brief Thermostat Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfThermostatClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Thermostat Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfThermostatClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Thermostat Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfThermostatClusterClientInitCallback(uint8_t endpoint);
/** @brief Thermostat Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfThermostatClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Thermostat Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfThermostatClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Thermostat Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfThermostatClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Thermostat Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfThermostatClusterClientTickCallback(uint8_t endpoint);
/** @brief Thermostat Cluster Current Weekly Schedule
 *
 * 
 *
 * @param numberOfTransitionsForSequence   Ver.: always
 * @param dayOfWeekForSequence   Ver.: always
 * @param modeForSequence   Ver.: always
 * @param payload   Ver.: always
 */
bool emberAfThermostatClusterCurrentWeeklyScheduleCallback(uint8_t numberOfTransitionsForSequence,
                                                              uint8_t dayOfWeekForSequence,
                                                              uint8_t modeForSequence,
                                                              uint8_t* payload);
/** @brief Thermostat Cluster Get Relay Status Log
 *
 * 
 *
 */
bool emberAfThermostatClusterGetRelayStatusLogCallback(void);
/** @brief Thermostat Cluster Get Weekly Schedule
 *
 * 
 *
 * @param daysToReturn   Ver.: always
 * @param modeToReturn   Ver.: always
 */
bool emberAfThermostatClusterGetWeeklyScheduleCallback(uint8_t daysToReturn,
                                                          uint8_t modeToReturn);
/** @brief Thermostat Cluster Relay Status Log
 *
 * 
 *
 * @param timeOfDay   Ver.: always
 * @param relayStatus   Ver.: always
 * @param localTemperature   Ver.: always
 * @param humidityInPercentage   Ver.: always
 * @param setpoint   Ver.: always
 * @param unreadEntries   Ver.: always
 */
bool emberAfThermostatClusterRelayStatusLogCallback(uint16_t timeOfDay,
                                                       uint16_t relayStatus,
                                                       int16_t localTemperature,
                                                       uint8_t humidityInPercentage,
                                                       int16_t setpoint,
                                                       uint16_t unreadEntries);
/** @brief Thermostat Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfThermostatClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Thermostat Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfThermostatClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Thermostat Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfThermostatClusterServerInitCallback(uint8_t endpoint);
/** @brief Thermostat Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfThermostatClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Thermostat Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfThermostatClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Thermostat Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfThermostatClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Thermostat Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfThermostatClusterServerTickCallback(uint8_t endpoint);
/** @brief Thermostat Cluster Set Weekly Schedule
 *
 * 
 *
 * @param numberOfTransitionsForSequence   Ver.: always
 * @param dayOfWeekForSequence   Ver.: always
 * @param modeForSequence   Ver.: always
 * @param payload   Ver.: always
 */
bool emberAfThermostatClusterSetWeeklyScheduleCallback(uint8_t numberOfTransitionsForSequence,
                                                          uint8_t dayOfWeekForSequence,
                                                          uint8_t modeForSequence,
                                                          uint8_t* payload);
/** @brief Thermostat Cluster Setpoint Raise Lower
 *
 * 
 *
 * @param mode   Ver.: always
 * @param amount   Ver.: always
 */
bool emberAfThermostatClusterSetpointRaiseLowerCallback(uint8_t mode,
                                                           int8_t amount);

/** @} END Thermostat Cluster Callbacks */

/** @name Fan Control Cluster Callbacks */
// @{

/** @brief Fan Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFanControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Fan Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFanControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Fan Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFanControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Fan Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFanControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Fan Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFanControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Fan Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFanControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Fan Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFanControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Fan Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFanControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Fan Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFanControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Fan Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFanControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Fan Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFanControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Fan Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFanControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Fan Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFanControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Fan Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFanControlClusterServerTickCallback(uint8_t endpoint);

/** @} END Fan Control Cluster Callbacks */

/** @name Dehumidification Control Cluster Callbacks */
// @{

/** @brief Dehumidification Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDehumidControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Dehumidification Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDehumidControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Dehumidification Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDehumidControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Dehumidification Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDehumidControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Dehumidification Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDehumidControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Dehumidification Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDehumidControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Dehumidification Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDehumidControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Dehumidification Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDehumidControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Dehumidification Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDehumidControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Dehumidification Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDehumidControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Dehumidification Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDehumidControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Dehumidification Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDehumidControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Dehumidification Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDehumidControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Dehumidification Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDehumidControlClusterServerTickCallback(uint8_t endpoint);

/** @} END Dehumidification Control Cluster Callbacks */

/** @name Thermostat User Interface Configuration Cluster Callbacks */
// @{

/** @brief Thermostat User Interface Configuration Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfThermostatUiConfigClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId);
/** @brief Thermostat User Interface Configuration Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfThermostatUiConfigClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                   uint8_t commandId,
                                                                   EmberAfStatus status);
/** @brief Thermostat User Interface Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfThermostatUiConfigClusterClientInitCallback(uint8_t endpoint);
/** @brief Thermostat User Interface Configuration Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfThermostatUiConfigClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                        EmberAfAttributeId attributeId,
                                                                                        uint16_t manufacturerCode);
/** @brief Thermostat User Interface Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfThermostatUiConfigClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                               uint16_t indexOrDestination,
                                                               EmberApsFrame *apsFrame,
                                                               uint16_t msgLen,
                                                               uint8_t *message,
                                                               EmberStatus status);
/** @brief Thermostat User Interface Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfThermostatUiConfigClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                EmberAfAttributeType attributeType,
                                                                                uint8_t size,
                                                                                uint8_t *value);
/** @brief Thermostat User Interface Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfThermostatUiConfigClusterClientTickCallback(uint8_t endpoint);
/** @brief Thermostat User Interface Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfThermostatUiConfigClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId);
/** @brief Thermostat User Interface Configuration Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfThermostatUiConfigClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                   uint8_t commandId,
                                                                   EmberAfStatus status);
/** @brief Thermostat User Interface Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfThermostatUiConfigClusterServerInitCallback(uint8_t endpoint);
/** @brief Thermostat User Interface Configuration Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfThermostatUiConfigClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                        EmberAfAttributeId attributeId,
                                                                                        uint16_t manufacturerCode);
/** @brief Thermostat User Interface Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfThermostatUiConfigClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                               uint16_t indexOrDestination,
                                                               EmberApsFrame *apsFrame,
                                                               uint16_t msgLen,
                                                               uint8_t *message,
                                                               EmberStatus status);
/** @brief Thermostat User Interface Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfThermostatUiConfigClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                EmberAfAttributeType attributeType,
                                                                                uint8_t size,
                                                                                uint8_t *value);
/** @brief Thermostat User Interface Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfThermostatUiConfigClusterServerTickCallback(uint8_t endpoint);

/** @} END Thermostat User Interface Configuration Cluster Callbacks */

/** @name Color Control Cluster Callbacks */
// @{

/** @brief Color Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfColorControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief Color Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfColorControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief Color Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfColorControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Color Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfColorControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief Color Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfColorControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief Color Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfColorControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief Color Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfColorControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Color Control Cluster Color Loop Set
 *
 * 
 *
 * @param updateFlags   Ver.: always
 * @param action   Ver.: always
 * @param direction   Ver.: always
 * @param time   Ver.: always
 * @param startHue   Ver.: always
 */
bool emberAfColorControlClusterColorLoopSetCallback(uint8_t updateFlags,
                                                       uint8_t action,
                                                       uint8_t direction,
                                                       uint16_t time,
                                                       uint16_t startHue);
/** @brief Color Control Cluster Enhanced Move Hue
 *
 * 
 *
 * @param moveMode   Ver.: always
 * @param rate   Ver.: always
 */
bool emberAfColorControlClusterEnhancedMoveHueCallback(uint8_t moveMode,
                                                          uint16_t rate);
/** @brief Color Control Cluster Enhanced Move To Hue And Saturation
 *
 * 
 *
 * @param enhancedHue   Ver.: always
 * @param saturation   Ver.: always
 * @param transitionTime   Ver.: always
 */
bool emberAfColorControlClusterEnhancedMoveToHueAndSaturationCallback(uint16_t enhancedHue,
                                                                         uint8_t saturation,
                                                                         uint16_t transitionTime);
/** @brief Color Control Cluster Enhanced Move To Hue
 *
 * 
 *
 * @param enhancedHue   Ver.: always
 * @param direction   Ver.: always
 * @param transitionTime   Ver.: always
 */
bool emberAfColorControlClusterEnhancedMoveToHueCallback(uint16_t enhancedHue,
                                                            uint8_t direction,
                                                            uint16_t transitionTime);
/** @brief Color Control Cluster Enhanced Step Hue
 *
 * 
 *
 * @param stepMode   Ver.: always
 * @param stepSize   Ver.: always
 * @param transitionTime   Ver.: always
 */
bool emberAfColorControlClusterEnhancedStepHueCallback(uint8_t stepMode,
                                                          uint16_t stepSize,
                                                          uint16_t transitionTime);
/** @brief Color Control Cluster Move Color
 *
 * 
 *
 * @param rateX   Ver.: always
 * @param rateY   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveColorCallback(int16_t rateX,
                                                    int16_t rateY,
                                                    uint8_t optionsMask,
                                                    uint8_t optionsOverride);
/** @brief Color Control Cluster Move Color Temperature
 *
 * 
 *
 * @param moveMode   Ver.: always
 * @param rate   Ver.: always
 * @param colorTemperatureMinimum   Ver.: always
 * @param colorTemperatureMaximum   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveColorTemperatureCallback(uint8_t moveMode,
                                                               uint16_t rate,
                                                               uint16_t colorTemperatureMinimum,
                                                               uint16_t colorTemperatureMaximum,
                                                               uint8_t optionsMask,
                                                               uint8_t optionsOverride);
/** @brief Color Control Cluster Move Hue
 *
 * 
 *
 * @param moveMode   Ver.: always
 * @param rate   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveHueCallback(uint8_t moveMode,
                                                  uint8_t rate,
                                                  uint8_t optionsMask,
                                                  uint8_t optionsOverride);
/** @brief Color Control Cluster Move Saturation
 *
 * 
 *
 * @param moveMode   Ver.: always
 * @param rate   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveSaturationCallback(uint8_t moveMode,
                                                         uint8_t rate,
                                                         uint8_t optionsMask,
                                                         uint8_t optionsOverride);
/** @brief Color Control Cluster Move To Color
 *
 * 
 *
 * @param colorX   Ver.: always
 * @param colorY   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveToColorCallback(uint16_t colorX,
                                                      uint16_t colorY,
                                                      uint16_t transitionTime,
                                                      uint8_t optionsMask,
                                                      uint8_t optionsOverride);
/** @brief Color Control Cluster Move To Color Temperature
 *
 * 
 *
 * @param colorTemperature   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveToColorTemperatureCallback(uint16_t colorTemperature,
                                                                 uint16_t transitionTime,
                                                                 uint8_t optionsMask,
                                                                 uint8_t optionsOverride);
/** @brief Color Control Cluster Move To Hue And Saturation
 *
 * 
 *
 * @param hue   Ver.: always
 * @param saturation   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveToHueAndSaturationCallback(uint8_t hue,
                                                                 uint8_t saturation,
                                                                 uint16_t transitionTime,
                                                                 uint8_t optionsMask,
                                                                 uint8_t optionsOverride);
/** @brief Color Control Cluster Move To Hue
 *
 * 
 *
 * @param hue   Ver.: always
 * @param direction   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveToHueCallback(uint8_t hue,
                                                    uint8_t direction,
                                                    uint16_t transitionTime,
                                                    uint8_t optionsMask,
                                                    uint8_t optionsOverride);
/** @brief Color Control Cluster Move To Saturation
 *
 * 
 *
 * @param saturation   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterMoveToSaturationCallback(uint8_t saturation,
                                                           uint16_t transitionTime,
                                                           uint8_t optionsMask,
                                                           uint8_t optionsOverride);
/** @brief Color Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfColorControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                              EmberAfAttributeId attributeId);
/** @brief Color Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfColorControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                             uint8_t commandId,
                                                             EmberAfStatus status);
/** @brief Color Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfColorControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Color Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfColorControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  uint16_t manufacturerCode);
/** @brief Color Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfColorControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                         uint16_t indexOrDestination,
                                                         EmberApsFrame *apsFrame,
                                                         uint16_t msgLen,
                                                         uint8_t *message,
                                                         EmberStatus status);
/** @brief Color Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfColorControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                          EmberAfAttributeId attributeId,
                                                                          EmberAfAttributeType attributeType,
                                                                          uint8_t size,
                                                                          uint8_t *value);
/** @brief Color Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfColorControlClusterServerTickCallback(uint8_t endpoint);
/** @brief Color Control Cluster Step Color
 *
 * 
 *
 * @param stepX   Ver.: always
 * @param stepY   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterStepColorCallback(int16_t stepX,
                                                    int16_t stepY,
                                                    uint16_t transitionTime,
                                                    uint8_t optionsMask,
                                                    uint8_t optionsOverride);
/** @brief Color Control Cluster Step Color Temperature
 *
 * 
 *
 * @param stepMode   Ver.: always
 * @param stepSize   Ver.: always
 * @param transitionTime   Ver.: always
 * @param colorTemperatureMinimum   Ver.: always
 * @param colorTemperatureMaximum   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterStepColorTemperatureCallback(uint8_t stepMode,
                                                               uint16_t stepSize,
                                                               uint16_t transitionTime,
                                                               uint16_t colorTemperatureMinimum,
                                                               uint16_t colorTemperatureMaximum,
                                                               uint8_t optionsMask,
                                                               uint8_t optionsOverride);
/** @brief Color Control Cluster Step Hue
 *
 * 
 *
 * @param stepMode   Ver.: always
 * @param stepSize   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterStepHueCallback(uint8_t stepMode,
                                                  uint8_t stepSize,
                                                  uint8_t transitionTime,
                                                  uint8_t optionsMask,
                                                  uint8_t optionsOverride);
/** @brief Color Control Cluster Step Saturation
 *
 * 
 *
 * @param stepMode   Ver.: always
 * @param stepSize   Ver.: always
 * @param transitionTime   Ver.: always
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterStepSaturationCallback(uint8_t stepMode,
                                                         uint8_t stepSize,
                                                         uint8_t transitionTime,
                                                         uint8_t optionsMask,
                                                         uint8_t optionsOverride);
/** @brief Color Control Cluster Stop Move Step
 *
 * 
 *
 * @param optionsMask   Ver.: since zcl6-errata-14-0129-15
 * @param optionsOverride   Ver.: since zcl6-errata-14-0129-15
 */
bool emberAfColorControlClusterStopMoveStepCallback(uint8_t optionsMask,
                                                       uint8_t optionsOverride);

/** @} END Color Control Cluster Callbacks */

/** @name Ballast Configuration Cluster Callbacks */
// @{

/** @brief Ballast Configuration Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBallastConfigurationClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId);
/** @brief Ballast Configuration Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBallastConfigurationClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                     uint8_t commandId,
                                                                     EmberAfStatus status);
/** @brief Ballast Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBallastConfigurationClusterClientInitCallback(uint8_t endpoint);
/** @brief Ballast Configuration Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBallastConfigurationClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId,
                                                                                          uint16_t manufacturerCode);
/** @brief Ballast Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBallastConfigurationClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                 uint16_t indexOrDestination,
                                                                 EmberApsFrame *apsFrame,
                                                                 uint16_t msgLen,
                                                                 uint8_t *message,
                                                                 EmberStatus status);
/** @brief Ballast Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBallastConfigurationClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  EmberAfAttributeType attributeType,
                                                                                  uint8_t size,
                                                                                  uint8_t *value);
/** @brief Ballast Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBallastConfigurationClusterClientTickCallback(uint8_t endpoint);
/** @brief Ballast Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBallastConfigurationClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId);
/** @brief Ballast Configuration Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBallastConfigurationClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                     uint8_t commandId,
                                                                     EmberAfStatus status);
/** @brief Ballast Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBallastConfigurationClusterServerInitCallback(uint8_t endpoint);
/** @brief Ballast Configuration Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBallastConfigurationClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId,
                                                                                          uint16_t manufacturerCode);
/** @brief Ballast Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBallastConfigurationClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                 uint16_t indexOrDestination,
                                                                 EmberApsFrame *apsFrame,
                                                                 uint16_t msgLen,
                                                                 uint8_t *message,
                                                                 EmberStatus status);
/** @brief Ballast Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBallastConfigurationClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  EmberAfAttributeType attributeType,
                                                                                  uint8_t size,
                                                                                  uint8_t *value);
/** @brief Ballast Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBallastConfigurationClusterServerTickCallback(uint8_t endpoint);

/** @} END Ballast Configuration Cluster Callbacks */

/** @name Illuminance Measurement Cluster Callbacks */
// @{

/** @brief Illuminance Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIllumMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Illuminance Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIllumMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Illuminance Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIllumMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Illuminance Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIllumMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Illuminance Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIllumMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Illuminance Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIllumMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Illuminance Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIllumMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Illuminance Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIllumMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Illuminance Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIllumMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Illuminance Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIllumMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Illuminance Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIllumMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Illuminance Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIllumMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Illuminance Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIllumMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Illuminance Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIllumMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Illuminance Measurement Cluster Callbacks */

/** @name Illuminance Level Sensing Cluster Callbacks */
// @{

/** @brief Illuminance Level Sensing Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIllumLevelSensingClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId);
/** @brief Illuminance Level Sensing Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIllumLevelSensingClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                  uint8_t commandId,
                                                                  EmberAfStatus status);
/** @brief Illuminance Level Sensing Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIllumLevelSensingClusterClientInitCallback(uint8_t endpoint);
/** @brief Illuminance Level Sensing Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIllumLevelSensingClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       uint16_t manufacturerCode);
/** @brief Illuminance Level Sensing Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIllumLevelSensingClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                              uint16_t indexOrDestination,
                                                              EmberApsFrame *apsFrame,
                                                              uint16_t msgLen,
                                                              uint8_t *message,
                                                              EmberStatus status);
/** @brief Illuminance Level Sensing Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIllumLevelSensingClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               EmberAfAttributeType attributeType,
                                                                               uint8_t size,
                                                                               uint8_t *value);
/** @brief Illuminance Level Sensing Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIllumLevelSensingClusterClientTickCallback(uint8_t endpoint);
/** @brief Illuminance Level Sensing Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIllumLevelSensingClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId);
/** @brief Illuminance Level Sensing Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIllumLevelSensingClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                  uint8_t commandId,
                                                                  EmberAfStatus status);
/** @brief Illuminance Level Sensing Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIllumLevelSensingClusterServerInitCallback(uint8_t endpoint);
/** @brief Illuminance Level Sensing Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIllumLevelSensingClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       uint16_t manufacturerCode);
/** @brief Illuminance Level Sensing Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIllumLevelSensingClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                              uint16_t indexOrDestination,
                                                              EmberApsFrame *apsFrame,
                                                              uint16_t msgLen,
                                                              uint8_t *message,
                                                              EmberStatus status);
/** @brief Illuminance Level Sensing Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIllumLevelSensingClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               EmberAfAttributeType attributeType,
                                                                               uint8_t size,
                                                                               uint8_t *value);
/** @brief Illuminance Level Sensing Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIllumLevelSensingClusterServerTickCallback(uint8_t endpoint);

/** @} END Illuminance Level Sensing Cluster Callbacks */

/** @name Temperature Measurement Cluster Callbacks */
// @{

/** @brief Temperature Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTempMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                 EmberAfAttributeId attributeId);
/** @brief Temperature Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTempMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                uint8_t commandId,
                                                                EmberAfStatus status);
/** @brief Temperature Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTempMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Temperature Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTempMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId,
                                                                                     uint16_t manufacturerCode);
/** @brief Temperature Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTempMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                            uint16_t indexOrDestination,
                                                            EmberApsFrame *apsFrame,
                                                            uint16_t msgLen,
                                                            uint8_t *message,
                                                            EmberStatus status);
/** @brief Temperature Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTempMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId,
                                                                             EmberAfAttributeType attributeType,
                                                                             uint8_t size,
                                                                             uint8_t *value);
/** @brief Temperature Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTempMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Temperature Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTempMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                 EmberAfAttributeId attributeId);
/** @brief Temperature Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTempMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                uint8_t commandId,
                                                                EmberAfStatus status);
/** @brief Temperature Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTempMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Temperature Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTempMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId,
                                                                                     uint16_t manufacturerCode);
/** @brief Temperature Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTempMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                            uint16_t indexOrDestination,
                                                            EmberApsFrame *apsFrame,
                                                            uint16_t msgLen,
                                                            uint8_t *message,
                                                            EmberStatus status);
/** @brief Temperature Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTempMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId,
                                                                             EmberAfAttributeType attributeType,
                                                                             uint8_t size,
                                                                             uint8_t *value);
/** @brief Temperature Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTempMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Temperature Measurement Cluster Callbacks */

/** @name Pressure Measurement Cluster Callbacks */
// @{

/** @brief Pressure Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPressureMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                     EmberAfAttributeId attributeId);
/** @brief Pressure Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPressureMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                    uint8_t commandId,
                                                                    EmberAfStatus status);
/** @brief Pressure Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPressureMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Pressure Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPressureMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId,
                                                                                         uint16_t manufacturerCode);
/** @brief Pressure Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPressureMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                uint16_t indexOrDestination,
                                                                EmberApsFrame *apsFrame,
                                                                uint16_t msgLen,
                                                                uint8_t *message,
                                                                EmberStatus status);
/** @brief Pressure Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPressureMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 EmberAfAttributeType attributeType,
                                                                                 uint8_t size,
                                                                                 uint8_t *value);
/** @brief Pressure Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPressureMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Pressure Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPressureMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                     EmberAfAttributeId attributeId);
/** @brief Pressure Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPressureMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                    uint8_t commandId,
                                                                    EmberAfStatus status);
/** @brief Pressure Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPressureMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Pressure Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPressureMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId,
                                                                                         uint16_t manufacturerCode);
/** @brief Pressure Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPressureMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                uint16_t indexOrDestination,
                                                                EmberApsFrame *apsFrame,
                                                                uint16_t msgLen,
                                                                uint8_t *message,
                                                                EmberStatus status);
/** @brief Pressure Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPressureMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 EmberAfAttributeType attributeType,
                                                                                 uint8_t size,
                                                                                 uint8_t *value);
/** @brief Pressure Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPressureMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Pressure Measurement Cluster Callbacks */

/** @name Flow Measurement Cluster Callbacks */
// @{

/** @brief Flow Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFlowMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                 EmberAfAttributeId attributeId);
/** @brief Flow Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFlowMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                uint8_t commandId,
                                                                EmberAfStatus status);
/** @brief Flow Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFlowMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Flow Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFlowMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId,
                                                                                     uint16_t manufacturerCode);
/** @brief Flow Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFlowMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                            uint16_t indexOrDestination,
                                                            EmberApsFrame *apsFrame,
                                                            uint16_t msgLen,
                                                            uint8_t *message,
                                                            EmberStatus status);
/** @brief Flow Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFlowMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId,
                                                                             EmberAfAttributeType attributeType,
                                                                             uint8_t size,
                                                                             uint8_t *value);
/** @brief Flow Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFlowMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Flow Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFlowMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                 EmberAfAttributeId attributeId);
/** @brief Flow Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFlowMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                uint8_t commandId,
                                                                EmberAfStatus status);
/** @brief Flow Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFlowMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Flow Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFlowMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId,
                                                                                     uint16_t manufacturerCode);
/** @brief Flow Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFlowMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                            uint16_t indexOrDestination,
                                                            EmberApsFrame *apsFrame,
                                                            uint16_t msgLen,
                                                            uint8_t *message,
                                                            EmberStatus status);
/** @brief Flow Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFlowMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId,
                                                                             EmberAfAttributeType attributeType,
                                                                             uint8_t size,
                                                                             uint8_t *value);
/** @brief Flow Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFlowMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Flow Measurement Cluster Callbacks */

/** @name Relative Humidity Measurement Cluster Callbacks */
// @{

/** @brief Relative Humidity Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId);
/** @brief Relative Humidity Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                            uint8_t commandId,
                                                                            EmberAfStatus status);
/** @brief Relative Humidity Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Relative Humidity Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                 EmberAfAttributeId attributeId,
                                                                                                 uint16_t manufacturerCode);
/** @brief Relative Humidity Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                        uint16_t indexOrDestination,
                                                                        EmberApsFrame *apsFrame,
                                                                        uint16_t msgLen,
                                                                        uint8_t *message,
                                                                        EmberStatus status);
/** @brief Relative Humidity Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfRelativeHumidityMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId,
                                                                                         EmberAfAttributeType attributeType,
                                                                                         uint8_t size,
                                                                                         uint8_t *value);
/** @brief Relative Humidity Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Relative Humidity Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId);
/** @brief Relative Humidity Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                            uint8_t commandId,
                                                                            EmberAfStatus status);
/** @brief Relative Humidity Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Relative Humidity Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                 EmberAfAttributeId attributeId,
                                                                                                 uint16_t manufacturerCode);
/** @brief Relative Humidity Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                        uint16_t indexOrDestination,
                                                                        EmberApsFrame *apsFrame,
                                                                        uint16_t msgLen,
                                                                        uint8_t *message,
                                                                        EmberStatus status);
/** @brief Relative Humidity Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfRelativeHumidityMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId,
                                                                                         EmberAfAttributeType attributeType,
                                                                                         uint8_t size,
                                                                                         uint8_t *value);
/** @brief Relative Humidity Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfRelativeHumidityMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Relative Humidity Measurement Cluster Callbacks */

/** @name Occupancy Sensing Cluster Callbacks */
// @{

/** @brief Occupancy Sensing Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOccupancySensingClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Occupancy Sensing Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOccupancySensingClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Occupancy Sensing Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOccupancySensingClusterClientInitCallback(uint8_t endpoint);
/** @brief Occupancy Sensing Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOccupancySensingClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Occupancy Sensing Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOccupancySensingClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Occupancy Sensing Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOccupancySensingClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Occupancy Sensing Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOccupancySensingClusterClientTickCallback(uint8_t endpoint);
/** @brief Occupancy Sensing Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOccupancySensingClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Occupancy Sensing Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOccupancySensingClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Occupancy Sensing Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOccupancySensingClusterServerInitCallback(uint8_t endpoint);
/** @brief Occupancy Sensing Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOccupancySensingClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Occupancy Sensing Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOccupancySensingClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Occupancy Sensing Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOccupancySensingClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Occupancy Sensing Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOccupancySensingClusterServerTickCallback(uint8_t endpoint);

/** @} END Occupancy Sensing Cluster Callbacks */

/** @name Carbon Monoxide Concentration Measurement Cluster Callbacks */
// @{

/** @brief Carbon Monoxide Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                        EmberAfAttributeId attributeId);
/** @brief Carbon Monoxide Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                       uint8_t commandId,
                                                                                       EmberAfStatus status);
/** @brief Carbon Monoxide Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Carbon Monoxide Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                            EmberAfAttributeId attributeId,
                                                                                                            uint16_t manufacturerCode);
/** @brief Carbon Monoxide Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                   uint16_t indexOrDestination,
                                                                                   EmberApsFrame *apsFrame,
                                                                                   uint16_t msgLen,
                                                                                   uint8_t *message,
                                                                                   EmberStatus status);
/** @brief Carbon Monoxide Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCarbonMonoxideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    EmberAfAttributeType attributeType,
                                                                                                    uint8_t size,
                                                                                                    uint8_t *value);
/** @brief Carbon Monoxide Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Carbon Monoxide Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                        EmberAfAttributeId attributeId);
/** @brief Carbon Monoxide Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                       uint8_t commandId,
                                                                                       EmberAfStatus status);
/** @brief Carbon Monoxide Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Carbon Monoxide Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                            EmberAfAttributeId attributeId,
                                                                                                            uint16_t manufacturerCode);
/** @brief Carbon Monoxide Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                   uint16_t indexOrDestination,
                                                                                   EmberApsFrame *apsFrame,
                                                                                   uint16_t msgLen,
                                                                                   uint8_t *message,
                                                                                   EmberStatus status);
/** @brief Carbon Monoxide Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCarbonMonoxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    EmberAfAttributeType attributeType,
                                                                                                    uint8_t size,
                                                                                                    uint8_t *value);
/** @brief Carbon Monoxide Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Carbon Monoxide Concentration Measurement Cluster Callbacks */

/** @name Carbon Dioxide Concentration Measurement Cluster Callbacks */
// @{

/** @brief Carbon Dioxide Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId);
/** @brief Carbon Dioxide Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                      uint8_t commandId,
                                                                                      EmberAfStatus status);
/** @brief Carbon Dioxide Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Carbon Dioxide Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           uint16_t manufacturerCode);
/** @brief Carbon Dioxide Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                  uint16_t indexOrDestination,
                                                                                  EmberApsFrame *apsFrame,
                                                                                  uint16_t msgLen,
                                                                                  uint8_t *message,
                                                                                  EmberStatus status);
/** @brief Carbon Dioxide Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCarbonDioxideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   EmberAfAttributeType attributeType,
                                                                                                   uint8_t size,
                                                                                                   uint8_t *value);
/** @brief Carbon Dioxide Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Carbon Dioxide Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId);
/** @brief Carbon Dioxide Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                      uint8_t commandId,
                                                                                      EmberAfStatus status);
/** @brief Carbon Dioxide Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Carbon Dioxide Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           uint16_t manufacturerCode);
/** @brief Carbon Dioxide Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                  uint16_t indexOrDestination,
                                                                                  EmberApsFrame *apsFrame,
                                                                                  uint16_t msgLen,
                                                                                  uint8_t *message,
                                                                                  EmberStatus status);
/** @brief Carbon Dioxide Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCarbonDioxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   EmberAfAttributeType attributeType,
                                                                                                   uint8_t size,
                                                                                                   uint8_t *value);
/** @brief Carbon Dioxide Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Carbon Dioxide Concentration Measurement Cluster Callbacks */

/** @name Ethylene Concentration Measurement Cluster Callbacks */
// @{

/** @brief Ethylene Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Ethylene Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Ethylene Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Ethylene Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Ethylene Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Ethylene Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEthyleneConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Ethylene Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Ethylene Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Ethylene Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Ethylene Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Ethylene Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Ethylene Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Ethylene Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEthyleneConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Ethylene Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEthyleneConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Ethylene Concentration Measurement Cluster Callbacks */

/** @name Ethylene Oxide Concentration Measurement Cluster Callbacks */
// @{

/** @brief Ethylene Oxide Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId);
/** @brief Ethylene Oxide Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                      uint8_t commandId,
                                                                                      EmberAfStatus status);
/** @brief Ethylene Oxide Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Ethylene Oxide Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           uint16_t manufacturerCode);
/** @brief Ethylene Oxide Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                  uint16_t indexOrDestination,
                                                                                  EmberApsFrame *apsFrame,
                                                                                  uint16_t msgLen,
                                                                                  uint8_t *message,
                                                                                  EmberStatus status);
/** @brief Ethylene Oxide Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEthyleneOxideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   EmberAfAttributeType attributeType,
                                                                                                   uint8_t size,
                                                                                                   uint8_t *value);
/** @brief Ethylene Oxide Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Ethylene Oxide Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId);
/** @brief Ethylene Oxide Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                      uint8_t commandId,
                                                                                      EmberAfStatus status);
/** @brief Ethylene Oxide Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Ethylene Oxide Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           uint16_t manufacturerCode);
/** @brief Ethylene Oxide Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                  uint16_t indexOrDestination,
                                                                                  EmberApsFrame *apsFrame,
                                                                                  uint16_t msgLen,
                                                                                  uint8_t *message,
                                                                                  EmberStatus status);
/** @brief Ethylene Oxide Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEthyleneOxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   EmberAfAttributeType attributeType,
                                                                                                   uint8_t size,
                                                                                                   uint8_t *value);
/** @brief Ethylene Oxide Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEthyleneOxideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Ethylene Oxide Concentration Measurement Cluster Callbacks */

/** @name Hydrogen Concentration Measurement Cluster Callbacks */
// @{

/** @brief Hydrogen Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Hydrogen Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Hydrogen Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Hydrogen Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Hydrogen Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Hydrogen Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfHydrogenConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Hydrogen Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Hydrogen Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Hydrogen Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Hydrogen Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Hydrogen Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Hydrogen Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Hydrogen Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfHydrogenConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Hydrogen Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfHydrogenConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Hydrogen Concentration Measurement Cluster Callbacks */

/** @name Hydrogen Sulphide Concentration Measurement Cluster Callbacks */
// @{

/** @brief Hydrogen Sulphide Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                         uint8_t commandId,
                                                                                         EmberAfStatus status);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                              EmberAfAttributeId attributeId,
                                                                                                              uint16_t manufacturerCode);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                     uint16_t indexOrDestination,
                                                                                     EmberApsFrame *apsFrame,
                                                                                     uint16_t msgLen,
                                                                                     uint8_t *message,
                                                                                     EmberStatus status);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfHydrogenSulphideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      EmberAfAttributeType attributeType,
                                                                                                      uint8_t size,
                                                                                                      uint8_t *value);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                         uint8_t commandId,
                                                                                         EmberAfStatus status);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                              EmberAfAttributeId attributeId,
                                                                                                              uint16_t manufacturerCode);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                     uint16_t indexOrDestination,
                                                                                     EmberApsFrame *apsFrame,
                                                                                     uint16_t msgLen,
                                                                                     uint8_t *message,
                                                                                     EmberStatus status);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfHydrogenSulphideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      EmberAfAttributeType attributeType,
                                                                                                      uint8_t size,
                                                                                                      uint8_t *value);
/** @brief Hydrogen Sulphide Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfHydrogenSulphideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Hydrogen Sulphide Concentration Measurement Cluster Callbacks */

/** @name Nitric Oxide Concentration Measurement Cluster Callbacks */
// @{

/** @brief Nitric Oxide Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId);
/** @brief Nitric Oxide Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                    uint8_t commandId,
                                                                                    EmberAfStatus status);
/** @brief Nitric Oxide Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Nitric Oxide Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                         EmberAfAttributeId attributeId,
                                                                                                         uint16_t manufacturerCode);
/** @brief Nitric Oxide Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                uint16_t indexOrDestination,
                                                                                EmberApsFrame *apsFrame,
                                                                                uint16_t msgLen,
                                                                                uint8_t *message,
                                                                                EmberStatus status);
/** @brief Nitric Oxide Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfNitricOxideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                 EmberAfAttributeId attributeId,
                                                                                                 EmberAfAttributeType attributeType,
                                                                                                 uint8_t size,
                                                                                                 uint8_t *value);
/** @brief Nitric Oxide Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Nitric Oxide Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId);
/** @brief Nitric Oxide Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                    uint8_t commandId,
                                                                                    EmberAfStatus status);
/** @brief Nitric Oxide Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Nitric Oxide Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                         EmberAfAttributeId attributeId,
                                                                                                         uint16_t manufacturerCode);
/** @brief Nitric Oxide Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                uint16_t indexOrDestination,
                                                                                EmberApsFrame *apsFrame,
                                                                                uint16_t msgLen,
                                                                                uint8_t *message,
                                                                                EmberStatus status);
/** @brief Nitric Oxide Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfNitricOxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                 EmberAfAttributeId attributeId,
                                                                                                 EmberAfAttributeType attributeType,
                                                                                                 uint8_t size,
                                                                                                 uint8_t *value);
/** @brief Nitric Oxide Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfNitricOxideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Nitric Oxide Concentration Measurement Cluster Callbacks */

/** @name Nitrogen Dioxide Concentration Measurement Cluster Callbacks */
// @{

/** @brief Nitrogen Dioxide Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                        uint8_t commandId,
                                                                                        EmberAfStatus status);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                             EmberAfAttributeId attributeId,
                                                                                                             uint16_t manufacturerCode);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                    uint16_t indexOrDestination,
                                                                                    EmberApsFrame *apsFrame,
                                                                                    uint16_t msgLen,
                                                                                    uint8_t *message,
                                                                                    EmberStatus status);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfNitrogenDioxideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     EmberAfAttributeType attributeType,
                                                                                                     uint8_t size,
                                                                                                     uint8_t *value);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                        uint8_t commandId,
                                                                                        EmberAfStatus status);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                             EmberAfAttributeId attributeId,
                                                                                                             uint16_t manufacturerCode);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                    uint16_t indexOrDestination,
                                                                                    EmberApsFrame *apsFrame,
                                                                                    uint16_t msgLen,
                                                                                    uint8_t *message,
                                                                                    EmberStatus status);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfNitrogenDioxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     EmberAfAttributeType attributeType,
                                                                                                     uint8_t size,
                                                                                                     uint8_t *value);
/** @brief Nitrogen Dioxide Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Nitrogen Dioxide Concentration Measurement Cluster Callbacks */

/** @name Oxygen Concentration Measurement Cluster Callbacks */
// @{

/** @brief Oxygen Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId);
/** @brief Oxygen Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                               uint8_t commandId,
                                                                               EmberAfStatus status);
/** @brief Oxygen Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Oxygen Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    uint16_t manufacturerCode);
/** @brief Oxygen Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                           uint16_t indexOrDestination,
                                                                           EmberApsFrame *apsFrame,
                                                                           uint16_t msgLen,
                                                                           uint8_t *message,
                                                                           EmberStatus status);
/** @brief Oxygen Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOxygenConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                            EmberAfAttributeId attributeId,
                                                                                            EmberAfAttributeType attributeType,
                                                                                            uint8_t size,
                                                                                            uint8_t *value);
/** @brief Oxygen Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Oxygen Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId);
/** @brief Oxygen Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                               uint8_t commandId,
                                                                               EmberAfStatus status);
/** @brief Oxygen Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Oxygen Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    uint16_t manufacturerCode);
/** @brief Oxygen Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                           uint16_t indexOrDestination,
                                                                           EmberApsFrame *apsFrame,
                                                                           uint16_t msgLen,
                                                                           uint8_t *message,
                                                                           EmberStatus status);
/** @brief Oxygen Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOxygenConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                            EmberAfAttributeId attributeId,
                                                                                            EmberAfAttributeType attributeType,
                                                                                            uint8_t size,
                                                                                            uint8_t *value);
/** @brief Oxygen Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOxygenConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Oxygen Concentration Measurement Cluster Callbacks */

/** @name Ozone Concentration Measurement Cluster Callbacks */
// @{

/** @brief Ozone Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId);
/** @brief Ozone Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                              uint8_t commandId,
                                                                              EmberAfStatus status);
/** @brief Ozone Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Ozone Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   uint16_t manufacturerCode);
/** @brief Ozone Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                          uint16_t indexOrDestination,
                                                                          EmberApsFrame *apsFrame,
                                                                          uint16_t msgLen,
                                                                          uint8_t *message,
                                                                          EmberStatus status);
/** @brief Ozone Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOzoneConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                           EmberAfAttributeId attributeId,
                                                                                           EmberAfAttributeType attributeType,
                                                                                           uint8_t size,
                                                                                           uint8_t *value);
/** @brief Ozone Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Ozone Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId);
/** @brief Ozone Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                              uint8_t commandId,
                                                                              EmberAfStatus status);
/** @brief Ozone Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Ozone Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   uint16_t manufacturerCode);
/** @brief Ozone Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                          uint16_t indexOrDestination,
                                                                          EmberApsFrame *apsFrame,
                                                                          uint16_t msgLen,
                                                                          uint8_t *message,
                                                                          EmberStatus status);
/** @brief Ozone Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfOzoneConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                           EmberAfAttributeId attributeId,
                                                                                           EmberAfAttributeType attributeType,
                                                                                           uint8_t size,
                                                                                           uint8_t *value);
/** @brief Ozone Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfOzoneConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Ozone Concentration Measurement Cluster Callbacks */

/** @name Sulfur Dioxide Concentration Measurement Cluster Callbacks */
// @{

/** @brief Sulfur Dioxide Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                      uint8_t commandId,
                                                                                      EmberAfStatus status);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           uint16_t manufacturerCode);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                  uint16_t indexOrDestination,
                                                                                  EmberApsFrame *apsFrame,
                                                                                  uint16_t msgLen,
                                                                                  uint8_t *message,
                                                                                  EmberStatus status);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSulfurDioxideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   EmberAfAttributeType attributeType,
                                                                                                   uint8_t size,
                                                                                                   uint8_t *value);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                      uint8_t commandId,
                                                                                      EmberAfStatus status);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           uint16_t manufacturerCode);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                  uint16_t indexOrDestination,
                                                                                  EmberApsFrame *apsFrame,
                                                                                  uint16_t msgLen,
                                                                                  uint8_t *message,
                                                                                  EmberStatus status);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSulfurDioxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                   EmberAfAttributeId attributeId,
                                                                                                   EmberAfAttributeType attributeType,
                                                                                                   uint8_t size,
                                                                                                   uint8_t *value);
/** @brief Sulfur Dioxide Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSulfurDioxideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Sulfur Dioxide Concentration Measurement Cluster Callbacks */

/** @name Dissolved Oxygen Concentration Measurement Cluster Callbacks */
// @{

/** @brief Dissolved Oxygen Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                        uint8_t commandId,
                                                                                        EmberAfStatus status);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                             EmberAfAttributeId attributeId,
                                                                                                             uint16_t manufacturerCode);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                    uint16_t indexOrDestination,
                                                                                    EmberApsFrame *apsFrame,
                                                                                    uint16_t msgLen,
                                                                                    uint8_t *message,
                                                                                    EmberStatus status);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDissolvedOxygenConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     EmberAfAttributeType attributeType,
                                                                                                     uint8_t size,
                                                                                                     uint8_t *value);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                        uint8_t commandId,
                                                                                        EmberAfStatus status);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                             EmberAfAttributeId attributeId,
                                                                                                             uint16_t manufacturerCode);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                    uint16_t indexOrDestination,
                                                                                    EmberApsFrame *apsFrame,
                                                                                    uint16_t msgLen,
                                                                                    uint8_t *message,
                                                                                    EmberStatus status);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDissolvedOxygenConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     EmberAfAttributeType attributeType,
                                                                                                     uint8_t size,
                                                                                                     uint8_t *value);
/** @brief Dissolved Oxygen Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDissolvedOxygenConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Dissolved Oxygen Concentration Measurement Cluster Callbacks */

/** @name Bromate Concentration Measurement Cluster Callbacks */
// @{

/** @brief Bromate Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId);
/** @brief Bromate Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                uint8_t commandId,
                                                                                EmberAfStatus status);
/** @brief Bromate Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Bromate Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     uint16_t manufacturerCode);
/** @brief Bromate Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                            uint16_t indexOrDestination,
                                                                            EmberApsFrame *apsFrame,
                                                                            uint16_t msgLen,
                                                                            uint8_t *message,
                                                                            EmberStatus status);
/** @brief Bromate Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBromateConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                             EmberAfAttributeId attributeId,
                                                                                             EmberAfAttributeType attributeType,
                                                                                             uint8_t size,
                                                                                             uint8_t *value);
/** @brief Bromate Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Bromate Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId);
/** @brief Bromate Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                uint8_t commandId,
                                                                                EmberAfStatus status);
/** @brief Bromate Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Bromate Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     uint16_t manufacturerCode);
/** @brief Bromate Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                            uint16_t indexOrDestination,
                                                                            EmberApsFrame *apsFrame,
                                                                            uint16_t msgLen,
                                                                            uint8_t *message,
                                                                            EmberStatus status);
/** @brief Bromate Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBromateConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                             EmberAfAttributeId attributeId,
                                                                                             EmberAfAttributeType attributeType,
                                                                                             uint8_t size,
                                                                                             uint8_t *value);
/** @brief Bromate Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBromateConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Bromate Concentration Measurement Cluster Callbacks */

/** @name Chloramines Concentration Measurement Cluster Callbacks */
// @{

/** @brief Chloramines Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId);
/** @brief Chloramines Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                    uint8_t commandId,
                                                                                    EmberAfStatus status);
/** @brief Chloramines Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Chloramines Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                         EmberAfAttributeId attributeId,
                                                                                                         uint16_t manufacturerCode);
/** @brief Chloramines Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                uint16_t indexOrDestination,
                                                                                EmberApsFrame *apsFrame,
                                                                                uint16_t msgLen,
                                                                                uint8_t *message,
                                                                                EmberStatus status);
/** @brief Chloramines Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChloraminesConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                 EmberAfAttributeId attributeId,
                                                                                                 EmberAfAttributeType attributeType,
                                                                                                 uint8_t size,
                                                                                                 uint8_t *value);
/** @brief Chloramines Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Chloramines Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                     EmberAfAttributeId attributeId);
/** @brief Chloramines Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                    uint8_t commandId,
                                                                                    EmberAfStatus status);
/** @brief Chloramines Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Chloramines Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                         EmberAfAttributeId attributeId,
                                                                                                         uint16_t manufacturerCode);
/** @brief Chloramines Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                uint16_t indexOrDestination,
                                                                                EmberApsFrame *apsFrame,
                                                                                uint16_t msgLen,
                                                                                uint8_t *message,
                                                                                EmberStatus status);
/** @brief Chloramines Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChloraminesConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                 EmberAfAttributeId attributeId,
                                                                                                 EmberAfAttributeType attributeType,
                                                                                                 uint8_t size,
                                                                                                 uint8_t *value);
/** @brief Chloramines Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChloraminesConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Chloramines Concentration Measurement Cluster Callbacks */

/** @name Chlorine Concentration Measurement Cluster Callbacks */
// @{

/** @brief Chlorine Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Chlorine Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Chlorine Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Chlorine Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Chlorine Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Chlorine Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChlorineConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Chlorine Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Chlorine Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Chlorine Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Chlorine Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Chlorine Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Chlorine Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Chlorine Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChlorineConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Chlorine Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChlorineConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Chlorine Concentration Measurement Cluster Callbacks */

/** @name Fecal coliform and E. Coli Concentration Measurement Cluster Callbacks */
// @{

/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                              uint8_t commandId,
                                                                                              EmberAfStatus status);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                   EmberAfAttributeId attributeId,
                                                                                                                   uint16_t manufacturerCode);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                          uint16_t indexOrDestination,
                                                                                          EmberApsFrame *apsFrame,
                                                                                          uint16_t msgLen,
                                                                                          uint8_t *message,
                                                                                          EmberStatus status);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFecalColiformAndEColiConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           EmberAfAttributeType attributeType,
                                                                                                           uint8_t size,
                                                                                                           uint8_t *value);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                              uint8_t commandId,
                                                                                              EmberAfStatus status);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                   EmberAfAttributeId attributeId,
                                                                                                                   uint16_t manufacturerCode);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                          uint16_t indexOrDestination,
                                                                                          EmberApsFrame *apsFrame,
                                                                                          uint16_t msgLen,
                                                                                          uint8_t *message,
                                                                                          EmberStatus status);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFecalColiformAndEColiConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           EmberAfAttributeType attributeType,
                                                                                                           uint8_t size,
                                                                                                           uint8_t *value);
/** @brief Fecal coliform and E. Coli Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFecalColiformAndEColiConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Fecal coliform and E. Coli Concentration Measurement Cluster Callbacks */

/** @name Fluoride Concentration Measurement Cluster Callbacks */
// @{

/** @brief Fluoride Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Fluoride Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Fluoride Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Fluoride Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Fluoride Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Fluoride Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFluorideConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Fluoride Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Fluoride Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId);
/** @brief Fluoride Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                 uint8_t commandId,
                                                                                 EmberAfStatus status);
/** @brief Fluoride Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Fluoride Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                      EmberAfAttributeId attributeId,
                                                                                                      uint16_t manufacturerCode);
/** @brief Fluoride Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                             uint16_t indexOrDestination,
                                                                             EmberApsFrame *apsFrame,
                                                                             uint16_t msgLen,
                                                                             uint8_t *message,
                                                                             EmberStatus status);
/** @brief Fluoride Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfFluorideConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId,
                                                                                              EmberAfAttributeType attributeType,
                                                                                              uint8_t size,
                                                                                              uint8_t *value);
/** @brief Fluoride Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfFluorideConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Fluoride Concentration Measurement Cluster Callbacks */

/** @name Haloacetic Acids Concentration Measurement Cluster Callbacks */
// @{

/** @brief Haloacetic Acids Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId);
/** @brief Haloacetic Acids Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                        uint8_t commandId,
                                                                                        EmberAfStatus status);
/** @brief Haloacetic Acids Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Haloacetic Acids Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                             EmberAfAttributeId attributeId,
                                                                                                             uint16_t manufacturerCode);
/** @brief Haloacetic Acids Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                    uint16_t indexOrDestination,
                                                                                    EmberApsFrame *apsFrame,
                                                                                    uint16_t msgLen,
                                                                                    uint8_t *message,
                                                                                    EmberStatus status);
/** @brief Haloacetic Acids Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfHaloaceticAcidsConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     EmberAfAttributeType attributeType,
                                                                                                     uint8_t size,
                                                                                                     uint8_t *value);
/** @brief Haloacetic Acids Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Haloacetic Acids Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId);
/** @brief Haloacetic Acids Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                        uint8_t commandId,
                                                                                        EmberAfStatus status);
/** @brief Haloacetic Acids Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Haloacetic Acids Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                             EmberAfAttributeId attributeId,
                                                                                                             uint16_t manufacturerCode);
/** @brief Haloacetic Acids Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                    uint16_t indexOrDestination,
                                                                                    EmberApsFrame *apsFrame,
                                                                                    uint16_t msgLen,
                                                                                    uint8_t *message,
                                                                                    EmberStatus status);
/** @brief Haloacetic Acids Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfHaloaceticAcidsConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     EmberAfAttributeType attributeType,
                                                                                                     uint8_t size,
                                                                                                     uint8_t *value);
/** @brief Haloacetic Acids Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfHaloaceticAcidsConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Haloacetic Acids Concentration Measurement Cluster Callbacks */

/** @name Total Trihalomethanes Concentration Measurement Cluster Callbacks */
// @{

/** @brief Total Trihalomethanes Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                             uint8_t commandId,
                                                                                             EmberAfStatus status);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                  EmberAfAttributeId attributeId,
                                                                                                                  uint16_t manufacturerCode);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                         uint16_t indexOrDestination,
                                                                                         EmberApsFrame *apsFrame,
                                                                                         uint16_t msgLen,
                                                                                         uint8_t *message,
                                                                                         EmberStatus status);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTotalTrihalomethanesConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                          EmberAfAttributeId attributeId,
                                                                                                          EmberAfAttributeType attributeType,
                                                                                                          uint8_t size,
                                                                                                          uint8_t *value);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                             uint8_t commandId,
                                                                                             EmberAfStatus status);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                  EmberAfAttributeId attributeId,
                                                                                                                  uint16_t manufacturerCode);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                         uint16_t indexOrDestination,
                                                                                         EmberApsFrame *apsFrame,
                                                                                         uint16_t msgLen,
                                                                                         uint8_t *message,
                                                                                         EmberStatus status);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTotalTrihalomethanesConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                          EmberAfAttributeId attributeId,
                                                                                                          EmberAfAttributeType attributeType,
                                                                                                          uint8_t size,
                                                                                                          uint8_t *value);
/** @brief Total Trihalomethanes Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTotalTrihalomethanesConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Total Trihalomethanes Concentration Measurement Cluster Callbacks */

/** @name Total Coliform Bacteria Concentration Measurement Cluster Callbacks */
// @{

/** @brief Total Coliform Bacteria Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                              uint8_t commandId,
                                                                                              EmberAfStatus status);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                   EmberAfAttributeId attributeId,
                                                                                                                   uint16_t manufacturerCode);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                          uint16_t indexOrDestination,
                                                                                          EmberApsFrame *apsFrame,
                                                                                          uint16_t msgLen,
                                                                                          uint8_t *message,
                                                                                          EmberStatus status);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTotalColiformBacteriaConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           EmberAfAttributeType attributeType,
                                                                                                           uint8_t size,
                                                                                                           uint8_t *value);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                              uint8_t commandId,
                                                                                              EmberAfStatus status);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                   EmberAfAttributeId attributeId,
                                                                                                                   uint16_t manufacturerCode);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                          uint16_t indexOrDestination,
                                                                                          EmberApsFrame *apsFrame,
                                                                                          uint16_t msgLen,
                                                                                          uint8_t *message,
                                                                                          EmberStatus status);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTotalColiformBacteriaConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                           EmberAfAttributeId attributeId,
                                                                                                           EmberAfAttributeType attributeType,
                                                                                                           uint8_t size,
                                                                                                           uint8_t *value);
/** @brief Total Coliform Bacteria Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTotalColiformBacteriaConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Total Coliform Bacteria Concentration Measurement Cluster Callbacks */

/** @name Turbidity Concentration Measurement Cluster Callbacks */
// @{

/** @brief Turbidity Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId);
/** @brief Turbidity Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                  uint8_t commandId,
                                                                                  EmberAfStatus status);
/** @brief Turbidity Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Turbidity Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                       EmberAfAttributeId attributeId,
                                                                                                       uint16_t manufacturerCode);
/** @brief Turbidity Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                              uint16_t indexOrDestination,
                                                                              EmberApsFrame *apsFrame,
                                                                              uint16_t msgLen,
                                                                              uint8_t *message,
                                                                              EmberStatus status);
/** @brief Turbidity Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTurbidityConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               EmberAfAttributeType attributeType,
                                                                                               uint8_t size,
                                                                                               uint8_t *value);
/** @brief Turbidity Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Turbidity Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId);
/** @brief Turbidity Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                  uint8_t commandId,
                                                                                  EmberAfStatus status);
/** @brief Turbidity Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Turbidity Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                       EmberAfAttributeId attributeId,
                                                                                                       uint16_t manufacturerCode);
/** @brief Turbidity Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                              uint16_t indexOrDestination,
                                                                              EmberApsFrame *apsFrame,
                                                                              uint16_t msgLen,
                                                                              uint8_t *message,
                                                                              EmberStatus status);
/** @brief Turbidity Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTurbidityConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               EmberAfAttributeType attributeType,
                                                                                               uint8_t size,
                                                                                               uint8_t *value);
/** @brief Turbidity Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTurbidityConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Turbidity Concentration Measurement Cluster Callbacks */

/** @name Copper Concentration Measurement Cluster Callbacks */
// @{

/** @brief Copper Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId);
/** @brief Copper Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                               uint8_t commandId,
                                                                               EmberAfStatus status);
/** @brief Copper Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Copper Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    uint16_t manufacturerCode);
/** @brief Copper Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                           uint16_t indexOrDestination,
                                                                           EmberApsFrame *apsFrame,
                                                                           uint16_t msgLen,
                                                                           uint8_t *message,
                                                                           EmberStatus status);
/** @brief Copper Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCopperConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                            EmberAfAttributeId attributeId,
                                                                                            EmberAfAttributeType attributeType,
                                                                                            uint8_t size,
                                                                                            uint8_t *value);
/** @brief Copper Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Copper Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId);
/** @brief Copper Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                               uint8_t commandId,
                                                                               EmberAfStatus status);
/** @brief Copper Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Copper Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    uint16_t manufacturerCode);
/** @brief Copper Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                           uint16_t indexOrDestination,
                                                                           EmberApsFrame *apsFrame,
                                                                           uint16_t msgLen,
                                                                           uint8_t *message,
                                                                           EmberStatus status);
/** @brief Copper Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCopperConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                            EmberAfAttributeId attributeId,
                                                                                            EmberAfAttributeType attributeType,
                                                                                            uint8_t size,
                                                                                            uint8_t *value);
/** @brief Copper Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCopperConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Copper Concentration Measurement Cluster Callbacks */

/** @name Lead Concentration Measurement Cluster Callbacks */
// @{

/** @brief Lead Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId);
/** @brief Lead Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                             uint8_t commandId,
                                                                             EmberAfStatus status);
/** @brief Lead Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Lead Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                  EmberAfAttributeId attributeId,
                                                                                                  uint16_t manufacturerCode);
/** @brief Lead Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                         uint16_t indexOrDestination,
                                                                         EmberApsFrame *apsFrame,
                                                                         uint16_t msgLen,
                                                                         uint8_t *message,
                                                                         EmberStatus status);
/** @brief Lead Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfLeadConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId,
                                                                                          EmberAfAttributeType attributeType,
                                                                                          uint8_t size,
                                                                                          uint8_t *value);
/** @brief Lead Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Lead Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId);
/** @brief Lead Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                             uint8_t commandId,
                                                                             EmberAfStatus status);
/** @brief Lead Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Lead Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                  EmberAfAttributeId attributeId,
                                                                                                  uint16_t manufacturerCode);
/** @brief Lead Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                         uint16_t indexOrDestination,
                                                                         EmberApsFrame *apsFrame,
                                                                         uint16_t msgLen,
                                                                         uint8_t *message,
                                                                         EmberStatus status);
/** @brief Lead Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfLeadConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId,
                                                                                          EmberAfAttributeType attributeType,
                                                                                          uint8_t size,
                                                                                          uint8_t *value);
/** @brief Lead Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfLeadConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Lead Concentration Measurement Cluster Callbacks */

/** @name Manganese Concentration Measurement Cluster Callbacks */
// @{

/** @brief Manganese Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId);
/** @brief Manganese Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                  uint8_t commandId,
                                                                                  EmberAfStatus status);
/** @brief Manganese Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Manganese Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                       EmberAfAttributeId attributeId,
                                                                                                       uint16_t manufacturerCode);
/** @brief Manganese Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                              uint16_t indexOrDestination,
                                                                              EmberApsFrame *apsFrame,
                                                                              uint16_t msgLen,
                                                                              uint8_t *message,
                                                                              EmberStatus status);
/** @brief Manganese Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfManganeseConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               EmberAfAttributeType attributeType,
                                                                                               uint8_t size,
                                                                                               uint8_t *value);
/** @brief Manganese Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Manganese Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId);
/** @brief Manganese Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                  uint8_t commandId,
                                                                                  EmberAfStatus status);
/** @brief Manganese Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Manganese Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                       EmberAfAttributeId attributeId,
                                                                                                       uint16_t manufacturerCode);
/** @brief Manganese Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                              uint16_t indexOrDestination,
                                                                              EmberApsFrame *apsFrame,
                                                                              uint16_t msgLen,
                                                                              uint8_t *message,
                                                                              EmberStatus status);
/** @brief Manganese Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfManganeseConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               EmberAfAttributeType attributeType,
                                                                                               uint8_t size,
                                                                                               uint8_t *value);
/** @brief Manganese Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfManganeseConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Manganese Concentration Measurement Cluster Callbacks */

/** @name Sulfate Concentration Measurement Cluster Callbacks */
// @{

/** @brief Sulfate Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId);
/** @brief Sulfate Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                uint8_t commandId,
                                                                                EmberAfStatus status);
/** @brief Sulfate Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Sulfate Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     uint16_t manufacturerCode);
/** @brief Sulfate Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                            uint16_t indexOrDestination,
                                                                            EmberApsFrame *apsFrame,
                                                                            uint16_t msgLen,
                                                                            uint8_t *message,
                                                                            EmberStatus status);
/** @brief Sulfate Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSulfateConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                             EmberAfAttributeId attributeId,
                                                                                             EmberAfAttributeType attributeType,
                                                                                             uint8_t size,
                                                                                             uint8_t *value);
/** @brief Sulfate Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Sulfate Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId);
/** @brief Sulfate Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                uint8_t commandId,
                                                                                EmberAfStatus status);
/** @brief Sulfate Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Sulfate Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                     EmberAfAttributeId attributeId,
                                                                                                     uint16_t manufacturerCode);
/** @brief Sulfate Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                            uint16_t indexOrDestination,
                                                                            EmberApsFrame *apsFrame,
                                                                            uint16_t msgLen,
                                                                            uint8_t *message,
                                                                            EmberStatus status);
/** @brief Sulfate Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSulfateConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                             EmberAfAttributeId attributeId,
                                                                                             EmberAfAttributeType attributeType,
                                                                                             uint8_t size,
                                                                                             uint8_t *value);
/** @brief Sulfate Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSulfateConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Sulfate Concentration Measurement Cluster Callbacks */

/** @name Bromodichloromethane Concentration Measurement Cluster Callbacks */
// @{

/** @brief Bromodichloromethane Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId);
/** @brief Bromodichloromethane Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                             uint8_t commandId,
                                                                                             EmberAfStatus status);
/** @brief Bromodichloromethane Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Bromodichloromethane Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                  EmberAfAttributeId attributeId,
                                                                                                                  uint16_t manufacturerCode);
/** @brief Bromodichloromethane Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                         uint16_t indexOrDestination,
                                                                                         EmberApsFrame *apsFrame,
                                                                                         uint16_t msgLen,
                                                                                         uint8_t *message,
                                                                                         EmberStatus status);
/** @brief Bromodichloromethane Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBromodichloromethaneConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                          EmberAfAttributeId attributeId,
                                                                                                          EmberAfAttributeType attributeType,
                                                                                                          uint8_t size,
                                                                                                          uint8_t *value);
/** @brief Bromodichloromethane Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Bromodichloromethane Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId);
/** @brief Bromodichloromethane Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                             uint8_t commandId,
                                                                                             EmberAfStatus status);
/** @brief Bromodichloromethane Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Bromodichloromethane Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                  EmberAfAttributeId attributeId,
                                                                                                                  uint16_t manufacturerCode);
/** @brief Bromodichloromethane Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                         uint16_t indexOrDestination,
                                                                                         EmberApsFrame *apsFrame,
                                                                                         uint16_t msgLen,
                                                                                         uint8_t *message,
                                                                                         EmberStatus status);
/** @brief Bromodichloromethane Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBromodichloromethaneConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                          EmberAfAttributeId attributeId,
                                                                                                          EmberAfAttributeType attributeType,
                                                                                                          uint8_t size,
                                                                                                          uint8_t *value);
/** @brief Bromodichloromethane Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBromodichloromethaneConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Bromodichloromethane Concentration Measurement Cluster Callbacks */

/** @name Bromoform Concentration Measurement Cluster Callbacks */
// @{

/** @brief Bromoform Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId);
/** @brief Bromoform Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                  uint8_t commandId,
                                                                                  EmberAfStatus status);
/** @brief Bromoform Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Bromoform Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                       EmberAfAttributeId attributeId,
                                                                                                       uint16_t manufacturerCode);
/** @brief Bromoform Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                              uint16_t indexOrDestination,
                                                                              EmberApsFrame *apsFrame,
                                                                              uint16_t msgLen,
                                                                              uint8_t *message,
                                                                              EmberStatus status);
/** @brief Bromoform Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBromoformConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               EmberAfAttributeType attributeType,
                                                                                               uint8_t size,
                                                                                               uint8_t *value);
/** @brief Bromoform Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Bromoform Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId);
/** @brief Bromoform Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                  uint8_t commandId,
                                                                                  EmberAfStatus status);
/** @brief Bromoform Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Bromoform Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                       EmberAfAttributeId attributeId,
                                                                                                       uint16_t manufacturerCode);
/** @brief Bromoform Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                              uint16_t indexOrDestination,
                                                                              EmberApsFrame *apsFrame,
                                                                              uint16_t msgLen,
                                                                              uint8_t *message,
                                                                              EmberStatus status);
/** @brief Bromoform Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBromoformConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               EmberAfAttributeType attributeType,
                                                                                               uint8_t size,
                                                                                               uint8_t *value);
/** @brief Bromoform Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBromoformConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Bromoform Concentration Measurement Cluster Callbacks */

/** @name Chlorodibromomethane Concentration Measurement Cluster Callbacks */
// @{

/** @brief Chlorodibromomethane Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                             uint8_t commandId,
                                                                                             EmberAfStatus status);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                  EmberAfAttributeId attributeId,
                                                                                                                  uint16_t manufacturerCode);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                                         uint16_t indexOrDestination,
                                                                                         EmberApsFrame *apsFrame,
                                                                                         uint16_t msgLen,
                                                                                         uint8_t *message,
                                                                                         EmberStatus status);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChlorodibromomethaneConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                          EmberAfAttributeId attributeId,
                                                                                                          EmberAfAttributeType attributeType,
                                                                                                          uint8_t size,
                                                                                                          uint8_t *value);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                              EmberAfAttributeId attributeId);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                             uint8_t commandId,
                                                                                             EmberAfStatus status);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                                  EmberAfAttributeId attributeId,
                                                                                                                  uint16_t manufacturerCode);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                                         uint16_t indexOrDestination,
                                                                                         EmberApsFrame *apsFrame,
                                                                                         uint16_t msgLen,
                                                                                         uint8_t *message,
                                                                                         EmberStatus status);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChlorodibromomethaneConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                          EmberAfAttributeId attributeId,
                                                                                                          EmberAfAttributeType attributeType,
                                                                                                          uint8_t size,
                                                                                                          uint8_t *value);
/** @brief Chlorodibromomethane Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChlorodibromomethaneConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Chlorodibromomethane Concentration Measurement Cluster Callbacks */

/** @name Chloroform Concentration Measurement Cluster Callbacks */
// @{

/** @brief Chloroform Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId);
/** @brief Chloroform Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                                   uint8_t commandId,
                                                                                   EmberAfStatus status);
/** @brief Chloroform Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Chloroform Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                        EmberAfAttributeId attributeId,
                                                                                                        uint16_t manufacturerCode);
/** @brief Chloroform Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                               uint16_t indexOrDestination,
                                                                               EmberApsFrame *apsFrame,
                                                                               uint16_t msgLen,
                                                                               uint8_t *message,
                                                                               EmberStatus status);
/** @brief Chloroform Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChloroformConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                EmberAfAttributeId attributeId,
                                                                                                EmberAfAttributeType attributeType,
                                                                                                uint8_t size,
                                                                                                uint8_t *value);
/** @brief Chloroform Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Chloroform Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId);
/** @brief Chloroform Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                                   uint8_t commandId,
                                                                                   EmberAfStatus status);
/** @brief Chloroform Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Chloroform Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                        EmberAfAttributeId attributeId,
                                                                                                        uint16_t manufacturerCode);
/** @brief Chloroform Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                               uint16_t indexOrDestination,
                                                                               EmberApsFrame *apsFrame,
                                                                               uint16_t msgLen,
                                                                               uint8_t *message,
                                                                               EmberStatus status);
/** @brief Chloroform Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfChloroformConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                                EmberAfAttributeId attributeId,
                                                                                                EmberAfAttributeType attributeType,
                                                                                                uint8_t size,
                                                                                                uint8_t *value);
/** @brief Chloroform Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfChloroformConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Chloroform Concentration Measurement Cluster Callbacks */

/** @name Sodium Concentration Measurement Cluster Callbacks */
// @{

/** @brief Sodium Concentration Measurement Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId);
/** @brief Sodium Concentration Measurement Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                               uint8_t commandId,
                                                                               EmberAfStatus status);
/** @brief Sodium Concentration Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterClientInitCallback(uint8_t endpoint);
/** @brief Sodium Concentration Measurement Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    uint16_t manufacturerCode);
/** @brief Sodium Concentration Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                           uint16_t indexOrDestination,
                                                                           EmberApsFrame *apsFrame,
                                                                           uint16_t msgLen,
                                                                           uint8_t *message,
                                                                           EmberStatus status);
/** @brief Sodium Concentration Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSodiumConcentrationMeasurementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                            EmberAfAttributeId attributeId,
                                                                                            EmberAfAttributeType attributeType,
                                                                                            uint8_t size,
                                                                                            uint8_t *value);
/** @brief Sodium Concentration Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterClientTickCallback(uint8_t endpoint);
/** @brief Sodium Concentration Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId);
/** @brief Sodium Concentration Measurement Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                               uint8_t commandId,
                                                                               EmberAfStatus status);
/** @brief Sodium Concentration Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterServerInitCallback(uint8_t endpoint);
/** @brief Sodium Concentration Measurement Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                                    EmberAfAttributeId attributeId,
                                                                                                    uint16_t manufacturerCode);
/** @brief Sodium Concentration Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                           uint16_t indexOrDestination,
                                                                           EmberApsFrame *apsFrame,
                                                                           uint16_t msgLen,
                                                                           uint8_t *message,
                                                                           EmberStatus status);
/** @brief Sodium Concentration Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSodiumConcentrationMeasurementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                            EmberAfAttributeId attributeId,
                                                                                            EmberAfAttributeType attributeType,
                                                                                            uint8_t size,
                                                                                            uint8_t *value);
/** @brief Sodium Concentration Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSodiumConcentrationMeasurementClusterServerTickCallback(uint8_t endpoint);

/** @} END Sodium Concentration Measurement Cluster Callbacks */

/** @name IAS Zone Cluster Callbacks */
// @{

/** @brief IAS Zone Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIasZoneClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                         EmberAfAttributeId attributeId);
/** @brief IAS Zone Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIasZoneClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                        uint8_t commandId,
                                                        EmberAfStatus status);
/** @brief IAS Zone Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIasZoneClusterClientInitCallback(uint8_t endpoint);
/** @brief IAS Zone Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIasZoneClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId,
                                                                             uint16_t manufacturerCode);
/** @brief IAS Zone Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIasZoneClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                    uint16_t indexOrDestination,
                                                    EmberApsFrame *apsFrame,
                                                    uint16_t msgLen,
                                                    uint8_t *message,
                                                    EmberStatus status);
/** @brief IAS Zone Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIasZoneClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                     EmberAfAttributeId attributeId,
                                                                     EmberAfAttributeType attributeType,
                                                                     uint8_t size,
                                                                     uint8_t *value);
/** @brief IAS Zone Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIasZoneClusterClientTickCallback(uint8_t endpoint);
/** @brief IAS Zone Cluster Initiate Normal Operation Mode
 *
 * 
 *
 */
bool emberAfIasZoneClusterInitiateNormalOperationModeCallback(void);
/** @brief IAS Zone Cluster Initiate Normal Operation Mode Response
 *
 * 
 *
 */
bool emberAfIasZoneClusterInitiateNormalOperationModeResponseCallback(void);
/** @brief IAS Zone Cluster Initiate Test Mode
 *
 * 
 *
 * @param testModeDuration   Ver.: always
 * @param currentZoneSensitivityLevel   Ver.: always
 */
bool emberAfIasZoneClusterInitiateTestModeCallback(uint8_t testModeDuration,
                                                      uint8_t currentZoneSensitivityLevel);
/** @brief IAS Zone Cluster Initiate Test Mode Response
 *
 * 
 *
 */
bool emberAfIasZoneClusterInitiateTestModeResponseCallback(void);
/** @brief IAS Zone Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIasZoneClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                         EmberAfAttributeId attributeId);
/** @brief IAS Zone Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIasZoneClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                        uint8_t commandId,
                                                        EmberAfStatus status);
/** @brief IAS Zone Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIasZoneClusterServerInitCallback(uint8_t endpoint);
/** @brief IAS Zone Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIasZoneClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                             EmberAfAttributeId attributeId,
                                                                             uint16_t manufacturerCode);
/** @brief IAS Zone Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIasZoneClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                    uint16_t indexOrDestination,
                                                    EmberApsFrame *apsFrame,
                                                    uint16_t msgLen,
                                                    uint8_t *message,
                                                    EmberStatus status);
/** @brief IAS Zone Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIasZoneClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                     EmberAfAttributeId attributeId,
                                                                     EmberAfAttributeType attributeType,
                                                                     uint8_t size,
                                                                     uint8_t *value);
/** @brief IAS Zone Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIasZoneClusterServerTickCallback(uint8_t endpoint);
/** @brief IAS Zone Cluster Zone Enroll Request
 *
 * 
 *
 * @param zoneType   Ver.: always
 * @param manufacturerCode   Ver.: always
 */
bool emberAfIasZoneClusterZoneEnrollRequestCallback(uint16_t zoneType,
                                                       uint16_t manufacturerCode);
/** @brief IAS Zone Cluster Zone Enroll Response
 *
 * 
 *
 * @param enrollResponseCode   Ver.: always
 * @param zoneId   Ver.: always
 */
bool emberAfIasZoneClusterZoneEnrollResponseCallback(uint8_t enrollResponseCode,
                                                        uint8_t zoneId);
/** @brief IAS Zone Cluster Zone Status Change Notification
 *
 * 
 *
 * @param zoneStatus   Ver.: always
 * @param extendedStatus   Ver.: always
 * @param zoneId   Ver.: since ha-1.2-05-3520-29
 * @param delay   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfIasZoneClusterZoneStatusChangeNotificationCallback(uint16_t zoneStatus,
                                                                  uint8_t extendedStatus,
                                                                  uint8_t zoneId,
                                                                  uint16_t delay);

/** @} END IAS Zone Cluster Callbacks */

/** @name IAS ACE Cluster Callbacks */
// @{

/** @brief IAS ACE Cluster Arm
 *
 * 
 *
 * @param armMode   Ver.: always
 * @param armDisarmCode   Ver.: since ha-1.2-05-3520-29
 * @param zoneId   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfIasAceClusterArmCallback(uint8_t armMode,
                                        uint8_t* armDisarmCode,
                                        uint8_t zoneId);
/** @brief IAS ACE Cluster Arm Response
 *
 * 
 *
 * @param armNotification   Ver.: always
 */
bool emberAfIasAceClusterArmResponseCallback(uint8_t armNotification);
/** @brief IAS ACE Cluster Bypass
 *
 * 
 *
 * @param numberOfZones   Ver.: always
 * @param zoneIds   Ver.: always
 * @param armDisarmCode   Ver.: since ha-1.2.1-05-3520-30
 */
bool emberAfIasAceClusterBypassCallback(uint8_t numberOfZones,
                                           uint8_t* zoneIds,
                                           uint8_t* armDisarmCode);
/** @brief IAS ACE Cluster Bypass Response
 *
 * 
 *
 * @param numberOfZones   Ver.: always
 * @param bypassResult   Ver.: always
 */
bool emberAfIasAceClusterBypassResponseCallback(uint8_t numberOfZones,
                                                   uint8_t* bypassResult);
/** @brief IAS ACE Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIasAceClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief IAS ACE Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIasAceClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief IAS ACE Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIasAceClusterClientInitCallback(uint8_t endpoint);
/** @brief IAS ACE Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIasAceClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief IAS ACE Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIasAceClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief IAS ACE Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIasAceClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief IAS ACE Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIasAceClusterClientTickCallback(uint8_t endpoint);
/** @brief IAS ACE Cluster Emergency
 *
 * 
 *
 */
bool emberAfIasAceClusterEmergencyCallback(void);
/** @brief IAS ACE Cluster Fire
 *
 * 
 *
 */
bool emberAfIasAceClusterFireCallback(void);
/** @brief IAS ACE Cluster Get Bypassed Zone List
 *
 * 
 *
 */
bool emberAfIasAceClusterGetBypassedZoneListCallback(void);
/** @brief IAS ACE Cluster Get Panel Status
 *
 * 
 *
 */
bool emberAfIasAceClusterGetPanelStatusCallback(void);
/** @brief IAS ACE Cluster Get Panel Status Response
 *
 * 
 *
 * @param panelStatus   Ver.: always
 * @param secondsRemaining   Ver.: always
 * @param audibleNotification   Ver.: always
 * @param alarmStatus   Ver.: always
 */
bool emberAfIasAceClusterGetPanelStatusResponseCallback(uint8_t panelStatus,
                                                           uint8_t secondsRemaining,
                                                           uint8_t audibleNotification,
                                                           uint8_t alarmStatus);
/** @brief IAS ACE Cluster Get Zone Id Map
 *
 * 
 *
 */
bool emberAfIasAceClusterGetZoneIdMapCallback(void);
/** @brief IAS ACE Cluster Get Zone Id Map Response
 *
 * 
 *
 * @param section0   Ver.: always
 * @param section1   Ver.: always
 * @param section2   Ver.: always
 * @param section3   Ver.: always
 * @param section4   Ver.: always
 * @param section5   Ver.: always
 * @param section6   Ver.: always
 * @param section7   Ver.: always
 * @param section8   Ver.: always
 * @param section9   Ver.: always
 * @param section10   Ver.: always
 * @param section11   Ver.: always
 * @param section12   Ver.: always
 * @param section13   Ver.: always
 * @param section14   Ver.: always
 * @param section15   Ver.: always
 */
bool emberAfIasAceClusterGetZoneIdMapResponseCallback(uint16_t section0,
                                                         uint16_t section1,
                                                         uint16_t section2,
                                                         uint16_t section3,
                                                         uint16_t section4,
                                                         uint16_t section5,
                                                         uint16_t section6,
                                                         uint16_t section7,
                                                         uint16_t section8,
                                                         uint16_t section9,
                                                         uint16_t section10,
                                                         uint16_t section11,
                                                         uint16_t section12,
                                                         uint16_t section13,
                                                         uint16_t section14,
                                                         uint16_t section15);
/** @brief IAS ACE Cluster Get Zone Information
 *
 * 
 *
 * @param zoneId   Ver.: always
 */
bool emberAfIasAceClusterGetZoneInformationCallback(uint8_t zoneId);
/** @brief IAS ACE Cluster Get Zone Information Response
 *
 * 
 *
 * @param zoneId   Ver.: always
 * @param zoneType   Ver.: always
 * @param ieeeAddress   Ver.: always
 * @param zoneLabel   Ver.: since ha-1.2.1-05-3520-30
 */
bool emberAfIasAceClusterGetZoneInformationResponseCallback(uint8_t zoneId,
                                                               uint16_t zoneType,
                                                               uint8_t* ieeeAddress,
                                                               uint8_t* zoneLabel);
/** @brief IAS ACE Cluster Get Zone Status
 *
 * 
 *
 * @param startingZoneId   Ver.: always
 * @param maxNumberOfZoneIds   Ver.: always
 * @param zoneStatusMaskFlag   Ver.: always
 * @param zoneStatusMask   Ver.: always
 */
bool emberAfIasAceClusterGetZoneStatusCallback(uint8_t startingZoneId,
                                                  uint8_t maxNumberOfZoneIds,
                                                  uint8_t zoneStatusMaskFlag,
                                                  uint16_t zoneStatusMask);
/** @brief IAS ACE Cluster Get Zone Status Response
 *
 * 
 *
 * @param zoneStatusComplete   Ver.: always
 * @param numberOfZones   Ver.: always
 * @param zoneStatusResult   Ver.: always
 */
bool emberAfIasAceClusterGetZoneStatusResponseCallback(uint8_t zoneStatusComplete,
                                                          uint8_t numberOfZones,
                                                          uint8_t* zoneStatusResult);
/** @brief IAS ACE Cluster Panel Status Changed
 *
 * 
 *
 * @param panelStatus   Ver.: always
 * @param secondsRemaining   Ver.: always
 * @param audibleNotification   Ver.: since ha-1.2.1-05-3520-30
 * @param alarmStatus   Ver.: since ha-1.2.1-05-3520-30
 */
bool emberAfIasAceClusterPanelStatusChangedCallback(uint8_t panelStatus,
                                                       uint8_t secondsRemaining,
                                                       uint8_t audibleNotification,
                                                       uint8_t alarmStatus);
/** @brief IAS ACE Cluster Panic
 *
 * 
 *
 */
bool emberAfIasAceClusterPanicCallback(void);
/** @brief IAS ACE Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIasAceClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief IAS ACE Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIasAceClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief IAS ACE Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIasAceClusterServerInitCallback(uint8_t endpoint);
/** @brief IAS ACE Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIasAceClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief IAS ACE Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIasAceClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief IAS ACE Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIasAceClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief IAS ACE Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIasAceClusterServerTickCallback(uint8_t endpoint);
/** @brief IAS ACE Cluster Set Bypassed Zone List
 *
 * 
 *
 * @param numberOfZones   Ver.: always
 * @param zoneIds   Ver.: always
 */
bool emberAfIasAceClusterSetBypassedZoneListCallback(uint8_t numberOfZones,
                                                        uint8_t* zoneIds);
/** @brief IAS ACE Cluster Zone Status Changed
 *
 * 
 *
 * @param zoneId   Ver.: always
 * @param zoneStatus   Ver.: always
 * @param audibleNotification   Ver.: since ha-1.2.1-05-3520-30
 * @param zoneLabel   Ver.: since ha-1.2.1-05-3520-30
 */
bool emberAfIasAceClusterZoneStatusChangedCallback(uint8_t zoneId,
                                                      uint16_t zoneStatus,
                                                      uint8_t audibleNotification,
                                                      uint8_t* zoneLabel);

/** @} END IAS ACE Cluster Callbacks */

/** @name IAS WD Cluster Callbacks */
// @{

/** @brief IAS WD Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIasWdClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief IAS WD Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIasWdClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief IAS WD Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIasWdClusterClientInitCallback(uint8_t endpoint);
/** @brief IAS WD Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIasWdClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief IAS WD Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIasWdClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief IAS WD Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIasWdClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief IAS WD Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIasWdClusterClientTickCallback(uint8_t endpoint);
/** @brief IAS WD Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIasWdClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief IAS WD Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIasWdClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief IAS WD Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIasWdClusterServerInitCallback(uint8_t endpoint);
/** @brief IAS WD Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIasWdClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief IAS WD Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIasWdClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief IAS WD Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIasWdClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief IAS WD Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIasWdClusterServerTickCallback(uint8_t endpoint);
/** @brief IAS WD Cluster Squawk
 *
 * 
 *
 * @param squawkInfo   Ver.: always
 */
bool emberAfIasWdClusterSquawkCallback(uint8_t squawkInfo);
/** @brief IAS WD Cluster Start Warning
 *
 * 
 *
 * @param warningInfo   Ver.: always
 * @param warningDuration   Ver.: always
 * @param strobeDutyCycle   Ver.: since ha-1.2-05-3520-29
 * @param strobeLevel   Ver.: since ha-1.2-05-3520-29
 */
bool emberAfIasWdClusterStartWarningCallback(uint8_t warningInfo,
                                                uint16_t warningDuration,
                                                uint8_t strobeDutyCycle,
                                                uint8_t strobeLevel);

/** @} END IAS WD Cluster Callbacks */

/** @name Generic Tunnel Cluster Callbacks */
// @{

/** @brief Generic Tunnel Cluster Advertise Protocol Address
 *
 * 
 *
 * @param protocolAddress   Ver.: always
 */
bool emberAfGenericTunnelClusterAdvertiseProtocolAddressCallback(uint8_t* protocolAddress);
/** @brief Generic Tunnel Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfGenericTunnelClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                               EmberAfAttributeId attributeId);
/** @brief Generic Tunnel Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfGenericTunnelClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                              uint8_t commandId,
                                                              EmberAfStatus status);
/** @brief Generic Tunnel Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfGenericTunnelClusterClientInitCallback(uint8_t endpoint);
/** @brief Generic Tunnel Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfGenericTunnelClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId,
                                                                                   uint16_t manufacturerCode);
/** @brief Generic Tunnel Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfGenericTunnelClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                          uint16_t indexOrDestination,
                                                          EmberApsFrame *apsFrame,
                                                          uint16_t msgLen,
                                                          uint8_t *message,
                                                          EmberStatus status);
/** @brief Generic Tunnel Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfGenericTunnelClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           EmberAfAttributeType attributeType,
                                                                           uint8_t size,
                                                                           uint8_t *value);
/** @brief Generic Tunnel Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfGenericTunnelClusterClientTickCallback(uint8_t endpoint);
/** @brief Generic Tunnel Cluster Match Protocol Address
 *
 * 
 *
 * @param protocolAddress   Ver.: always
 */
bool emberAfGenericTunnelClusterMatchProtocolAddressCallback(uint8_t* protocolAddress);
/** @brief Generic Tunnel Cluster Match Protocol Address Response
 *
 * 
 *
 * @param deviceIeeeAddress   Ver.: always
 * @param protocolAddress   Ver.: always
 */
bool emberAfGenericTunnelClusterMatchProtocolAddressResponseCallback(uint8_t* deviceIeeeAddress,
                                                                        uint8_t* protocolAddress);
/** @brief Generic Tunnel Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfGenericTunnelClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                               EmberAfAttributeId attributeId);
/** @brief Generic Tunnel Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfGenericTunnelClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                              uint8_t commandId,
                                                              EmberAfStatus status);
/** @brief Generic Tunnel Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfGenericTunnelClusterServerInitCallback(uint8_t endpoint);
/** @brief Generic Tunnel Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfGenericTunnelClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId,
                                                                                   uint16_t manufacturerCode);
/** @brief Generic Tunnel Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfGenericTunnelClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                          uint16_t indexOrDestination,
                                                          EmberApsFrame *apsFrame,
                                                          uint16_t msgLen,
                                                          uint8_t *message,
                                                          EmberStatus status);
/** @brief Generic Tunnel Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfGenericTunnelClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           EmberAfAttributeType attributeType,
                                                                           uint8_t size,
                                                                           uint8_t *value);
/** @brief Generic Tunnel Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfGenericTunnelClusterServerTickCallback(uint8_t endpoint);

/** @} END Generic Tunnel Cluster Callbacks */

/** @name BACnet Protocol Tunnel Cluster Callbacks */
// @{

/** @brief BACnet Protocol Tunnel Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId);
/** @brief BACnet Protocol Tunnel Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                     uint8_t commandId,
                                                                     EmberAfStatus status);
/** @brief BACnet Protocol Tunnel Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterClientInitCallback(uint8_t endpoint);
/** @brief BACnet Protocol Tunnel Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId,
                                                                                          uint16_t manufacturerCode);
/** @brief BACnet Protocol Tunnel Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                 uint16_t indexOrDestination,
                                                                 EmberApsFrame *apsFrame,
                                                                 uint16_t msgLen,
                                                                 uint8_t *message,
                                                                 EmberStatus status);
/** @brief BACnet Protocol Tunnel Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBacnetProtocolTunnelClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  EmberAfAttributeType attributeType,
                                                                                  uint8_t size,
                                                                                  uint8_t *value);
/** @brief BACnet Protocol Tunnel Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterClientTickCallback(uint8_t endpoint);
/** @brief BACnet Protocol Tunnel Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId);
/** @brief BACnet Protocol Tunnel Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                     uint8_t commandId,
                                                                     EmberAfStatus status);
/** @brief BACnet Protocol Tunnel Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterServerInitCallback(uint8_t endpoint);
/** @brief BACnet Protocol Tunnel Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                          EmberAfAttributeId attributeId,
                                                                                          uint16_t manufacturerCode);
/** @brief BACnet Protocol Tunnel Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                 uint16_t indexOrDestination,
                                                                 EmberApsFrame *apsFrame,
                                                                 uint16_t msgLen,
                                                                 uint8_t *message,
                                                                 EmberStatus status);
/** @brief BACnet Protocol Tunnel Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfBacnetProtocolTunnelClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                  EmberAfAttributeId attributeId,
                                                                                  EmberAfAttributeType attributeType,
                                                                                  uint8_t size,
                                                                                  uint8_t *value);
/** @brief BACnet Protocol Tunnel Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfBacnetProtocolTunnelClusterServerTickCallback(uint8_t endpoint);
/** @brief BACnet Protocol Tunnel Cluster Transfer Npdu
 *
 * 
 *
 * @param npdu   Ver.: always
 */
bool emberAfBacnetProtocolTunnelClusterTransferNpduCallback(uint8_t* npdu);

/** @} END BACnet Protocol Tunnel Cluster Callbacks */

/** @name 11073 Protocol Tunnel Cluster Callbacks */
// @{

/** @brief 11073 Protocol Tunnel Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                     EmberAfAttributeId attributeId);
/** @brief 11073 Protocol Tunnel Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                    uint8_t commandId,
                                                                    EmberAfStatus status);
/** @brief 11073 Protocol Tunnel Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterClientInitCallback(uint8_t endpoint);
/** @brief 11073 Protocol Tunnel Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAf11073ProtocolTunnelClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId,
                                                                                         uint16_t manufacturerCode);
/** @brief 11073 Protocol Tunnel Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                uint16_t indexOrDestination,
                                                                EmberApsFrame *apsFrame,
                                                                uint16_t msgLen,
                                                                uint8_t *message,
                                                                EmberStatus status);
/** @brief 11073 Protocol Tunnel Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAf11073ProtocolTunnelClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 EmberAfAttributeType attributeType,
                                                                                 uint8_t size,
                                                                                 uint8_t *value);
/** @brief 11073 Protocol Tunnel Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterClientTickCallback(uint8_t endpoint);
/** @brief 11073 Protocol Tunnel Cluster Connect Request
 *
 * 
 *
 * @param connectControl   Ver.: always
 * @param idleTimeout   Ver.: always
 * @param managerTarget   Ver.: always
 * @param managerEndpoint   Ver.: always
 */
bool emberAf11073ProtocolTunnelClusterConnectRequestCallback(uint8_t connectControl,
                                                                uint16_t idleTimeout,
                                                                uint8_t* managerTarget,
                                                                uint8_t managerEndpoint);
/** @brief 11073 Protocol Tunnel Cluster Connect Status Notification
 *
 * 
 *
 * @param connectStatus   Ver.: always
 */
bool emberAf11073ProtocolTunnelClusterConnectStatusNotificationCallback(uint8_t connectStatus);
/** @brief 11073 Protocol Tunnel Cluster Disconnect Request
 *
 * 
 *
 * @param managerIEEEAddress   Ver.: always
 */
bool emberAf11073ProtocolTunnelClusterDisconnectRequestCallback(uint8_t* managerIEEEAddress);
/** @brief 11073 Protocol Tunnel Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                     EmberAfAttributeId attributeId);
/** @brief 11073 Protocol Tunnel Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                    uint8_t commandId,
                                                                    EmberAfStatus status);
/** @brief 11073 Protocol Tunnel Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterServerInitCallback(uint8_t endpoint);
/** @brief 11073 Protocol Tunnel Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAf11073ProtocolTunnelClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                         EmberAfAttributeId attributeId,
                                                                                         uint16_t manufacturerCode);
/** @brief 11073 Protocol Tunnel Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                uint16_t indexOrDestination,
                                                                EmberApsFrame *apsFrame,
                                                                uint16_t msgLen,
                                                                uint8_t *message,
                                                                EmberStatus status);
/** @brief 11073 Protocol Tunnel Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAf11073ProtocolTunnelClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                 EmberAfAttributeId attributeId,
                                                                                 EmberAfAttributeType attributeType,
                                                                                 uint8_t size,
                                                                                 uint8_t *value);
/** @brief 11073 Protocol Tunnel Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAf11073ProtocolTunnelClusterServerTickCallback(uint8_t endpoint);
/** @brief 11073 Protocol Tunnel Cluster Transfer A P D U
 *
 * 
 *
 * @param apdu   Ver.: always
 */
bool emberAf11073ProtocolTunnelClusterTransferAPDUCallback(uint8_t* apdu);

/** @} END 11073 Protocol Tunnel Cluster Callbacks */

/** @name ISO 7816 Protocol Tunnel Cluster Callbacks */
// @{

/** @brief ISO 7816 Protocol Tunnel Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId);
/** @brief ISO 7816 Protocol Tunnel Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                      uint8_t commandId,
                                                                      EmberAfStatus status);
/** @brief ISO 7816 Protocol Tunnel Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterClientInitCallback(uint8_t endpoint);
/** @brief ISO 7816 Protocol Tunnel Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                           EmberAfAttributeId attributeId,
                                                                                           uint16_t manufacturerCode);
/** @brief ISO 7816 Protocol Tunnel Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                  uint16_t indexOrDestination,
                                                                  EmberApsFrame *apsFrame,
                                                                  uint16_t msgLen,
                                                                  uint8_t *message,
                                                                  EmberStatus status);
/** @brief ISO 7816 Protocol Tunnel Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIso7816ProtocolTunnelClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId,
                                                                                   EmberAfAttributeType attributeType,
                                                                                   uint8_t size,
                                                                                   uint8_t *value);
/** @brief ISO 7816 Protocol Tunnel Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterClientTickCallback(uint8_t endpoint);
/** @brief ISO 7816 Protocol Tunnel Cluster Extract Smart Card
 *
 * 
 *
 */
bool emberAfIso7816ProtocolTunnelClusterExtractSmartCardCallback(void);
/** @brief ISO 7816 Protocol Tunnel Cluster Insert Smart Card
 *
 * 
 *
 */
bool emberAfIso7816ProtocolTunnelClusterInsertSmartCardCallback(void);
/** @brief ISO 7816 Protocol Tunnel Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId);
/** @brief ISO 7816 Protocol Tunnel Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                      uint8_t commandId,
                                                                      EmberAfStatus status);
/** @brief ISO 7816 Protocol Tunnel Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterServerInitCallback(uint8_t endpoint);
/** @brief ISO 7816 Protocol Tunnel Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                           EmberAfAttributeId attributeId,
                                                                                           uint16_t manufacturerCode);
/** @brief ISO 7816 Protocol Tunnel Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                  uint16_t indexOrDestination,
                                                                  EmberApsFrame *apsFrame,
                                                                  uint16_t msgLen,
                                                                  uint8_t *message,
                                                                  EmberStatus status);
/** @brief ISO 7816 Protocol Tunnel Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfIso7816ProtocolTunnelClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                   EmberAfAttributeId attributeId,
                                                                                   EmberAfAttributeType attributeType,
                                                                                   uint8_t size,
                                                                                   uint8_t *value);
/** @brief ISO 7816 Protocol Tunnel Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfIso7816ProtocolTunnelClusterServerTickCallback(uint8_t endpoint);
/** @brief ISO 7816 Protocol Tunnel Cluster Transfer Apdu
 *
 * 
 *
 * @param apdu   Ver.: always
 */
bool emberAfIso7816ProtocolTunnelClusterTransferApduCallback(uint8_t* apdu);

/** @} END ISO 7816 Protocol Tunnel Cluster Callbacks */

/** @name Price Cluster Callbacks */
// @{

/** @brief Price Cluster Cancel Tariff
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerTariffId   Ver.: always
 * @param tariffType   Ver.: always
 */
bool emberAfPriceClusterCancelTariffCallback(uint32_t providerId,
                                                uint32_t issuerTariffId,
                                                uint8_t tariffType);
/** @brief Price Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPriceClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief Price Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPriceClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief Price Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPriceClusterClientInitCallback(uint8_t endpoint);
/** @brief Price Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPriceClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief Price Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPriceClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief Price Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPriceClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief Price Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPriceClusterClientTickCallback(uint8_t endpoint);
/** @brief Price Cluster Cpp Event Response
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param cppAuth   Ver.: always
 */
bool emberAfPriceClusterCppEventResponseCallback(uint32_t issuerEventId,
                                                    uint8_t cppAuth);
/** @brief Price Cluster Get Billing Period
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param minIssuerEventId   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param tariffType   Ver.: always
 */
bool emberAfPriceClusterGetBillingPeriodCallback(uint32_t earliestStartTime,
                                                    uint32_t minIssuerEventId,
                                                    uint8_t numberOfCommands,
                                                    uint8_t tariffType);
/** @brief Price Cluster Get Block Periods
 *
 * 
 *
 * @param startTime   Ver.: always
 * @param numberOfEvents   Ver.: always
 * @param tariffType   Ver.: always
 */
bool emberAfPriceClusterGetBlockPeriodsCallback(uint32_t startTime,
                                                   uint8_t numberOfEvents,
                                                   uint8_t tariffType);
/** @brief Price Cluster Get Block Thresholds
 *
 * 
 *
 * @param issuerTariffId   Ver.: always
 */
bool emberAfPriceClusterGetBlockThresholdsCallback(uint32_t issuerTariffId);
/** @brief Price Cluster Get C O2 Value
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param minIssuerEventId   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param tariffType   Ver.: always
 */
bool emberAfPriceClusterGetCO2ValueCallback(uint32_t earliestStartTime,
                                               uint32_t minIssuerEventId,
                                               uint8_t numberOfCommands,
                                               uint8_t tariffType);
/** @brief Price Cluster Get Calorific Value
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param minIssuerEventId   Ver.: always
 * @param numberOfCommands   Ver.: always
 */
bool emberAfPriceClusterGetCalorificValueCallback(uint32_t earliestStartTime,
                                                     uint32_t minIssuerEventId,
                                                     uint8_t numberOfCommands);
/** @brief Price Cluster Get Consolidated Bill
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param minIssuerEventId   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param tariffType   Ver.: always
 */
bool emberAfPriceClusterGetConsolidatedBillCallback(uint32_t earliestStartTime,
                                                       uint32_t minIssuerEventId,
                                                       uint8_t numberOfCommands,
                                                       uint8_t tariffType);
/** @brief Price Cluster Get Conversion Factor
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param minIssuerEventId   Ver.: always
 * @param numberOfCommands   Ver.: always
 */
bool emberAfPriceClusterGetConversionFactorCallback(uint32_t earliestStartTime,
                                                       uint32_t minIssuerEventId,
                                                       uint8_t numberOfCommands);
/** @brief Price Cluster Get Credit Payment
 *
 * 
 *
 * @param latestEndTime   Ver.: always
 * @param numberOfRecords   Ver.: always
 */
bool emberAfPriceClusterGetCreditPaymentCallback(uint32_t latestEndTime,
                                                    uint8_t numberOfRecords);
/** @brief Price Cluster Get Currency Conversion Command
 *
 * 
 *
 */
bool emberAfPriceClusterGetCurrencyConversionCommandCallback(void);
/** @brief Price Cluster Get Current Price
 *
 * 
 *
 * @param commandOptions   Ver.: always
 */
bool emberAfPriceClusterGetCurrentPriceCallback(uint8_t commandOptions);
/** @brief Price Cluster Get Price Matrix
 *
 * 
 *
 * @param issuerTariffId   Ver.: always
 */
bool emberAfPriceClusterGetPriceMatrixCallback(uint32_t issuerTariffId);
/** @brief Price Cluster Get Scheduled Prices
 *
 * 
 *
 * @param startTime   Ver.: always
 * @param numberOfEvents   Ver.: always
 */
bool emberAfPriceClusterGetScheduledPricesCallback(uint32_t startTime,
                                                      uint8_t numberOfEvents);
/** @brief Price Cluster Get Tariff Cancellation
 *
 * 
 *
 */
bool emberAfPriceClusterGetTariffCancellationCallback(void);
/** @brief Price Cluster Get Tariff Information
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param minIssuerEventId   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param tariffType   Ver.: always
 */
bool emberAfPriceClusterGetTariffInformationCallback(uint32_t earliestStartTime,
                                                        uint32_t minIssuerEventId,
                                                        uint8_t numberOfCommands,
                                                        uint8_t tariffType);
/** @brief Price Cluster Get Tier Labels
 *
 * 
 *
 * @param issuerTariffId   Ver.: always
 */
bool emberAfPriceClusterGetTierLabelsCallback(uint32_t issuerTariffId);
/** @brief Price Cluster Price Acknowledgement
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param priceAckTime   Ver.: always
 * @param control   Ver.: always
 */
bool emberAfPriceClusterPriceAcknowledgementCallback(uint32_t providerId,
                                                        uint32_t issuerEventId,
                                                        uint32_t priceAckTime,
                                                        uint8_t control);
/** @brief Price Cluster Publish Billing Period
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param billingPeriodStartTime   Ver.: always
 * @param billingPeriodDuration   Ver.: always
 * @param billingPeriodDurationType   Ver.: always
 * @param tariffType   Ver.: always
 */
bool emberAfPriceClusterPublishBillingPeriodCallback(uint32_t providerId,
                                                        uint32_t issuerEventId,
                                                        uint32_t billingPeriodStartTime,
                                                        uint32_t billingPeriodDuration,
                                                        uint8_t billingPeriodDurationType,
                                                        uint8_t tariffType);
/** @brief Price Cluster Publish Block Period
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param blockPeriodStartTime   Ver.: always
 * @param blockPeriodDuration   Ver.: always
 * @param blockPeriodControl   Ver.: always
 * @param blockPeriodDurationType   Ver.: since se-1.2a-07-5356-19
 * @param tariffType   Ver.: since se-1.2a-07-5356-19
 * @param tariffResolutionPeriod   Ver.: since se-1.2a-07-5356-19
 */
bool emberAfPriceClusterPublishBlockPeriodCallback(uint32_t providerId,
                                                      uint32_t issuerEventId,
                                                      uint32_t blockPeriodStartTime,
                                                      uint32_t blockPeriodDuration,
                                                      uint8_t blockPeriodControl,
                                                      uint8_t blockPeriodDurationType,
                                                      uint8_t tariffType,
                                                      uint8_t tariffResolutionPeriod);
/** @brief Price Cluster Publish Block Thresholds
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param issuerTariffId   Ver.: always
 * @param commandIndex   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param subPayloadControl   Ver.: always
 * @param payload   Ver.: always
 */
bool emberAfPriceClusterPublishBlockThresholdsCallback(uint32_t providerId,
                                                          uint32_t issuerEventId,
                                                          uint32_t startTime,
                                                          uint32_t issuerTariffId,
                                                          uint8_t commandIndex,
                                                          uint8_t numberOfCommands,
                                                          uint8_t subPayloadControl,
                                                          uint8_t* payload);
/** @brief Price Cluster Publish C O2 Value
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param tariffType   Ver.: always
 * @param cO2Value   Ver.: always
 * @param cO2ValueUnit   Ver.: always
 * @param cO2ValueTrailingDigit   Ver.: always
 */
bool emberAfPriceClusterPublishCO2ValueCallback(uint32_t providerId,
                                                   uint32_t issuerEventId,
                                                   uint32_t startTime,
                                                   uint8_t tariffType,
                                                   uint32_t cO2Value,
                                                   uint8_t cO2ValueUnit,
                                                   uint8_t cO2ValueTrailingDigit);
/** @brief Price Cluster Publish Calorific Value
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param calorificValue   Ver.: always
 * @param calorificValueUnit   Ver.: always
 * @param calorificValueTrailingDigit   Ver.: always
 */
bool emberAfPriceClusterPublishCalorificValueCallback(uint32_t issuerEventId,
                                                         uint32_t startTime,
                                                         uint32_t calorificValue,
                                                         uint8_t calorificValueUnit,
                                                         uint8_t calorificValueTrailingDigit);
/** @brief Price Cluster Publish Consolidated Bill
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param billingPeriodStartTime   Ver.: always
 * @param billingPeriodDuration   Ver.: always
 * @param billingPeriodDurationType   Ver.: always
 * @param tariffType   Ver.: always
 * @param consolidatedBill   Ver.: always
 * @param currency   Ver.: always
 * @param billTrailingDigit   Ver.: always
 */
bool emberAfPriceClusterPublishConsolidatedBillCallback(uint32_t providerId,
                                                           uint32_t issuerEventId,
                                                           uint32_t billingPeriodStartTime,
                                                           uint32_t billingPeriodDuration,
                                                           uint8_t billingPeriodDurationType,
                                                           uint8_t tariffType,
                                                           uint32_t consolidatedBill,
                                                           uint16_t currency,
                                                           uint8_t billTrailingDigit);
/** @brief Price Cluster Publish Conversion Factor
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param conversionFactor   Ver.: always
 * @param conversionFactorTrailingDigit   Ver.: always
 */
bool emberAfPriceClusterPublishConversionFactorCallback(uint32_t issuerEventId,
                                                           uint32_t startTime,
                                                           uint32_t conversionFactor,
                                                           uint8_t conversionFactorTrailingDigit);
/** @brief Price Cluster Publish Cpp Event
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param durationInMinutes   Ver.: always
 * @param tariffType   Ver.: always
 * @param cppPriceTier   Ver.: always
 * @param cppAuth   Ver.: always
 */
bool emberAfPriceClusterPublishCppEventCallback(uint32_t providerId,
                                                   uint32_t issuerEventId,
                                                   uint32_t startTime,
                                                   uint16_t durationInMinutes,
                                                   uint8_t tariffType,
                                                   uint8_t cppPriceTier,
                                                   uint8_t cppAuth);
/** @brief Price Cluster Publish Credit Payment
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param creditPaymentDueDate   Ver.: always
 * @param creditPaymentOverDueAmount   Ver.: always
 * @param creditPaymentStatus   Ver.: always
 * @param creditPayment   Ver.: always
 * @param creditPaymentDate   Ver.: always
 * @param creditPaymentRef   Ver.: always
 */
bool emberAfPriceClusterPublishCreditPaymentCallback(uint32_t providerId,
                                                        uint32_t issuerEventId,
                                                        uint32_t creditPaymentDueDate,
                                                        uint32_t creditPaymentOverDueAmount,
                                                        uint8_t creditPaymentStatus,
                                                        uint32_t creditPayment,
                                                        uint32_t creditPaymentDate,
                                                        uint8_t* creditPaymentRef);
/** @brief Price Cluster Publish Currency Conversion
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param oldCurrency   Ver.: always
 * @param newCurrency   Ver.: always
 * @param conversionFactor   Ver.: always
 * @param conversionFactorTrailingDigit   Ver.: always
 * @param currencyChangeControlFlags   Ver.: always
 */
bool emberAfPriceClusterPublishCurrencyConversionCallback(uint32_t providerId,
                                                             uint32_t issuerEventId,
                                                             uint32_t startTime,
                                                             uint16_t oldCurrency,
                                                             uint16_t newCurrency,
                                                             uint32_t conversionFactor,
                                                             uint8_t conversionFactorTrailingDigit,
                                                             uint32_t currencyChangeControlFlags);
/** @brief Price Cluster Publish Price
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param rateLabel   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param currentTime   Ver.: always
 * @param unitOfMeasure   Ver.: always
 * @param currency   Ver.: always
 * @param priceTrailingDigitAndPriceTier   Ver.: always
 * @param numberOfPriceTiersAndRegisterTier   Ver.: always
 * @param startTime   Ver.: always
 * @param durationInMinutes   Ver.: always
 * @param price   Ver.: always
 * @param priceRatio   Ver.: always
 * @param generationPrice   Ver.: always
 * @param generationPriceRatio   Ver.: always
 * @param alternateCostDelivered   Ver.: since se-1.0-07-5356-15
 * @param alternateCostUnit   Ver.: since se-1.0-07-5356-15
 * @param alternateCostTrailingDigit   Ver.: since se-1.0-07-5356-15
 * @param numberOfBlockThresholds   Ver.: since se-1.1-07-5356-16
 * @param priceControl   Ver.: since se-1.1-07-5356-16
 * @param numberOfGenerationTiers   Ver.: since se-1.2a-07-5356-19
 * @param generationTier   Ver.: since se-1.2a-07-5356-19
 * @param extendedNumberOfPriceTiers   Ver.: since se-1.2a-07-5356-19
 * @param extendedPriceTier   Ver.: since se-1.2a-07-5356-19
 * @param extendedRegisterTier   Ver.: since se-1.2a-07-5356-19
 */
bool emberAfPriceClusterPublishPriceCallback(uint32_t providerId,
                                                uint8_t* rateLabel,
                                                uint32_t issuerEventId,
                                                uint32_t currentTime,
                                                uint8_t unitOfMeasure,
                                                uint16_t currency,
                                                uint8_t priceTrailingDigitAndPriceTier,
                                                uint8_t numberOfPriceTiersAndRegisterTier,
                                                uint32_t startTime,
                                                uint16_t durationInMinutes,
                                                uint32_t price,
                                                uint8_t priceRatio,
                                                uint32_t generationPrice,
                                                uint8_t generationPriceRatio,
                                                uint32_t alternateCostDelivered,
                                                uint8_t alternateCostUnit,
                                                uint8_t alternateCostTrailingDigit,
                                                uint8_t numberOfBlockThresholds,
                                                uint8_t priceControl,
                                                uint8_t numberOfGenerationTiers,
                                                uint8_t generationTier,
                                                uint8_t extendedNumberOfPriceTiers,
                                                uint8_t extendedPriceTier,
                                                uint8_t extendedRegisterTier);
/** @brief Price Cluster Publish Price Matrix
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param issuerTariffId   Ver.: always
 * @param commandIndex   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param subPayloadControl   Ver.: always
 * @param payload   Ver.: always
 */
bool emberAfPriceClusterPublishPriceMatrixCallback(uint32_t providerId,
                                                      uint32_t issuerEventId,
                                                      uint32_t startTime,
                                                      uint32_t issuerTariffId,
                                                      uint8_t commandIndex,
                                                      uint8_t numberOfCommands,
                                                      uint8_t subPayloadControl,
                                                      uint8_t* payload);
/** @brief Price Cluster Publish Tariff Information
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param issuerTariffId   Ver.: always
 * @param startTime   Ver.: always
 * @param tariffTypeChargingScheme   Ver.: always
 * @param tariffLabel   Ver.: always
 * @param numberOfPriceTiersInUse   Ver.: always
 * @param numberOfBlockThresholdsInUse   Ver.: always
 * @param unitOfMeasure   Ver.: always
 * @param currency   Ver.: always
 * @param priceTrailingDigit   Ver.: always
 * @param standingCharge   Ver.: always
 * @param tierBlockMode   Ver.: always
 * @param blockThresholdMultiplier   Ver.: always
 * @param blockThresholdDivisor   Ver.: always
 */
bool emberAfPriceClusterPublishTariffInformationCallback(uint32_t providerId,
                                                            uint32_t issuerEventId,
                                                            uint32_t issuerTariffId,
                                                            uint32_t startTime,
                                                            uint8_t tariffTypeChargingScheme,
                                                            uint8_t* tariffLabel,
                                                            uint8_t numberOfPriceTiersInUse,
                                                            uint8_t numberOfBlockThresholdsInUse,
                                                            uint8_t unitOfMeasure,
                                                            uint16_t currency,
                                                            uint8_t priceTrailingDigit,
                                                            uint32_t standingCharge,
                                                            uint8_t tierBlockMode,
                                                            uint32_t blockThresholdMultiplier,
                                                            uint32_t blockThresholdDivisor);
/** @brief Price Cluster Publish Tier Labels
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param issuerTariffId   Ver.: always
 * @param commandIndex   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param numberOfLabels   Ver.: always
 * @param tierLabelsPayload   Ver.: always
 */
bool emberAfPriceClusterPublishTierLabelsCallback(uint32_t providerId,
                                                     uint32_t issuerEventId,
                                                     uint32_t issuerTariffId,
                                                     uint8_t commandIndex,
                                                     uint8_t numberOfCommands,
                                                     uint8_t numberOfLabels,
                                                     uint8_t* tierLabelsPayload);
/** @brief Price Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPriceClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                       EmberAfAttributeId attributeId);
/** @brief Price Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPriceClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                      uint8_t commandId,
                                                      EmberAfStatus status);
/** @brief Price Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPriceClusterServerInitCallback(uint8_t endpoint);
/** @brief Price Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPriceClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId,
                                                                           uint16_t manufacturerCode);
/** @brief Price Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPriceClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                  uint16_t indexOrDestination,
                                                  EmberApsFrame *apsFrame,
                                                  uint16_t msgLen,
                                                  uint8_t *message,
                                                  EmberStatus status);
/** @brief Price Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPriceClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                   EmberAfAttributeId attributeId,
                                                                   EmberAfAttributeType attributeType,
                                                                   uint8_t size,
                                                                   uint8_t *value);
/** @brief Price Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPriceClusterServerTickCallback(uint8_t endpoint);

/** @} END Price Cluster Callbacks */

/** @name Demand Response and Load Control Cluster Callbacks */
// @{

/** @brief Demand Response and Load Control Cluster Cancel All Load Control Events
 *
 * 
 *
 * @param cancelControl   Ver.: always
 */
bool emberAfDemandResponseLoadControlClusterCancelAllLoadControlEventsCallback(uint8_t cancelControl);
/** @brief Demand Response and Load Control Cluster Cancel Load Control Event
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param deviceClass   Ver.: always
 * @param utilityEnrollmentGroup   Ver.: always
 * @param cancelControl   Ver.: always
 * @param effectiveTime   Ver.: always
 */
bool emberAfDemandResponseLoadControlClusterCancelLoadControlEventCallback(uint32_t issuerEventId,
                                                                              uint16_t deviceClass,
                                                                              uint8_t utilityEnrollmentGroup,
                                                                              uint8_t cancelControl,
                                                                              uint32_t effectiveTime);
/** @brief Demand Response and Load Control Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId);
/** @brief Demand Response and Load Control Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                          uint8_t commandId,
                                                                          EmberAfStatus status);
/** @brief Demand Response and Load Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterClientInitCallback(uint8_t endpoint);
/** @brief Demand Response and Load Control Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDemandResponseLoadControlClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               uint16_t manufacturerCode);
/** @brief Demand Response and Load Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                                      uint16_t indexOrDestination,
                                                                      EmberApsFrame *apsFrame,
                                                                      uint16_t msgLen,
                                                                      uint8_t *message,
                                                                      EmberStatus status);
/** @brief Demand Response and Load Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDemandResponseLoadControlClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       EmberAfAttributeType attributeType,
                                                                                       uint8_t size,
                                                                                       uint8_t *value);
/** @brief Demand Response and Load Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterClientTickCallback(uint8_t endpoint);
/** @brief Demand Response and Load Control Cluster Get Scheduled Events
 *
 * 
 *
 * @param startTime   Ver.: always
 * @param numberOfEvents   Ver.: always
 * @param issuerEventId   Ver.: since se-1.2b-15-0131-02
 */
bool emberAfDemandResponseLoadControlClusterGetScheduledEventsCallback(uint32_t startTime,
                                                                          uint8_t numberOfEvents,
                                                                          uint32_t issuerEventId);
/** @brief Demand Response and Load Control Cluster Load Control Event
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param deviceClass   Ver.: always
 * @param utilityEnrollmentGroup   Ver.: always
 * @param startTime   Ver.: always
 * @param durationInMinutes   Ver.: always
 * @param criticalityLevel   Ver.: always
 * @param coolingTemperatureOffset   Ver.: always
 * @param heatingTemperatureOffset   Ver.: always
 * @param coolingTemperatureSetPoint   Ver.: always
 * @param heatingTemperatureSetPoint   Ver.: always
 * @param averageLoadAdjustmentPercentage   Ver.: always
 * @param dutyCycle   Ver.: always
 * @param eventControl   Ver.: always
 */
bool emberAfDemandResponseLoadControlClusterLoadControlEventCallback(uint32_t issuerEventId,
                                                                        uint16_t deviceClass,
                                                                        uint8_t utilityEnrollmentGroup,
                                                                        uint32_t startTime,
                                                                        uint16_t durationInMinutes,
                                                                        uint8_t criticalityLevel,
                                                                        uint8_t coolingTemperatureOffset,
                                                                        uint8_t heatingTemperatureOffset,
                                                                        int16_t coolingTemperatureSetPoint,
                                                                        int16_t heatingTemperatureSetPoint,
                                                                        int8_t averageLoadAdjustmentPercentage,
                                                                        uint8_t dutyCycle,
                                                                        uint8_t eventControl);
/** @brief Demand Response and Load Control Cluster Report Event Status
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param eventStatus   Ver.: always
 * @param eventStatusTime   Ver.: always
 * @param criticalityLevelApplied   Ver.: always
 * @param coolingTemperatureSetPointApplied   Ver.: always
 * @param heatingTemperatureSetPointApplied   Ver.: always
 * @param averageLoadAdjustmentPercentageApplied   Ver.: always
 * @param dutyCycleApplied   Ver.: always
 * @param eventControl   Ver.: always
 * @param signatureType   Ver.: always
 * @param signature   Ver.: always
 */
bool emberAfDemandResponseLoadControlClusterReportEventStatusCallback(uint32_t issuerEventId,
                                                                         uint8_t eventStatus,
                                                                         uint32_t eventStatusTime,
                                                                         uint8_t criticalityLevelApplied,
                                                                         uint16_t coolingTemperatureSetPointApplied,
                                                                         uint16_t heatingTemperatureSetPointApplied,
                                                                         int8_t averageLoadAdjustmentPercentageApplied,
                                                                         uint8_t dutyCycleApplied,
                                                                         uint8_t eventControl,
                                                                         uint8_t signatureType,
                                                                         uint8_t* signature);
/** @brief Demand Response and Load Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                           EmberAfAttributeId attributeId);
/** @brief Demand Response and Load Control Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                          uint8_t commandId,
                                                                          EmberAfStatus status);
/** @brief Demand Response and Load Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterServerInitCallback(uint8_t endpoint);
/** @brief Demand Response and Load Control Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDemandResponseLoadControlClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                               EmberAfAttributeId attributeId,
                                                                                               uint16_t manufacturerCode);
/** @brief Demand Response and Load Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                                      uint16_t indexOrDestination,
                                                                      EmberApsFrame *apsFrame,
                                                                      uint16_t msgLen,
                                                                      uint8_t *message,
                                                                      EmberStatus status);
/** @brief Demand Response and Load Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDemandResponseLoadControlClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                                       EmberAfAttributeId attributeId,
                                                                                       EmberAfAttributeType attributeType,
                                                                                       uint8_t size,
                                                                                       uint8_t *value);
/** @brief Demand Response and Load Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDemandResponseLoadControlClusterServerTickCallback(uint8_t endpoint);

/** @} END Demand Response and Load Control Cluster Callbacks */

/** @name Simple Metering Cluster Callbacks */
// @{

/** @brief Simple Metering Cluster Change Supply
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param requestDateTime   Ver.: always
 * @param implementationDateTime   Ver.: always
 * @param proposedSupplyStatus   Ver.: always
 * @param supplyControlBits   Ver.: always
 */
bool emberAfSimpleMeteringClusterChangeSupplyCallback(uint32_t providerId,
                                                         uint32_t issuerEventId,
                                                         uint32_t requestDateTime,
                                                         uint32_t implementationDateTime,
                                                         uint8_t proposedSupplyStatus,
                                                         uint8_t supplyControlBits);
/** @brief Simple Metering Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSimpleMeteringClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Simple Metering Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSimpleMeteringClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Simple Metering Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSimpleMeteringClusterClientInitCallback(uint8_t endpoint);
/** @brief Simple Metering Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSimpleMeteringClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Simple Metering Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSimpleMeteringClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Simple Metering Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSimpleMeteringClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Simple Metering Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSimpleMeteringClusterClientTickCallback(uint8_t endpoint);
/** @brief Simple Metering Cluster Configure Mirror
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param reportingInterval   Ver.: always
 * @param mirrorNotificationReporting   Ver.: always
 * @param notificationScheme   Ver.: always
 */
bool emberAfSimpleMeteringClusterConfigureMirrorCallback(uint32_t issuerEventId,
                                                            uint32_t reportingInterval,
                                                            uint8_t mirrorNotificationReporting,
                                                            uint8_t notificationScheme);
/** @brief Simple Metering Cluster Configure Notification Flags
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param notificationScheme   Ver.: always
 * @param notificationFlagAttributeId   Ver.: always
 * @param clusterId   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param numberOfCommands   Ver.: always
 * @param commandIds   Ver.: always
 */
bool emberAfSimpleMeteringClusterConfigureNotificationFlagsCallback(uint32_t issuerEventId,
                                                                       uint8_t notificationScheme,
                                                                       uint16_t notificationFlagAttributeId,
                                                                       uint16_t clusterId,
                                                                       uint16_t manufacturerCode,
                                                                       uint8_t numberOfCommands,
                                                                       uint8_t* commandIds);
/** @brief Simple Metering Cluster Configure Notification Scheme
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param notificationScheme   Ver.: always
 * @param notificationFlagOrder   Ver.: always
 */
bool emberAfSimpleMeteringClusterConfigureNotificationSchemeCallback(uint32_t issuerEventId,
                                                                        uint8_t notificationScheme,
                                                                        uint32_t notificationFlagOrder);
/** @brief Simple Metering Cluster Get Notified Message
 *
 * 
 *
 * @param notificationScheme   Ver.: always
 * @param notificationFlagAttributeId   Ver.: always
 * @param notificationFlagsN   Ver.: always
 */
bool emberAfSimpleMeteringClusterGetNotifiedMessageCallback(uint8_t notificationScheme,
                                                               uint16_t notificationFlagAttributeId,
                                                               uint32_t notificationFlagsN);
/** @brief Simple Metering Cluster Get Profile
 *
 * 
 *
 * @param intervalChannel   Ver.: always
 * @param endTime   Ver.: always
 * @param numberOfPeriods   Ver.: always
 */
bool emberAfSimpleMeteringClusterGetProfileCallback(uint8_t intervalChannel,
                                                       uint32_t endTime,
                                                       uint8_t numberOfPeriods);
/** @brief Simple Metering Cluster Get Profile Response
 *
 * 
 *
 * @param endTime   Ver.: always
 * @param status   Ver.: always
 * @param profileIntervalPeriod   Ver.: always
 * @param numberOfPeriodsDelivered   Ver.: always
 * @param intervals   Ver.: always
 */
bool emberAfSimpleMeteringClusterGetProfileResponseCallback(uint32_t endTime,
                                                               uint8_t status,
                                                               uint8_t profileIntervalPeriod,
                                                               uint8_t numberOfPeriodsDelivered,
                                                               uint8_t* intervals);
/** @brief Simple Metering Cluster Get Sampled Data
 *
 * 
 *
 * @param sampleId   Ver.: always
 * @param earliestSampleTime   Ver.: always
 * @param sampleType   Ver.: always
 * @param numberOfSamples   Ver.: always
 */
bool emberAfSimpleMeteringClusterGetSampledDataCallback(uint16_t sampleId,
                                                           uint32_t earliestSampleTime,
                                                           uint8_t sampleType,
                                                           uint16_t numberOfSamples);
/** @brief Simple Metering Cluster Get Sampled Data Response
 *
 * 
 *
 * @param sampleId   Ver.: always
 * @param sampleStartTime   Ver.: always
 * @param sampleType   Ver.: always
 * @param sampleRequestInterval   Ver.: always
 * @param numberOfSamples   Ver.: always
 * @param samples   Ver.: always
 */
bool emberAfSimpleMeteringClusterGetSampledDataResponseCallback(uint16_t sampleId,
                                                                   uint32_t sampleStartTime,
                                                                   uint8_t sampleType,
                                                                   uint16_t sampleRequestInterval,
                                                                   uint16_t numberOfSamples,
                                                                   uint8_t* samples);
/** @brief Simple Metering Cluster Get Snapshot
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param latestEndTime   Ver.: always
 * @param snapshotOffset   Ver.: always
 * @param snapshotCause   Ver.: always
 */
bool emberAfSimpleMeteringClusterGetSnapshotCallback(uint32_t earliestStartTime,
                                                        uint32_t latestEndTime,
                                                        uint8_t snapshotOffset,
                                                        uint32_t snapshotCause);
/** @brief Simple Metering Cluster Local Change Supply
 *
 * 
 *
 * @param proposedSupplyStatus   Ver.: always
 */
bool emberAfSimpleMeteringClusterLocalChangeSupplyCallback(uint8_t proposedSupplyStatus);
/** @brief Simple Metering Cluster Mirror Removed
 *
 * 
 *
 * @param endpointId   Ver.: always
 */
bool emberAfSimpleMeteringClusterMirrorRemovedCallback(uint16_t endpointId);
/** @brief Simple Metering Cluster Mirror Report Attribute Response
 *
 * 
 *
 * @param notificationScheme   Ver.: always
 * @param notificationFlags   Ver.: always
 */
bool emberAfSimpleMeteringClusterMirrorReportAttributeResponseCallback(uint8_t notificationScheme,
                                                                          uint8_t* notificationFlags);
/** @brief Simple Metering Cluster Publish Snapshot
 *
 * 
 *
 * @param snapshotId   Ver.: always
 * @param snapshotTime   Ver.: always
 * @param totalSnapshotsFound   Ver.: always
 * @param commandIndex   Ver.: always
 * @param totalCommands   Ver.: always
 * @param snapshotCause   Ver.: always
 * @param snapshotPayloadType   Ver.: always
 * @param snapshotPayload   Ver.: always
 */
bool emberAfSimpleMeteringClusterPublishSnapshotCallback(uint32_t snapshotId,
                                                            uint32_t snapshotTime,
                                                            uint8_t totalSnapshotsFound,
                                                            uint8_t commandIndex,
                                                            uint8_t totalCommands,
                                                            uint32_t snapshotCause,
                                                            uint8_t snapshotPayloadType,
                                                            uint8_t* snapshotPayload);
/** @brief Simple Metering Cluster Remove Mirror
 *
 * 
 *
 */
bool emberAfSimpleMeteringClusterRemoveMirrorCallback(void);
/** @brief Simple Metering Cluster Request Fast Poll Mode
 *
 * 
 *
 * @param fastPollUpdatePeriod   Ver.: always
 * @param duration   Ver.: always
 */
bool emberAfSimpleMeteringClusterRequestFastPollModeCallback(uint8_t fastPollUpdatePeriod,
                                                                uint8_t duration);
/** @brief Simple Metering Cluster Request Fast Poll Mode Response
 *
 * 
 *
 * @param appliedUpdatePeriod   Ver.: always
 * @param fastPollModeEndtime   Ver.: always
 */
bool emberAfSimpleMeteringClusterRequestFastPollModeResponseCallback(uint8_t appliedUpdatePeriod,
                                                                        uint32_t fastPollModeEndtime);
/** @brief Simple Metering Cluster Request Mirror
 *
 * 
 *
 */
bool emberAfSimpleMeteringClusterRequestMirrorCallback(void);
/** @brief Simple Metering Cluster Request Mirror Response
 *
 * 
 *
 * @param endpointId   Ver.: always
 */
bool emberAfSimpleMeteringClusterRequestMirrorResponseCallback(uint16_t endpointId);
/** @brief Simple Metering Cluster Reset Load Limit Counter
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 */
bool emberAfSimpleMeteringClusterResetLoadLimitCounterCallback(uint32_t providerId,
                                                                  uint32_t issuerEventId);
/** @brief Simple Metering Cluster Schedule Snapshot
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param commandIndex   Ver.: always
 * @param commandCount   Ver.: always
 * @param snapshotSchedulePayload   Ver.: always
 */
bool emberAfSimpleMeteringClusterScheduleSnapshotCallback(uint32_t issuerEventId,
                                                             uint8_t commandIndex,
                                                             uint8_t commandCount,
                                                             uint8_t* snapshotSchedulePayload);
/** @brief Simple Metering Cluster Schedule Snapshot Response
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param snapshotResponsePayload   Ver.: always
 */
bool emberAfSimpleMeteringClusterScheduleSnapshotResponseCallback(uint32_t issuerEventId,
                                                                     uint8_t* snapshotResponsePayload);
/** @brief Simple Metering Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfSimpleMeteringClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                EmberAfAttributeId attributeId);
/** @brief Simple Metering Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfSimpleMeteringClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                               uint8_t commandId,
                                                               EmberAfStatus status);
/** @brief Simple Metering Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfSimpleMeteringClusterServerInitCallback(uint8_t endpoint);
/** @brief Simple Metering Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfSimpleMeteringClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                    EmberAfAttributeId attributeId,
                                                                                    uint16_t manufacturerCode);
/** @brief Simple Metering Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfSimpleMeteringClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                           uint16_t indexOrDestination,
                                                           EmberApsFrame *apsFrame,
                                                           uint16_t msgLen,
                                                           uint8_t *message,
                                                           EmberStatus status);
/** @brief Simple Metering Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfSimpleMeteringClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            EmberAfAttributeType attributeType,
                                                                            uint8_t size,
                                                                            uint8_t *value);
/** @brief Simple Metering Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfSimpleMeteringClusterServerTickCallback(uint8_t endpoint);
/** @brief Simple Metering Cluster Set Supply Status
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param supplyTamperState   Ver.: always
 * @param supplyDepletionState   Ver.: always
 * @param supplyUncontrolledFlowState   Ver.: always
 * @param loadLimitSupplyState   Ver.: always
 */
bool emberAfSimpleMeteringClusterSetSupplyStatusCallback(uint32_t issuerEventId,
                                                            uint8_t supplyTamperState,
                                                            uint8_t supplyDepletionState,
                                                            uint8_t supplyUncontrolledFlowState,
                                                            uint8_t loadLimitSupplyState);
/** @brief Simple Metering Cluster Set Uncontrolled Flow Threshold
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param uncontrolledFlowThreshold   Ver.: always
 * @param unitOfMeasure   Ver.: always
 * @param multiplier   Ver.: always
 * @param divisor   Ver.: always
 * @param stabilisationPeriod   Ver.: always
 * @param measurementPeriod   Ver.: always
 */
bool emberAfSimpleMeteringClusterSetUncontrolledFlowThresholdCallback(uint32_t providerId,
                                                                         uint32_t issuerEventId,
                                                                         uint16_t uncontrolledFlowThreshold,
                                                                         uint8_t unitOfMeasure,
                                                                         uint16_t multiplier,
                                                                         uint16_t divisor,
                                                                         uint8_t stabilisationPeriod,
                                                                         uint16_t measurementPeriod);
/** @brief Simple Metering Cluster Start Sampling
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param startSamplingTime   Ver.: always
 * @param sampleType   Ver.: always
 * @param sampleRequestInterval   Ver.: always
 * @param maxNumberOfSamples   Ver.: always
 */
bool emberAfSimpleMeteringClusterStartSamplingCallback(uint32_t issuerEventId,
                                                          uint32_t startSamplingTime,
                                                          uint8_t sampleType,
                                                          uint16_t sampleRequestInterval,
                                                          uint16_t maxNumberOfSamples);
/** @brief Simple Metering Cluster Start Sampling Response
 *
 * 
 *
 * @param sampleId   Ver.: always
 */
bool emberAfSimpleMeteringClusterStartSamplingResponseCallback(uint16_t sampleId);
/** @brief Simple Metering Cluster Supply Status Response
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param implementationDateTime   Ver.: always
 * @param supplyStatus   Ver.: always
 */
bool emberAfSimpleMeteringClusterSupplyStatusResponseCallback(uint32_t providerId,
                                                                 uint32_t issuerEventId,
                                                                 uint32_t implementationDateTime,
                                                                 uint8_t supplyStatus);
/** @brief Simple Metering Cluster Take Snapshot
 *
 * 
 *
 * @param snapshotCause   Ver.: always
 */
bool emberAfSimpleMeteringClusterTakeSnapshotCallback(uint32_t snapshotCause);
/** @brief Simple Metering Cluster Take Snapshot Response
 *
 * 
 *
 * @param snapshotId   Ver.: always
 * @param snapshotConfirmation   Ver.: always
 */
bool emberAfSimpleMeteringClusterTakeSnapshotResponseCallback(uint32_t snapshotId,
                                                                 uint8_t snapshotConfirmation);

/** @} END Simple Metering Cluster Callbacks */

/** @name Messaging Cluster Callbacks */
// @{

/** @brief Messaging Cluster Cancel All Messages
 *
 * 
 *
 * @param implementationDateTime   Ver.: always
 */
bool emberAfMessagingClusterCancelAllMessagesCallback(uint32_t implementationDateTime);
/** @brief Messaging Cluster Cancel Message
 *
 * 
 *
 * @param messageId   Ver.: always
 * @param messageControl   Ver.: always
 */
bool emberAfMessagingClusterCancelMessageCallback(uint32_t messageId,
                                                     uint8_t messageControl);
/** @brief Messaging Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfMessagingClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Messaging Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfMessagingClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Messaging Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfMessagingClusterClientInitCallback(uint8_t endpoint);
/** @brief Messaging Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfMessagingClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Messaging Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfMessagingClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Messaging Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfMessagingClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Messaging Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfMessagingClusterClientTickCallback(uint8_t endpoint);
/** @brief Messaging Cluster Display Message
 *
 * 
 *
 * @param messageId   Ver.: always
 * @param messageControl   Ver.: always
 * @param startTime   Ver.: always
 * @param durationInMinutes   Ver.: always
 * @param message   Ver.: always
 * @param optionalExtendedMessageControl   Ver.: since se-1.2a-07-5356-19
 */
bool emberAfMessagingClusterDisplayMessageCallback(uint32_t messageId,
                                                      uint8_t messageControl,
                                                      uint32_t startTime,
                                                      uint16_t durationInMinutes,
                                                      uint8_t* message,
                                                      uint8_t optionalExtendedMessageControl);
/** @brief Messaging Cluster Display Protected Message
 *
 * 
 *
 * @param messageId   Ver.: always
 * @param messageControl   Ver.: always
 * @param startTime   Ver.: always
 * @param durationInMinutes   Ver.: always
 * @param message   Ver.: always
 * @param optionalExtendedMessageControl   Ver.: always
 */
bool emberAfMessagingClusterDisplayProtectedMessageCallback(uint32_t messageId,
                                                               uint8_t messageControl,
                                                               uint32_t startTime,
                                                               uint16_t durationInMinutes,
                                                               uint8_t* message,
                                                               uint8_t optionalExtendedMessageControl);
/** @brief Messaging Cluster Get Last Message
 *
 * 
 *
 */
bool emberAfMessagingClusterGetLastMessageCallback(void);
/** @brief Messaging Cluster Get Message Cancellation
 *
 * 
 *
 * @param earliestImplementationTime   Ver.: always
 */
bool emberAfMessagingClusterGetMessageCancellationCallback(uint32_t earliestImplementationTime);
/** @brief Messaging Cluster Message Confirmation
 *
 * 
 *
 * @param messageId   Ver.: always
 * @param confirmationTime   Ver.: always
 * @param messageConfirmationControl   Ver.: since se-1.2a-07-5356-19
 * @param messageResponse   Ver.: since se-1.2a-07-5356-19
 */
bool emberAfMessagingClusterMessageConfirmationCallback(uint32_t messageId,
                                                           uint32_t confirmationTime,
                                                           uint8_t messageConfirmationControl,
                                                           uint8_t* messageResponse);
/** @brief Messaging Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfMessagingClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Messaging Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfMessagingClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Messaging Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfMessagingClusterServerInitCallback(uint8_t endpoint);
/** @brief Messaging Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfMessagingClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Messaging Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfMessagingClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Messaging Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfMessagingClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Messaging Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfMessagingClusterServerTickCallback(uint8_t endpoint);

/** @} END Messaging Cluster Callbacks */

/** @name Tunneling Cluster Callbacks */
// @{

/** @brief Tunneling Cluster Ack Transfer Data Client To Server
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param numberOfBytesLeft   Ver.: always
 */
bool emberAfTunnelingClusterAckTransferDataClientToServerCallback(uint16_t tunnelId,
                                                                     uint16_t numberOfBytesLeft);
/** @brief Tunneling Cluster Ack Transfer Data Server To Client
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param numberOfBytesLeft   Ver.: always
 */
bool emberAfTunnelingClusterAckTransferDataServerToClientCallback(uint16_t tunnelId,
                                                                     uint16_t numberOfBytesLeft);
/** @brief Tunneling Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTunnelingClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Tunneling Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTunnelingClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Tunneling Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTunnelingClusterClientInitCallback(uint8_t endpoint);
/** @brief Tunneling Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTunnelingClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Tunneling Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTunnelingClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Tunneling Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTunnelingClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Tunneling Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTunnelingClusterClientTickCallback(uint8_t endpoint);
/** @brief Tunneling Cluster Close Tunnel
 *
 * 
 *
 * @param tunnelId   Ver.: always
 */
bool emberAfTunnelingClusterCloseTunnelCallback(uint16_t tunnelId);
/** @brief Tunneling Cluster Get Supported Tunnel Protocols
 *
 * 
 *
 * @param protocolOffset   Ver.: always
 */
bool emberAfTunnelingClusterGetSupportedTunnelProtocolsCallback(uint8_t protocolOffset);
/** @brief Tunneling Cluster Ready Data Client To Server
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param numberOfOctetsLeft   Ver.: always
 */
bool emberAfTunnelingClusterReadyDataClientToServerCallback(uint16_t tunnelId,
                                                               uint16_t numberOfOctetsLeft);
/** @brief Tunneling Cluster Ready Data Server To Client
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param numberOfOctetsLeft   Ver.: always
 */
bool emberAfTunnelingClusterReadyDataServerToClientCallback(uint16_t tunnelId,
                                                               uint16_t numberOfOctetsLeft);
/** @brief Tunneling Cluster Request Tunnel
 *
 * 
 *
 * @param protocolId   Ver.: always
 * @param manufacturerCode   Ver.: always
 * @param flowControlSupport   Ver.: always
 * @param maximumIncomingTransferSize   Ver.: since se-1.1a-07-5356-17
 */
bool emberAfTunnelingClusterRequestTunnelCallback(uint8_t protocolId,
                                                     uint16_t manufacturerCode,
                                                     uint8_t flowControlSupport,
                                                     uint16_t maximumIncomingTransferSize);
/** @brief Tunneling Cluster Request Tunnel Response
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param tunnelStatus   Ver.: always
 * @param maximumIncomingTransferSize   Ver.: since se-1.1a-07-5356-17
 */
bool emberAfTunnelingClusterRequestTunnelResponseCallback(uint16_t tunnelId,
                                                             uint8_t tunnelStatus,
                                                             uint16_t maximumIncomingTransferSize);
/** @brief Tunneling Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfTunnelingClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                           EmberAfAttributeId attributeId);
/** @brief Tunneling Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfTunnelingClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                          uint8_t commandId,
                                                          EmberAfStatus status);
/** @brief Tunneling Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfTunnelingClusterServerInitCallback(uint8_t endpoint);
/** @brief Tunneling Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfTunnelingClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                               EmberAfAttributeId attributeId,
                                                                               uint16_t manufacturerCode);
/** @brief Tunneling Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfTunnelingClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                      uint16_t indexOrDestination,
                                                      EmberApsFrame *apsFrame,
                                                      uint16_t msgLen,
                                                      uint8_t *message,
                                                      EmberStatus status);
/** @brief Tunneling Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfTunnelingClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                       EmberAfAttributeId attributeId,
                                                                       EmberAfAttributeType attributeType,
                                                                       uint8_t size,
                                                                       uint8_t *value);
/** @brief Tunneling Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfTunnelingClusterServerTickCallback(uint8_t endpoint);
/** @brief Tunneling Cluster Supported Tunnel Protocols Response
 *
 * 
 *
 * @param protocolListComplete   Ver.: always
 * @param protocolCount   Ver.: always
 * @param protocolList   Ver.: always
 */
bool emberAfTunnelingClusterSupportedTunnelProtocolsResponseCallback(uint8_t protocolListComplete,
                                                                        uint8_t protocolCount,
                                                                        uint8_t* protocolList);
/** @brief Tunneling Cluster Transfer Data Client To Server
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param data   Ver.: always
 */
bool emberAfTunnelingClusterTransferDataClientToServerCallback(uint16_t tunnelId,
                                                                  uint8_t* data);
/** @brief Tunneling Cluster Transfer Data Error Client To Server
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param transferDataStatus   Ver.: always
 */
bool emberAfTunnelingClusterTransferDataErrorClientToServerCallback(uint16_t tunnelId,
                                                                       uint8_t transferDataStatus);
/** @brief Tunneling Cluster Transfer Data Error Server To Client
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param transferDataStatus   Ver.: always
 */
bool emberAfTunnelingClusterTransferDataErrorServerToClientCallback(uint16_t tunnelId,
                                                                       uint8_t transferDataStatus);
/** @brief Tunneling Cluster Transfer Data Server To Client
 *
 * 
 *
 * @param tunnelId   Ver.: always
 * @param data   Ver.: always
 */
bool emberAfTunnelingClusterTransferDataServerToClientCallback(uint16_t tunnelId,
                                                                  uint8_t* data);
/** @brief Tunneling Cluster Tunnel Closure Notification
 *
 * 
 *
 * @param tunnelId   Ver.: always
 */
bool emberAfTunnelingClusterTunnelClosureNotificationCallback(uint16_t tunnelId);

/** @} END Tunneling Cluster Callbacks */

/** @name Prepayment Cluster Callbacks */
// @{

/** @brief Prepayment Cluster Change Debt
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param debtLabel   Ver.: always
 * @param debtAmount   Ver.: always
 * @param debtRecoveryMethod   Ver.: always
 * @param debtAmountType   Ver.: always
 * @param debtRecoveryStartTime   Ver.: always
 * @param debtRecoveryCollectionTime   Ver.: always
 * @param debtRecoveryFrequency   Ver.: always
 * @param debtRecoveryAmount   Ver.: always
 * @param debtRecoveryBalancePercentage   Ver.: always
 */
bool emberAfPrepaymentClusterChangeDebtCallback(uint32_t issuerEventId,
                                                   uint8_t* debtLabel,
                                                   uint32_t debtAmount,
                                                   uint8_t debtRecoveryMethod,
                                                   uint8_t debtAmountType,
                                                   uint32_t debtRecoveryStartTime,
                                                   uint16_t debtRecoveryCollectionTime,
                                                   uint8_t debtRecoveryFrequency,
                                                   uint32_t debtRecoveryAmount,
                                                   uint16_t debtRecoveryBalancePercentage);
/** @brief Prepayment Cluster Change Payment Mode
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param implementationDateTime   Ver.: always
 * @param proposedPaymentControlConfiguration   Ver.: always
 * @param cutOffValue   Ver.: always
 */
bool emberAfPrepaymentClusterChangePaymentModeCallback(uint32_t providerId,
                                                          uint32_t issuerEventId,
                                                          uint32_t implementationDateTime,
                                                          uint16_t proposedPaymentControlConfiguration,
                                                          uint32_t cutOffValue);
/** @brief Prepayment Cluster Change Payment Mode Response
 *
 * 
 *
 * @param friendlyCredit   Ver.: always
 * @param friendlyCreditCalendarId   Ver.: always
 * @param emergencyCreditLimit   Ver.: always
 * @param emergencyCreditThreshold   Ver.: always
 */
bool emberAfPrepaymentClusterChangePaymentModeResponseCallback(uint8_t friendlyCredit,
                                                                  uint32_t friendlyCreditCalendarId,
                                                                  uint32_t emergencyCreditLimit,
                                                                  uint32_t emergencyCreditThreshold);
/** @brief Prepayment Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPrepaymentClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Prepayment Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPrepaymentClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Prepayment Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPrepaymentClusterClientInitCallback(uint8_t endpoint);
/** @brief Prepayment Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPrepaymentClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Prepayment Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPrepaymentClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Prepayment Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPrepaymentClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Prepayment Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPrepaymentClusterClientTickCallback(uint8_t endpoint);
/** @brief Prepayment Cluster Consumer Top Up
 *
 * 
 *
 * @param originatingDevice   Ver.: always
 * @param topUpCode   Ver.: always
 */
bool emberAfPrepaymentClusterConsumerTopUpCallback(uint8_t originatingDevice,
                                                      uint8_t* topUpCode);
/** @brief Prepayment Cluster Consumer Top Up Response
 *
 * 
 *
 * @param resultType   Ver.: always
 * @param topUpValue   Ver.: always
 * @param sourceOfTopUp   Ver.: always
 * @param creditRemaining   Ver.: always
 */
bool emberAfPrepaymentClusterConsumerTopUpResponseCallback(uint8_t resultType,
                                                              uint32_t topUpValue,
                                                              uint8_t sourceOfTopUp,
                                                              uint32_t creditRemaining);
/** @brief Prepayment Cluster Credit Adjustment
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param creditAdjustmentType   Ver.: always
 * @param creditAdjustmentValue   Ver.: always
 */
bool emberAfPrepaymentClusterCreditAdjustmentCallback(uint32_t issuerEventId,
                                                         uint32_t startTime,
                                                         uint8_t creditAdjustmentType,
                                                         uint32_t creditAdjustmentValue);
/** @brief Prepayment Cluster Emergency Credit Setup
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param startTime   Ver.: always
 * @param emergencyCreditLimit   Ver.: always
 * @param emergencyCreditThreshold   Ver.: always
 */
bool emberAfPrepaymentClusterEmergencyCreditSetupCallback(uint32_t issuerEventId,
                                                             uint32_t startTime,
                                                             uint32_t emergencyCreditLimit,
                                                             uint32_t emergencyCreditThreshold);
/** @brief Prepayment Cluster Get Debt Repayment Log
 *
 * 
 *
 * @param latestEndTime   Ver.: always
 * @param numberOfDebts   Ver.: always
 * @param debtType   Ver.: always
 */
bool emberAfPrepaymentClusterGetDebtRepaymentLogCallback(uint32_t latestEndTime,
                                                            uint8_t numberOfDebts,
                                                            uint8_t debtType);
/** @brief Prepayment Cluster Get Prepay Snapshot
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param latestEndTime   Ver.: always
 * @param snapshotOffset   Ver.: always
 * @param snapshotCause   Ver.: always
 */
bool emberAfPrepaymentClusterGetPrepaySnapshotCallback(uint32_t earliestStartTime,
                                                          uint32_t latestEndTime,
                                                          uint8_t snapshotOffset,
                                                          uint32_t snapshotCause);
/** @brief Prepayment Cluster Get Top Up Log
 *
 * 
 *
 * @param latestEndTime   Ver.: always
 * @param numberOfRecords   Ver.: always
 */
bool emberAfPrepaymentClusterGetTopUpLogCallback(uint32_t latestEndTime,
                                                    uint8_t numberOfRecords);
/** @brief Prepayment Cluster Publish Debt Log
 *
 * 
 *
 * @param commandIndex   Ver.: always
 * @param totalNumberOfCommands   Ver.: always
 * @param debtPayload   Ver.: always
 */
bool emberAfPrepaymentClusterPublishDebtLogCallback(uint8_t commandIndex,
                                                       uint8_t totalNumberOfCommands,
                                                       uint8_t* debtPayload);
/** @brief Prepayment Cluster Publish Prepay Snapshot
 *
 * 
 *
 * @param snapshotId   Ver.: always
 * @param snapshotTime   Ver.: always
 * @param totalSnapshotsFound   Ver.: always
 * @param commandIndex   Ver.: always
 * @param totalNumberOfCommands   Ver.: always
 * @param snapshotCause   Ver.: always
 * @param snapshotPayloadType   Ver.: always
 * @param snapshotPayload   Ver.: always
 */
bool emberAfPrepaymentClusterPublishPrepaySnapshotCallback(uint32_t snapshotId,
                                                              uint32_t snapshotTime,
                                                              uint8_t totalSnapshotsFound,
                                                              uint8_t commandIndex,
                                                              uint8_t totalNumberOfCommands,
                                                              uint32_t snapshotCause,
                                                              uint8_t snapshotPayloadType,
                                                              uint8_t* snapshotPayload);
/** @brief Prepayment Cluster Publish Top Up Log
 *
 * 
 *
 * @param commandIndex   Ver.: always
 * @param totalNumberOfCommands   Ver.: always
 * @param topUpPayload   Ver.: always
 */
bool emberAfPrepaymentClusterPublishTopUpLogCallback(uint8_t commandIndex,
                                                        uint8_t totalNumberOfCommands,
                                                        uint8_t* topUpPayload);
/** @brief Prepayment Cluster Select Available Emergency Credit
 *
 * 
 *
 * @param commandIssueDateTime   Ver.: always
 * @param originatingDevice   Ver.: always
 */
bool emberAfPrepaymentClusterSelectAvailableEmergencyCreditCallback(uint32_t commandIssueDateTime,
                                                                       uint8_t originatingDevice);
/** @brief Prepayment Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfPrepaymentClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief Prepayment Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfPrepaymentClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief Prepayment Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfPrepaymentClusterServerInitCallback(uint8_t endpoint);
/** @brief Prepayment Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfPrepaymentClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief Prepayment Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfPrepaymentClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief Prepayment Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfPrepaymentClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief Prepayment Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfPrepaymentClusterServerTickCallback(uint8_t endpoint);
/** @brief Prepayment Cluster Set Low Credit Warning Level
 *
 * 
 *
 * @param lowCreditWarningLevel   Ver.: always
 */
bool emberAfPrepaymentClusterSetLowCreditWarningLevelCallback(uint32_t lowCreditWarningLevel);
/** @brief Prepayment Cluster Set Maximum Credit Limit
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param implementationDateTime   Ver.: always
 * @param maximumCreditLevel   Ver.: always
 * @param maximumCreditPerTopUp   Ver.: always
 */
bool emberAfPrepaymentClusterSetMaximumCreditLimitCallback(uint32_t providerId,
                                                              uint32_t issuerEventId,
                                                              uint32_t implementationDateTime,
                                                              uint32_t maximumCreditLevel,
                                                              uint32_t maximumCreditPerTopUp);
/** @brief Prepayment Cluster Set Overall Debt Cap
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param implementationDateTime   Ver.: always
 * @param overallDebtCap   Ver.: always
 */
bool emberAfPrepaymentClusterSetOverallDebtCapCallback(uint32_t providerId,
                                                          uint32_t issuerEventId,
                                                          uint32_t implementationDateTime,
                                                          uint32_t overallDebtCap);

/** @} END Prepayment Cluster Callbacks */

/** @name Energy Management Cluster Callbacks */
// @{

/** @brief Energy Management Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEnergyManagementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Energy Management Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEnergyManagementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Energy Management Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEnergyManagementClusterClientInitCallback(uint8_t endpoint);
/** @brief Energy Management Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEnergyManagementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Energy Management Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEnergyManagementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Energy Management Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEnergyManagementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Energy Management Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEnergyManagementClusterClientTickCallback(uint8_t endpoint);
/** @brief Energy Management Cluster Manage Event
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param deviceClass   Ver.: always
 * @param utilityEnrollmentGroup   Ver.: always
 * @param actionRequired   Ver.: always
 */
bool emberAfEnergyManagementClusterManageEventCallback(uint32_t issuerEventId,
                                                          uint16_t deviceClass,
                                                          uint8_t utilityEnrollmentGroup,
                                                          uint8_t actionRequired);
/** @brief Energy Management Cluster Report Event Status
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param eventStatus   Ver.: always
 * @param eventStatusTime   Ver.: always
 * @param criticalityLevelApplied   Ver.: always
 * @param coolingTemperatureSetPointApplied   Ver.: always
 * @param heatingTemperatureSetPointApplied   Ver.: always
 * @param averageLoadAdjustmentPercentageApplied   Ver.: always
 * @param dutyCycleApplied   Ver.: always
 * @param eventControl   Ver.: always
 */
bool emberAfEnergyManagementClusterReportEventStatusCallback(uint32_t issuerEventId,
                                                                uint8_t eventStatus,
                                                                uint32_t eventStatusTime,
                                                                uint8_t criticalityLevelApplied,
                                                                uint16_t coolingTemperatureSetPointApplied,
                                                                uint16_t heatingTemperatureSetPointApplied,
                                                                int8_t averageLoadAdjustmentPercentageApplied,
                                                                uint8_t dutyCycleApplied,
                                                                uint8_t eventControl);
/** @brief Energy Management Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEnergyManagementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Energy Management Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEnergyManagementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Energy Management Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEnergyManagementClusterServerInitCallback(uint8_t endpoint);
/** @brief Energy Management Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEnergyManagementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Energy Management Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEnergyManagementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Energy Management Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEnergyManagementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Energy Management Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEnergyManagementClusterServerTickCallback(uint8_t endpoint);

/** @} END Energy Management Cluster Callbacks */

/** @name Calendar Cluster Callbacks */
// @{

/** @brief Calendar Cluster Cancel Calendar
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param calendarType   Ver.: always
 */
bool emberAfCalendarClusterCancelCalendarCallback(uint32_t providerId,
                                                     uint32_t issuerCalendarId,
                                                     uint8_t calendarType);
/** @brief Calendar Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCalendarClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                          EmberAfAttributeId attributeId);
/** @brief Calendar Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCalendarClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                         uint8_t commandId,
                                                         EmberAfStatus status);
/** @brief Calendar Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCalendarClusterClientInitCallback(uint8_t endpoint);
/** @brief Calendar Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCalendarClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              uint16_t manufacturerCode);
/** @brief Calendar Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCalendarClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                     uint16_t indexOrDestination,
                                                     EmberApsFrame *apsFrame,
                                                     uint16_t msgLen,
                                                     uint8_t *message,
                                                     EmberStatus status);
/** @brief Calendar Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCalendarClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId,
                                                                      EmberAfAttributeType attributeType,
                                                                      uint8_t size,
                                                                      uint8_t *value);
/** @brief Calendar Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCalendarClusterClientTickCallback(uint8_t endpoint);
/** @brief Calendar Cluster Get Calendar
 *
 * 
 *
 * @param earliestStartTime   Ver.: always
 * @param minIssuerEventId   Ver.: always
 * @param numberOfCalendars   Ver.: always
 * @param calendarType   Ver.: always
 * @param providerId   Ver.: always
 */
bool emberAfCalendarClusterGetCalendarCallback(uint32_t earliestStartTime,
                                                  uint32_t minIssuerEventId,
                                                  uint8_t numberOfCalendars,
                                                  uint8_t calendarType,
                                                  uint32_t providerId);
/** @brief Calendar Cluster Get Calendar Cancellation
 *
 * 
 *
 */
bool emberAfCalendarClusterGetCalendarCancellationCallback(void);
/** @brief Calendar Cluster Get Day Profiles
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param startDayId   Ver.: always
 * @param numberOfDays   Ver.: always
 */
bool emberAfCalendarClusterGetDayProfilesCallback(uint32_t providerId,
                                                     uint32_t issuerCalendarId,
                                                     uint8_t startDayId,
                                                     uint8_t numberOfDays);
/** @brief Calendar Cluster Get Seasons
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 */
bool emberAfCalendarClusterGetSeasonsCallback(uint32_t providerId,
                                                 uint32_t issuerCalendarId);
/** @brief Calendar Cluster Get Special Days
 *
 * 
 *
 * @param startTime   Ver.: always
 * @param numberOfEvents   Ver.: always
 * @param calendarType   Ver.: always
 * @param providerId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 */
bool emberAfCalendarClusterGetSpecialDaysCallback(uint32_t startTime,
                                                     uint8_t numberOfEvents,
                                                     uint8_t calendarType,
                                                     uint32_t providerId,
                                                     uint32_t issuerCalendarId);
/** @brief Calendar Cluster Get Week Profiles
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param startWeekId   Ver.: always
 * @param numberOfWeeks   Ver.: always
 */
bool emberAfCalendarClusterGetWeekProfilesCallback(uint32_t providerId,
                                                      uint32_t issuerCalendarId,
                                                      uint8_t startWeekId,
                                                      uint8_t numberOfWeeks);
/** @brief Calendar Cluster Publish Calendar
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param startTime   Ver.: always
 * @param calendarType   Ver.: always
 * @param calendarTimeReference   Ver.: always
 * @param calendarName   Ver.: always
 * @param numberOfSeasons   Ver.: always
 * @param numberOfWeekProfiles   Ver.: always
 * @param numberOfDayProfiles   Ver.: always
 */
bool emberAfCalendarClusterPublishCalendarCallback(uint32_t providerId,
                                                      uint32_t issuerEventId,
                                                      uint32_t issuerCalendarId,
                                                      uint32_t startTime,
                                                      uint8_t calendarType,
                                                      uint8_t calendarTimeReference,
                                                      uint8_t* calendarName,
                                                      uint8_t numberOfSeasons,
                                                      uint8_t numberOfWeekProfiles,
                                                      uint8_t numberOfDayProfiles);
/** @brief Calendar Cluster Publish Day Profile
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param dayId   Ver.: always
 * @param totalNumberOfScheduleEntries   Ver.: always
 * @param commandIndex   Ver.: always
 * @param totalNumberOfCommands   Ver.: always
 * @param calendarType   Ver.: always
 * @param dayScheduleEntries   Ver.: always
 */
bool emberAfCalendarClusterPublishDayProfileCallback(uint32_t providerId,
                                                        uint32_t issuerEventId,
                                                        uint32_t issuerCalendarId,
                                                        uint8_t dayId,
                                                        uint8_t totalNumberOfScheduleEntries,
                                                        uint8_t commandIndex,
                                                        uint8_t totalNumberOfCommands,
                                                        uint8_t calendarType,
                                                        uint8_t* dayScheduleEntries);
/** @brief Calendar Cluster Publish Seasons
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param commandIndex   Ver.: always
 * @param totalNumberOfCommands   Ver.: always
 * @param seasonEntries   Ver.: always
 */
bool emberAfCalendarClusterPublishSeasonsCallback(uint32_t providerId,
                                                     uint32_t issuerEventId,
                                                     uint32_t issuerCalendarId,
                                                     uint8_t commandIndex,
                                                     uint8_t totalNumberOfCommands,
                                                     uint8_t* seasonEntries);
/** @brief Calendar Cluster Publish Special Days
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param startTime   Ver.: always
 * @param calendarType   Ver.: always
 * @param totalNumberOfSpecialDays   Ver.: always
 * @param commandIndex   Ver.: always
 * @param totalNumberOfCommands   Ver.: always
 * @param specialDayEntries   Ver.: always
 */
bool emberAfCalendarClusterPublishSpecialDaysCallback(uint32_t providerId,
                                                         uint32_t issuerEventId,
                                                         uint32_t issuerCalendarId,
                                                         uint32_t startTime,
                                                         uint8_t calendarType,
                                                         uint8_t totalNumberOfSpecialDays,
                                                         uint8_t commandIndex,
                                                         uint8_t totalNumberOfCommands,
                                                         uint8_t* specialDayEntries);
/** @brief Calendar Cluster Publish Week Profile
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param issuerCalendarId   Ver.: always
 * @param weekId   Ver.: always
 * @param dayIdRefMonday   Ver.: always
 * @param dayIdRefTuesday   Ver.: always
 * @param dayIdRefWednesday   Ver.: always
 * @param dayIdRefThursday   Ver.: always
 * @param dayIdRefFriday   Ver.: always
 * @param dayIdRefSaturday   Ver.: always
 * @param dayIdRefSunday   Ver.: always
 */
bool emberAfCalendarClusterPublishWeekProfileCallback(uint32_t providerId,
                                                         uint32_t issuerEventId,
                                                         uint32_t issuerCalendarId,
                                                         uint8_t weekId,
                                                         uint8_t dayIdRefMonday,
                                                         uint8_t dayIdRefTuesday,
                                                         uint8_t dayIdRefWednesday,
                                                         uint8_t dayIdRefThursday,
                                                         uint8_t dayIdRefFriday,
                                                         uint8_t dayIdRefSaturday,
                                                         uint8_t dayIdRefSunday);
/** @brief Calendar Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfCalendarClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                          EmberAfAttributeId attributeId);
/** @brief Calendar Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfCalendarClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                         uint8_t commandId,
                                                         EmberAfStatus status);
/** @brief Calendar Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfCalendarClusterServerInitCallback(uint8_t endpoint);
/** @brief Calendar Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfCalendarClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              uint16_t manufacturerCode);
/** @brief Calendar Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfCalendarClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                     uint16_t indexOrDestination,
                                                     EmberApsFrame *apsFrame,
                                                     uint16_t msgLen,
                                                     uint8_t *message,
                                                     EmberStatus status);
/** @brief Calendar Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfCalendarClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                      EmberAfAttributeId attributeId,
                                                                      EmberAfAttributeType attributeType,
                                                                      uint8_t size,
                                                                      uint8_t *value);
/** @brief Calendar Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfCalendarClusterServerTickCallback(uint8_t endpoint);

/** @} END Calendar Cluster Callbacks */

/** @name Device Management Cluster Callbacks */
// @{

/** @brief Device Management Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDeviceManagementClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Device Management Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDeviceManagementClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Device Management Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDeviceManagementClusterClientInitCallback(uint8_t endpoint);
/** @brief Device Management Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDeviceManagementClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Device Management Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDeviceManagementClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Device Management Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDeviceManagementClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Device Management Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDeviceManagementClusterClientTickCallback(uint8_t endpoint);
/** @brief Device Management Cluster Get C I N
 *
 * 
 *
 */
bool emberAfDeviceManagementClusterGetCINCallback(void);
/** @brief Device Management Cluster Get Change Of Supplier
 *
 * 
 *
 */
bool emberAfDeviceManagementClusterGetChangeOfSupplierCallback(void);
/** @brief Device Management Cluster Get Change Of Tenancy
 *
 * 
 *
 */
bool emberAfDeviceManagementClusterGetChangeOfTenancyCallback(void);
/** @brief Device Management Cluster Get Event Configuration
 *
 * 
 *
 * @param eventId   Ver.: always
 */
bool emberAfDeviceManagementClusterGetEventConfigurationCallback(uint16_t eventId);
/** @brief Device Management Cluster Get Site Id
 *
 * 
 *
 */
bool emberAfDeviceManagementClusterGetSiteIdCallback(void);
/** @brief Device Management Cluster Publish Change Of Supplier
 *
 * 
 *
 * @param currentProviderId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param tariffType   Ver.: always
 * @param proposedProviderId   Ver.: always
 * @param providerChangeImplementationTime   Ver.: always
 * @param providerChangeControl   Ver.: always
 * @param proposedProviderName   Ver.: always
 * @param proposedProviderContactDetails   Ver.: always
 */
bool emberAfDeviceManagementClusterPublishChangeOfSupplierCallback(uint32_t currentProviderId,
                                                                      uint32_t issuerEventId,
                                                                      uint8_t tariffType,
                                                                      uint32_t proposedProviderId,
                                                                      uint32_t providerChangeImplementationTime,
                                                                      uint32_t providerChangeControl,
                                                                      uint8_t* proposedProviderName,
                                                                      uint8_t* proposedProviderContactDetails);
/** @brief Device Management Cluster Publish Change Of Tenancy
 *
 * 
 *
 * @param providerId   Ver.: always
 * @param issuerEventId   Ver.: always
 * @param tariffType   Ver.: always
 * @param implementationDateTime   Ver.: always
 * @param proposedTenancyChangeControl   Ver.: always
 */
bool emberAfDeviceManagementClusterPublishChangeOfTenancyCallback(uint32_t providerId,
                                                                     uint32_t issuerEventId,
                                                                     uint8_t tariffType,
                                                                     uint32_t implementationDateTime,
                                                                     uint32_t proposedTenancyChangeControl);
/** @brief Device Management Cluster Report Event Configuration
 *
 * 
 *
 * @param commandIndex   Ver.: always
 * @param totalCommands   Ver.: always
 * @param eventConfigurationPayload   Ver.: always
 */
bool emberAfDeviceManagementClusterReportEventConfigurationCallback(uint8_t commandIndex,
                                                                       uint8_t totalCommands,
                                                                       uint8_t* eventConfigurationPayload);
/** @brief Device Management Cluster Request New Password
 *
 * 
 *
 * @param passwordType   Ver.: always
 */
bool emberAfDeviceManagementClusterRequestNewPasswordCallback(uint8_t passwordType);
/** @brief Device Management Cluster Request New Password Response
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param implementationDateTime   Ver.: always
 * @param durationInMinutes   Ver.: always
 * @param passwordType   Ver.: always
 * @param password   Ver.: always
 */
bool emberAfDeviceManagementClusterRequestNewPasswordResponseCallback(uint32_t issuerEventId,
                                                                         uint32_t implementationDateTime,
                                                                         uint16_t durationInMinutes,
                                                                         uint8_t passwordType,
                                                                         uint8_t* password);
/** @brief Device Management Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfDeviceManagementClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                                  EmberAfAttributeId attributeId);
/** @brief Device Management Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfDeviceManagementClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                                 uint8_t commandId,
                                                                 EmberAfStatus status);
/** @brief Device Management Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfDeviceManagementClusterServerInitCallback(uint8_t endpoint);
/** @brief Device Management Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfDeviceManagementClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                      EmberAfAttributeId attributeId,
                                                                                      uint16_t manufacturerCode);
/** @brief Device Management Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfDeviceManagementClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                             uint16_t indexOrDestination,
                                                             EmberApsFrame *apsFrame,
                                                             uint16_t msgLen,
                                                             uint8_t *message,
                                                             EmberStatus status);
/** @brief Device Management Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfDeviceManagementClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                              EmberAfAttributeId attributeId,
                                                                              EmberAfAttributeType attributeType,
                                                                              uint8_t size,
                                                                              uint8_t *value);
/** @brief Device Management Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfDeviceManagementClusterServerTickCallback(uint8_t endpoint);
/** @brief Device Management Cluster Set Event Configuration
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param startDateTime   Ver.: always
 * @param eventConfiguration   Ver.: always
 * @param configurationControl   Ver.: always
 * @param eventConfigurationPayload   Ver.: always
 */
bool emberAfDeviceManagementClusterSetEventConfigurationCallback(uint32_t issuerEventId,
                                                                    uint32_t startDateTime,
                                                                    uint8_t eventConfiguration,
                                                                    uint8_t configurationControl,
                                                                    uint8_t* eventConfigurationPayload);
/** @brief Device Management Cluster Update C I N
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param implementationTime   Ver.: always
 * @param providerId   Ver.: always
 * @param customerIdNumber   Ver.: always
 */
bool emberAfDeviceManagementClusterUpdateCINCallback(uint32_t issuerEventId,
                                                        uint32_t implementationTime,
                                                        uint32_t providerId,
                                                        uint8_t* customerIdNumber);
/** @brief Device Management Cluster Update Site Id
 *
 * 
 *
 * @param issuerEventId   Ver.: always
 * @param siteIdTime   Ver.: always
 * @param providerId   Ver.: always
 * @param siteId   Ver.: always
 */
bool emberAfDeviceManagementClusterUpdateSiteIdCallback(uint32_t issuerEventId,
                                                           uint32_t siteIdTime,
                                                           uint32_t providerId,
                                                           uint8_t* siteId);

/** @} END Device Management Cluster Callbacks */

/** @name Events Cluster Callbacks */
// @{

/** @brief Events Cluster Clear Event Log Request
 *
 * 
 *
 * @param logId   Ver.: always
 */
bool emberAfEventsClusterClearEventLogRequestCallback(uint8_t logId);
/** @brief Events Cluster Clear Event Log Response
 *
 * 
 *
 * @param clearedEventsLogs   Ver.: always
 */
bool emberAfEventsClusterClearEventLogResponseCallback(uint8_t clearedEventsLogs);
/** @brief Events Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEventsClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief Events Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEventsClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief Events Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEventsClusterClientInitCallback(uint8_t endpoint);
/** @brief Events Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEventsClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief Events Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEventsClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief Events Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEventsClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief Events Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEventsClusterClientTickCallback(uint8_t endpoint);
/** @brief Events Cluster Get Event Log
 *
 * 
 *
 * @param eventControlLogId   Ver.: always
 * @param eventId   Ver.: always
 * @param startTime   Ver.: always
 * @param endTime   Ver.: always
 * @param numberOfEvents   Ver.: always
 * @param eventOffset   Ver.: always
 */
bool emberAfEventsClusterGetEventLogCallback(uint8_t eventControlLogId,
                                                uint16_t eventId,
                                                uint32_t startTime,
                                                uint32_t endTime,
                                                uint8_t numberOfEvents,
                                                uint16_t eventOffset);
/** @brief Events Cluster Publish Event
 *
 * 
 *
 * @param logId   Ver.: always
 * @param eventId   Ver.: always
 * @param eventTime   Ver.: always
 * @param eventControl   Ver.: always
 * @param eventData   Ver.: always
 */
bool emberAfEventsClusterPublishEventCallback(uint8_t logId,
                                                 uint16_t eventId,
                                                 uint32_t eventTime,
                                                 uint8_t eventControl,
                                                 uint8_t* eventData);
/** @brief Events Cluster Publish Event Log
 *
 * 
 *
 * @param totalNumberOfEvents   Ver.: always
 * @param commandIndex   Ver.: always
 * @param totalCommands   Ver.: always
 * @param logPayloadControl   Ver.: always
 * @param logPayload   Ver.: always
 */
bool emberAfEventsClusterPublishEventLogCallback(uint16_t totalNumberOfEvents,
                                                    uint8_t commandIndex,
                                                    uint8_t totalCommands,
                                                    uint8_t logPayloadControl,
                                                    uint8_t* logPayload);
/** @brief Events Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfEventsClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                        EmberAfAttributeId attributeId);
/** @brief Events Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfEventsClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                       uint8_t commandId,
                                                       EmberAfStatus status);
/** @brief Events Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfEventsClusterServerInitCallback(uint8_t endpoint);
/** @brief Events Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfEventsClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                            EmberAfAttributeId attributeId,
                                                                            uint16_t manufacturerCode);
/** @brief Events Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfEventsClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                   uint16_t indexOrDestination,
                                                   EmberApsFrame *apsFrame,
                                                   uint16_t msgLen,
                                                   uint8_t *message,
                                                   EmberStatus status);
/** @brief Events Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfEventsClusterServerPreAttributeChangedCallback(uint8_t endpoint,
                                                                    EmberAfAttributeId attributeId,
                                                                    EmberAfAttributeType attributeType,
                                                                    uint8_t size,
                                                                    uint8_t *value);
/** @brief Events Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfEventsClusterServerTickCallback(uint8_t endpoint);

/** @} END Events Cluster Callbacks */

/** @name MDU Pairing Cluster Callbacks */
// @{

/** @brief MDU Pairing Cluster Client Attribute Changed
 *
 * Client Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfMduPairingClusterClientAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief MDU Pairing Cluster Client Default Response
 *
 * This function is called when the client receives the default response from
 * the server.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfMduPairingClusterClientDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief MDU Pairing Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfMduPairingClusterClientInitCallback(uint8_t endpoint);
/** @brief MDU Pairing Cluster Client Manufacturer Specific Attribute Changed
 *
 * Client Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfMduPairingClusterClientManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief MDU Pairing Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfMduPairingClusterClientMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief MDU Pairing Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @param size Attribute size  Ver.: always
 * @param value Attribute value  Ver.: always
 */
EmberAfStatus emberAfMduPairingClusterClientPreAttributeChangedCallback(uint8_t endpoint,
                                                                        EmberAfAttributeId attributeId,
                                                                        EmberAfAttributeType attributeType,
                                                                        uint8_t size,
                                                                        uint8_t *value);
/** @brief MDU Pairing Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint Endpoint that is being served  Ver.: always
 */
void emberAfMduPairingClusterClientTickCallback(uint8_t endpoint);
/** @brief MDU Pairing Cluster Pairing Request
 *
 * 
 *
 * @param localPairingInformationVersion   Ver.: always
 * @param eui64OfRequestingDevice   Ver.: always
 */
bool emberAfMduPairingClusterPairingRequestCallback(uint32_t localPairingInformationVersion,
                                                       uint8_t* eui64OfRequestingDevice);
/** @brief MDU Pairing Cluster Pairing Response
 *
 * 
 *
 * @param pairingInformationVersion   Ver.: always
 * @param totalNumberOfDevices   Ver.: always
 * @param commandIndex   Ver.: always
 * @param totalNumberOfCommands   Ver.: always
 * @param eui64s   Ver.: always
 */
bool emberAfMduPairingClusterPairingResponseCallback(uint32_t pairingInformationVersion,
                                                        uint8_t totalNumberOfDevices,
                                                        uint8_t commandIndex,
                                                        uint8_t totalNumberOfCommands,
                                                        uint8_t* eui64s);
/** @brief MDU Pairing Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 */
void emberAfMduPairingClusterServerAttributeChangedCallback(uint8_t endpoint,
                                                            EmberAfAttributeId attributeId);
/** @brief MDU Pairing Cluster Server Default Response
 *
 * This function is called when the server receives the default response from
 * the client.
 *
 * @param endpoint Destination endpoint  Ver.: always
 * @param commandId Command id  Ver.: always
 * @param status Status in default response  Ver.: always
 */
void emberAfMduPairingClusterServerDefaultResponseCallback(uint8_t endpoint,
                                                           uint8_t commandId,
                                                           EmberAfStatus status);
/** @brief MDU Pairing Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 */
void emberAfMduPairingClusterServerInitCallback(uint8_t endpoint);
/** @brief MDU Pairing Cluster Server Manufacturer Specific Attribute Changed
 *
 * Server Manufacturer Specific Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute that changed  Ver.: always
 * @param manufacturerCode Manufacturer Code of the attribute that changed 
 * Ver.: always
 */
void emberAfMduPairingClusterServerManufacturerSpecificAttributeChangedCallback(uint8_t endpoint,
                                                                                EmberAfAttributeId attributeId,
                                                                                uint16_t manufacturerCode);
/** @brief MDU Pairing Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param type The type of message sent  Ver.: always
 * @param indexOrDestination The destination or address to which the message was
 * sent  Ver.: always
 * @param apsFrame The APS frame for the message  Ver.: always
 * @param msgLen The length of the message  Ver.: always
 * @param message The message that was sent  Ver.: always
 * @param status The status of the sent message  Ver.: always
 */
void emberAfMduPairingClusterServerMessageSentCallback(EmberOutgoingMessageType type,
                                                       uint16_t indexOrDestination,
                                                       EmberApsFrame *apsFrame,
                                                       uint16_t msgLen,
                                                       uint8_t *message,
                                                       EmberStatus status);
/** @brief MDU Pairing Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param endpoint Endpoint that is being initialized  Ver.: always
 * @param attributeId Attribute to be changed  Ver.: always
 * @param attributeType Attribute type  Ver.: always
 * @para