/************************************************************
*版权所有 （C）2020，公司（或个人）名称
*
*文件名称： kk_scene.db.c
*内容摘要： 场景功能数据库处理
*其他说明： 
*当前版本：  
*************************************************************/
 
/*************************************************************
头文件引用 
*************************************************************/
	
#include <stdio.h>
#include "kk_tsl_api.h"
#include "sqlite3.h"
#include "kk_log.h"
#include "kk_scene_handle.h"
#include "kk_scene_db.h"


 /*************************************************************
全局变量定义 
*************************************************************/
extern sqlite3 *g_kk_pDb;

/*************************************************************
函数实现 
*************************************************************/

int kk_scene_db_init(void)
{
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *pcErr;
	/************************************************************
	*功能描述： 场景数据库初始化
	*输入参数： 无
	*输出参数： 无
	*返 回 值：  0：成功；其他：失败
	*其他说明：
	*************************************************************/

	//eUtils_LockLock(&sLock);
	_kk_scene_lock();
	ctx->pDb = g_kk_pDb;

	INFO_PRINT("scene db Database opened\n");

	const char *pSceneTable = "CREATE TABLE IF NOT EXISTS SceneInfo( \
		roomId varchar(255), \
		sceneName varchar(255), \
		sceneType INTEGER, \
		enable INTEGER, \
		sceneId varchar(255) UNIQUE, \
		productType varchar(255),\
		actionRoomId varchar(255))";

	if (sqlite3_exec(ctx->pDb, pSceneTable, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}

	const char *pSceneTriggerTable = "CREATE TABLE IF NOT EXISTS SceneTriggerInfo( \
		type varchar(255), \
		deviceCode varchar(255), \
		epNum INTEGER, \
		propertyName varchar(255), \
		compareType varchar(255), \
		compareValue varchar(255), \
		sceneId varchar(255), \
		isAnd INTEGER, \
		active INTEGER)";


	if (sqlite3_exec(ctx->pDb, pSceneTriggerTable, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}

	const char *pSceneConditionTable = "CREATE TABLE IF NOT EXISTS SceneConditionInfo( \
		type varchar(255), \
		startTime INTEGER, \
		endTime INTEGER, \
		crossDay INTEGER, \
		repeat_days INTEGER, \
		sceneId varchar(255))";


	if (sqlite3_exec(ctx->pDb, pSceneConditionTable, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}

	const char *pSceneActionTable = "CREATE TABLE IF NOT EXISTS SceneActionInfo( \
		type varchar(255), \
		deviceCode varchar(255), \
		epNum INTEGER, \
		propertyName varchar(255), \
		propertyValue varchar(255), \
		delay INTEGER, \
		sceneId varchar(255),\
		gwdeviceCode varchar(255),\
		active INTEGER)";


	if (sqlite3_exec(ctx->pDb, pSceneActionTable, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}

	const char *pSceneTimerTable = "CREATE TABLE IF NOT EXISTS SceneTimerInfo( \
		week INTEGER, \
		time INTEGER, \
		sceneId varchar(255))";

	if (sqlite3_exec(ctx->pDb, pSceneTimerTable, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}
	/*内嵌场景关联表*/
	const char *pSceneEmbedTable = "CREATE TABLE IF NOT EXISTS SceneEmbedInfo( \
		delay INTEGER, \
		executeSceneId varchar(255), \
		sceneId varchar(255))";

	if (sqlite3_exec(ctx->pDb, pSceneEmbedTable, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}
	/*invoke场景关联表*/
	const char *pSceneInvokeServiceTable = "CREATE TABLE IF NOT EXISTS SceneInvokeService( \
		type varchar(255), \
		identifier varchar(255), \
		sceneId varchar(255), \
		args varchar(255))";

	if (sqlite3_exec(ctx->pDb, pSceneInvokeServiceTable, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}	
	//情景面板场景关联
	const char *pPanelScene = "CREATE TABLE IF NOT EXISTS QuickPanelScene( \
		buttonId varchar(255), \
		bindType INTEGER, \
		deviceCode varchar(255), \
		sceneId varchar(255), \
		roomId varchar(255), \
		productType varchar(255))";

	if (sqlite3_exec(ctx->pDb, pPanelScene, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}	
	
	const char *pSceneProTypeInfo = "CREATE TABLE IF NOT EXISTS SceneProTypeInfo( \
		sceneId varchar(255), \
		roomId varchar(255), \
		propertyName varchar(255), \
		propertyValue varchar(255), \
		productType varchar(255),	\
		delay INTEGER)";

	if (sqlite3_exec(ctx->pDb, pSceneProTypeInfo, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}	
	#if 0	
	printf("-------------------------------eee-----------------------akdkkkkkkkkkkkkkkkkkkkk---\n");
	sqlite3_stmt *stmt;
	const char *pAlterPanelScene = "select * from sqlite_master WHERE name = 'QuickPanelScene' and sql like '%TTTEST%'";
	sqlite3_prepare_v2(ctx->pDb, pAlterPanelScene, strlen(pAlterPanelScene), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		int count = sqlite3_column_count(stmt);
		char* pSceneId = (char*)sqlite3_column_text(stmt, 4);
		printf("pSceneId:%s\n",pSceneId);
	}

	printf("------------------------------------------------------akdkkkkkkkkkkkkkkkkkkkk---\n");
	//const char *pAlterPanelScene = "ALTER TABLE QuickPanelScene ADD TTTEST varchar(255)";
	if (sqlite3_exec(ctx->pDb, pAlterPanelScene, NULL, NULL, &pcErr) != SQLITE_OK)
	{
		ERROR_PRINT("Error creating table (%s)\n", pcErr);
		sqlite3_free(pcErr);
		//eUtils_LockUnlock(&sLock);
		_kk_scene_unlock();
		return FAIL_RETURN;
	}
	printf("-----------------------------------------111-------------akdkkkkkkkkkkkkkkkkkkkk---\n");
	#endif
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 场景使能位更新
*输入参数： sceneId：场景Id
          enable: 1,使能；0，不使能
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_update_scene_enable(int enable,const char *sceneId)
{
	char *sqlCmd = NULL;
	//int len =0;
	int rc = 0;
	char *zErrMsg = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();

	//_kk_subDb_lock();
	sqlCmd = sqlite3_mprintf("UPDATE SceneInfo SET enable=%d  WHERE sceneId= '%s'",enable,sceneId);	
	INFO_PRINT("kk_scene_update_scene_enable,sqlCmd:%s\n",sqlCmd);
	rc = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( rc != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
	}else{
		//INFO_PRINT("Table updata data successfully\n");
	}
	sqlite3_free(sqlCmd);
	//_kk_subDb_unlock();
	return SUCCESS_RETURN;
}

/************************************************************
*功能描述： 添加场景信息到数据库
*输入参数： name：场景名称
          enable: 1,使能；0，不使能
          sceneType：场景类型
          sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_insert_scene_info(const char* roomId,const char* sceneName,int sceneType,int enable,const char* sceneId,char *productType,char *actionRoomId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneInfo (roomId,sceneName, sceneType,enable,sceneId,productType,actionRoomId) \
								values ('%s','%s','%d','%d','%s','%s','%s');";
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,roomId,sceneName,sceneType,enable,sceneId,productType,actionRoomId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;
	}
	
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述：更新场景设备类型
*输入参数：sceneId:场景Id
           productType:类型
*输出参数：无
*返 回 值：0:成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_update_productType(const char *sceneId,char *productType)
{
	char *sqlCmd = NULL;
	int rc = 0;
	char *zErrMsg = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();

	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf("UPDATE SceneInfo SET productType='%s'  WHERE sceneId= '%s'",productType,sceneId);	
	INFO_PRINT("kk_scene_update_productType sqlCmd:%s\n",sqlCmd);
	rc = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( rc != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	}else{
	   INFO_PRINT("Table updata data successfully\n");
	}
    sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述：更新场景设备类型
*输入参数：sceneId:场景Id
           productType:类型
*输出参数：无
*返 回 值：0:成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_update_actionRoomId(const char *sceneId,char *roomId)
{
	char *sqlCmd = NULL;
	int rc = 0;
	char *zErrMsg = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();

	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf("UPDATE SceneInfo SET actionRoomId='%s'  WHERE sceneId= '%s'",roomId,sceneId);	
	INFO_PRINT("kk_scene_update_actionRoomId sqlCmd:%s\n",sqlCmd);
	rc = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( rc != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	}else{
	   INFO_PRINT("Table updata data successfully\n");
	}
    sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 添加情景面板信息到数据库
*输入参数： name：场景名称
          enable: 1,使能；0，不使能
          sceneType：场景类型
          sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_insert_panel_scene_info(int bindType,char *buttonId,char *deviceCode,const char* sceneId,const char* roomId,const char* productType)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into QuickPanelScene (buttonId,bindType,deviceCode,sceneId,roomId,productType) \
								values ('%s','%d','%s','%s','%s','%s');";
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,buttonId,bindType,deviceCode,sceneId,roomId,productType);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;
	}
	
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 取消关联
*输入参数： name：场景名称
          enable: 1,使能；0，不使能
          sceneType：场景类型
          sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_panel_scene_info(char *buttonId,char *deviceCode)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;
	char *zErrMsg = 0;
	char *pSceneId = NULL;
	int bindType = 0;

	const char *selectCmd = "select * from QuickPanelScene WHERE deviceCode = '%s' and buttonId = '%s';";

	sqlCmd = sqlite3_mprintf(selectCmd,deviceCode,buttonId);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		pSceneId = (char*)sqlite3_column_text(stmt, DB_QUICKPANEL_SCENEID);
		bindType = sqlite3_column_int(stmt, DB_QUICKPANEL_BINDTYPE);
		if(bindType == 4){
			kk_scene_delete_scene_action(pSceneId,0);
		}else if(bindType == 2 || bindType == 3){
			kk_scene_delete_scene_action(pSceneId,1);
		}
		kk_scene_delete_quickpanel_info(buttonId,deviceCode);
		break;
	}
	sqlite3_finalize(stmt);
	sqlite3_free(sqlCmd);								
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 取消所有关联
*输入参数： name：场景名称
          enable: 1,使能；0，不使能
          sceneType：场景类型
          sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_deleteall_panel_scene_info(char *deviceCode)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;
	char *zErrMsg = 0;
	char *pSceneId = NULL;
	char *buttonId = NULL;
	int bindType = 0;

	const char *selectCmd = "select * from QuickPanelScene WHERE deviceCode = '%s';";

	sqlCmd = sqlite3_mprintf(selectCmd,deviceCode);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		pSceneId = (char*)sqlite3_column_text(stmt, DB_QUICKPANEL_SCENEID);
		bindType = sqlite3_column_int(stmt, DB_QUICKPANEL_BINDTYPE);
		buttonId = (char*)sqlite3_column_text(stmt, DB_QUICKPANEL_BUTTONID);
		if(bindType == 4){
			kk_scene_delete_scene_action(pSceneId,0);
		}else if(bindType == 2 || bindType == 3){
			kk_scene_delete_scene_action(pSceneId,1);
		}
		kk_scene_delete_quickpanel_info(buttonId,deviceCode);
	}
	sqlite3_finalize(stmt);
	sqlite3_free(sqlCmd);								
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 检查场景触发是否已经存在
*输入参数： deviceCode：设备deviceCode
          epNum: 设备路数
          propertyName：属性名称
          compareType：比对符号
          compareValue：value值
          sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
static int kk_scene_check_trigger_exist(const char* deviceCode,int epNum,const char* propertyName,
												const char* compareType,const char* compareValue,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt; 
	int dbepNum = 0;
	char *dbcompareValue =NULL;
	char *dbcompareType =NULL;
	char *dbsceneId =NULL;

	const char *selectCmd = "select * from SceneTriggerInfo WHERE deviceCode = '%s' and propertyName = '%s' and epNum = '%d';";
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(selectCmd,deviceCode,propertyName,epNum);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		dbepNum = sqlite3_column_int(stmt, DB_SCENETRIGGER_EPNUM);
		dbcompareType = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPARETYPE);
		dbcompareValue = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPAREVALUE);
		dbsceneId = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_SCENEID);
		if((epNum == dbepNum) && (!strcmp(dbcompareType,compareType)) && \
				(!strcmp(compareValue,dbcompareValue)) && (!strcmp(dbsceneId,sceneId))){
			res = 1;
			INFO_PRINT("kk_scene_check_trigger_exist!!!\n");
			break;
		}
		
	}
	sqlite3_finalize(stmt);
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return res;
}

/************************************************************
*功能描述： 添加场景触发信息到数据库
*输入参数： type：类型
          deviceCode：设备deviceCode
          epNum: 设备路数
          propertyName：属性名称
          compareType：比对符号
          compareValue：value值
          sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_insert_scene_trigger(const char* type,const char* deviceCode,int epNum,const char* propertyName,
												const char* compareType,const char* compareValue,const char* sceneId,int isAnd)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	/*此触发条件已经存在*/
	if(kk_scene_check_trigger_exist(deviceCode,epNum,propertyName,compareType,compareValue,sceneId)){
 		
		sqlCmd = sqlite3_mprintf("UPDATE SceneTriggerInfo SET isAnd=%d WHERE deviceCode = '%s' and propertyName = '%s' and epNum = '%d' and sceneId= '%s';",isAnd,deviceCode,propertyName,epNum,sceneId);	
		printf("sqlCmd=%s\n",sqlCmd);
		res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
		if( res != SQLITE_OK ){
			ERROR_PRINT("SQL error: %s\n", zErrMsg);
			sqlite3_free(zErrMsg);
			sqlite3_free(sqlCmd);
			_kk_scene_unlock();	
			return FAIL_RETURN;	
		}
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();
	
		return SUCCESS_RETURN; 
	}
	const char *insertCmd = "insert into SceneTriggerInfo (type, deviceCode,epNum,propertyName,compareType,compareValue,sceneId,isAnd,active) \
								values ('%s','%s','%d','%s','%s','%s','%s','%d','%d');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,type,deviceCode,epNum,propertyName,compareType,compareValue,sceneId,isAnd,1);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}
/************************************************************
*功能描述： 添加场景时间触发条件到数据库
*输入参数： type：类型
		  startTime：开始时间
		  endTime：结束时间
		  crossDay：是否跨天
		  repeat_days: 重复星期
		  sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_insert_scene_condition(const char* type,int startTime,int endTime,int crossDay,
												char repeat_days,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneConditionInfo (type, startTime,endTime,crossDay,repeat_days,sceneId) \
								values ('%s','%d','%d','%d','%d','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,type,startTime,endTime,crossDay,repeat_days,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;

}

/************************************************************
*功能描述： 添加定时场景信息到数据库
*输入参数：startTime：开始时间
		  weekflag: 重复星期
		  sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_insert_scene_timer(time_t startTime,char weekflag,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneTimerInfo (week,time,sceneId) \
								values ('%d','%d','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,weekflag,startTime,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}
/************************************************************
*功能描述： 添加嵌套场景信息到数据库
*输入参数：executeSceneId：要执行的场景Id
		  delay: 延迟时间
		  sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_insert_scene_embed(int delay,const char* executeSceneId,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneEmbedInfo (delay,executeSceneId,sceneId) \
								values ('%d','%s','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,delay,executeSceneId,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}
/************************************************************
*功能描述： 添加invokeService场景信息到数据库
*输入参数：type：场景type
		  identifier: 场景identifier
		  args：参数
		  sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_insert_scene_invokeService(const char* type,const char* identifier,const char* args,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneInvokeService (type,identifier,sceneId,args) \
								values ('%s','%s','%s','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,type,identifier,sceneId,args);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 添加场景执行动作到数据库
*输入参数：type：类型
          deviceCode：设备deviceCode
          epNum: 设备路数
          propertyName：属性名称
          delay：延迟时间
          compareValue：value值
          sceneId：场景Id
          gwdeviceCode：网关deviceCode
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_insert_scene_action(const char* type,const char* deviceCode,int epNum,const char* propertyName,
												const char* propertyValue,int delay,const char* sceneId,const char *gwdeviceCode,int act)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	printf("----->kk_scene_insert_scene_action\n");
	const char *insertCmd = "insert into SceneActionInfo (type, deviceCode,epNum,propertyName,propertyValue,delay,sceneId,gwdeviceCode,active) \
								values ('%s','%s','%d','%s','%s','%d','%s','%s','%d');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,type,deviceCode,epNum,propertyName,propertyValue,delay,sceneId,gwdeviceCode,act);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述：更新场景设备使能
*输入参数：sceneId:场景Id
           productType:类型
*输出参数：无
*返 回 值：0:成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_update_device_active(char *deviceCode,int epNum,int value)
{
	char *sqlCmd = NULL;
	int rc = 0;
	char *zErrMsg = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();

	_kk_scene_lock();
	if(epNum == -1){
		sqlCmd = sqlite3_mprintf("UPDATE SceneActionInfo SET active='%d' WHERE deviceCode = '%s'",value,deviceCode);
	}else{
		sqlCmd = sqlite3_mprintf("UPDATE SceneActionInfo SET active='%d' WHERE deviceCode = '%s' and epNum= '%d'",value,deviceCode,epNum);
	}	
	INFO_PRINT("kk_scene_update_device_active sqlCmd:%s\n",sqlCmd);
	rc = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( rc != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	}
    sqlite3_free(sqlCmd);
	if(epNum == -1){
		sqlCmd = sqlite3_mprintf("UPDATE SceneTriggerInfo SET active='%d' WHERE deviceCode = '%s'",value,deviceCode);
	}else{
		sqlCmd = sqlite3_mprintf("UPDATE SceneTriggerInfo SET active='%d' WHERE deviceCode = '%s' and epNum= '%d'",value,deviceCode,epNum);
	}	
	rc = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( rc != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	}
    sqlite3_free(sqlCmd);	
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}

/************************************************************
*功能描述： 从数据库删除情景面板的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_quickpanel_info(char *buttonId,char* deviceCode)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from QuickPanelScene where buttonId = '%s' and deviceCode = '%s';";
						
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(deleteCmd,buttonId,deviceCode);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除场景的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_scene_info(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除场景触发的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_delete_scene_trigger(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneTriggerInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除场景触发条件的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_scene_condition(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneConditionInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除场景触发的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/

int kk_scene_delete_scene_protype(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneProTypeInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除定时场景的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_scene_timing(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneTimerInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除嵌套场景的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_scene_embed(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneEmbedInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除invokeservice场景的基本数据
*输入参数： sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_scene_invokeservice(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneInvokeService where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
/************************************************************
*功能描述： 从数据库删除场景执行动作的基本数据
*输入参数： sceneId：场景Id
          isforword：1,updateScene;0,addScene;
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_delete_scene_action(const char *sceneId,int isforword)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	if(isforword){
		kk_scene_delete_send_to_gw(sceneId);
	}

	const char *deleteCmd = "delete from SceneActionInfo where sceneId = '%s';";	
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}

/************************************************************
*功能描述： 添加场景信息到数据库
*输入参数： name：场景名称
          enable: 1,使能；0，不使能
          sceneType：场景类型
          sceneId：场景Id
*输出参数： 无
*返 回 值：  0：成功；其他：失败
*其他说明：
*************************************************************/
int kk_scene_insert_sceneProType_info(const char* roomId,char *propertyName,char *propertyValue,const char* sceneId,char *productType,int delay)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneProTypeInfo (sceneId,roomId,propertyName,propertyValue,productType,delay) \
								values ('%s','%s','%s','%s','%s','%d');";
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,sceneId,roomId,propertyName,propertyValue,productType,delay);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
		ERROR_PRINT("SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		sqlite3_free(sqlCmd);
		_kk_scene_unlock();	
		return FAIL_RETURN;
	}
	
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}

