/************************************************************
*版权所有 （C）2020，公司（或个人）名称
*
*文件名称： kk_property_get_handle.c
*内容摘要： 数据get处理相关
*其他说明： 
*当前版本：  
*************************************************************/

#include <stdio.h>
#include <string.h>

#include "kk_tsl_api.h"
#include "kk_sync_data.h"
#include "kk_dm_mng.h"
#include "kk_scene_handle.h"
#include "kk_scene_db.h"
#include "sqlite3.h"
#include "kk_log.h"
#include "cJSON.h"
#include "kk_property_db.h"
#include "kk_tsl_api.h"
#include "kk_sub_db.h"
#include "kk_hal.h"
#include "kk_dm_msg.h"
#include "kk_linkkit.h"
extern void kk_sendData2gw(void* data, int len, char* chalMark);
static int kk_service_get_reply(char *deviceCode,char *productCode,char *msgId,double param1,double param2,double param3,int epNum,char *type)
{
	if(deviceCode == NULL || productCode == NULL){
		return INVALID_PARAMETER;
	}	
	cJSON *info = cJSON_CreateObject();
	cJSON_AddStringToObject(info, MSG_TYPE_STR, KK_THING_SERVICE_PROPERTY_GET_REPLY);
	cJSON_AddStringToObject(info, MSG_DEVICE_CODE_STR, deviceCode);
	cJSON_AddStringToObject(info, MSG_PRODUCT_CODE_STR, productCode);
	char *infff=cJSON_Print(info);

	cJSON *payload = cJSON_CreateObject();
	cJSON_AddStringToObject(payload, "desc", "success");
	cJSON_AddStringToObject(payload, "version", "1.0");
	cJSON_AddStringToObject(payload, "code", "0");
	cJSON_AddStringToObject(payload, "msgId", msgId);
	cJSON *paramInfo = cJSON_CreateObject();
	if(strcmp(type,"ColorTempSwitch") == 0){
		cJSON_AddNumberToObject(paramInfo, "ColorTempSwitch", (int)param1);
	}else if(strcmp(type,"FadeTime") == 0){
		cJSON_AddNumberToObject(paramInfo, "FadeTime", (int)param1);
		cJSON_AddNumberToObject(paramInfo, "LowBrightness", (int)param2);
		cJSON_AddNumberToObject(paramInfo, "HighBrightness", (int)param3);
	}else if(strcmp(type,"Power") == 0){
		cJSON_AddNumberToObject(paramInfo, "data", (double)param1);
	}else if(strcmp(type,"ChildLockState") == 0){
        cJSON_AddNumberToObject(paramInfo, "ChildLockState", (int)param1);
    }else if(strcmp(type,"PowerDownSave") == 0){
        cJSON_AddNumberToObject(paramInfo, "PowerMemory", (int)param1);
        cJSON_AddNumberToObject(paramInfo, "Mode", (int)1);
    }else if(strcmp(type,"Screensaver") == 0){
        cJSON_AddNumberToObject(paramInfo, "Screensaver", (int)param1);
    }else if(strcmp(type,"TripTime") == 0){
        cJSON_AddNumberToObject(paramInfo, "TripTime", (int)param1);
    }else if(strcmp(type,"SwapState") == 0){
        cJSON_AddNumberToObject(paramInfo, "SwapState", (int)param1);
    }else if(strcmp(type,"remoteOpenDoor") == 0){
        cJSON_AddNumberToObject(paramInfo, "RemoteOpenDoor", (int)param1);
    }
	cJSON_AddNumberToObject(paramInfo, "epNum", epNum);
	cJSON_AddItemToObject(payload, "params", paramInfo);
	char *payload11=cJSON_Print(payload);
	kk_sendData2app(infff,payload11,0);
	free(payload11);
	free(infff);
	cJSON_Delete(payload);
	cJSON_Delete(info);
	return SUCCESS_RETURN;
}
static int kk_check_muti_device(dm_mgr_dev_node_t *node)
{
    int idx = 0;
	int num = 0;	
	int mutiDev = 0;    
    kk_tsl_data_t *property = NULL;		
	char *propertiesbuf[64] = {0};
	char propertiesTmp[64] = {0};	

	for(idx = 0; idx < node->dev_shadow->property_number; idx++){
		property = (kk_tsl_data_t *)(node->dev_shadow->properties + idx);
		if(property == NULL){
			continue;
		}
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		memcpy(propertiesTmp,property->identifier,strlen(property->identifier));
		kk_split(propertiesTmp,"_",propertiesbuf,&num);
		if(num == 2){
			return 1;
		}	
		break;	
	}
    return 0;
}
static int kk_property_FadeAndRange_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int FadeTime = 0;
	int LowBrightness = 0;
    dm_mgr_dev_node_t *node = NULL;	    
	int HighBrightness = 0;
    char propertiesTmp[64] = {0};
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"FadeTime_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&FadeTime);
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"LowBrightness_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&LowBrightness);	
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"HighBrightness_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&HighBrightness);				
		
	}else{
		kk_property_db_get_value(deviceCode,"FadeTime",&FadeTime);
		kk_property_db_get_value(deviceCode,"LowBrightness",&LowBrightness);	
		kk_property_db_get_value(deviceCode,"HighBrightness",&HighBrightness);	
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,FadeTime,LowBrightness,HighBrightness,epNum,"FadeTime");
	return SUCCESS_RETURN;
}
static int kk_property_LightProperty_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int ColorTempSwitch = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"ColorTempSwitch_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&ColorTempSwitch);	
	}else{
		kk_property_db_get_value(deviceCode,"ColorTempSwitch",&ColorTempSwitch);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,ColorTempSwitch,-1,-1,epNum,"ColorTempSwitch");
	return SUCCESS_RETURN;
}
static int kk_property_AirSwitchConfig_handle(char *deviceCode,int epNum,char *msgid)
{
    int res = 0;
	int mutiDev = 0;
	int OverloadCurrent = 0;
    int ExcessiveTemperature = 0;
    int SwitchEnable = 0;
    int BreakTime = 0;
    int RatedVoltage = 0;
    int RatedCurrent = 0;
	char propertiesTmp[64] = {0};	
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
    if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"OverloadCurrent_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&OverloadCurrent);
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"ExcessiveTemperature_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&ExcessiveTemperature); 
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"SwitchEnable_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&SwitchEnable);         
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"BreakTime_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&BreakTime);       
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"RatedVoltage_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&RatedVoltage);     
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"RatedCurrent_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&RatedCurrent);                               	
	}else{
		kk_property_db_get_value(deviceCode,"OverloadCurrent",&OverloadCurrent);
		kk_property_db_get_value(deviceCode,"ExcessiveTemperature",&ExcessiveTemperature);
		kk_property_db_get_value(deviceCode,"SwitchEnable",&SwitchEnable);
		kk_property_db_get_value(deviceCode,"BreakTime",&BreakTime);
		kk_property_db_get_value(deviceCode,"RatedVoltage",&RatedVoltage);
		kk_property_db_get_value(deviceCode,"RatedCurrent",&RatedCurrent);                
	}
	cJSON *info = cJSON_CreateObject();
	cJSON_AddStringToObject(info, MSG_TYPE_STR, KK_THING_SERVICE_PROPERTY_GET_REPLY);
	cJSON_AddStringToObject(info, MSG_DEVICE_CODE_STR, deviceCode);
	cJSON_AddStringToObject(info, MSG_PRODUCT_CODE_STR, node->productCode);
	char *infff=cJSON_Print(info);

	cJSON *payload = cJSON_CreateObject();
	cJSON_AddStringToObject(payload, "desc", "success");
	cJSON_AddStringToObject(payload, "version", "1.0");
	cJSON_AddStringToObject(payload, "code", "0");
	cJSON_AddStringToObject(payload, "msgId", msgid);
	cJSON *paramInfo = cJSON_CreateObject();
    cJSON_AddNumberToObject(paramInfo, "OverloadCurrent", OverloadCurrent);
    cJSON_AddNumberToObject(paramInfo, "ExcessiveTemperature", ExcessiveTemperature);
    cJSON_AddNumberToObject(paramInfo, "SwitchEnable", SwitchEnable);
    cJSON_AddNumberToObject(paramInfo, "BreakTime", BreakTime);
    cJSON_AddNumberToObject(paramInfo, "RatedVoltage", RatedVoltage);
    cJSON_AddNumberToObject(paramInfo, "RatedCurrent", RatedCurrent);
    cJSON_AddStringToObject(paramInfo, "DevModel", "UNKNOWN");
    cJSON_AddStringToObject(paramInfo, "DevVersion", "1.0.0");
	cJSON_AddNumberToObject(paramInfo, "epNum", epNum);
	cJSON_AddItemToObject(payload, "params", paramInfo);
	char *payload11=cJSON_Print(payload);
	kk_sendData2app(infff,payload11,0);
	free(payload11);
	free(infff);
	cJSON_Delete(payload);
	cJSON_Delete(info);    
    return SUCCESS_RETURN;
}

static int kk_property_sendtogw_handle(cJSON *payload,cJSON *info_root,char *deviceCode)
{
	int res = 0;
	cJSON * rootData=cJSON_CreateObject();
	dm_mgr_dev_node_t *node = NULL;
	res = dm_mgr_get_device_by_devicecode(deviceCode,&node);
	if(res != SUCCESS_RETURN){
		cJSON_Delete(rootData);
		return res;
	}
	char *info_rootS=cJSON_Print(info_root);
	char *payloadS = cJSON_Print(payload);
	cJSON_AddItemToObject(rootData,MSG_INFO_STR, cJSON_Parse(info_rootS));
	cJSON_AddItemToObject(rootData,MSG_PAYLOAD_STR, cJSON_Parse(payloadS));
	char *pnewout=cJSON_Print(rootData);
	kk_sendData2gw(pnewout, strlen(pnewout), node->fatherDeviceCode);//send to sub device
	cJSON_Delete(rootData);
	free(info_rootS);
	free(payloadS);
	free(pnewout);   
    return res;
}
static int kk_property_SocketRealTimePower_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	double Power = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"Power_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&Power);	
	}else{
		kk_property_db_get_value(deviceCode,"Power",&Power);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,Power,-1,-1,epNum,"Power");
	return SUCCESS_RETURN;
}
static int kk_property_DeviceStatus_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int WorkMode = 0;
    int WindSpeed = 0;
    int PowerSwitch = 0;
    int StrainerAlarmTime = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"WorkMode_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&WorkMode);	
    	memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"WindSpeed_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&WindSpeed);    
    	memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"PowerSwitch_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&PowerSwitch);    
    	memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"StrainerAlarmTime_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&StrainerAlarmTime);                   
	}else{
		kk_property_db_get_value(deviceCode,"WorkMode",&WorkMode);
        kk_property_db_get_value(deviceCode,"WindSpeed",&WindSpeed);
        kk_property_db_get_value(deviceCode,"PowerSwitch",&PowerSwitch);
        kk_property_db_get_value(deviceCode,"StrainerAlarmTime",&StrainerAlarmTime);
	}
	cJSON *info = cJSON_CreateObject();
	cJSON_AddStringToObject(info, MSG_TYPE_STR, KK_THING_SERVICE_PROPERTY_GET_REPLY);
	cJSON_AddStringToObject(info, MSG_DEVICE_CODE_STR, deviceCode);
	cJSON_AddStringToObject(info, MSG_PRODUCT_CODE_STR, node->productCode);
	char *infff=cJSON_Print(info);

	cJSON *payload = cJSON_CreateObject();
	cJSON_AddStringToObject(payload, "desc", "success");
	cJSON_AddStringToObject(payload, "version", "1.0");
	cJSON_AddStringToObject(payload, "code", "0");
	cJSON_AddStringToObject(payload, "msgId", msgid);
	cJSON *paramInfo = cJSON_CreateObject();
    cJSON_AddNumberToObject(paramInfo, "WorkMode", WorkMode);
    cJSON_AddNumberToObject(paramInfo, "WindSpeed", WindSpeed);
    cJSON_AddNumberToObject(paramInfo, "PowerSwitch", PowerSwitch);
    cJSON_AddNumberToObject(paramInfo, "StrainerAlarmTime", StrainerAlarmTime);
	cJSON_AddNumberToObject(paramInfo, "epNum", epNum);
	cJSON_AddItemToObject(payload, "params", paramInfo);
	char *payload11=cJSON_Print(payload);
	kk_sendData2app(infff,payload11,0);
	free(payload11);
	free(infff);
	cJSON_Delete(payload);
	cJSON_Delete(info);
	return SUCCESS_RETURN;
}
static int kk_property_ChildLockState_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int ChildLockState = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"ChildLockState_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&ChildLockState);	
	}else{
		kk_property_db_get_value(deviceCode,"ChildLockState",&ChildLockState);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,ChildLockState,-1,-1,epNum,"ChildLockState");
	return SUCCESS_RETURN;
}
static int kk_property_WaterValveArgs_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int PowerDownSave = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"PowerMemory_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&PowerDownSave);	
	}else{
		kk_property_db_get_value(deviceCode,"PowerMemory",&PowerDownSave);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,PowerDownSave,1,-1,epNum,"PowerMemory");
	return SUCCESS_RETURN;
}
static int kk_property_Screensaver_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int Screensaver = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"Screensaver_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&Screensaver);	
	}else{
		kk_property_db_get_value(deviceCode,"Screensaver",&Screensaver);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,Screensaver,-1,-1,epNum,"Screensaver");
	return SUCCESS_RETURN;
}

static int kk_property_RunTime_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int TripTime = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"TripTime_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&TripTime);	
	}else{
		kk_property_db_get_value(deviceCode,"TripTime",&TripTime);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,TripTime,-1,-1,epNum,"TripTime");
	return SUCCESS_RETURN;
}
static int kk_property_SwapState_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int SwapState = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"SwapState_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&SwapState);	
	}else{
		kk_property_db_get_value(deviceCode,"SwapState",&SwapState);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,SwapState,-1,-1,epNum,"SwapState");
	return SUCCESS_RETURN;
}
static int kk_property_remoteOpenDoor_handle(char *deviceCode,int epNum,char *msgid)
{	
    int res = 0;
	int mutiDev = 0;
	int remoteOpenDoor = 0;
	char propertiesTmp[64] = {0};
    dm_mgr_dev_node_t *node = NULL;	
	res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
	if (res != SUCCESS_RETURN) {
		ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		return FAIL_RETURN;
	}    
    mutiDev = kk_check_muti_device(node);
	if(mutiDev){
		memset(propertiesTmp,0x0,sizeof(propertiesTmp));
		sprintf(propertiesTmp,"remoteOpenDoorSwitch_%d",epNum);
		kk_property_db_get_value(deviceCode,propertiesTmp,&remoteOpenDoor);	
	}else{
		kk_property_db_get_value(deviceCode,"remoteOpenDoorSwitch",&remoteOpenDoor);
	}
	kk_service_get_reply(deviceCode,node->productCode,msgid,remoteOpenDoor,-1,-1,epNum,"remoteOpenDoor");
	return SUCCESS_RETURN;
}
int kk_property_get_handle(cJSON * payload,char *deviceCode,cJSON * inforoot)
{
	cJSON *params = NULL;
	cJSON *propertyItem = NULL;	
	cJSON *epNum = NULL;
	cJSON *msgId = NULL;
	int epNumInt = 1;
	int res = 0;
	int idx = 0;
	int value = 0;
	int iCnt = 0;

	if(payload == NULL || deviceCode == NULL){
		return FAIL_RETURN;
	}	
	msgId = cJSON_GetObjectItem(payload, MSG_COMMON_MSGID);
	if(msgId == NULL){
		return FAIL_RETURN;
	}
	params = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);
	if(params != NULL){
		epNum = cJSON_GetObjectItem(params, "epNum");
		if(epNum != NULL){
			epNumInt = epNum->valueint;
		}else{
			epNumInt = 1;
		}		
		cJSON* propertyIdentifier = cJSON_GetObjectItem(params, "propertyIdentifier");
		if(propertyIdentifier == NULL){
			return FAIL_RETURN;
		}
		int  array_size = cJSON_GetArraySize(propertyIdentifier);
		for( iCnt = 0 ; iCnt < array_size ; iCnt ++ ){
			cJSON * pSub = cJSON_GetArrayItem(propertyIdentifier, iCnt);
			if(NULL == pSub ){ continue ; }
			if(strcmp(pSub->valuestring,"FadeAndRange") == 0){
				kk_property_FadeAndRange_handle(deviceCode,epNumInt,msgId->valuestring);
			}else if(strcmp(pSub->valuestring,"LightProperty") == 0){
				kk_property_LightProperty_handle(deviceCode,epNumInt,msgId->valuestring);
			}else if(strcmp(pSub->valuestring,"AirSwitchConfig") == 0){
                kk_property_sendtogw_handle(payload,inforoot,deviceCode);
            }else if(strcmp(pSub->valuestring,"SocketRealTimePower") == 0){
                kk_property_SocketRealTimePower_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"DeviceStatus") == 0){
                kk_property_DeviceStatus_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"ChildLockState") == 0){
                kk_property_ChildLockState_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"WaterValveArgs") == 0){
                kk_property_WaterValveArgs_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"Screensaver") == 0){
                kk_property_Screensaver_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"RunTime") == 0){
                kk_property_RunTime_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"SwapState") == 0){
                kk_property_SwapState_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"remoteOpenDoor") == 0){
                kk_property_remoteOpenDoor_handle(deviceCode,epNumInt,msgId->valuestring);
            }else if(strcmp(pSub->valuestring,"AirSwitchStatus") == 0){
               kk_property_sendtogw_handle(payload,inforoot,deviceCode);
            }
		}
	}
	return SUCCESS_RETURN;	
}