#include "cJSON.h"
#include "kk_product.h"
#include "kk_tsl_common.h"
#include "kk_tsl_api.h"
#include "kk_dm_api.h"
#include "kk_dm_msg.h"
#include "kk_dm_mng.h"
#include "kk_alarm_handle.h"
#include "kk_property_db.h"
#include "kk_history_db.h"
#include "kk_area_handle.h"

enum{
    CCU_ARMING_LEAVE_STATE = 0, //离家布防
    CCU_ARMING_NO_STATE,        //撤防
    CCU_ARMING_HOME_STATE,      //在家布防
    CCU_ARMING_AREA_STATE,      //区域布防
};
enum{
    SUB_ARMING_HOME_STATE = 0,  //在家安防
    SUB_ARMING_OUTHOME_STATE,   //室外安防
    SUB_ARMING_ALL_STATE,       //24小时警戒
    SUB_ARMING_NO_STATE,        //无警戒
};
extern int HAL_Get_ccuid(_OU_ char *device_code);
char *CommonAlarmStateDevice[] = 
{
    (char *){"SmokeSensorState"},
    (char *){"GasSensorState"},
    (char *){"WaterSensorState"},
    (char *){"SosState"},
    (char *){"AlarmState"},
};
int kk_is_CommonAlarmState(char * identifier)
{
    int cnt = 0;
    int num = sizeof(CommonAlarmStateDevice)/sizeof(char *);
    for(cnt = 0; cnt < num; cnt++){
        if(strcmp(identifier,CommonAlarmStateDevice[cnt]) == 0){
            return 1;
        }
    }
    return 0;
}
/************************************************************
*功能描述：告警消息处理
*输入参数：data：从gw 层发来的数据
          chalMark:网关通道，一般用mac
*输出参数：无
*返 回 值： 无
*其他说明：
安防等级：
0: 在家安防
1: 室外安防
2: 24小时警戒
3: 无警戒
主机安防：
0:离家布防
1:撤防
2:在家布防
3:区域布防
*************************************************************/
int kk_alarm_notify_handle(dm_mgr_dev_node_t *node,char *identifier,char *valueBuf,char *eventIdebtifier)
{
    char ccuid[32] = {0};
	int currentValue = 0;
	char armingstate[16] = {0};
	int ret = 0;
	int needSave = 0;
	if(node == NULL || identifier == NULL){
		return -1;
	}
	if(strcmp(eventIdebtifier,"LockOpenNotification") == 0||
		strcmp(eventIdebtifier,"KeyDeletedNotification") == 0||
		strcmp(eventIdebtifier,"KeyAddNotification") == 0||
		strcmp(eventIdebtifier,"BatteryAlarm") == 0){
		return -1;
	}
    HAL_Get_ccuid(ccuid);
	kk_property_db_get_value(node->deviceCode,"SensorType",&currentValue);
	//INFO_PRINT("------------------------->currentValue:%d\n",currentValue);
    //INFO_PRINT("------------------------->valueBuf:%s\n",valueBuf);
    //INFO_PRINT("------------------------->identifier:%s\n",identifier);
	kk_property_db_get_value(ccuid,KK_TSL_CCU_ARMINGSTATE_IDENTIFIER,armingstate);
	if(strcmp(node->productCode,"3064") == 0){//门锁强报警
		currentValue = SUB_ARMING_ALL_STATE;
	}
	cJSON *info = cJSON_CreateObject();
	cJSON_AddStringToObject(info, MSG_DEVICE_CODE_STR, node->deviceCode);
	cJSON_AddStringToObject(info, MSG_PRODUCT_CODE_STR, node->productCode);
	cJSON *payload = cJSON_CreateObject();
	cJSON_AddStringToObject(payload, "version", "1.0");
	char msgId[64] = {0};
	iotx_report_id(msgId);
	cJSON_AddStringToObject(payload, "msgId", msgId);	
	//char timerStr[16] = {0};
	//HAL_GetTime_s(timerStr);
	cJSON_AddNumberToObject(payload, "time", HAL_GetTime_ms());	
	cJSON *param = cJSON_CreateObject();
	if(strcmp(identifier,"Battery") == 0){
		if(atoi(valueBuf) == 1 || strcmp(valueBuf,"1.000000") == 0){
			cJSON_AddStringToObject(param, "LowBatteryState", "1");
			cJSON_AddStringToObject(info, MSG_TYPE_STR, "/thing/event/BatteryAlarm/post");
			cJSON_AddStringToObject(payload, "method", "thing.event.BatteryAlarm.post");
			cJSON_AddStringToObject(payload, "identifier", "BatteryAlarm");
		}else{
            cJSON_Delete(param);
            cJSON_Delete(payload);
            cJSON_Delete(info);	
            return 0;
        }
	}else if(strcmp(identifier,"DismantleState") == 0){
        if(atoi(valueBuf) == 1){
			if(strcmp(node->productCode,"3064") == 0){//门锁防拆特殊处理
		   	 	cJSON_AddStringToObject(param, "DismantleState", valueBuf);
				cJSON_AddStringToObject(info, MSG_TYPE_STR, "/thing/event/LockTamperAlarm/post");
				cJSON_AddStringToObject(payload, "method", "thing.event.LockTamperAlarm.post");
				cJSON_AddStringToObject(payload, "identifier", "LockTamperAlarm");				
			}else{
		   	 	cJSON_AddStringToObject(param, "DismantleState", valueBuf);
				cJSON_AddStringToObject(info, MSG_TYPE_STR, "/thing/event/alarmNotify");
				cJSON_AddStringToObject(payload, "method", "thing.event.alarmNotify");
				cJSON_AddStringToObject(payload, "identifier", "alarmNotify");
			}
        }else{
            cJSON_Delete(param);
            cJSON_Delete(payload);
            cJSON_Delete(info);	
            return 0;
        }
		//needSave = 1;
	}//else if(kk_is_CommonAlarmState(identifier) == 1){
        //cJSON_AddStringToObject(param, "CommonAlarmState", valueBuf);
   // }
    else{
		cJSON_AddStringToObject(info, MSG_TYPE_STR, "/thing/event/alarmNotify");
		cJSON_AddStringToObject(payload, "method", "thing.event.alarmNotify");
		cJSON_AddStringToObject(payload, "identifier", "alarmNotify");
        if(atoi(valueBuf) == 1){
		    cJSON_AddStringToObject(param, "CommonAlarmState", "1");
        }else{
            cJSON_Delete(param);
            cJSON_Delete(payload);
            cJSON_Delete(info);	
            return 0;
        }
		//needSave = 1;
	}
	cJSON_AddItemToObject(payload, "params", param);
	char *payload11=cJSON_Print(payload);
	char *infff=cJSON_Print(info);		
	if(currentValue == SUB_ARMING_ALL_STATE)//24小时警戒
	{
        INFO_PRINT("payload11: %s\n",payload11);
		kk_sendData2app(infff,payload11,0);
		goto end;	
	}
	else if(currentValue != SUB_ARMING_NO_STATE && atoi(armingstate) == CCU_ARMING_LEAVE_STATE) //离家布防
	{
        INFO_PRINT("payload11: %s\n",payload11);
		kk_sendData2app(infff,payload11,0);
	}
	else if((currentValue == SUB_ARMING_OUTHOME_STATE||currentValue == SUB_ARMING_ALL_STATE) && atoi(armingstate) == CCU_ARMING_HOME_STATE) //在家布防 
	{
        INFO_PRINT("payload11: %s\n",payload11);
		kk_sendData2app(infff,payload11,0);
	}
	else if(atoi(armingstate) == CCU_ARMING_AREA_STATE)
	{
		char roomId[16] = {0};
		ret = kk_get_roomId_by_deviceCode(node->deviceCode,"1",roomId,sizeof(roomId));
		INFO_PRINT("roomId: [%s] \n",roomId);
		if(ret == 1){
			int state = kk_get_room_armingstate(roomId);
			INFO_PRINT("state: [%d] \n",state);
			if(state == 1){
                if(currentValue != SUB_ARMING_NO_STATE){
                    INFO_PRINT("payload11: %s\n",payload11);
                    kk_sendData2app(infff,payload11,0);
                }
			}else{
                if(currentValue == SUB_ARMING_OUTHOME_STATE||currentValue == SUB_ARMING_ALL_STATE){
                    INFO_PRINT("payload11: %s\n",payload11);
                    kk_sendData2app(infff,payload11,0);
                }
            }
		}
	}
end:	
	needSave = 0;
	free(payload11);
	free(infff);
	cJSON_Delete(payload);
	cJSON_Delete(info);	
	return 0;
}