#ifndef __KK_AREA_H__
#define __KK_AREA_H__

#include "kk_tsl_common.h"
typedef struct kk_dev_list{
	char  deviceCode[DEVICE_CODE_MAXLEN];
	struct kk_dev_list * next;
}kk_dev_list_t;

typedef struct kk_floor_list{
	char  *floorId;
	char  *floorName;
	struct kk_floor_list * next;
}kk_floor_list_t;
enum{
	DB_ROOM_IDX = 0,
	DB_ROOM_NAME,
	DB_ROOM_ID,	
	DB_ROOM_ARMING,	
	DB_ROOM_FLOORID,	
	DB_ROOM_FLOORNAME,
	DB_ROOM_ROOMICON,
};

enum{
	DB_DEV_IDX = 0,
	DB_DEV_ROOM_ID,
	DB_DEV_ROOM_NAME,
	DB_DEV_DEVICECODE,
	DB_DEV_EPNUM,
	DB_DEV_DEV_NAME,
};
enum{
	DB_FLOOR_IDX = 0,
	DB_FLOOR_NAME,
	DB_FLOOR_ID,	
};
int kk_room_delete(const char *roomId);
int kk_room_add(const char *name,const char *roomId,const char *icon);
int kk_area_init(void);
int kk_room_dev_add(const char *roomId,const char *roomName,const char *deviceCode,const char *epNum,const char *devName);
int kk_room_dev_remove(const char *deviceCode,const char *epNum);
int kk_room_device_list_add(const char *deviceCode);
kk_dev_list_t*  kk_get_room_deviceCode(const char* roomId);
void kk_free_room_dev_list(void);
int kk_get_device_name(const char* deviceCode,const char *epNum,char *devName,int size);
int kk_room_update_armingstate(int state,const char *roomid);
int kk_get_room_armingstate(const char* roomId);
int kk_get_roomId_by_deviceCode(const char* deviceCode,const char *epNum,char *roomId,int size);
int kk_get_device_roomInfo(const char* deviceCode,int epNum,char *roomName,char *roomId);
int kk_room_reset_armingstate(void);
int kk_room_dev_remove_by_roomid(const char *roomid);
int kk_room_set_floor_info(const char*floorId,const char* floorName,const char *roomid);
int kk_floor_delete_all(void);
int kk_floor_delete_by_id(char *floorId);
int kk_set_floor_to_default(const char*floorId);
kk_floor_list_t *kk_get_floorIds_ary(void);
int kk_floor_add(const char *name,const char *floorId);
cJSON * kk_get_roomids_by_floorId(const char* floorId);
int kk_creater_floorid(char *floorId);
void kk_free_floor_list(void);
cJSON *kk_get_roomIds_ary(void);
int kk_check_dev_exist_inRoom(const char* deviceCode,const char *epNum);
int kk_check_dev_exist_roomId(const char* deviceCode,const char *epNum,char *roomId);
#endif

