#ifndef _LAN_QUEUE_H_
#define _LAN_QUEUE_H_

#include "klist.h"

typedef struct {
	void *data;
	struct list_head list;
} lan_queue_msg_s;

typedef struct {
	void *mutex;
	int max_size;
	int size;
	struct list_head list;
}lan_queue_s;

typedef enum{
	NODE_MAP = 0,
	LAN_QUEUE_END
}LAN_QUEUE_ENUM;
#define LAN_QUEUE1_SIZE				50
#define LAN_QUEUE2_SIZE				20
#define LAN_QUEUE_SIZE(x)			LAN_QUEUE##x##_SIZE

int lan_queue_init(void);
int lan_queue_dequeue(LAN_QUEUE_ENUM ix,void **data);
int lan_queue_enqueue(LAN_QUEUE_ENUM ix,void *data);

#endif
