#ifndef _LOG_DEBUG_H
#define _LOG_DEBUG_H

#include <stdio.h>
#include <time.h>
#include <libgen.h>

#define LOG_EN					1
#define LOG_LEVEL				LOG_DEBUG_LEVEL
static const int g_syslog		 = 1;



#define LOG_STRING(level)		((level == LOG_EMERG) ? "EMERG   " :            \
								(level == LOG_ALERT) ? "ALERT   " :             \
								(level == LOG_CRIT) ? "CRIT    " :              \
								(level == LOG_ERR) ? "ERR     " :               \
								(level == LOG_WARNING) ? "WARNING " :           \
								(level == LOG_NOTICE) ? "NOTICE  " :            \
								(level == LOG_INFO) ? "INFO    " :              \
								(level == LOG_DEBUG) ? "DEBUG   " : "NONE    ")




#define LOG_DEBUG_LEVEL			1 //亮白色
#define LOG_INFO_LEVEL			2 //绿色
#define LOG_NOTICE_LEVEL		3 //蓝色
#define LOG_WARNING_LEVEL		4 //黄色
#define LOG_ERROR_LEVEL			5 //蓝绿色
#define LOG_CRIT_LEVEL			6 //紫色
#define LOG_ALERT_LEVEL			7 //红色
#define LOG_EMERG_LEVEL			8 //红色(下划线)

#define SYSLOG_LEVEL_1			LOG_DEBUG
#define SYSLOG_LEVEL_2			LOG_INFO
#define SYSLOG_LEVEL_3			LOG_NOTICE
#define SYSLOG_LEVEL_4			LOG_WARNING
#define SYSLOG_LEVEL_5			LOG_ERR
#define SYSLOG_LEVEL_6			LOG_CRIT
#define SYSLOG_LEVEL_7			LOG_ALERT
#define SYSLOG_LEVEL_8			LOG_EMERG


#define LOG_LEVEL_(x)			LOG_LEVEL_##x
#define LOG_LEVEL_1				LOG_DEBUG_ACT
#define LOG_LEVEL_2				LOG_INFO_ACT
#define LOG_LEVEL_3				LOG_NOTICE_ACT
#define LOG_LEVEL_4				LOG_WARNING_ACT
#define LOG_LEVEL_5				LOG_ERR_ACT
#define LOG_LEVEL_6				LOG_CRIT_ACT
#define LOG_LEVEL_7				LOG_ALERT_ACT
#define LOG_LEVEL_8				LOG_EMERG_ACT


#define SYSLOG_LEVEL_(x)		SYSLOG_LEVEL_##x
#define SYSLOG_LEVEL_1			LOG_DEBUG
#define SYSLOG_LEVEL_2			LOG_INFO
#define SYSLOG_LEVEL_3			LOG_NOTICE
#define SYSLOG_LEVEL_4			LOG_WARNING
#define SYSLOG_LEVEL_5			LOG_ERR
#define SYSLOG_LEVEL_6			LOG_CRIT
#define SYSLOG_LEVEL_7			LOG_ALERT
#define SYSLOG_LEVEL_8			LOG_EMERG








#define LOG_DEBUG_ACT			"\033[0;1;37m"
#define LOG_INFO_ACT			"\033[0;1;32m"
#define LOG_NOTICE_ACT			"\033[0;1;34m"
#define LOG_WARNING_ACT			"\033[0;1;33m"
#define LOG_ERR_ACT				"\033[0;1;36m"
#define LOG_CRIT_ACT			"\033[0;1;35m"
#define LOG_ALERT_ACT			"\033[0;1;31m"
#define LOG_EMERG_ACT			"\033[0;1;4;31m"







#if (LOG_EN)
	#define debug_log(level,format,...)	do { \
		if( level >= LOG_LEVEL && level <= LOG_EMERG_LEVEL) { \
			char dateTime[64] = {0};\
			time_t curTime = time(NULL); \
			struct tm *ptm = localtime(&curTime);\
			snprintf(dateTime,sizeof(dateTime),"%d-%d-%d %d:%d:%d",(ptm->tm_year+1900),(ptm->tm_mon+1),ptm->tm_mday,ptm->tm_hour,ptm->tm_min,ptm->tm_sec);\
			printf("%s%s %s(%d):%s::"format"\033[m", LOG_LEVEL_(level),dateTime,(__FILE__),__LINE__,__func__,##__VA_ARGS__); \
			if (g_syslog!=0){ \
				syslog(SYSLOG_LEVEL_(level),"%s %s %s(%d):%s::"format,LOG_STRING(level),dateTime,(__FILE__),__LINE__,__func__,##__VA_ARGS__); \
			} \
		} \
	}while(0)
#else
	#define debug_log(level,format,...)
#endif



//#define VOICE_SUPPORT





#endif

