#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <time.h>
#include <errno.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pthread.h>
#include "cJSON.h"
#include "com_api.h"
#include "kk_product.h"
#include "kk_log.h"
#include "kk_hal.h"
#include "mqtt_api.h"
#if CONFIG_NX5_PLATFORM
static pthread_mutex_t s_data_mutex;
extern int kk_get_gw_status(void);
#define TO_OLED_NANOMSG_SOCKET_ADDR "ipc:///tmp/oled_pair.ipc"
static int kk_info_nanomsg_init(void)
{
	int socketfd = 0;
	socketfd = nn_socket(AF_SP, NN_PAIR);
	if(socketfd < 0){
		return -1;
	}
	if(nn_connect(socketfd, TO_OLED_NANOMSG_SOCKET_ADDR) < 0){
		WARNING_PRINT("[%s][%d]connect fail!!!\n",__FUNCTION__,__LINE__);
		return -1;
	}
	return socketfd;
}
int kk_GetVersion(_OU_ char *version);
static int kk_info_get(char *str)
{
	int ret = 0;
	char version[VERSION_MAXLEN] = {0};
	char *str_tmp = NULL;
	char ccuid[32] = {0};
	char pid[32] = {0};
	char key[128] = {0};

	if(str == NULL){
		return -1;
	}
	//HAL_GetVersion(version);

	KK_Get_ccuid(ccuid);
	kk_cloud_get_pid(pid);
	kk_cloud_get_key(key);
	kk_GetVersion(version);
	cJSON *root = cJSON_CreateObject();
	if (root)
	{
		cJSON *args = cJSON_CreateObject();
		if (args)
		{
			cJSON_AddItemToObject(root, "args", args);

			cJSON *ccu = cJSON_CreateObject();
			if (ccu)
			{
				char status[4] = {0};

                cJSON_AddItemToObject(args, "ccu", ccu);
                cJSON_AddStringToObject(ccu, "id", &ccuid[4]);
                cJSON_AddStringToObject(ccu, "version", version);
                cJSON_AddStringToObject(ccu, "name", "kk_new_ccu");
                //INFO_PRINT("---222kk_get_cloud_status():%d\n",kk_get_cloud_status());
                if(kk_get_cloud_status() == DEVICE_OFFLINE){
                    //cJSON_AddStringToObject(ccu, "status", "1");
                    //INFO_PRINT("_-----------------------------------------------------------11\n");
                    memcpy(status,"1",strlen("1"));
                }else if(kk_get_gw_status() == DEVICE_OFFLINE){
					memcpy(status,"2",strlen("2"));
				}else{
                    //INFO_PRINT("_-----------------------------------------------------------22\n");
                    memcpy(status,"0",strlen("0"));
                }
                INFO_PRINT("kk_info_get------------------------------------->status :%s\n",status);

				cJSON_AddStringToObject(ccu, "status", status);
			}
			cJSON *net = cJSON_CreateObject();
			if (net)
			{
				char s_IP[NETWORK_ADDR_LEN] = {0};
				HAL_Get_IP(s_IP,NULL);
				cJSON_AddItemToObject(args, "net", net);
				cJSON_AddStringToObject(net, "interface", "eth0");
				cJSON_AddStringToObject(net, "ip", s_IP);
			}
			cJSON *lsc_status = cJSON_CreateObject();
			if (lsc_status)
			{
				cJSON_AddStringToObject(args, "lsc_status", "1");
			}

			cJSON *qr_code = cJSON_CreateObject();
			if (qr_code)
			{
				char qrcodeStr[256] = {0};
				sprintf(qrcodeStr,"KONKE-CCU:%s:%s:%s",pid,&ccuid[4],key);
				cJSON_AddItemToObject(args, "qr_code", qr_code);
				cJSON_AddStringToObject(qr_code, "string", qrcodeStr);
				cJSON_AddBoolToObject(qr_code, "show", 1);
			}
			cJSON *service = cJSON_CreateObject();
			if (service)
			{
				cJSON_AddStringToObject(args, "service", "1");
			}
		}
		str_tmp = cJSON_PrintUnformatted(root);
		//INFO_PRINT("JSON %s\r\n", str_tmp);
		strcpy(str, str_tmp);
		free(str_tmp);
		cJSON_Delete(root);
	}
	else
	{
		ret = -1;
	}
	return ret;
}

//static int
void *kk_info_nanomsg_send(void *data)
{
	int ret = 0;
	char str[1024] = {0};
	int socketfd = kk_info_nanomsg_init();
	if(socketfd < 0){
		return NULL;
	}
	while(1){
		memset(str,0x0,sizeof(str));
		ret = kk_info_get(str);
		if(ret == 0){
			//printf("*********nn_send***********\n");
			ret = nn_send(socketfd, str, strlen(str), 1);
			if(ret < 0)	{
				//WARNING_PRINT("[%s][%d]nn_send fail!!!\n",__FUNCTION__,__LINE__);
			}
		}
		sleep(10);
	}
}
int kk_info_report_start(void)
{
	int rc;
	pthread_t info_report_thread;
	pthread_attr_t info_report_attr;
	pthread_mutex_init(&s_data_mutex, NULL);
	/*创建线程*/
	pthread_attr_init(&info_report_attr);
	size_t s = 1500;
	pthread_attr_setstacksize(&info_report_attr, s);
	pthread_attr_setdetachstate(&info_report_attr, PTHREAD_CREATE_JOINABLE);
	rc = pthread_create(&info_report_thread, &info_report_attr, kk_info_nanomsg_send, (void *)NULL);   //收数据
	if (rc)
	{
		WARNING_PRINT("Error : unable to create thread udp_recv \r\n");
		return -1;
	}
	pthread_attr_destroy(&info_report_attr);
	return 0;
}
#endif