#ifndef __YJQ_EZSP_H_
#define __YJQ_EZSP_H_

#include "app/framework/include/af.h"


// determines the number of in-clusters and out-clusters based on defines
// in config.h
#include "app/framework/util/af-main.h"



#ifdef GATEWAY_APP
  #define COMMAND_INTERPRETER_SUPPORT
  #include "app/util/gateway/gateway.h"
#endif

#include "app/util/common/library.h"


#include "afv2-bookkeeping.h"



#include "app/framework/include/af.h"
#include "app/framework/util/af-main.h"
#include "app/framework/util/util.h"
#include "app/util/serial/command-interpreter2.h"
#include "app/util/zigbee-framework/zigbee-device-common.h"
#include "network-cli.h"



#define emberAfAppPrint(...) emberAfPrint(EMBER_AF_PRINT_APP, __VA_ARGS__)

#define kk_print(...)				do{\
	emberAfAppPrint("%s:",__TIME__);\
	emberAfAppPrintln(__VA_ARGS__);\
}while(0)
#define kk_print_debug(...)			UTIL_LOG_DBG(__VA_ARGS__)
#define kk_print_info(...)			UTIL_LOG_INFO(__VA_ARGS__)
#define kk_print_warnning(...)		UTIL_LOG_WARNING(__VA_ARGS__)
#define kk_print_error(...)			UTIL_LOG_ERR(__VA_ARGS__)



typedef struct {
	uint8_t ncpEzspProtocolVer;
	uint8_t hostEzspProtocolVer;
	uint8_t stackType;
	uint16_t stackVersion;
	EmberVersion* emberVer;
}kk_EZSP_version_s;

extern kk_EZSP_version_s kk_EZSP_ver;

extern void kk_print_version(void);

extern void kk_set_ezsp_version_info(uint8_t hostEzspProtocolVer,
										uint8_t ncpEzspProtocolVer,
										uint8_t stackType,
										uint16_t stackVersion,
										EmberVersion *emberVer);


extern void kk_read_ncp_configuration_without_memory_allocation(void);
extern void kk_read_ncp_configuration_with_memory_allocation(void);



extern void kk_message_process(char *messageString);
/////////////////////////////////////////////////////////////////////////////////////////////////////
//api
extern void setTxPower(signed char dBm);
//color control
extern void ColorCtrEmovehueCMD( unsigned short node,
											unsigned char ep,
											unsigned char mode,
											unsigned short rate );




//
extern void rpcInterfaceParse(void);


#endif
