#include "kk_test.h"
#include "kk_sub_tsl.h"
#include "kk_tsl_zigbee_map.h"

extern kk_tsl_zigbee_map_t g_tsl_zigbee_map [];


static void kk_rpc_send_message(cJSON *data,char *msgtype,char *method,EmberEUI64 mac)
{
	static uint16_t msgid;
	char msgIdString[10]= {0};
	char macString[19] = {0};
	sub_dev_node_t *node = NULL;
	int res = 0;
	
	rpc_eui64ToString(mac,macString);	
	res = kk_sub_tsl_get_device_by_mac(macString, &node);
	if (res != SUCCESS_RETURN) {
		printf("[%s][%d]kk_rpc_send_message error!!!\n",__FUNCTION__,__LINE__);
		return; 
	}	

	cJSON *info = rpc_cJSON_CreateObject();
	if(info != NULL){
		rpc_cJSON_AddStringToObject(info, "msgType",msgtype);
		rpc_cJSON_AddStringToObject(info, "productCode",node->productCode);
		rpc_cJSON_AddStringToObject(info, "deviceCode",macString);	
	}
	cJSON *payload = rpc_cJSON_CreateObject();
	if(payload != NULL){
		sprintf(msgIdString,"%d",++msgid);
		rpc_cJSON_AddStringToObject(payload, "msgId",msgIdString);
		rpc_cJSON_AddStringToObject(payload, "version", KK_IPC_VERSION);
		rpc_cJSON_AddStringToObject(payload, "method",method);
		rpc_cJSON_AddItemToObject(payload, "params", data);		
	}
	cJSON *root = rpc_cJSON_CreateObject();
	if(root != NULL){
		rpc_cJSON_AddItemToObject(root, "info", info);	
		rpc_cJSON_AddItemToObject(root, "payload", payload);	
	}

	char* p = rpc_cJSON_Print(root);
	emberAfAppPrintln("send json:\n%s\n",p);
	free(p);
	jrpc_send_msg(root);	
	rpc_cJSON_Delete(root);	
}
void kk_rpc_report_devices(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_DEVICE_JOINED_TYPE,KK_REPORT_DEVICE_JOINED_METHOD,mac);
}
void kk_rpc_report_left_devices(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_DEVICE_LEFT_TYPE,KK_REPORT_DEVICE_LEAVE_METHOD,mac);
}

void kk_rpc_report_status(cJSON *data,EmberEUI64 mac)
{

	kk_rpc_send_message(data,KK_REPORT_ATTRIBUTE_TYPE,KK_REPORT_ATTRIBUTE_METHOD,mac);
}

typedef struct{
	EmberEUI64 mac;
	uint8_t AppVersion;
	uint8_t deviceType;
	uint8_t deviceCode;
	uint8_t productType;
	uint8_t productCode;
}kk_report_device_s;

void kk_rpc_reportLeftDevices(EmberEUI64 mac)
{
	cJSON* devicesJson;
	char macString[RPC_EUI64_STRING_LENGTH];
	sub_dev_node_t *node = NULL;
	int res = 0;
	EmberEUI64 gw_eui64  = {0};
	
	rpc_eui64ToString(mac,macString);	
	res = kk_sub_tsl_get_device_by_mac(macString, &node);
	if (res != SUCCESS_RETURN) {
		printf("[%s][%d]kk_rpc_send_message error!!!\n",__FUNCTION__,__LINE__);
		return; 
	}
	devicesJson = rpc_cJSON_CreateObject();
	rpc_cJSON_AddStringToObject(devicesJson, "productCode",node->productCode);
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode",macString);
	emberAfGetEui64(gw_eui64);
	kk_rpc_report_left_devices(devicesJson,gw_eui64);
	kk_sub_tsl_delete(mac);
	kk_device_table_delete(mac);

	
}



void kk_rpc_reportDevices(EmberEUI64 mac,const char* productCode)
{
	cJSON* devicesJson;
	char macString[19] = {0};
	EmberEUI64 eui64  = {0};

	UTIL_LOG_WARNING("report tsl product code:%s\n",productCode);
	emberAfPrintBigEndianEui64(mac);
	emberAfDebugPrintln("");

	devicesJson = rpc_cJSON_CreateObject();
	rpc_eui64ToString(mac,macString);
	rpc_cJSON_AddStringToObject(devicesJson, "productCode",productCode);
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode",macString);
	rpc_cJSON_AddStringToObject(devicesJson, "mac",macString);
	//
	kk_sub_tsl_add(mac,productCode);
	emberAfGetEui64(eui64);
	kk_rpc_report_devices(devicesJson,eui64);
}



int kk_zcl_onoff_set(jrpc_context * ctx,const char *mac,unsigned char ep,void* data)
{
	uint8_t eui64[EUI64_SIZE];
    uint8_t OnOffStatus	= 0;
	EmberStatus status = 0;
	EmberNodeId node = 0xffff;

	OnOffStatus = *(uint8_t*)data;
	bool macMatch= rpc_get_mac(mac,eui64);
	emberAfCorePrintBuffer(eui64,EUI64_SIZE,true);
	for(int i=0;i<EUI64_SIZE;i++){
		emberAfCorePrintln("i=%d,val=%02x",i,eui64[i]);
	}


	if(macMatch){
		node = emberAfDeviceTableGetNodeIdFromEui64(eui64);
		if(node==0xffff){
			emberAfCorePrintln("\r\n not find device by node!\r\n" );
			if(ctx)
				set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
		emberAfCorePrintln("\r\nnode=0x%02X,ep=%d,OnOffStatus=%d\r\n",node,ep,OnOffStatus);

		if(OnOffStatus==1){
			status = zclOnOff_On(node,ep);
			emberAfCorePrintln("\r\nzclOnOff_On,status=0x%x\r\n",status);
		}else if(OnOffStatus==0){
			status = zclOnOff_Off(node,ep);
			emberAfCorePrintln("\r\nzclOnOff_Off,status=0x%x\r\n",status);
		}else{
			if(ctx)
				set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
	}else{
		emberAfCorePrintln("\r\n not find device by mac!\r\n" );
		if(ctx)
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}	
	return status;
error_return:
	return -1;
}
//EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep);
//EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep);
//EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep);

































void emberAfMainTickCallback(void)
{

	static int last_time;
	int time = halCommonGetInt32uMillisecondTick();

	if((time-last_time)>=1000){
		last_time = time;
		kk_productCode_tick();
		//printf("kk_productCode_tick!\n");

	}
}




