#ifndef __KK_ZIGBEE_API_H
#define __KK_ZIGBEE_API_H
#include "kk_test.h"


typedef int (*kk_rpc_set)(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data);
typedef int(*kk_rpc_report)(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data);

typedef struct{
	const char * name;
	kk_rpc_set set;
}kk_rpc_set_api_s;

typedef struct{
	const char * name;
	kk_rpc_report report;
}kk_rpc_report_api_s;

void kk_rpc_test(void);

#define KK_RPC_SET_FUNCTION_TABLE	{\
	{"zclOnOff_On",zclOnOff_On},\
	{"zclOnOff_Off",zclOnOff_Off}\
}

#define KK_RPC_REPORT_FUNCTION_TABLE	{\
	{"kk_tsl_report_global_onoff",kk_tsl_report_global_onoff},\
	{"kk_tsl_report_global_onoff",kk_tsl_report_global_onoff}\
}

kk_rpc_set_api_s kk_rpc_set_api[];
kk_rpc_report_api_s kk_rpc_report_api[];


uint8_t kk_get_rpc_set_api_size(void );
uint8_t kk_get_rpc_report_api_size(void );



EmberStatus kk_network_leave(void);
EmberStatus kk_network_form(bool centralized,EmberPanId panId,int8_t radioTxPower,uint8_t channel);
void kk_print_network_info(void);

EmberStatus kk_zdo_leave_request(EmberNodeId target,bool removeChildren,bool rejoin);

EmberStatus zclGRead(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				bool svr);
EmberStatus zclGWrite(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				uint8_t dataType,
				uint8_t dataLen,
				uint8_t *data,
				bool svr);



EmberStatus zclOnOff_On(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Off(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Toggle(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OffWithEffect(uint16_t node,uint8_t ep,uint8_t id,uint8_t var);
EmberStatus zclOnOff_OnWithRecallGlobalScene(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OnWithTimedOff(uint16_t node,uint8_t ep,uint8_t Control,uint16_t OnTime,uint16_t OffWaitTime);

EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep);
EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep);
EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep);
EmberStatus WindowCover_GotoLiftPercentage(uint16_t node,uint8_t ep,uint8_t position);

EmberStatus zclColorControlMovetohue(uint16_t node,
										uint8_t ep,
										uint8_t hue,
										uint8_t dir,
										uint16_t trsTime,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlMovehue(uint16_t node,
										uint8_t ep,
										uint8_t mode,
										uint8_t rate,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlStephue(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlMovetosat(uint16_t node,
												uint8_t ep,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlMovesat(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint8_t rate,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepsat(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);

EmberStatus zclColorControlMovetohueandsat(uint16_t node,
														uint8_t ep,
														uint8_t hue,
														uint8_t saturation,
														uint16_t trsTime,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlMovetocolor(uint16_t node,
													uint8_t ep,
													uint16_t colorX,
													uint16_t colorY,
													uint16_t trsTime,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolor(uint16_t node,
												uint8_t ep,
												uint16_t rateX,
												uint16_t rateY,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepcolor(uint16_t node,
												uint8_t ep,
												uint16_t stepX,
												uint16_t stepY,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlMovetocolortemp(uint16_t node,
															uint8_t ep,
															uint16_t colorTemp,
															uint16_t trsTime,
															bool options,
															uint8_t mask,
															uint8_t Override);

EmberStatus zclColorControlEmovetohue(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t dir,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlEmovehue( uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint16_t rate,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlEstephue(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint16_t size,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlEmovetohueandsat(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlLoopSet(uint16_t node,
											uint8_t ep,
											uint8_t flags,
											uint8_t action,
											uint8_t dir,
											uint16_t time,
											uint16_t sHue,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlStopmovestep(uint16_t node,
													uint8_t ep,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t rate,
														uint16_t Tmin,
														uint16_t Tmax,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlStepcolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t size,
														uint16_t trsTime,
														uint16_t minimum,
														uint16_t maximum,
														bool options,
														uint8_t mask,
														uint8_t Override);







EmberStatus zclGroupsAddGroup(uint16_t node,
									uint8_t ep,
									uint16_t id,
									char *name);

EmberStatus zclGroupsViewGroup(uint16_t node,
									uint8_t ep,
									uint16_t id);

EmberStatus zclGroupsGetGroupMembership(uint16_t node,
									uint8_t ep,
									uint16_t count,
									uint16_t *list);

EmberStatus zclGroupsRemoveGroup(uint16_t node,
									uint8_t ep,
									uint16_t id);

EmberStatus zclGroupsRemoveAllGroups(uint16_t node,
									uint8_t ep);

EmberStatus zclGroupsAddGroupIfIdentifying(uint16_t node,
									uint8_t ep,
									uint16_t id,
									char *name);

EmberStatus zclScenesAddScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id,
									uint16_t trs_time,
									char *name,
									uint8_t extLen,
									uint8_t* extData);

EmberStatus zclScenesViewScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id);

EmberStatus zclScenesRemoveScene(uint16_t node,
								uint8_t ep,
								uint16_t g_id,
								uint16_t s_id);

EmberStatus zclScenesRemoveAllScene(uint16_t node,
								uint8_t ep,
								uint16_t g_id);

EmberStatus zclScenesStoreScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id);

EmberStatus zclScenesRecallScene(uint16_t node,
										uint8_t ep,
										uint16_t g_id,
										uint16_t s_id,
										uint16_t trsTime);

EmberStatus zclScenesGetSceneMembership(uint16_t node,
										uint8_t ep,
										uint16_t g_id);


EmberStatus zclScenesEnhancedAddScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id,
									uint16_t trs_time,
									char *name,
									uint8_t extLen,
									uint8_t* extData);



EmberStatus zclScenesEnhancedViewScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id);

EmberStatus zclScenesCopyScene(uint16_t node,
									uint8_t ep,
									uint8_t mode,
									uint16_t gidFrom,
									uint16_t sidFrom,
									uint16_t gidTo,
									uint16_t sidTo);






EmberStatus zclLevel_MoveToLevel(uint16_t node,
										uint8_t ep,
										uint8_t level,
										uint16_t trsTime,
										uint8_t *mask,
										uint8_t *override);
EmberStatus zclLevel_Move(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t rate,
								uint8_t *mask,
								uint8_t *override);

EmberStatus zclLevel_Step(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t size,
								uint16_t trsTime,
								uint8_t *mask,
								uint8_t *override);
EmberStatus zclLevel_Stop(uint16_t node,
								uint8_t ep,
								uint8_t *mask,
								uint8_t *override);


EmberStatus zclLevel_MoveToLevelWithOnOff(uint16_t node,
										uint8_t ep,
										uint8_t level,
										uint16_t trsTime,
										uint8_t *mask,
										uint8_t *override);
										
EmberStatus zclLevel_MoveWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t rate,
								uint8_t *mask,
								uint8_t *override);

EmberStatus zclLevel_StepWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t size,
								uint16_t trsTime,
								uint8_t *mask,
								uint8_t *override);

EmberStatus zclLevel_StopWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t *mask,
								uint8_t *override);



EmberStatus zclWD_StartWarning(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint16_t duration,
								uint8_t cycle,
								uint8_t level);

EmberStatus zclWD_Squawk(uint16_t node,
								uint8_t ep,
								uint8_t mode);



EmberStatus zclThermostat_Setpoint_Raise_Lower(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t amount);

EmberStatus zclThermostat_GetWeeklySchedule(uint16_t node,
								uint8_t ep,
								uint8_t days,
								uint8_t mode);

EmberStatus zclThermostat_ClearWeeklySchedule(uint16_t node,
								uint8_t ep);

EmberStatus zclThermostat_GetRelayStatusLog(uint16_t node,
														uint8_t ep);


#endif
