#include <stdio.h>
#include "kk_tsl_api.h"
#include "sqlite3.h"
#include "kk_log.h"
#include "kk_scene_handle.h"

extern sqlite3 *g_kk_pDb;
int kk_scene_db_init(void)
{
    kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
    char *pcErr;

    //eUtils_LockLock(&sLock);
    _kk_scene_lock();
    ctx->pDb = g_kk_pDb;
   
    INFO_PRINT("scene db Database opened\n");
    
	const char *pSceneTable = "CREATE TABLE IF NOT EXISTS SceneInfo( \
		name varchar(255), \
		sceneType INTEGER, \
		enable INTEGER, \
		sceneId varchar(255) UNIQUE)";

    if (sqlite3_exec(ctx->pDb, pSceneTable, NULL, NULL, &pcErr) != SQLITE_OK)
    {
        ERROR_PRINT("Error creating table (%s)\n", pcErr);
        sqlite3_free(pcErr);
        //eUtils_LockUnlock(&sLock);
        _kk_scene_unlock();
        return FAIL_RETURN;
    }

	const char *pSceneTriggerTable = "CREATE TABLE IF NOT EXISTS SceneTriggerInfo( \
		type varchar(255), \
		deviceCode varchar(255), \
		epNum INTEGER, \
		propertyName varchar(255), \
		compareType varchar(255), \
		compareValue varchar(255), \
		sceneId varchar(255))";


    if (sqlite3_exec(ctx->pDb, pSceneTriggerTable, NULL, NULL, &pcErr) != SQLITE_OK)
    {
        ERROR_PRINT("Error creating table (%s)\n", pcErr);
        sqlite3_free(pcErr);
        //eUtils_LockUnlock(&sLock);
        _kk_scene_unlock();
        return FAIL_RETURN;
    }

	const char *pSceneConditionTable = "CREATE TABLE IF NOT EXISTS SceneConditionInfo( \
		type varchar(255), \
		startTime INTEGER, \
		endTime INTEGER, \
		crossDay INTEGER, \
		repeat_days INTEGER, \
		sceneId varchar(255))";


    if (sqlite3_exec(ctx->pDb, pSceneConditionTable, NULL, NULL, &pcErr) != SQLITE_OK)
    {
        ERROR_PRINT("Error creating table (%s)\n", pcErr);
        sqlite3_free(pcErr);
        //eUtils_LockUnlock(&sLock);
        _kk_scene_unlock();
        return FAIL_RETURN;
    }	

	const char *pSceneActionTable = "CREATE TABLE IF NOT EXISTS SceneActionInfo( \
		type varchar(255), \
		deviceCode varchar(255), \
		epNum INTEGER, \
		propertyName varchar(255), \
		propertyValue varchar(255), \
		delay INTEGER, \
		sceneId varchar(255),\
		gwdeviceCode varchar(255))";


    if (sqlite3_exec(ctx->pDb, pSceneActionTable, NULL, NULL, &pcErr) != SQLITE_OK)
    {
        ERROR_PRINT("Error creating table (%s)\n", pcErr);
        sqlite3_free(pcErr);
        //eUtils_LockUnlock(&sLock);
        _kk_scene_unlock();
        return FAIL_RETURN;
    }	

	const char *pSceneTimerTable = "CREATE TABLE IF NOT EXISTS SceneTimerInfo( \
		week INTEGER, \
		time INTEGER, \
		sceneId varchar(255))";

    if (sqlite3_exec(ctx->pDb, pSceneTimerTable, NULL, NULL, &pcErr) != SQLITE_OK)
    {
        ERROR_PRINT("Error creating table (%s)\n", pcErr);
        sqlite3_free(pcErr);
        //eUtils_LockUnlock(&sLock);
        _kk_scene_unlock();
        return FAIL_RETURN;
    }
	/*内嵌场景关联表*/
	const char *pSceneEmbedTable = "CREATE TABLE IF NOT EXISTS SceneEmbedInfo( \
		delay INTEGER, \
		executeSceneId varchar(255), \
		sceneId varchar(255))";

    if (sqlite3_exec(ctx->pDb, pSceneTimerTable, NULL, NULL, &pcErr) != SQLITE_OK)
    {
        ERROR_PRINT("Error creating table (%s)\n", pcErr);
        sqlite3_free(pcErr);
        //eUtils_LockUnlock(&sLock);
        _kk_scene_unlock();
        return FAIL_RETURN;
    }	

    _kk_scene_unlock();
    return SUCCESS_RETURN;
}

int kk_scene_update_scene_enable(int enable,const char *sceneId)
{
	char *sqlCmd = NULL;
	int len =0;
	int rc = 0;
	char *zErrMsg = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();

	//_kk_subDb_lock();
	sqlCmd = sqlite3_mprintf("UPDATE SceneInfo SET enable=%d  WHERE sceneId= '%s'",enable,sceneId);	
	INFO_PRINT("kk_scene_update_scene_enable,sqlCmd:%s\n",sqlCmd);
	rc = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( rc != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	}else{
	   //INFO_PRINT("Table updata data successfully\n");
	}
    sqlite3_free(sqlCmd);
	//_kk_subDb_unlock();
	return SUCCESS_RETURN;
}

int kk_scene_insert_scene_info(const char* name,const char* sceneType,const char* enable,const char* sceneId)
{
	int res = 0;
    kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneInfo (name, sceneType,enable,sceneId) \
								values ('%s','%d','%d','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,name,sceneType,enable,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;
	}
	
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;

}
#if 0
static int kk_scene_check_trigger_exist(const char* type,const char* deviceCode,const char* epNum,const char* propertyName,
												const char* compareType,const char* compareValue,const char* sceneId)
{
	int res = 0;
    kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt; 

	const char *selectCmd = "select * from SceneTriggerInfo WHERE deviceCode = '%s' and propertyName = '%s';";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(selectCmd,,deviceCode,propertyName);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
	    *sceneType = sqlite3_column_int(stmt, DB_SCENEINFO_SCENETYPE);
		*enable = sqlite3_column_int(stmt, DB_SCENEINFO_ENABLE);
		res =  SUCCESS_RETURN;
	}
	sqlite3_finalize(stmt);

	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}
#endif
int kk_scene_insert_scene_trigger(const char* type,const char* deviceCode,const char* epNum,const char* propertyName,
												const char* compareType,const char* compareValue,const char* sceneId)
{
	int res = 0;
    kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneTriggerInfo (type, deviceCode,epNum,propertyName,compareType,compareValue,sceneId) \
								values ('%s','%s','%d','%s','%s','%s','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,type,deviceCode,epNum,propertyName,compareType,compareValue,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}

int kk_scene_insert_scene_condition(const char* type,int startTime,int endTime,int crossDay,
												char repeat_days,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneConditionInfo (type, startTime,endTime,crossDay,repeat_days,sceneId) \
								values ('%s','%d','%d','%d','%d','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,type,startTime,endTime,crossDay,repeat_days,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}


int kk_scene_insert_scene_timer(time_t startTime,char weekflag,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneTimerInfo (week,time,sceneId) \
								values ('%d','%d','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,weekflag,startTime,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}

int kk_scene_insert_scene_embed(int delay,const char* executeSceneId,const char* sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneEmbedInfo (delay,executeSceneId,sceneId) \
								values ('%d','%s','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,delay,executeSceneId,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}

int kk_scene_insert_scene_action(const char* type,const char* deviceCode,int epNum,const char* propertyName,
												const char* propertyValue,int delay,const char* sceneId,const char *gwdeviceCode)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;

	const char *insertCmd = "insert into SceneActionInfo (type, deviceCode,epNum,propertyName,propertyValue,delay,sceneId,gwdeviceCode) \
								values ('%s','%s','%d','%s','%s','%d','%s','%s');";	
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(insertCmd,type,deviceCode,epNum,propertyName,propertyValue,delay,sceneId,gwdeviceCode);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;	
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return SUCCESS_RETURN;

}
int kk_scene_delete_scene_info(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
int kk_scene_delete_scene_trigger(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneTriggerInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}
int kk_scene_delete_scene_condition(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneConditionInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}

int kk_scene_delete_scene_timing(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneTimerInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}

int kk_scene_delete_scene_embed(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	const char *deleteCmd = "delete from SceneEmbedInfo where sceneId = '%s';";
						
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}


int kk_scene_delete_scene_action(const char *sceneId)
{
	int res = 0;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	char *zErrMsg = 0;
	sqlite3_stmt *stmt; 

	kk_scene_delete_send_to_gw(sceneId);

	const char *deleteCmd = "delete from SceneActionInfo where sceneId = '%s';";	
	_kk_scene_lock();
	 sqlCmd = sqlite3_mprintf(deleteCmd,sceneId);	
	res = sqlite3_exec(ctx->pDb, sqlCmd, NULL, NULL, &zErrMsg);
	if( res != SQLITE_OK ){
	   ERROR_PRINT("SQL error: %s\n", zErrMsg);
	   sqlite3_free(zErrMsg);
	   sqlite3_free(sqlCmd);
	   _kk_scene_unlock();	
	   return FAIL_RETURN;		
	}
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	return SUCCESS_RETURN;
}



