#include "kk_msg_report.h"


static void kk_msg_report(cJSON *data,char *msgtype,char *method,EmberEUI64 mac)
{
	static uint16_t msgid;
	char msgIdString[10]= {0};
	char macString[19] = {0};
	int res = 0;
	kk_device_table_s *dev =NULL;
	rpc_eui64ToString(mac,macString);	
	dev = kk_device_find_by_mac(mac);
	if (dev == NULL) {
		printf("[%s][%d]kk_msg_report error!!!\n",__FUNCTION__,__LINE__);
		return; 
	}	

	cJSON *info = rpc_cJSON_CreateObject();
	if(info != NULL){
		rpc_cJSON_AddStringToObject(info, "msgType",msgtype);
		rpc_cJSON_AddStringToObject(info, "productCode",dev->productCode);
		rpc_cJSON_AddStringToObject(info, "deviceCode",macString);	
	}
	cJSON *payload = rpc_cJSON_CreateObject();
	if(payload != NULL){
		sprintf(msgIdString,"%d",++msgid);
		rpc_cJSON_AddStringToObject(payload, "msgId",msgIdString);
		rpc_cJSON_AddStringToObject(payload, "version", KK_IPC_VERSION);
		rpc_cJSON_AddStringToObject(payload, "method",method);
		rpc_cJSON_AddItemToObject(payload, "params", data);		
	}
	cJSON *root = rpc_cJSON_CreateObject();
	if(root != NULL){
		rpc_cJSON_AddItemToObject(root, "info", info);	
		rpc_cJSON_AddItemToObject(root, "payload", payload);	
	}

	char* p = rpc_cJSON_Print(root);
	emberAfAppPrintln("send json:\n%s\n",p);
	free(p);
	jrpc_send_msg(root);	
	rpc_cJSON_Delete(root);	
}

void kk_msg_report_batch_joined(cJSON *data,EmberEUI64 mac)
{
	kk_msg_report(data,KK_REPORT_DEVICE_BATCH_JOINED_TYPE,KK_REPORT_DEVICE_BATCH_JOINED_METHOD,mac);
}
void kk_msg_report_batch_leave(cJSON *data,EmberEUI64 mac)
{
	kk_msg_report(data,KK_REPORT_DEVICE_BATCH_LEFT_TYPE,KK_REPORT_DEVICE_BATCH_LEAVE_METHOD,mac);
}


static void kk_msg_report_joined(cJSON *data,EmberEUI64 mac)
{
	kk_msg_report(data,KK_REPORT_DEVICE_JOINED_TYPE,KK_REPORT_DEVICE_JOINED_METHOD,mac);
}
static void kk_msg_report_leave(cJSON *data,EmberEUI64 mac)
{
	kk_msg_report(data,KK_REPORT_DEVICE_LEFT_TYPE,KK_REPORT_DEVICE_LEAVE_METHOD,mac);
}
void kk_msg_report_property(cJSON *data,EmberEUI64 mac)
{
	kk_msg_report(data,KK_REPORT_ATTRIBUTE_TYPE,KK_REPORT_ATTRIBUTE_METHOD,mac);
}

void kk_msg_report_dev_joined(EmberEUI64 mac,const char* productCode)
{
	cJSON* devicesJson;
	EmberEUI64 localEui64  = {0};
	char macString[KK_EUI64_STRING_LENGTH] = {0};

	UTIL_LOG_WARNING("report tsl product code:%s\n",productCode);
	emberAfDebugPrint("mac:");
	emberAfPrintBigEndianEui64(mac);
	emberAfDebugPrintln("");

	devicesJson = rpc_cJSON_CreateObject();
	rpc_eui64ToString(mac,macString);
	rpc_cJSON_AddStringToObject(devicesJson, "productCode",productCode);
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode",macString);
	rpc_cJSON_AddStringToObject(devicesJson, "mac",macString);

	emberAfGetEui64(localEui64);
	kk_msg_report_joined(devicesJson,localEui64);
}

void kk_msg_report_dev_leave(EmberEUI64 mac)
{
	int res = 0;
	cJSON* devicesJson;
	EmberEUI64 localEui64  = {0};
	char macString[KK_EUI64_STRING_LENGTH];
	kk_device_table_s *dev =NULL;
	rpc_eui64ToString(mac,macString);	
	dev = kk_device_find_by_mac(mac);
	if (dev == NULL) {
		emberAfDebugPrintln("[%s][%d]kk_msg_report_dev_leave error!!!\n",__FUNCTION__,__LINE__);
		return; 
	}
	devicesJson = rpc_cJSON_CreateObject();
	rpc_cJSON_AddStringToObject(devicesJson, "productCode",dev->productCode);
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode",macString);
	emberAfGetEui64(localEui64);
	kk_msg_report_leave(devicesJson,localEui64);
	kk_device_table_delete(mac);
	kk_device_db_delete(mac);
}


int kk_sendData2CCU(char* data, int len)
{
	if (strcmp(GW2CCU_PROTOCOL,"tcp") == 0 ){
		kk_tcp_client_send(data, len);
	}else{
		kk_ipc_send(IPC_PLAT2MID, data, len + 1);
	}
}

