#ifndef __KK_DEVICE_TABLE_DB_H
#define __KK_DEVICE_TABLE_DB_H

#include "kk_ncp_common.h"
#include "kk_device_manager.h"
#include "../device-table/device-table.h"

typedef struct kk_device_table_s{
	EmberEUI64 mac;
	EmberNodeId nodeId;
	uint16_t deviceId;
	uint16_t identifyCnt;
	char productCode[33];
	SubDevManage_s manage;
	struct kk_device_table_s *next;
}kk_device_table_s;


#define KK_MAX_PRODUCT_CODE_SIZE		33



#define KK_DEVICE_DB_TABLE		"kk_device"
#define KK_DEVICE_DB_FILE		"/usr/kk/kk_device.db"



void kk_device_db_init(void);

void kk_device_db_insert(EmberEUI64 mac,EmberNodeId nodeId,uint16_t deviceId,char* productCode);

void kk_device_db_delete(EmberEUI64 mac);
void kk_device_db_update(EmberEUI64 mac,EmberNodeId nodeId,uint16_t deviceId,char* productCode);
bool kk_device_db_check(EmberEUI64 mac);
int kk_device_db_get_num();



kk_device_table_s *kk_get_device_table_pointer(void);

void kk_print_device_table(void);

char * kk_device_find_productCode(EmberEUI64 mac);
kk_device_table_s * kk_device_find_by_mac(EmberEUI64 mac);
void kk_device_table_add(EmberEUI64 mac,EmberNodeId nodeId,const char *productCode,uint16_t deviceId);

void kk_device_table_delete(EmberEUI64 mac);

void kk_add_device_to_table(EmberEUI64 mac,EmberNodeId nodeId,uint16_t deviceId);
















#endif


