/************************************************************
*版权所有 （C）2020，公司（或个人）名称
*
*文件名称： kk_sync_data.c
*内容摘要： 数据同步处理相关
*其他说明： 
*当前版本：  
*************************************************************/

#include <stdio.h>
#include <string.h>

#include "kk_tsl_api.h"
#include "kk_sync_data.h"
#include "kk_dm_mng.h"
#include "kk_scene_handle.h"
#include "kk_scene_db.h"
#include "sqlite3.h"
#include "kk_log.h"
#include "cJSON.h"
#include "kk_property_db.h"
#include "kk_tsl_api.h"
#include "kk_area_handle.h"
#include "kk_sub_db.h"
#include "kk_hal.h"
extern sqlite3 *g_kk_pDb;

static int kk_check_multi_ep_num(char *deviceCode);
static int kk_get_scenes_actions_info(cJSON *actionArray,int id);

static int kk_get_panel_scenes_actions_info(cJSON *actionArray,int id);

typedef struct {
	void *mutex;
	sqlite3 *pDb;	
} kk_sync_ctx_t;

static kk_sync_ctx_t s_kk_sync_ctx = {NULL,NULL};
static kk_sync_ctx_t *_kk_sync_get_ctx(void)
{
	return &s_kk_sync_ctx;
}
static void _kk_sync_lock(void)
{
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	if (ctx->mutex) {
		HAL_MutexLock(ctx->mutex);
	}
}

static void _kk_sync_unlock(void)
{
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	if (ctx->mutex) {
		HAL_MutexUnlock(ctx->mutex);
	}
}

/************************************************************
*功能描述：同步数据模块初始化
*输入参数：无
*输出参数：无
*返 回 值：0:成功；其他：失败
*其他说明：
*************************************************************/
int kk_sync_init(void)
{
	//int res = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	/* Create Mutex */
	ctx->mutex = HAL_MutexCreate();
	if (ctx->mutex == NULL) {
		return FAIL_RETURN;
	}
	ctx->pDb = g_kk_pDb;
	return SUCCESS_RETURN;
}


static cJSON * kk_get_room_devices(const char *roomId)
{
	dm_mgr_dev_node_t *node = NULL;
	const char *selectCmd = "select * from AreaDevInfo WHERE roomId = '%s';";
	int res = 0;
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;
	char *deviceCode = NULL;
	char *epNum = NULL;
	cJSON *devs = cJSON_CreateArray();
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();

	sqlCmd = sqlite3_mprintf(selectCmd,roomId);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *dev = cJSON_CreateObject();
		char devName[64] = {0};
		deviceCode = (char*)sqlite3_column_text(stmt, DB_DEV_DEVICECODE);

		epNum = (char*)sqlite3_column_text(stmt, DB_DEV_EPNUM);
		res = dm_mgr_get_device_by_devicecode((char*)deviceCode,&node);
		if (res != SUCCESS_RETURN) {
			ERROR_PRINT("ERROR [%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
			return NULL;
		}
		if(kk_check_multi_ep_num(deviceCode)){
			cJSON_AddStringToObject(dev,KK_SYNC_SCENE_EPNUM_STR,epNum);
		}else if(strcmp(node->productType,KK_DM_AIR_GATEWAY_TYPE) == 0){
			if(atoi(epNum) == 1){//epNum为1的是空调网关
				continue;
			}else{
				cJSON_AddStringToObject(dev,KK_SYNC_SCENE_EPNUM_STR,epNum);
			}
		}
		cJSON_AddStringToObject(dev,KK_SYNC_DEVICECODE_STR,deviceCode);
		//cJSON_AddStringToObject(dev,KK_SYNC_SCENE_EPNUM_STR,epNum);
		kk_get_device_name(deviceCode,epNum,devName,sizeof(devName));
		cJSON_AddStringToObject(dev,"name",devName);

		cJSON_AddItemToArray(devs, dev);
	}
	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt);

	return devs;
}


static cJSON * kk_get_room_sences(const char *roomId)
{
	const char *selectCmd = "select * from SceneInfo where roomId = '%s';";

	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;
	char *sceneId = NULL;
	char *sceneType = NULL;
	cJSON *scenes = cJSON_CreateArray();
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();

	sqlCmd = sqlite3_mprintf(selectCmd,roomId); 
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *scene = cJSON_CreateObject();
		sceneId = (char*)sqlite3_column_text(stmt, DB_SCENEINFO_SCENEID);
		sceneType = (char*)sqlite3_column_text(stmt, DB_SCENEINFO_SCENETYPE);
		cJSON_AddStringToObject(scene,KK_SYNC_SCENEID_STR,sceneId);
		cJSON_AddStringToObject(scene,KK_SYNC_SCENE_SCENETYPE_STR,sceneType);
		cJSON_AddItemToArray(scenes, scene);
	}
	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt);

	return scenes;
}



static int kk_get_rooms_info(cJSON *data)
{
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;
	char *roomId = NULL;
	char *roomName = NULL;
	//int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	if(data == NULL){
		return FAIL_RETURN;
	}
	cJSON *rooms = cJSON_CreateArray();
	cJSON *roomItem = NULL;
	cJSON *roomDevicesArray = NULL;
	cJSON *scenesArray = NULL;

	_kk_sync_lock();
	sqlCmd = sqlite3_mprintf("select * from AreaInfo");
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		roomItem = cJSON_CreateObject();
		roomId = (char*)sqlite3_column_text(stmt, DB_ROOM_ID);
		roomName = (char*)sqlite3_column_text(stmt, DB_ROOM_NAME);
		cJSON_AddStringToObject(roomItem, KK_SYNC_ROOMID_STR, roomId);
		cJSON_AddStringToObject(roomItem, KK_SYNC_NANE_STR, roomName);
		
		roomDevicesArray = kk_get_room_devices(roomId);
		cJSON_AddItemToObject(roomItem, KK_SYNC_DEVICES_STR, roomDevicesArray);

		scenesArray = kk_get_room_sences(roomId);
		cJSON_AddItemToObject(roomItem, KK_SYNC_SCENE_STR, scenesArray);

		cJSON_AddItemToArray(rooms, roomItem);	
	}
	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt);
	_kk_sync_unlock();

	cJSON_AddItemToObject(data, KK_SYNC_ROOMS_STR, rooms);
	
	return SUCCESS_RETURN;
}

static int kk_check_multi_ep_num(char *deviceCode)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt; 
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	
	if(deviceCode == NULL){
		return 0;
	}

	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE deviceCode = '%s' and devType=%d;",deviceCode,KK_DM_DEVICE_SUBDEV);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		char *propertiesbuf[64] = {0};
		int num = 0;
		split(propertyStr,"_",propertiesbuf,&num);
		if(num>=2){
			return 1;
		}
	}
	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt); 
	return 0;
}

static cJSON *kk_get_gw_properties_info(cJSON *data)
{
	char *sqlCmd = NULL;

	sqlite3_stmt *stmt; 
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();		


	cJSON *roomIdsAry = NULL;
	cJSON *property = cJSON_CreateObject();
	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE devType = '%d' ",KK_DM_DEVICE_GATEWAY);
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	

	while(sqlite3_step(stmt) == SQLITE_ROW){
		propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		valueType = sqlite3_column_int(stmt, DB_VALUETYPE);
		valueStr = (char*)sqlite3_column_text(stmt, DB_VALUE);
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		if(valueType == KK_TSL_DATA_TYPE_TEXT){
			cJSON_AddStringToObject(property, propertyStr, valueStr);
		}else if(valueType == KK_TSL_DATA_TYPE_INT||
			valueType == KK_TSL_DATA_TYPE_ENUM||
			valueType == KK_TSL_DATA_TYPE_BOOL){
			cJSON_AddNumberToObject(property, propertyStr, atoi(valueStr));
		}else if(valueType == KK_TSL_DATA_TYPE_DOUBLE){
			cJSON_AddNumberToObject(property, propertyStr, atof(valueStr));
		}
	}
	cJSON_AddItemToObject(data, KK_SYNC_PROPERTY_STR, property);
	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt); 
	return property;
}

static cJSON *kk_get_ccu_properties_info(cJSON *data)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt; 
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();		


	cJSON *roomIdsAry = NULL;
	cJSON *property = cJSON_CreateObject();
	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE devType = '%d' ",KK_DM_DEVICE_CCU);
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	

	while(sqlite3_step(stmt) == SQLITE_ROW){
		propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		valueType = sqlite3_column_int(stmt, DB_VALUETYPE);
		valueStr = (char*)sqlite3_column_text(stmt, DB_VALUE);
		if(valueType == KK_TSL_DATA_TYPE_TEXT){
			if(!strcmp(propertyStr,"ArmingState")){
				cJSON_AddNumberToObject(property, propertyStr, atoi(valueStr));
			}else{
				cJSON_AddStringToObject(property, propertyStr, valueStr);
			}
		}else if(valueType == KK_TSL_DATA_TYPE_INT||
			valueType == KK_TSL_DATA_TYPE_ENUM||
			valueType == KK_TSL_DATA_TYPE_BOOL){
			cJSON_AddNumberToObject(property, propertyStr, atoi(valueStr));
		}else if(valueType == KK_TSL_DATA_TYPE_DOUBLE){
			cJSON_AddNumberToObject(property, propertyStr, atof(valueStr));
		}
	}

	if((roomIdsAry = kk_get_roomIds_ary())!=NULL){
		cJSON_AddItemToObject(property, "RoomIds", roomIdsAry);
	}
	cJSON_AddItemToObject(data, KK_SYNC_PROPERTY_STR, property);
	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt); 
	return property;
}




static cJSON *kk_get_properties_info(char *deviceCode,int devType)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	char *ptr = NULL;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();		
	if(deviceCode == NULL){
		return NULL;
	}

	cJSON *obj = cJSON_CreateObject();
	cJSON *eps = cJSON_CreateArray();
	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE deviceCode = '%s' and devType=%d;",deviceCode,devType);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	

	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *propertyItem = cJSON_CreateObject();
        propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		valueType = sqlite3_column_int(stmt, DB_VALUETYPE);
		valueStr = (char*)sqlite3_column_text(stmt, DB_VALUE);
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);

		
		char *propertiesbuf[64] = {0};
		int num = 0;
		split(propertyStr,"_",propertiesbuf,&num);
		if(num==2){
			cJSON_AddStringToObject(propertyItem, "epNum",propertiesbuf[1]);
			if(valueType == KK_TSL_DATA_TYPE_TEXT){
				cJSON_AddStringToObject(propertyItem, propertiesbuf[0], valueStr);
			}else if(valueType == KK_TSL_DATA_TYPE_INT||
	            valueType == KK_TSL_DATA_TYPE_ENUM||
	            valueType == KK_TSL_DATA_TYPE_BOOL){
				cJSON_AddNumberToObject(propertyItem, propertiesbuf[0], atoi(valueStr));
			}else if(valueType == KK_TSL_DATA_TYPE_DOUBLE){
				cJSON_AddNumberToObject(propertyItem, propertiesbuf[0], atof(valueStr));
			}
		}else{
			cJSON_AddStringToObject(propertyItem, "epNum","1");
			if(valueType == KK_TSL_DATA_TYPE_TEXT){
				cJSON_AddStringToObject(propertyItem, propertyStr, valueStr);
			}else if(valueType == KK_TSL_DATA_TYPE_INT||
	            valueType == KK_TSL_DATA_TYPE_ENUM||
	            valueType == KK_TSL_DATA_TYPE_BOOL){
				cJSON_AddNumberToObject(propertyItem, propertyStr, atoi(valueStr));
			}else if(valueType == KK_TSL_DATA_TYPE_DOUBLE){
				cJSON_AddNumberToObject(propertyItem, propertyStr, atof(valueStr));
			}
		}
		cJSON_AddItemToArray(eps,propertyItem);
	}
	cJSON_AddItemToObject(obj, "eps", eps);
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return obj;
}
static cJSON *kk_get_indoor_properties_info(char *deviceCode)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	int eplist[65] = {0};
	int count  = 0,i = 0;
	char *ptr = NULL;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();		
	if(deviceCode == NULL){
		return NULL;
	}

	cJSON *obj = cJSON_CreateObject();
	cJSON *eps = cJSON_CreateArray();
	count = kk_indoorAir_query_epnums(deviceCode,eplist);
	for(i = 0; i < count; i++){
		sqlCmd = sqlite3_mprintf("select * from indoorAirProperties WHERE deviceCode = '%s' and epNum=%d;",deviceCode,eplist[i]);	
		sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
		cJSON *propertyItem = cJSON_CreateObject();
		cJSON_AddNumberToObject(propertyItem, "epNum",eplist[i]);
		while(sqlite3_step(stmt) == SQLITE_ROW){
			propertyStr = (char*)sqlite3_column_text(stmt, DB_INDOORAIR_IDENTIFITER);
			valueType = sqlite3_column_int(stmt, DB_INDOORAIR_VALUETYPE);
			valueStr = (char*)sqlite3_column_text(stmt, DB_INDOORAIR_VALUE);
			if(valueType == KK_TSL_DATA_TYPE_TEXT){
				cJSON_AddStringToObject(propertyItem, propertyStr, valueStr);
			}else if(valueType == KK_TSL_DATA_TYPE_INT||
				valueType == KK_TSL_DATA_TYPE_ENUM||
				valueType == KK_TSL_DATA_TYPE_BOOL){
				cJSON_AddNumberToObject(propertyItem, propertyStr, atoi(valueStr));
			}else if(valueType == KK_TSL_DATA_TYPE_DOUBLE){
				cJSON_AddNumberToObject(propertyItem, propertyStr, atof(valueStr));
			}
		}
		cJSON_AddItemToArray(eps,propertyItem);
	}
	cJSON_AddItemToObject(obj, "eps", eps);
	cJSON_AddNumberToObject(obj, "EpTotal", count);
	cJSON_AddNumberToObject(obj, "CombineDeviceFlag", 1);
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return obj;
}
static int kk_get_properties_info_obj(char *deviceCode)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();	
	cJSON *obj = cJSON_CreateObject();
	if(deviceCode == NULL ){
		return NULL;
	}

	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE deviceCode = '%s' and devType=%d;",deviceCode,KK_DM_DEVICE_SUBDEV);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	

	while(sqlite3_step(stmt) == SQLITE_ROW){

        propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		valueType = sqlite3_column_int(stmt, DB_VALUETYPE);
		valueStr = (char*)sqlite3_column_text(stmt, DB_VALUE);
		if(valueType == KK_TSL_DATA_TYPE_TEXT){
			cJSON_AddStringToObject(obj, propertyStr, valueStr);
		}else if(valueType == KK_TSL_DATA_TYPE_INT||
            valueType == KK_TSL_DATA_TYPE_ENUM||
            valueType == KK_TSL_DATA_TYPE_BOOL){
			cJSON_AddNumberToObject(obj, propertyStr, atoi(valueStr));
		}else if(valueType == KK_TSL_DATA_TYPE_DOUBLE){
			cJSON_AddNumberToObject(obj, propertyStr, atof(valueStr));
		}
	}
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return obj;
}



static int kk_get_panelConfig_info(cJSON *decvies,char *deviceCode)
{
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();

	

	char *sceneId = NULL;
	char *buttonId = NULL;
	int bindType = 0;
	int mFlag = 0;
	
	if(decvies==NULL||deviceCode==NULL) {
		return FAIL_RETURN;
	}

	cJSON *panelConfig = NULL;

	sqlCmd = sqlite3_mprintf("select * from QuickPanelScene WHERE deviceCode = '%s' ",deviceCode);
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		if(mFlag == 0){
			mFlag = 1;
			panelConfig = cJSON_CreateArray();
		}
		
		cJSON *item = cJSON_CreateObject();
		cJSON *action= cJSON_CreateObject();

		sceneId = (char*)sqlite3_column_text(stmt, DB_QUICKPANEL_SCENEID);
		buttonId = (char*)sqlite3_column_text(stmt, DB_QUICKPANEL_BUTTONID);
		bindType = (int)sqlite3_column_int(stmt,DB_QUICKPANEL_BINDTYPE);

		kk_get_panel_scenes_actions_info(action,atoi(sceneId));
		
		cJSON_AddItemToObject(item, "action", action); 
		cJSON_AddNumberToObject(item, "bindType", bindType);
		cJSON_AddStringToObject(item, "buttonId", buttonId);
		cJSON_AddItemToArray(panelConfig, item);
	}	
	
	if(mFlag == 1){
		cJSON_AddItemToObject(decvies, "panelConfig",panelConfig );
	}
	

	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt); 
		
	
	return SUCCESS_RETURN;
}



static int kk_get_sub_devices_info(cJSON *gwdevicesItem,char *deviceCode)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	char *subDeviceCode = NULL;	
	char *subProductCode = NULL;
	char *subproductType = NULL;
	char *subVersion = NULL;
	char *subIsline = NULL;	
	if(gwdevicesItem == NULL || deviceCode == NULL){
		return FAIL_RETURN;
	}
	cJSON *subDevices = cJSON_CreateArray();
	#if 1

	sqlCmd = sqlite3_mprintf("select * from SubDeviceInfo WHERE fatherDeviceCode = '%s' ",deviceCode);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *subdevicesItem = cJSON_CreateObject();
		cJSON *properties = NULL;
		
        subDeviceCode = (char*)sqlite3_column_text(stmt, DB_SUB_DEVICECODE);
        subProductCode = (char*)sqlite3_column_text(stmt, DB_SUB_PRODUCTCODE);	
		subVersion = (char*)sqlite3_column_text(stmt, DB_SUB_VERSION);
        subIsline = (char*)sqlite3_column_text(stmt, DB_SUB_ONLINE);
		subproductType	= (char*)sqlite3_column_text(stmt, DB_SUB_PRODUCTTYPE);		
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_DEVICECODE_STR, subDeviceCode);	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_VERSION_STR, subVersion);
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_MAC_STR, subDeviceCode);

		cJSON_AddNumberToObject(subdevicesItem, KK_SYNC_ONLINE_STR, (strcmp(subIsline,"0")==0)?1:0);	

		kk_get_panelConfig_info(subdevicesItem,subDeviceCode);
			 
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_PRODUCTCODE_STR, subProductCode);	
		cJSON_AddStringToObject(subdevicesItem, KK_SYNC_SN_STR, "");	
		cJSON_AddNumberToObject(subdevicesItem, KK_SYNC_STATUS_STR, 1);

		if(kk_check_multi_ep_num(subDeviceCode)){
			properties=kk_get_properties_info(subDeviceCode,KK_DM_DEVICE_SUBDEV);
		}else if(strcmp(subproductType,KK_DM_AIR_GATEWAY_TYPE) == 0){
			properties=kk_get_indoor_properties_info(subDeviceCode);
		}
		else{
			properties=kk_get_properties_info_obj(subDeviceCode);
		}

		cJSON_AddItemToObject(subdevicesItem, "properties", properties);
		cJSON_AddItemToArray(subDevices, subdevicesItem);			
	}	
	#endif

	cJSON_AddItemToObject(gwdevicesItem, KK_SYNC_DEVICES_STR, subDevices);
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	

	return SUCCESS_RETURN;
}
static int kk_get_gw_devices_info(cJSON *gwdevices)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	//cJSON *gwdevicesItem = NULL;
	char *gw_deviceCode = NULL;
	char *gw_productCode = NULL;
	char *gw_version = NULL;	
	char *gw_isline = NULL;		
	//char *valueStr = NULL;
	//int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();	
	if(gwdevices == NULL){
		return FAIL_RETURN;
	}

	_kk_sync_lock();
	sqlCmd = sqlite3_mprintf("select * from SubDeviceInfo WHERE devType = '%d' ",KK_DM_DEVICE_GATEWAY);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *gwdevicesItem = cJSON_CreateObject();
        gw_deviceCode = (char*)sqlite3_column_text(stmt, DB_SUB_DEVICECODE);
        gw_productCode = (char*)sqlite3_column_text(stmt, DB_SUB_PRODUCTCODE);	
		gw_version = (char*)sqlite3_column_text(stmt, DB_SUB_VERSION);
        gw_isline = (char*)sqlite3_column_text(stmt, DB_SUB_ONLINE);	
		printf("gw_deviceCode:%s\n",gw_deviceCode);		
		printf("gw_productCode:%s\n",gw_productCode);		
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_DEVICECODE_STR, gw_deviceCode);	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_VERSION_STR, gw_version);
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_MAC_STR, gw_deviceCode);	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_NANE_STR, "GW");	
		cJSON_AddNumberToObject(gwdevicesItem, KK_SYNC_ONLINE_STR, (strcmp(gw_isline,"0")==0)?1:0);
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_PRODUCTCODE_STR, gw_productCode);	
		cJSON_AddStringToObject(gwdevicesItem, KK_SYNC_SN_STR, "");	
		cJSON_AddNumberToObject(gwdevicesItem, KK_SYNC_STATUS_STR, 1);
		kk_get_gw_properties_info(gwdevicesItem);
		kk_get_sub_devices_info(gwdevicesItem,gw_deviceCode);
		cJSON_AddItemToArray(gwdevices, gwdevicesItem);			
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	_kk_sync_unlock();
	return SUCCESS_RETURN;
}
static int kk_get_devices_info(cJSON *data)
{
	if(data == NULL){
		return FAIL_RETURN;
	}
	cJSON *gwdevices = cJSON_CreateArray();	
	kk_get_gw_devices_info(gwdevices);
	cJSON_AddItemToObject(data, KK_SYNC_DEVICES_STR, gwdevices);	
	return SUCCESS_RETURN;		
}

int kk_get_room_name_by_scene_id(int scene_id,char *room_name)
{
	int res = -1;
	kk_scene_ctx_t *ctx = _kk_scene_get_ctx();
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt; 
	int dbepNum = 0;
	char *roomNameStr =NULL;

	const char *selectCmd = "select * from SceneInfo WHERE sceneId = '%d';";
								
	_kk_scene_lock();
	sqlCmd = sqlite3_mprintf(selectCmd,scene_id);
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		roomNameStr = (char*)sqlite3_column_text(stmt, DB_SCENEINFO_ROOMID);
		memcpy(room_name,roomNameStr,strlen(roomNameStr));
		res = 0;
		break;
	}
	sqlite3_finalize(stmt);
	sqlite3_free(sqlCmd);
	_kk_scene_unlock();
	
	return res;
}



static int kk_get_panel_scenes_actions_info(cJSON *actionItem,int id)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;
	char *deviceCode = NULL;
	char *propertyName = NULL;
	char *propertyValue = NULL;	
	char roomIdStr[32] = {0};

	char *type = NULL;
	int delay = 0,epNum = 0,scene_id=0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();			
	if(actionItem == NULL){
		return FAIL_RETURN;
	}
	sqlCmd = sqlite3_mprintf("select * from SceneActionInfo");	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){

		scene_id = sqlite3_column_int(stmt, DB_SCENEACTION_SCENEID);

		if(id!=scene_id){
			continue ;
		}
        deviceCode = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_DEVICECODE);
        delay = sqlite3_column_int(stmt, DB_SCENEACTION_DELAY);	
		epNum = sqlite3_column_int(stmt, DB_SCENEACTION_EPNUM);
        propertyName = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_PROPERTYNAME);
	    propertyValue = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_PROPERTYVALUE);	
		type = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_TYPE);			
			

		kk_get_roomId_by_deviceCode(deviceCode,"1",roomIdStr,sizeof(roomIdStr));


		cJSON_AddStringToObject(actionItem, KK_SYNC_DEVICECODE_STR, deviceCode);	
		cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_DELAY_STR, delay);
		cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_EPNUM_STR, epNum);

		char *propertiesbuf[64] = {0};
		int num = 0;
		split(propertyName,"_",propertiesbuf,&num);
		if(num==2){
			cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYNAME_STR, propertiesbuf[0]);	
		}else{
			cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYNAME_STR, propertyName);	
		}
			
		
		cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_TYPE_STR, type);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYVALUE_STR, propertyValue);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_ROOMID_STR, roomIdStr);	
		break;
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;	
}



static int kk_get_scenes_actions_info(cJSON *actionArray,int id)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;
	char *deviceCode = NULL;
	char *propertyName = NULL;
	char *propertyValue = NULL;	
	char room_name[64] = {0};

	char *type = NULL;
	int delay = 0,epNum = 0,scene_id=0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();			
	if(actionArray == NULL){
		return FAIL_RETURN;
	}
	sqlCmd = sqlite3_mprintf("select * from SceneActionInfo");	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *actionItem;

		scene_id = sqlite3_column_int(stmt, DB_SCENEACTION_SCENEID);

		if(id!=scene_id){
			continue ;
		}
        deviceCode = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_DEVICECODE);
        delay = sqlite3_column_int(stmt, DB_SCENEACTION_DELAY);
		epNum = sqlite3_column_int(stmt, DB_SCENEACTION_EPNUM);
        propertyName = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_PROPERTYNAME);
	    propertyValue = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_PROPERTYVALUE);	
		type = (char*)sqlite3_column_text(stmt, DB_SCENEACTION_TYPE);			
			
		kk_get_room_name_by_scene_id(scene_id,room_name);
		

		actionItem = cJSON_CreateObject();

		cJSON_AddStringToObject(actionItem, KK_SYNC_DEVICECODE_STR, deviceCode);	
		cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_DELAY_STR, delay);
		

		char *propertiesbuf[64] = {0};
		int num = 0;
		split(propertyName,"_",propertiesbuf,&num);
		if(num==2){
			cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYNAME_STR, propertiesbuf[0]);	
			cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_EPNUM_STR, atoi(propertiesbuf[1]));
		}else{
			cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYNAME_STR, propertyName);	
			cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_EPNUM_STR, epNum);
		}
		//cJSON_AddNumberToObject(actionItem, KK_SYNC_SCENE_EPNUM_STR, epNum);
		
		cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_TYPE_STR, type);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_SCENE_PROPERTYVALUE_STR, propertyValue);	
		cJSON_AddStringToObject(actionItem, KK_SYNC_ROOMID_STR, room_name);	
		cJSON_AddItemToArray(actionArray, actionItem);			
	}	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;	
}



static int kk_build_repeatday_string(int repeatday,char *repeatStr,int size)
{
	int i = 0;

	int pos = 0;
	char tmp[16] = {0};

	memset(repeatStr,0,size);

	for(;i<7;i++){
		if(repeatday&(1<<i)){
			memset(tmp,0,sizeof(tmp));
			snprintf(tmp,sizeof(tmp),"%d",i+1);
			strcat(repeatStr,tmp);
			strcat(repeatStr,",");
		}
	}
	
	pos = strlen(repeatStr);
	if(pos>0){
		repeatStr[pos-1] = '\0';
	}
}

int kk_is_trigger_timing(char *sceneId)
{
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;

	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();

	sqlCmd = sqlite3_mprintf("select * from SceneTimerInfo where sceneId = %s",sceneId);
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		return 1;
	}
	return 0;
}

static int kk_creat_starttime_build(time_t current)
{
	struct tm *c = gmtime(&current); 

	return (c->tm_hour*3600 +c->tm_min*60 + c->tm_sec);
}


static int kk_get_scenes_trigger_info(cJSON *triggerObj,char *sceneId)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;
	char *deviceCode = NULL;
	char *propertyName = NULL;
	char *compareType = NULL;	
	char *compareValue = NULL;		
	cJSON *triggerAry;
	char *type = NULL;
	int epNum = 0;

	int week;
	int time;
	
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	if(triggerObj == NULL || sceneId == NULL){
		return FAIL_RETURN;
	}

	triggerAry = cJSON_CreateArray();

	sqlCmd = sqlite3_mprintf("select * from SceneTimerInfo where sceneId = %s",sceneId);
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *conditionItem = cJSON_CreateObject();
		char weekStr[32] = {0};

		week = sqlite3_column_int(stmt, DB_SCENETIMER_WEEK);
		time = sqlite3_column_int(stmt, DB_SCENETIMER_TIME);

		kk_build_repeatday_string(week,weekStr,sizeof(weekStr));
		cJSON_AddStringToObject(conditionItem, "type", "trigger/timing");
		cJSON_AddStringToObject(conditionItem, "week", weekStr);
		//cJSON_AddNumberToObject(conditionItem, "time", time);
		int startTime = kk_creat_starttime_build(time);
		char TimeStr[32] = {0};
		memset(TimeStr,0,sizeof(TimeStr));
		snprintf(TimeStr,sizeof(TimeStr),"%d",startTime);
		cJSON_AddStringToObject(conditionItem, "time", TimeStr);

		cJSON_AddItemToArray(triggerAry, conditionItem);
	}

	sqlCmd = sqlite3_mprintf("select * from SceneTriggerInfo where sceneId = %s",sceneId);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *triggerItem = cJSON_CreateObject();
		deviceCode = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_DEVICECODE);
		epNum = sqlite3_column_int(stmt, DB_SCENETRIGGER_EPNUM);
		propertyName = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_PROPERTYNAME);
		compareType = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPARETYPE);
		compareValue = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPAREVALUE);	
		type = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_TYPE);
		cJSON_AddStringToObject(triggerItem, "type", type);
		cJSON_AddStringToObject(triggerItem, KK_SYNC_DEVICECODE_STR, (char*)deviceCode);	
		cJSON_AddNumberToObject(triggerItem, KK_SYNC_SCENE_EPNUM_STR, epNum);	
		cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_PROPERTYNAME_STR, (char*)propertyName);	
		cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_COMPARETYPE_STR, (char*)compareType);	
		cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_COMPAREValue_STR, (char*)compareValue);		
		cJSON_AddItemToArray(triggerAry, triggerItem);			
	}
	

	cJSON_AddItemToObject(triggerObj, "items",triggerAry);

	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);	
	return SUCCESS_RETURN;	
}

static cJSON *kk_build_repeatday_array(int repeatday)
{
	int i = 0;
	cJSON *repeatAry = cJSON_CreateArray();
	for(;i<7;i++){
		if(repeatday&(1<<i)){
			cJSON_AddItemToArray(repeatAry, cJSON_CreateNumber(i+1));
		}
	}
	return repeatAry;
}

static int kk_get_scenes_condition_info(cJSON *conditionObj,char *sceneId)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;
	char *type;
	int starttime = 0;
	int endtime = 0;	
	int crossDay = 0;		
	int repeat = 0;


	
	cJSON *conditionAry;

	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	if(conditionObj == NULL || sceneId == NULL){
		return FAIL_RETURN;
	}
	conditionAry = cJSON_CreateArray();
	sqlCmd = sqlite3_mprintf("select * from SceneConditionInfo where sceneId = %s",sceneId);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *conditionItem = cJSON_CreateObject();
		cJSON *repeatAry = NULL;
		type = (char*)sqlite3_column_text(stmt, DB_SCENECONDITION_TYPE);

		starttime = sqlite3_column_int(stmt, DB_SCENECONDITION_STARTTIME);
		endtime = sqlite3_column_int(stmt, DB_SCENECONDITION_ENDTIME);
		crossDay = sqlite3_column_int(stmt, DB_SCENECONDITION_CROSSDAY);
		repeat = sqlite3_column_int(stmt, DB_SCENECONDITION_REPEATDAY);

		repeatAry = kk_build_repeatday_array(repeat);
		cJSON_AddStringToObject(conditionItem, KK_SYNC_SCENE_TYPE_STR, type); 
		cJSON_AddNumberToObject(conditionItem, KK_SYNC_SCENE_STARTTIME_STR, starttime); 
		cJSON_AddNumberToObject(conditionItem, KK_SYNC_SCENE_ENDTIME_STR, endtime); 
		cJSON_AddNumberToObject(conditionItem, KK_SYNC_SCENE_CROSSDAY_STR, crossDay);	
		cJSON_AddItemToObject(conditionItem,KK_SYNC_SCENE_REPEATDAY_STR,repeatAry);

		
		cJSON_AddItemToArray(conditionAry, conditionItem);			
	}

	char *deviceCode = NULL;
	char *propertyName = NULL;
	char *compareType = NULL;	
	char *compareValue = NULL;	
	
	int epNum = 0;
	int isAnd;

	sqlCmd = sqlite3_mprintf("select * from SceneTriggerInfo where sceneId = %s",sceneId);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		
		
		isAnd = sqlite3_column_int(stmt, DB_SCENETRIGGER_ISAND);

		if(isAnd==1){
			cJSON *triggerItem = cJSON_CreateObject();
			deviceCode = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_DEVICECODE);
			epNum = sqlite3_column_int(stmt, DB_SCENETRIGGER_EPNUM);
			propertyName = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_PROPERTYNAME);
			compareType = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPARETYPE);
			compareValue = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_COMPAREVALUE);
			type = (char*)sqlite3_column_text(stmt, DB_SCENETRIGGER_TYPE);
			cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_TYPE_STR, (char*)type);
			cJSON_AddStringToObject(triggerItem, KK_SYNC_DEVICECODE_STR, (char*)deviceCode);
			cJSON_AddNumberToObject(triggerItem, KK_SYNC_SCENE_EPNUM_STR, epNum);
			cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_PROPERTYNAME_STR, (char*)propertyName);
			cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_COMPARETYPE_STR, (char*)compareType);
			cJSON_AddStringToObject(triggerItem, KK_SYNC_SCENE_COMPAREValue_STR, (char*)compareValue);
			cJSON_AddItemToArray(conditionAry, triggerItem);
		}
	}
		

	cJSON_AddItemToObject(conditionObj, "items",conditionAry);
	
	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt); 
	return SUCCESS_RETURN;	
}

static int kk_get_scenes_info(cJSON *data)
{
	char *sqlCmd = NULL;
	//char *zErrMsg = 0;
	sqlite3_stmt *stmt;	
	int enable = 0,type = 0;
	char *name = NULL;
	char *sceneId = NULL;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();		
	if(data == NULL){
		return FAIL_RETURN;
	}
	cJSON *sceneArray = cJSON_CreateArray();	
	sqlCmd = sqlite3_mprintf("select * from SceneInfo");
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);	
	while(sqlite3_step(stmt) == SQLITE_ROW){
		cJSON *sceneArrayItem = cJSON_CreateObject();
		enable = sqlite3_column_int(stmt, DB_SCENEINFO_ENABLE);
		if(enable == 1){
			cJSON_AddNumberToObject(sceneArrayItem, KK_SYNC_SCENE_ENABLE_STR, 1);	
		}else{
			cJSON_AddNumberToObject(sceneArrayItem, KK_SYNC_SCENE_ENABLE_STR, 0);	

		}
		type = sqlite3_column_int(stmt, DB_SCENEINFO_SCENETYPE);
		cJSON_AddNumberToObject(sceneArrayItem, KK_SYNC_SCENE_SCENETYPE_STR, type);	
		name = (char*)sqlite3_column_text(stmt, DB_SCENEINFO_SCENENAME);
		cJSON_AddStringToObject(sceneArrayItem, KK_SYNC_NANE_STR, name);	
		sceneId = (char*)sqlite3_column_text(stmt, DB_SCENEINFO_SCENEID);
		cJSON_AddStringToObject(sceneArrayItem, KK_SYNC_SCENEID_STR, sceneId);
		cJSON *actionArray = cJSON_CreateArray();
		kk_get_scenes_actions_info(actionArray,atoi(sceneId));	
		cJSON_AddItemToObject(sceneArrayItem, KK_SYNC_SCENE_ACTIONS_STR, actionArray);
		cJSON *triggerObj = cJSON_CreateObject();
		kk_get_scenes_trigger_info(triggerObj,sceneId);	
		cJSON_AddItemToObject(sceneArrayItem, KK_SYNC_SCENE_TRIGGER_STR, triggerObj);
		if(kk_is_trigger_timing(sceneId)!=1){
			cJSON *conditionObj = cJSON_CreateObject();
			kk_get_scenes_condition_info(conditionObj,sceneId);
			cJSON_AddItemToObject(sceneArrayItem, KK_SYNC_SCENE_CONDITION_STR, conditionObj);
		}

		cJSON_AddItemToArray(sceneArray, sceneArrayItem);			
	}			
	cJSON_AddItemToObject(data, KK_SYNC_SCENE_STR, sceneArray);	
	sqlite3_free(sqlCmd);
    sqlite3_finalize(stmt);
	return SUCCESS_RETURN;		
}

/*
static int kk_get_ccu_properties(cJSON *property)
{
	char *sqlCmd = NULL;
	sqlite3_stmt *stmt;
	char *propertyStr = NULL;
	char *valueStr = NULL;
	int valueType = 0;
	kk_sync_ctx_t *ctx = _kk_sync_get_ctx();
	if(property == NULL){
		return FAIL_RETURN;
	}
	
	_kk_sync_lock();
	sqlCmd = sqlite3_mprintf("select * from PropertiesInfo WHERE devType = '%d' ",KK_DM_DEVICE_CCU);	
	sqlite3_prepare_v2(ctx->pDb, sqlCmd, strlen(sqlCmd), &stmt, NULL);
	while(sqlite3_step(stmt) == SQLITE_ROW){
		propertyStr = (char*)sqlite3_column_text(stmt, DB_IDENTIFITER);
		valueType = sqlite3_column_int(stmt, DB_VALUETYPE);
		valueStr = (char*)sqlite3_column_text(stmt, DB_VALUE);
		if(valueType == KK_TSL_DATA_TYPE_TEXT){
			cJSON_AddStringToObject(property, propertyStr, valueStr);
		}else if(valueType == KK_TSL_DATA_TYPE_INT||
			valueType == KK_TSL_DATA_TYPE_ENUM||
			valueType == KK_TSL_DATA_TYPE_BOOL){
			cJSON_AddNumberToObject(property, propertyStr, atoi(valueStr));
		}
	}

	sqlite3_free(sqlCmd);
	sqlite3_finalize(stmt);
	_kk_sync_unlock();
	return SUCCESS_RETURN;
}
*/
/************************************************************
*功能描述：检查设备是否有重复
*输入参数：deviceCode：设备deviceCode
*输出参数：无
*返 回 值：1:存在；0：不存在
*其他说明：
*************************************************************/
char *kk_sync_get_info()
{
	char *out = NULL;
	char ccu_deviceCode[DEVICE_CODE_MAXLEN] = {0};
	char ccu_productCode[PRODUCT_CODE_MAXLEN] = {0};
	char version[32] = {0};
	char cloudstatus_str[16] = {0};


	cJSON *data = cJSON_CreateObject();
	kk_get_rooms_info(data);
	kk_get_devices_info(data);
	kk_get_scenes_info(data);
	//HAL_GetDevice_Code(ccu_deviceCode);
	HAL_Get_ccuid(ccu_deviceCode);
	HAL_GetProduct_Code(ccu_productCode);
	HAL_GetVersion(version);
	cJSON_AddStringToObject(data, KK_SYNC_DEVICECODE_STR,ccu_deviceCode);
	cJSON_AddStringToObject(data, KK_SYNC_NANE_STR, "newccu");	
	sprintf(cloudstatus_str, "%d", kk_get_cloudstatus());
	cJSON_AddStringToObject(data, KK_SYNC_ONLINE_STR, cloudstatus_str);	
	cJSON_AddStringToObject(data, KK_SYNC_PRODUCTCODE_STR, ccu_productCode);	
	cJSON_AddStringToObject(data, KK_SYNC_VERSION_STR, version);

	kk_get_ccu_properties_info(data);
	
	out=cJSON_Print(data);
	printf("kk_sync_get_info:%s\n",out);
	cJSON_Delete(data); 
	//free(out);	
	return out;
}

