#include <stdint.h>

#ifndef __SERIAL_H__
#define __SERIAL_H__

#include <syslog.h>

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/


/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

#define _SERIAL_LOG(level, fmt, args...)   \
    do                                  \
    {                                   \
        syslog(level, fmt, ##args);     \
        printf("\n["__FILE__":%d] "fmt,__LINE__, ##args);           \
    } while(0)

#define SERIAL_LOG_DBG(fmt, args...)      _SERIAL_LOG(LOG_DEBUG, fmt, ##args)
#define SERIAL_LOG_ERR(fmt, args...)      _SERIAL_LOG(LOG_ERR, fmt, ##args)

#define SERIAL_NAME "/dev/ttyS0"
#define SERIAL_BAUD 115200

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

typedef enum
{
    E_ERROR = -1,
    E_SERIAL_OK = 0,
    E_SERIAL_ERROR,
    E_SERIAL_NODATA,
    E_SERIAL_FD_ERROR,
} teSerial_Status;

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

extern int serial_fd;

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

void eSerial_start();
void eSerial_stop();

teSerial_Status eSerial_Init(char *name, uint32_t baud, int *piserial_fd);
teSerial_Status eSerial_Read(unsigned char *data);
teSerial_Status eSerial_Write(const unsigned char data);

teSerial_Status eSerial_ReadBuffer(unsigned char *data, int *count);
teSerial_Status eSerial_WriteBuffer(unsigned char *data, uint32_t count);

/****************************************************************************/
/***        Local Functions                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
#if defined __cplusplus
}
#endif

#endif /* __SERIAL_H__ */
