
#ifndef __KK_SCENE_DB_H__
#define __KK_SCENE_DB_H__

enum{
	DB_SCENETYPE_SCENE = 0,
	DB_SCENETYPE_IFTT,
	DB_SCENETYPE_TIMING,
	DB_SCENETYPE_MUTICONTROL,
};

enum{
	DB_SCENEINFO_ROOMID = 0,
	DB_SCENEINFO_SCENENAME,
	DB_SCENEINFO_SCENETYPE,
	DB_SCENEINFO_ENABLE,
	DB_SCENEINFO_SCENEID,
};
	
enum{
	DB_SCENETRIGGER_TYPE = 0,
	DB_SCENETRIGGER_DEVICECODE,
	DB_SCENETRIGGER_EPNUM,
	DB_SCENETRIGGER_PROPERTYNAME,
	DB_SCENETRIGGER_COMPARETYPE,
	DB_SCENETRIGGER_COMPAREVALUE,
	DB_SCENETRIGGER_SCENEID,
	DB_SCENETRIGGER_ISAND,
};

enum{
	DB_SCENECONDITION_TYPE = 0,
	DB_SCENECONDITION_STARTTIME,
	DB_SCENECONDITION_ENDTIME,
	DB_SCENECONDITION_CROSSDAY,
	DB_SCENECONDITION_REPEATDAY,
	DB_SCENECONDITION_SCENEID,
};

enum{
	DB_SCENEACTION_TYPE = 0,
	DB_SCENEACTION_DEVICECODE,
	DB_SCENEACTION_EPNUM,	
	DB_SCENEACTION_PROPERTYNAME,
	DB_SCENEACTION_PROPERTYVALUE,
	DB_SCENEACTION_DELAY,
	DB_SCENEACTION_SCENEID,
	DB_SCENEACTION_GWDEVICECODE,
};

enum{
	DB_SCENETIMER_WEEK = 0,
	DB_SCENETIMER_TIME,
	DB_SCENETIMER_SCENEID,

};

enum{
	DB_SCENEEMBED_WEEK = 0,
	DB_SCENEEMBED_EXECUTESCENEID,
	DB_SCENEMBED_SCENEID,

};

enum{
	DB_SCENEINVOKESERVICE_TYPE = 0,
	DB_SCENEINVOKESERVICE_IDENTIFIER,
	DB_SCENEINVOKESERVICE_SCENEID,
	DB_SCENEINVOKESERVICE_args,
};

enum{
	DB_QUICKPANEL_BUTTONID = 0,
	DB_QUICKPANEL_BINDTYPE,
	DB_QUICKPANEL_DEVICECODE,
	DB_QUICKPANEL_SCENEID,
	DB_QUICKPANEL_ROOMID,
	DB_QUICKPANEL_PRODUCTTYPE,
};
int kk_scene_delete_scene_timing(const char *sceneId);
int kk_scene_delete_scene_condition(const char *sceneId);
int kk_scene_delete_scene_trigger(const char *sceneId);
int kk_scene_delete_scene_embed(const char *sceneId);
int kk_scene_delete_scene_info(const char *sceneId);
int kk_scene_delete_scene_invokeservice(const char *sceneId);
int kk_scene_delete_scene_action(const char *sceneId,int isforword);
int kk_scene_insert_scene_action(const char* type,const char* deviceCode,int epNum,const char* propertyName,
												const char* propertyValue,int delay,const char* sceneId,const char *gwdeviceCode);
int kk_scene_insert_scene_invokeService(const char* type,const char* identifier,const char* args,const char* sceneId);
int kk_scene_insert_scene_embed(int delay,const char* executeSceneId,const char* sceneId);
int kk_scene_insert_scene_timer(time_t startTime,char weekflag,const char* sceneId);	
int kk_scene_insert_scene_condition(const char* type,int startTime,int endTime,int crossDay,
												char repeat_days,const char* sceneId);
												int kk_scene_insert_scene_trigger(const char* type,const char* deviceCode,int epNum,const char* propertyName,
												const char* compareType,const char* compareValue,const char* sceneId,int isAnd);
int kk_scene_insert_scene_info(const char* roomName,const char* name,int sceneType,int enable,const char* sceneId);
int kk_scene_update_scene_enable(int enable,const char *sceneId);
int kk_scene_db_init(void);					
int kk_scene_insert_panel_scene_info(int bindType,char *buttonId,char *deviceCode,const char* sceneId,const char* roomId,const char* productType);
int kk_scene_delete_quickpanel_info(char *buttonId,char* deviceCode);
int kk_scene_delete_panel_scene_info(char *buttonId,char *deviceCode);
int kk_scene_deleteall_panel_scene_info(char *deviceCode);

#endif
