#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "kk_data_mng.h"
#include "kk_lan_node_db.h"

#include "kk_log.h"

#include "klist.h"
#include "kk_product.h"
#include "com_api.h"
#include "kk_opcode.h"
#include "kk_lan_ctrl.h"
#include "kk_data_mng.h"

#include "kk_oldccu_msg.h"
#include "kk_ccu_msg.h"
#include "kk_lan_new_dev_notify.h"


static cJSON * _new_device_build(void* arg);
static cJSON * _new_hue_light_build(void* arg);
static cJSON * _new_ipc_build(void* arg);
static cJSON * _new_konke_socket_build(void* arg);
static cJSON * _new_konke_light_build(void* arg);
static cJSON * _new_cnwise_music_controller_build(void* arg);
static cJSON * _new_modbus_dev_build(void* arg);
static cJSON * _new_modbus_daikin_indoorunit_build(void* arg);
static cJSON * _new_konke_humidifier_build(void* arg);
static cJSON * _new_konke_aircleaner_build(void* arg);
static cJSON * _new_central_ac_gw_build(void* arg);
static cJSON * _new_central_ac_gw_indoor_build(void* arg);
static cJSON * _new_youzhuan_music_controllers_build(void* arg);


typedef cJSON *(*build_func)(void* arg);
typedef struct BUILD_FUNC{
	
#define NEW_DEVICES_BUILD_TYPE							0
#define NEW_HUE_LIGHTS_BUILD_TYPE						1
#define NEW_IPCS_BUILD_TYPE								2
#define NEW_KONKE_SOCKETS_BUILD_TYPE					3
#define NEW_KONKE_LIGHTS_BUILD_TYPE						4
#define NEW_CNWISE_MUSIC_CONTROLLERS_BUILD_TYPE			5
#define NEW_MODBUS_DEVS_BUILD_TYPE						6
#define NEW_MODBUS_DAIKIN_INDOORUNIT_BUILD_TYPE			7
#define NEW_KONKE_HUMIDIFIERS_BUILD_TYPE				8
#define NEW_KONKE_AIRCLEANERS_BUILD_TYPE				9
#define NEW_CENTRAL_AC_GWS_BUILD_TYPE					10
#define NEW_CENTRAL_AC_GW_INDOORS_BUILD_TYPE			11
#define NEW_YOUZHUAN_MUSIC_CONTROLLERS_BUILD_TYPE		12

	int type;
	build_func func;
}BUILD_FUNC;





static BUILD_FUNC new_dev_build_table[]={
	{NEW_DEVICES_BUILD_TYPE,_new_device_build},
	{NEW_HUE_LIGHTS_BUILD_TYPE,_new_hue_light_build},
	{NEW_IPCS_BUILD_TYPE,_new_ipc_build},
	{NEW_KONKE_SOCKETS_BUILD_TYPE,_new_konke_socket_build},
	{NEW_KONKE_LIGHTS_BUILD_TYPE,_new_konke_light_build},
	{NEW_CNWISE_MUSIC_CONTROLLERS_BUILD_TYPE,_new_cnwise_music_controller_build},
	{NEW_MODBUS_DEVS_BUILD_TYPE,_new_modbus_dev_build},
	{NEW_MODBUS_DAIKIN_INDOORUNIT_BUILD_TYPE,_new_modbus_daikin_indoorunit_build},
	{NEW_KONKE_HUMIDIFIERS_BUILD_TYPE,_new_konke_humidifier_build},
	{NEW_KONKE_AIRCLEANERS_BUILD_TYPE,_new_konke_aircleaner_build},
	{NEW_CENTRAL_AC_GWS_BUILD_TYPE,_new_central_ac_gw_build},
	{NEW_CENTRAL_AC_GW_INDOORS_BUILD_TYPE,_new_central_ac_gw_indoor_build},
	{NEW_YOUZHUAN_MUSIC_CONTROLLERS_BUILD_TYPE,_new_youzhuan_music_controllers_build},
};

build_func find_build_func(int type)
{
	int i,size;
	BUILD_FUNC*func = NULL;
	
	size = sizeof(new_dev_build_table)/sizeof(BUILD_FUNC);
	func = (BUILD_FUNC *)&new_dev_build_table;
	
	for(i=0;i<size;i++,func++){
		if(func->type==type){
			return func->func;
		}
	}
	return NULL;
}
static cJSON * new_devices_build(int type,int num,void** items)
{
	cJSON *ary = cJSON_CreateArray();
	cJSON *dev;
	build_func func;
	int i;
	
	if(items==NULL||*items==NULL){
		return ary;
	}

	if((func = find_build_func(type))==NULL){
		return ary;
	}

	
	for(i=0;i<num;i++){
		dev = func(items[i]);
		cJSON_AddItemToArray(ary,dev);
	}
	return ary;
}




static cJSON * _new_device_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	new_dev_item* item = arg;
	cJSON_AddStringToObject(dev,"channel",item->channel);
	cJSON_AddStringToObject(dev,"mac",item->mac);
	cJSON_AddStringToObject(dev,"nodeid",item->nodeid);
	cJSON_AddStringToObject(dev,"operate_type",item->operate_type);
	cJSON_AddStringToObject(dev,"gw_mac",item->gwmac);
	cJSON_AddStringToObject(dev,"status","");
	//printf("------------------CWC------------------------>[%s][%d]\n",__FUNCTION__,__LINE__);
	return dev;
}
static cJSON * _new_hue_light_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	HUE_LIGHT_ITEM* item = arg;
	cJSON_AddStringToObject(dev,"hue_light_id",item->hue_light_id);
	cJSON_AddStringToObject(dev,"hue_gw_id",item->hue_gw_id);
	cJSON_AddStringToObject(dev,"hue_light_status",item->hue_light_status);

	return dev;
}
static cJSON * _new_ipc_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	const char* item = arg;
	cJSON_AddStringToObject(dev,"ipcid",item);

	return dev;
}

static cJSON * _new_konke_socket_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	KK_SOCKET_ITEM* item = arg;
	cJSON_AddStringToObject(dev,"konke_socket_id",item->konke_socket_id);
	cJSON_AddStringToObject(dev,"konke_socket_mac",item->konke_socket_mac);
	cJSON_AddStringToObject(dev,"konke_socket_online",item->konke_socket_online);
	cJSON_AddStringToObject(dev,"konke_socket_status",item->konke_socket_status);

	return dev;
}

static cJSON * _new_konke_light_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	KK_LIGHT_ITEM* item = arg;
	cJSON_AddStringToObject(dev,"konke_light_id",item->konke_light_id);
	cJSON_AddStringToObject(dev,"konke_light_mac",item->konke_light_mac);
	cJSON_AddStringToObject(dev,"konke_light_online",item->konke_light_online);
	cJSON_AddStringToObject(dev,"konke_light_status",item->konke_light_status);

	return dev;
}
static cJSON * _new_cnwise_music_controller_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	MC_CTRL_ITEM* item = arg;
	cJSON_AddStringToObject(dev,"id",item->id);
	cJSON_AddStringToObject(dev,"music_controller_mac",item->music_controller_mac);
	cJSON_AddStringToObject(dev,"music_controller_type",item->music_controller_type);
	cJSON_AddStringToObject(dev,"music_controller_online",item->music_controller_online);
	cJSON_AddStringToObject(dev,"music_controller_status",item->music_controller_status);

	return dev;
}

static cJSON * _new_modbus_dev_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	MODBUS_DEV_ITEM* item=arg;
	cJSON_AddStringToObject(dev,"id",item->id);
	cJSON_AddStringToObject(dev,"dev_type",item->dev_type);
	cJSON_AddStringToObject(dev,"daikin_gw",item->daikin_gw);
	cJSON_AddStringToObject(dev,"dev_addr",item->dev_addr);
	cJSON_AddStringToObject(dev,"bind_modbus_gw_node_id",item->bind_modbus_gw_node_id);

	return dev;
}

static cJSON * _new_modbus_daikin_indoorunit_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	MODBUS_DAIKIN_INDOORUNIT_ITEM* item = arg;
	cJSON_AddStringToObject(dev,"id",item->id);
	cJSON_AddStringToObject(dev,"indooruint_addr",item->indooruint_addr);
	cJSON_AddStringToObject(dev,"bind_daikin_gw_devid",item->bind_daikin_gw_devid);

	return dev;
}

static cJSON * _new_konke_humidifier_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	KK_HUMIDIFIER_ITEM* item=arg;
	cJSON_AddStringToObject(dev,"konke_humidifier_id",item->konke_humidifier_id);
	cJSON_AddStringToObject(dev,"konke_humidifier_mac",item->konke_humidifier_mac);
	cJSON_AddStringToObject(dev,"konke_humidifier_online",item->konke_humidifier_online);
	cJSON_AddStringToObject(dev,"konke_humidifier_status",item->konke_humidifier_status);

	return dev;
}


static cJSON * _new_konke_aircleaner_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	KK_AIRCLEANER_ITEM* item =arg;
	cJSON_AddStringToObject(dev,"konke_aircleaner_id",item->konke_aircleaner_id);
	cJSON_AddStringToObject(dev,"konke_aircleaner_mac",item->konke_aircleaner_mac);
	cJSON_AddStringToObject(dev,"konke_aircleaner_online",item->konke_aircleaner_online);
	cJSON_AddStringToObject(dev,"konke_aircleaner_status",item->konke_aircleaner_status);

	return dev;
}

static cJSON * _new_central_ac_gw_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	CENTRAL_AC_ITEM* item =arg;
	cJSON_AddStringToObject(dev,"id",item->id);
	cJSON_AddStringToObject(dev,"bind_central_ac_gw_node_id",item->bind_central_ac_gw_node_id);
	cJSON_AddStringToObject(dev,"ac_gw_status",item->ac_gw_status);

	return dev;
}






static cJSON * _new_central_ac_gw_indoor_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	CENTRAL_AC_INDOOR_ITEM* item=arg;
	cJSON_AddStringToObject(dev,"id",item->id);
	cJSON_AddStringToObject(dev,"indooruint_addr",item->indooruint_addr);
	cJSON_AddStringToObject(dev,"bind_central_ac_gw_node_id",item->nodeid);
	cJSON *status = cJSON_CreateObject();
	cJSON_AddBoolToObject(status,"on",item->ac_gw_status.on);
	cJSON_AddBoolToObject(status,"online",item->ac_gw_status.online);
	cJSON_AddNumberToObject(status,"roomTemperature",item->ac_gw_status.roomTemperature);
	cJSON_AddNumberToObject(status,"settingTemperature",item->ac_gw_status.settingTemperature);
	cJSON_AddStringToObject(status,"runModel",item->ac_gw_status.mode);
	cJSON_AddStringToObject(status,"fanSpeed",item->ac_gw_status.speed);
	cJSON_AddItemToObject(dev,"status",status);
	return dev;
}






static cJSON * _new_youzhuan_music_controllers_build(void* arg)
{
	cJSON *dev = cJSON_CreateObject();
	YOUZHUAN_MC_CTRL_ITEM* item =arg;
	cJSON_AddStringToObject(dev,"id",item->id);
	cJSON_AddStringToObject(dev,"music_controller_mac",item->music_controller_mac);
	cJSON_AddStringToObject(dev,"music_controller_type",item->music_controller_type);
	cJSON_AddStringToObject(dev,"music_controller_online",item->music_controller_online);
	cJSON_AddStringToObject(dev,"music_controller_status",item->music_controller_status);

	return dev;
}






cJSON *new_device_notify_msg_build(NEW_DEVICE_NOTIFY *info)
{
	cJSON *arg;
	cJSON *msg;

	if(info==NULL){
		return NULL;
	}
	
	arg = cJSON_CreateObject();
	cJSON_AddItemToObject(arg,"new_device_count",info->new_device_count);
	cJSON_AddItemToObject(arg,"new_devices",info->new_devices);
	cJSON_AddItemToObject(arg,"new_hue_lights_count",info->new_hue_lights_count);
	cJSON_AddItemToObject(arg,"new_hue_lights",info->new_hue_lights);
	cJSON_AddItemToObject(arg,"new_ipc_count",info->new_ipc_count);
	cJSON_AddItemToObject(arg,"new_ipcs",info->new_ipcs);
	cJSON_AddItemToObject(arg,"new_konke_count",info->new_konke_count);
	cJSON_AddItemToObject(arg,"new_konke_sockets",info->new_konke_sockets);
	cJSON_AddItemToObject(arg,"new_konke_lights_count",info->new_konke_lights_count);
	cJSON_AddItemToObject(arg,"new_konke_lights",info->new_konke_lights);
	cJSON_AddItemToObject(arg,"new_cnwise_music_controllers_count",info->new_cnwise_music_controllers_count);
	cJSON_AddItemToObject(arg,"new_cnwise_music_controllers",info->new_cnwise_music_controllers);
	cJSON_AddItemToObject(arg,"new_modbus_devs_count",info->new_modbus_devs_count);
	cJSON_AddItemToObject(arg,"new_modbus_devs",info->new_modbus_devs);
	cJSON_AddItemToObject(arg,"new_modbus_daikin_indoorunits_count",info->new_modbus_daikin_indoorunits_count);
	cJSON_AddItemToObject(arg,"new_modbus_daikin_indoorunits",info->new_modbus_daikin_indoorunits);
	cJSON_AddItemToObject(arg,"new_konke_humidifiers_count",info->new_konke_humidifiers_count);
	cJSON_AddItemToObject(arg,"new_konke_humidifiers",info->new_konke_humidifiers);
	cJSON_AddItemToObject(arg,"new_konke_aircleaners_count",info->new_konke_aircleaners_count);
	cJSON_AddItemToObject(arg,"new_konke_aircleaners",info->new_konke_aircleaners);
	cJSON_AddItemToObject(arg,"new_central_ac_gws_count",info->new_central_ac_gws_count);
	cJSON_AddItemToObject(arg,"new_central_ac_gws",info->new_central_ac_gws);

	cJSON_AddItemToObject(arg,"new_central_ac_indoorunits_count",info->new_central_ac_indoorunits_count);
	cJSON_AddItemToObject(arg,"new_central_ac_indoorunits",info->new_central_ac_indoorunits);


	cJSON_AddItemToObject(arg,"new_youzhuan_music_controllers_count",info->new_youzhuan_music_controllers_count);
	cJSON_AddItemToObject(arg,"new_youzhuan_music_controllers",info->new_youzhuan_music_controllers);

	msg = old_ccu_msg_build_json("*","NEW_DEVICES",NULL,arg);

	return msg;
}
extern new_dev_item g_new_item[16];
extern int g_newgw_count;
extern int g_indoor_count;
extern CENTRAL_AC_INDOOR_ITEM *g_indoor_item;
static cJSON *new_devices_build_gw(int count)
{
	int i = 0;
	cJSON *ary = cJSON_CreateArray();
	for(i = 0; i < count; i++){
		cJSON *dev = cJSON_CreateObject();
		cJSON_AddStringToObject(dev,"channel",g_new_item[i].channel);
		cJSON_AddStringToObject(dev,"mac",g_new_item[i].mac);
		cJSON_AddStringToObject(dev,"nodeid",g_new_item[i].nodeid);
		cJSON_AddStringToObject(dev,"operate_type",g_new_item[i].operate_type);
		cJSON_AddStringToObject(dev,"gw_mac",g_new_item[i].gwmac);
		cJSON_AddStringToObject(dev,"status","");
		cJSON_AddItemToArray(ary,dev);
	}
	return ary;
}
cJSON *new_devices_build_indoor(int count)
{
	int i = 0;
	cJSON *ary = cJSON_CreateArray();
	for(i = 0 ; i < count; i++){
		cJSON *dev = cJSON_CreateObject();
		cJSON_AddStringToObject(dev,"id",g_indoor_item[i].id);
		cJSON_AddStringToObject(dev,"indooruint_addr",g_indoor_item[i].indooruint_addr);
		cJSON_AddStringToObject(dev,"bind_central_ac_gw_node_id",g_indoor_item[i].nodeid);
		cJSON *status = cJSON_CreateObject();
		cJSON_AddBoolToObject(status,"on",g_indoor_item[i].ac_gw_status.on);
		cJSON_AddBoolToObject(status,"online",g_indoor_item[i].ac_gw_status.online);
		cJSON_AddNumberToObject(status,"roomTemperature",g_indoor_item[i].ac_gw_status.roomTemperature);
		cJSON_AddNumberToObject(status,"settingTemperature",g_indoor_item[i].ac_gw_status.settingTemperature);
		cJSON_AddStringToObject(status,"runModel",g_indoor_item[i].ac_gw_status.mode);
		cJSON_AddStringToObject(status,"fanSpeed",g_indoor_item[i].ac_gw_status.speed);
		cJSON_AddItemToObject(dev,"status",status);
		cJSON_AddItemToArray(ary,dev);
	}
	return ary;
}
void kk_new_device_send()
{
	char tmp[4] = {0};
	NEW_DEVICE_NOTIFY info;
	cJSON *msg;

	sprintf(tmp,"%d",g_newgw_count);
	info.new_device_count = cJSON_CreateString(tmp);
	info.new_devices = new_devices_build_gw(g_newgw_count);


	info.new_hue_lights_count = cJSON_CreateString("0");
	info.new_hue_lights = new_devices_build(NEW_HUE_LIGHTS_BUILD_TYPE,0,NULL);
	
	info.new_ipc_count = cJSON_CreateString("0");
	info.new_ipcs =new_devices_build(NEW_IPCS_BUILD_TYPE,0,NULL);

	info.new_konke_count = cJSON_CreateString("0");
	info.new_konke_sockets = new_devices_build(NEW_KONKE_SOCKETS_BUILD_TYPE,0,NULL);

	info.new_konke_lights_count = cJSON_CreateString("0");
	info.new_konke_lights = new_devices_build(NEW_KONKE_LIGHTS_BUILD_TYPE,0,NULL);

	info.new_cnwise_music_controllers_count = cJSON_CreateString("0");
	info.new_cnwise_music_controllers =  new_devices_build(NEW_CNWISE_MUSIC_CONTROLLERS_BUILD_TYPE,0,NULL);

	info.new_modbus_devs_count = cJSON_CreateString("0");
	info.new_modbus_devs = new_devices_build(NEW_MODBUS_DEVS_BUILD_TYPE,0,NULL);

	info.new_modbus_daikin_indoorunits_count = cJSON_CreateString("0");
	info.new_modbus_daikin_indoorunits = new_devices_build(NEW_MODBUS_DAIKIN_INDOORUNIT_BUILD_TYPE,0,NULL);

	info.new_konke_humidifiers_count = cJSON_CreateString("0");
	info.new_konke_humidifiers =new_devices_build(NEW_KONKE_HUMIDIFIERS_BUILD_TYPE,0,NULL);

	info.new_konke_aircleaners_count = cJSON_CreateString("0");
	info.new_konke_aircleaners = new_devices_build(NEW_KONKE_AIRCLEANERS_BUILD_TYPE,0,NULL);

	info.new_central_ac_gws_count = cJSON_CreateString("0");
	info.new_central_ac_gws = new_devices_build(NEW_CENTRAL_AC_GWS_BUILD_TYPE,0,NULL);
	//printf("------------------CWC------------------------>[%s][%d]\n",__FUNCTION__,__LINE__);
	memset(tmp,0x0,sizeof(tmp));
	sprintf(tmp,"%d",g_indoor_count);
	info.new_central_ac_indoorunits_count = cJSON_CreateString(tmp);
	info.new_central_ac_indoorunits = new_devices_build_indoor(g_indoor_count);

	info.new_youzhuan_music_controllers_count = cJSON_CreateString("0");
	info.new_youzhuan_music_controllers =  new_devices_build(NEW_YOUZHUAN_MUSIC_CONTROLLERS_BUILD_TYPE,0,NULL);
	msg = new_device_notify_msg_build(&info);
	send_msg_to_module(msg);
	cJSON_Delete(msg);
	kk_clear_indoor_data();
}












