#ifndef __KK_ZIGBEE_API_H
#define __KK_ZIGBEE_API_H
#include "kk_test.h"


typedef int (*kk_rpc_set)(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data);
typedef int(*kk_rpc_report)(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data);

typedef struct{
	const char * name;
	kk_rpc_set set;
}kk_rpc_set_api_s;

typedef struct{
	const char * name;
	kk_rpc_report report;
}kk_rpc_report_api_s;

void kk_rpc_test(void);

#define KK_RPC_SET_FUNCTION_TABLE	{\
	{"kk_permit_join",kk_permit_join},\
	{"kk_wlist_ctrl",kk_wlist_ctrl},\	
	{"zclOnOff",kk_tsl_set_gloabl_OnOff},\
	{"zclOnOff_Off",zclOnOff_Off},\
	{"kk_tsl_set_colorlight_RGB_red",kk_tsl_set_colorlight_RGB_red},\
	{"kk_tsl_set_colorlight_RGB_green",kk_tsl_set_colorlight_RGB_green},\
	{"kk_tsl_set_colorlight_RGB_blue",kk_tsl_set_colorlight_RGB_blue},\	
	{"kk_tsl_set_colorlight_Brightness",kk_tsl_set_colorlight_Brightness},\	
	{"kk_tsl_set_colorlight_mode",kk_tsl_set_colorlight_mode},\	
}


#define KK_RPC_REPORT_FUNCTION_TABLE	{\
	{"kk_tsl_report_global_onoff",kk_tsl_report_global_onoff},\
	{"kk_tsl_report_colorControl_Brightness",kk_tsl_report_colorControl_Brightness},\
	{"kk_tsl_report_colorControl_RGB",kk_tsl_report_colorControl_RGB},\
	{"kk_tsl_report_iasZoneStatus",kk_tsl_report_iasZoneStatus},\
	{"kk_tsl_report_battery",kk_tsl_report_battery},\
}

kk_rpc_set_api_s kk_rpc_set_api[];
kk_rpc_report_api_s kk_rpc_report_api[];


uint8_t kk_get_rpc_set_api_size(void );
uint8_t kk_get_rpc_report_api_size(void );

typedef enum{
	EnrollResponseCode_Success					= 0x00,
	EnrollResponseCode_NoSupported				= 0x01,
	EnrollResponseCode_NoEnrollPermit			= 0x02,
	EnrollResponseCode_TooManyZones				= 0x03,
}EnrollResponseCode;
typedef enum{
	ArmMode_Disarm								= 0x00,
	ArmMode_ArmDayOrHomeZonesOnly				= 0x01,
	ArmMode_ArmNightOrSleepZonesOnly			= 0x02,
	ArmMode_ArmAllZones 						= 0x03,
}ArmMode;
typedef enum{
	ArmNotification_AllZonesDisarmed					= 0x01,
	ArmNotification_OnlyDayOrHomeZonesArmed 			= 0x02,
	ArmNotification_OnlyNightOrSleepZonesArmed			= 0x03,
	ArmNotification_AllZonesArmed						= 0x04,
	ArmNotification_InvalidArmOrDisarmCode				= 0x05,
	ArmNotification_NotReadyToArm						= 0x06,
	ArmNotification_AlreadyDisarmed 		
}ArmNotification;
typedef enum{
	PanelStatus_PanelDisarmedAndReadyToArm					= 0x00,
	PanelStatus_ArmedStay									= 0x01,
	PanelStatus_ArmedNight									= 0x02,
	PanelStatus_ArmedAway									= 0x03,
	PanelStatus_ExitDelay									= 0x04,
	PanelStatus_EntryDelay									= 0x05,
	PanelStatus_NotReadyToArm								= 0x06,
	PanelStatus_InAlarm 									= 0x07,
	PanelStatus_ArmingStay									= 0x08,
	PanelStatus_ArmingNight 								= 0x09,
	PanelStatus_ArmingAway									= 0x0a,
}PanelStatus;
typedef enum{
	AlarmStatus_NoAlarm 								= 0x00,
	AlarmStatus_Burglar 								= 0x01,
	AlarmStatus_Fire									= 0x02,
	AlarmStatus_Emergency								= 0x03,
	AlarmStatus_PolicePanic 							= 0x04,
	AlarmStatus_FirePanic								= 0x05,
	AlarmStatus_EmergencyPanic							= 0x06,
}AlarmStatus;
typedef enum{
	BypassResult_ZoneBypassed								= 0x00,
	BypassResult_ZoneNotBypassed							= 0x01,
	BypassResult_NotAllowed 								= 0x02,
	BypassResult_InvalidZoneID								= 0x03,
	BypassResult_UnknownZoneID								= 0x04,
	BypassResult_InvalidArmOrDisarmCode 					= 0x05,
}BypassResult;
typedef struct
{
	uint8_t zoneId;
	uint16_t zoneStatus;
}ZoneStatus_s;
typedef enum{
	WarningModes_Stop									= 0x00,
	WarningModes_Burglar								= 0x01,
	WarningModes_Fire									= 0x02,
	WarningModes_Emergency								= 0x03,
	WarningModes_PolicePanic							= 0x04,
	WarningModes_FirePanic 								= 0x05,
	WarningModes_EmergencyPanic							= 0x06,
}WarningModes;


typedef enum{
	StrobeField_NoStrobe								= 0x00,
	StrobeField_UseStrobe								= 0x01,
}StrobeField;

typedef enum{
	SirenLevel_LowLevelSound								= 0x00,
	SirenLevel_MediumLevelSound								= 0x01,
	SirenLevel_HighLevelSound								= 0x02,
	SirenLevel_VeryHighLevelSound							= 0x03,
}SirenLevel;

typedef enum{
	StrobeLevel_LowLevelSound								= 0x00,
	StrobeLevel_MediumLevelSound							= 0x01,
	StrobeLevel_HighLevelSound								= 0x02,
	StrobeLevel_VeryHighLevelSound							= 0x03,
}StrobeLevel;
	
typedef enum{
	SquawkModeField_Arm										= 0x00,
	SquawkModeField_Disarmed								= 0x01,
}SquawkModeField;





EmberAfStatus kk_private_protocol(uint16_t node,uint8_t dataLen,uint8_t *data);



EmberStatus kk_network_leave(void);
EmberStatus kk_network_form(bool centralized,EmberPanId panId,int8_t radioTxPower,uint8_t channel);
void kk_print_network_info(void);

EmberStatus kk_zdo_leave_request(EmberNodeId target,bool removeChildren,bool rejoin);

EmberStatus zclGRead(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				bool svr);

EmberStatus zclGReadAttrs(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint8_t len,
				uint16_t* attrIds,
				bool svr);

EmberStatus zclGWrite(uint16_t node,
				uint8_t srcEP,
				uint8_t dstEP,
				bool multicast,
				uint16_t clusterId,
				uint16_t attrId,
				uint8_t dataType,
				uint8_t dataLen,
				uint8_t *data,
				bool svr);


EmberStatus zclOnOff_On(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Off(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Toggle(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OffWithEffect(uint16_t node,uint8_t ep,uint8_t id,uint8_t var);
EmberStatus zclOnOff_OnWithRecallGlobalScene(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OnWithTimedOff(uint16_t node,uint8_t ep,uint8_t Control,uint16_t OnTime,uint16_t OffWaitTime);

EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep);
EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep);
EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep);
EmberStatus WindowCover_GotoLiftPercentage(uint16_t node,uint8_t ep,uint8_t position);

EmberStatus zclColorControlMovetohue(uint16_t node,
										uint8_t ep,
										uint8_t hue,
										uint8_t dir,
										uint16_t trsTime,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlMovehue(uint16_t node,
										uint8_t ep,
										uint8_t mode,
										uint8_t rate,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlStephue(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlMovetosat(uint16_t node,
												uint8_t ep,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlMovesat(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint8_t rate,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepsat(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);

EmberStatus zclColorControlMovetohueandsat(uint16_t node,
														uint8_t ep,
														uint8_t hue,
														uint8_t saturation,
														uint16_t trsTime,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlMovetocolor(uint16_t node,
													uint8_t ep,
													uint16_t colorX,
													uint16_t colorY,
													uint16_t trsTime,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolor(uint16_t node,
												uint8_t ep,
												uint16_t rateX,
												uint16_t rateY,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepcolor(uint16_t node,
												uint8_t ep,
												uint16_t stepX,
												uint16_t stepY,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlMovetocolortemp(uint16_t node,
															uint8_t ep,
															uint16_t colorTemp,
															uint16_t trsTime,
															bool options,
															uint8_t mask,
															uint8_t Override);

EmberStatus zclColorControlEmovetohue(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t dir,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlEmovehue( uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint16_t rate,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlEstephue(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint16_t size,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlEmovetohueandsat(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlLoopSet(uint16_t node,
											uint8_t ep,
											uint8_t flags,
											uint8_t action,
											uint8_t dir,
											uint16_t time,
											uint16_t sHue,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlStopmovestep(uint16_t node,
													uint8_t ep,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t rate,
														uint16_t Tmin,
														uint16_t Tmax,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlStepcolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t size,
														uint16_t trsTime,
														uint16_t minimum,
														uint16_t maximum,
														bool options,
														uint8_t mask,
														uint8_t Override);







EmberStatus zclGroupsAddGroup(uint16_t node,
									uint8_t ep,
									uint16_t id,
									char *name);

EmberStatus zclGroupsViewGroup(uint16_t node,
									uint8_t ep,
									uint16_t id);

EmberStatus zclGroupsGetGroupMembership(uint16_t node,
									uint8_t ep,
									uint16_t count,
									uint16_t *list);

EmberStatus zclGroupsRemoveGroup(uint16_t node,
									uint8_t ep,
									uint16_t id);

EmberStatus zclGroupsRemoveAllGroups(uint16_t node,
									uint8_t ep);

EmberStatus zclGroupsAddGroupIfIdentifying(uint16_t node,
									uint8_t ep,
									uint16_t id,
									char *name);

EmberStatus zclScenesAddScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id,
									uint16_t trs_time,
									char *name,
									uint8_t extLen,
									uint8_t* extData);

EmberStatus zclScenesViewScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id);

EmberStatus zclScenesRemoveScene(uint16_t node,
								uint8_t ep,
								uint16_t g_id,
								uint16_t s_id);

EmberStatus zclScenesRemoveAllScene(uint16_t node,
								uint8_t ep,
								uint16_t g_id);

EmberStatus zclScenesStoreScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id);

EmberStatus zclScenesRecallScene(uint16_t node,
										uint8_t ep,
										uint16_t g_id,
										uint16_t s_id,
										uint16_t trsTime);

EmberStatus zclScenesGetSceneMembership(uint16_t node,
										uint8_t ep,
										uint16_t g_id);


EmberStatus zclScenesEnhancedAddScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id,
									uint16_t trs_time,
									char *name,
									uint8_t extLen,
									uint8_t* extData);



EmberStatus zclScenesEnhancedViewScene(uint16_t node,
									uint8_t ep,
									uint16_t g_id,
									uint16_t s_id);

EmberStatus zclScenesCopyScene(uint16_t node,
									uint8_t ep,
									uint8_t mode,
									uint16_t gidFrom,
									uint16_t sidFrom,
									uint16_t gidTo,
									uint16_t sidTo);






EmberStatus zclLevel_MoveToLevel(uint16_t node,
										uint8_t ep,
										uint8_t level,
										uint16_t trsTime,
										uint8_t *mask,
										uint8_t *override);
EmberStatus zclLevel_Move(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t rate,
								uint8_t *mask,
								uint8_t *override);

EmberStatus zclLevel_Step(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t size,
								uint16_t trsTime,
								uint8_t *mask,
								uint8_t *override);
EmberStatus zclLevel_Stop(uint16_t node,
								uint8_t ep,
								uint8_t *mask,
								uint8_t *override);


EmberStatus zclLevel_MoveToLevelWithOnOff(uint16_t node,
										uint8_t ep,
										uint8_t level,
										uint16_t trsTime,
										uint8_t *mask,
										uint8_t *override);
										
EmberStatus zclLevel_MoveWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t rate,
								uint8_t *mask,
								uint8_t *override);

EmberStatus zclLevel_StepWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t size,
								uint16_t trsTime,
								uint8_t *mask,
								uint8_t *override);

EmberStatus zclLevel_StopWithOnOff(uint16_t node,
								uint8_t ep,
								uint8_t *mask,
								uint8_t *override);



EmberStatus zclWD_StartWarning(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint16_t duration,
								uint8_t cycle,
								uint8_t level);

EmberStatus zclWD_Squawk(uint16_t node,
								uint8_t ep,
								uint8_t mode);



EmberStatus zclThermostat_Setpoint_Raise_Lower(uint16_t node,
								uint8_t ep,
								uint8_t mode,
								uint8_t amount);

EmberStatus zclThermostat_GetWeeklySchedule(uint16_t node,
								uint8_t ep,
								uint8_t days,
								uint8_t mode);

EmberStatus zclThermostat_ClearWeeklySchedule(uint16_t node,
								uint8_t ep);

EmberStatus zclThermostat_GetRelayStatusLog(uint16_t node,
														uint8_t ep);




//IAS
EmberStatus arm_command(uint16_t node,
							uint8_t ep,
							ArmMode mode,
							char* code,
							uint8_t id);

EmberStatus bypass_command(uint16_t node,
								uint8_t ep,
								uint8_t num,
								uint8_t *id,
								char* code);

EmberStatus emergency_command(uint16_t node,
								uint8_t ep);

EmberStatus fire_command(uint16_t node,
							uint8_t ep);

EmberStatus panic_command(uint16_t node,
							uint8_t ep);

EmberStatus get_zone_id_command(uint16_t node,
							uint8_t ep);

EmberStatus get_zone_information_command(uint16_t node,
											uint8_t ep,
											uint8_t id);

EmberStatus get_panel_status_command(uint16_t node,
											uint8_t ep);

EmberStatus get_bypassed_zone_list_command(uint16_t node,
														uint8_t ep);

EmberStatus get_zone_status_command(uint16_t node,
											uint8_t ep,
											uint8_t statrId,
											uint8_t maxNum,
											bool flag,
											uint16_t mask);

EmberStatus arm_response(uint16_t node,
							uint8_t ep,
							ArmNotification arm);

EmberStatus get_zone_id_map_response(uint16_t node,
										uint8_t ep,
										uint16_t* map);//16

EmberStatus get_zone_information_response(uint16_t node,
										uint8_t ep,
										uint8_t id,
										uint16_t type,
										uint8_t* ieee,
										char* label);

EmberStatus zone_status_changed(uint16_t node,
										uint8_t ep,
										uint8_t id,
										uint16_t zonestatus,
										uint8_t audible,
										char* label);

EmberStatus panel_status_changed(uint16_t node,
								uint8_t ep,
								PanelStatus panel,
								uint8_t remain,
								uint8_t audible,
								AlarmStatus alarm);

EmberStatus get_panel_status_response(uint16_t node,
								uint8_t ep,
								PanelStatus panel,
								uint8_t remain,
								uint8_t audible,
								AlarmStatus alarm);

EmberStatus set_bypassed_zone_list(uint16_t node,
								uint8_t ep,
								uint8_t num,
								uint8_t* id);

EmberStatus bypass_response(uint16_t node,
							uint8_t ep,
							uint8_t num,
							BypassResult* id);

EmberStatus get_zone_status_response(uint16_t node,
											uint8_t ep,
											bool complete,
											uint8_t num,
											ZoneStatus_s**ZoneStatus);

EmberStatus start_warning(uint16_t node,
								uint8_t ep,
								WarningModes mode,
								StrobeField strobe,
								SirenLevel siren,
								uint16_t duration,
								uint8_t cycle,
								StrobeLevel level);

EmberStatus squawk_command(uint16_t node,
								uint8_t ep,
								WarningModes mode,
								StrobeField strobe,
								SquawkModeField squawk);

#endif
