/*
 * Copyright (C) 2020-2020 ikonke
 */

//#include "iotx_dm_internal.h"
#include "kk_tsl_common.h"
#include "klist.h"
#include "cJSON.h"
#include "kk_dm_msg.h"
#include "kk_dm_mng.h"
#include "kk_dm_api.h"
#include "kk_tsl_api.h"
#include "com_api.h"
#include "kk_log.h"
#include "kk_area_handle.h"


#define IOTX_LINKKIT_KEY_ID          "id"
#define IOTX_LINKKIT_KEY_CODE        "code"
#define IOTX_LINKKIT_KEY_DEVID       "devid"
#define IOTX_LINKKIT_KEY_SERVICEID   "serviceid"
#define IOTX_LINKKIT_KEY_PROPERTYID  "propertyid"
#define IOTX_LINKKIT_KEY_EVENTID     "eventid"
#define IOTX_LINKKIT_KEY_PAYLOAD     "payload"
#define IOTX_LINKKIT_KEY_CONFIG_ID   "configId"
#define IOTX_LINKKIT_KEY_CONFIG_SIZE "configSize"
#define IOTX_LINKKIT_KEY_GET_TYPE    "getType"
#define IOTX_LINKKIT_KEY_SIGN        "sign"
#define IOTX_LINKKIT_KEY_SIGN_METHOD "signMethod"
#define IOTX_LINKKIT_KEY_URL         "url"
#define IOTX_LINKKIT_KEY_VERSION     "version"
#define IOTX_LINKKIT_KEY_UTC         "utc"
#define IOTX_LINKKIT_KEY_RRPCID      "rrpcid"
#define IOTX_LINKKIT_KEY_CTX         "ctx"
#define IOTX_LINKKIT_KEY_TOPO        "topo"
#define IOTX_LINKKIT_KEY_PRODUCT_KEY "productKey"
#define IOTX_LINKKIT_KEY_TIME        "time"
#define IOTX_LINKKIT_KEY_DATA        "data"

#define IOTX_LINKKIT_SYNC_DEFAULT_TIMEOUT_MS 10000
#define dm_log_err          ERROR_PRINT
#define dm_log_debug        WARNING_PRINT
#define dm_log_info         INFO_PRINT





typedef struct {
    int msgid;
    void *semaphore;
    int code;
    struct list_head linked_list;
} iotx_linkkit_upstream_sync_callback_node_t;

typedef struct {
    void *mutex;
    void *upstream_mutex;
    int is_opened;
    int is_connected;
    struct list_head upstream_sync_callback_list;
} iotx_linkkit_ctx_t;

static iotx_linkkit_ctx_t g_iotx_linkkit_ctx = {0};

static iotx_linkkit_ctx_t *_iotx_linkkit_get_ctx(void)
{
    return &g_iotx_linkkit_ctx;
}

static void _iotx_linkkit_mutex_lock(void)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    if (ctx->mutex) {
        HAL_MutexLock(ctx->mutex);
    }
}

static void _iotx_linkkit_mutex_unlock(void)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    if (ctx->mutex) {
        HAL_MutexUnlock(ctx->mutex);
    }
}

static int _impl_copy(_IN_ void *input, _IN_ int input_len, _OU_ void **output, _IN_ int output_len)
{
    if (input == NULL || output == NULL || *output != NULL) {
        return INVALID_PARAMETER;
    }

    *output = malloc(output_len);
    if (*output == NULL) {
        return MEMORY_NOT_ENOUGH;
    }
    memset(*output, 0, output_len);
    memcpy(*output, input, input_len);

    return SUCCESS_RETURN;
}

#if 1
static void _iotx_linkkit_upstream_mutex_lock(void)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    if (ctx->upstream_mutex) {
        HAL_MutexLock(ctx->upstream_mutex);
    }
}

static void _iotx_linkkit_upstream_mutex_unlock(void)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    if (ctx->upstream_mutex) {
        HAL_MutexUnlock(ctx->upstream_mutex);
    }
}


static int _iotx_linkkit_upstream_sync_callback_list_insert(int msgid, void *semaphore,
        iotx_linkkit_upstream_sync_callback_node_t **node)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    iotx_linkkit_upstream_sync_callback_node_t *search_node = NULL;

    list_for_each_entry(search_node, &ctx->upstream_sync_callback_list, linked_list,
                        iotx_linkkit_upstream_sync_callback_node_t) {
        if (search_node->msgid == msgid) {
            WARNING_PRINT("Message Already Exist: %d", msgid);
            return FAIL_RETURN;
        }
    }

    search_node = malloc(sizeof(iotx_linkkit_upstream_sync_callback_node_t));
    if (search_node == NULL) {
        dm_log_debug("malloc error");
        return FAIL_RETURN;
    }
    memset(search_node, 0, sizeof(iotx_linkkit_upstream_sync_callback_node_t));
    search_node->msgid = msgid;
    search_node->semaphore = semaphore;
    INIT_LIST_HEAD(&search_node->linked_list);

    list_add(&search_node->linked_list, &ctx->upstream_sync_callback_list);
    INFO_PRINT("New Message, msgid: %d", msgid);

    *node = search_node;
    return SUCCESS_RETURN;
}

static int _iotx_linkkit_upstream_sync_callback_list_remove(int msgid)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    iotx_linkkit_upstream_sync_callback_node_t *search_node = NULL;

    list_for_each_entry(search_node, &ctx->upstream_sync_callback_list, linked_list,
                        iotx_linkkit_upstream_sync_callback_node_t) {
        if (search_node->msgid == msgid) {
            INFO_PRINT("Message Found: %d, Delete It \n", msgid);
            HAL_SemaphoreDestroy(search_node->semaphore);
            list_del(&search_node->linked_list);
            free(search_node);
            return SUCCESS_RETURN;
        }
    }

    return FAIL_RETURN;
}

int _iotx_linkkit_upstream_sync_callback_list_search(int msgid,
        iotx_linkkit_upstream_sync_callback_node_t **node)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    iotx_linkkit_upstream_sync_callback_node_t *search_node = NULL;

    if (node == NULL || *node != NULL) {
        dm_log_debug("invalid param");
        return FAIL_RETURN;
    }

    list_for_each_entry(search_node, &ctx->upstream_sync_callback_list, linked_list,
                        iotx_linkkit_upstream_sync_callback_node_t) {
        if (search_node->msgid == msgid) {
            dm_log_debug("Sync Message Found: %d", msgid);
            *node = search_node;
            return SUCCESS_RETURN;
        }
    }

    return FAIL_RETURN;
}

static void _iotx_linkkit_upstream_sync_callback_list_destroy(void)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    iotx_linkkit_upstream_sync_callback_node_t *search_node = NULL, *next_node = NULL;

    list_for_each_entry_safe(search_node, next_node, &ctx->upstream_sync_callback_list, linked_list,
                             iotx_linkkit_upstream_sync_callback_node_t) {
        list_del(&search_node->linked_list);
        HAL_SemaphoreDestroy(search_node->semaphore);
        free(search_node);
    }
}


static void _iotx_linkkit_upstream_callback_remove(int msgid, int code)
{
     INFO_PRINT("_iotx_linkkit_upstream_callback_remove : [%d] ,code= %d  \n",msgid, code );
    int res = 0;
    iotx_linkkit_upstream_sync_callback_node_t *sync_node = NULL;
    res = _iotx_linkkit_upstream_sync_callback_list_search(msgid, &sync_node);
    if (res == SUCCESS_RETURN) {
        sync_node->code = (code == IOTX_DM_ERR_CODE_SUCCESS) ? (SUCCESS_RETURN) : (FAIL_RETURN);
        INFO_PRINT("Sync Message %d Result: %d", msgid, sync_node->code);
        HAL_SemaphorePost(sync_node->semaphore);
    }
}
#endif

#ifdef LOG_REPORT_TO_CLOUD
    int  report_sample = 0;
#endif
#ifdef ALCS_ENABLED
    extern void dm_server_free_context(_IN_ void *ctx);
#endif
static int s_CloudStatus = 0;
static int s_CloudStatusRecv = 0;

int kk_get_cloudstatus(void){
	return s_CloudStatus;
}
int kk_get_cloud_recv_status(void){
	return s_CloudStatusRecv;
}

static int kk_topo_delete_handle(cJSON *payload)
{
	if(payload == NULL){
		return FAIL_RETURN;
	}
	cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR); 
	cJSON *state = cJSON_GetObjectItem(paramStr, MSG_TOPO_CHANGE_TYPE_STR);
	if(state != NULL && state->valueint == 1){
		cJSON *deviceArray = cJSON_GetObjectItem(paramStr, MSG_TOPO_CHANGE_DEVICES_STR);
		if(deviceArray == NULL){
			return FAIL_RETURN;
		}
		cJSON * item = deviceArray->child;
		while(item != NULL){
			char *deviceCode = cJSON_GetObjectItem(item,MSG_DEVICE_CODE_STR)->valuestring;
			dm_mgr_subdev_delete(deviceCode);
			item = item->next;
		}

	}
	return SUCCESS_RETURN;
	

}
static int kk_service_addRoom_handle(const char *deviceCode, cJSON *params)
{
	dm_mgr_dev_node_t *node = NULL;
	char roomId[32] = {0};
	int res = 0;
	int idx = 0,idxIpt = 0;
	int start  = 0,serverNum = 0;
	kk_tsl_service_t *serviceItem = NULL;
	kk_tsl_data_t* pinputData = NULL;
	cJSON *currentItem  =NULL;
	if(deviceCode == NULL||params == NULL){
		return INVALID_PARAMETER;
	}
    res = dm_mgr_get_device_by_devicecode(deviceCode, &node);
    if (res < SUCCESS_RETURN) {
		ERROR_PRINT("dm_mgr_get_device_by_devicecode failed\n");
        return res;
    }
	cJSON *roomInfoStr = cJSON_GetObjectItem(params, MSG_AREA_ADDROOM_ROOMNAME);	
	if(roomInfoStr == NULL){
		return FAIL_RETURN;
	}
	uint64_t id = kk_room_add(roomInfoStr->valuestring);
	sprintf(roomId,"%u",id);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_AREA_ADDROOM_NOTIFICATION_ROOMID,NULL,roomId);	
	return SUCCESS_RETURN;
	
}
static int kk_service_deleteRoom_handle(cJSON *params)
{
	if(params == NULL){
		return INVALID_PARAMETER;
	}

	cJSON *roomInfoStr = cJSON_GetObjectItem(params, MSG_AREA_ROOM_ROOMID);	
	if(roomInfoStr == NULL){
		return FAIL_RETURN;
	}
	kk_room_delete(roomInfoStr->valuestring);
	return SUCCESS_RETURN;
	
}
static int kk_service_addDeviceToRoom_handle(cJSON *params)
{
	if(params == NULL){
		return INVALID_PARAMETER;
	}

	cJSON *roomId = cJSON_GetObjectItem(params, MSG_AREA_ROOM_ROOMID);	
	if(roomId == NULL){
		return FAIL_RETURN;
	}
	cJSON *deviceCode = cJSON_GetObjectItem(params, MSG_DEVICE_CODE_STR);	
	if(deviceCode == NULL){
		return FAIL_RETURN;
	}	
	cJSON *epNum = cJSON_GetObjectItem(params, MSG_AREA_ROOM_EPNUM);	
	if(epNum == NULL){
		return FAIL_RETURN;
	}		
	kk_room_dev_add(roomId->valuestring,deviceCode->valuestring,epNum->valuestring);
	return SUCCESS_RETURN;
}
static int kk_service_removeDeviceFromRoom_handle(cJSON *params)
{
	if(params == NULL){
		return INVALID_PARAMETER;
	}

	cJSON *deviceCode = cJSON_GetObjectItem(params, MSG_DEVICE_CODE_STR);	
	if(deviceCode == NULL){
		return FAIL_RETURN;
	}	
	cJSON *epNum = cJSON_GetObjectItem(params, MSG_AREA_ROOM_EPNUM);	
	if(epNum == NULL){
		return FAIL_RETURN;
	}		
	kk_room_dev_remove(deviceCode->valuestring,epNum->valuestring);
	return SUCCESS_RETURN;
}
static int kk_service_execute_action(cJSON *action,dm_mgr_dev_node_t *node)
{
	int idx = 0;
	kk_tsl_data_t *pCurrentItem = NULL;
	cJSON *pCurrentData = NULL;
	if(node == NULL){
		return INVALID_PARAMETER;
	}
	void *param = cJSON_Print(action);
	kk_msg_execute_property_set(node->productCode,node->deviceCode,param,node->fatherDeviceCode);
	
#if 0	
	for(idx = 0; idx < shadow->property_number; idx++){
		pCurrentItem = shadow->properties + idx;
		if(pCurrentItem != NULL){
			cJSON *pCurrentData = cJSON_GetObjectItem(action, pCurrentItem->identifier);
			if(pCurrentData != NULL){

			}
		}
	}
#endif	
	free(param);
	return SUCCESS_RETURN;


}
static int kk_service_executeRoom_handle(cJSON *params)
{
	int res = 0;
	kk_dev_list_t *pList = NULL;
	dm_mgr_dev_node_t *search_node = NULL;	

	if(params == NULL){
		return INVALID_PARAMETER;
	}
	cJSON *roomId = cJSON_GetObjectItem(params, MSG_AREA_ROOM_ROOMID);	
	if(roomId == NULL){
		return FAIL_RETURN;
	}

	cJSON *productCodeStr = cJSON_GetObjectItem(params, MSG_PRODUCT_TYPE_STR);	
	if(productCodeStr == NULL){
		return FAIL_RETURN;
	}	

	pList = kk_get_room_deviceCode(roomId->valuestring);
	if(pList != NULL){
		while(pList != NULL){
			res = dm_mgr_get_device_by_devicecode(pList->deviceCode,&search_node);
			if (res != SUCCESS_RETURN) {
				pList = pList->next;
		        continue;
		    }
			if(strcmp(search_node->productCode,productCodeStr->valuestring) == 0){
				cJSON *action = cJSON_GetObjectItem(params, MSG_AREA_ROOM_ACTION);
				if(action != NULL){
					kk_service_execute_action(action,search_node);
					
				}
			}
			pList = pList->next;
		}
	}
	kk_free_room_dev_list();
	return SUCCESS_RETURN;
}
static int kk_service_setLocalTimer_handle(cJSON *params,const char *deviceCode)
{
	int res = 0;
	kk_dev_list_t *pList = NULL;
	dm_mgr_dev_node_t *search_node = NULL;	
	char *timer = NULL,*targets = NULL;
	int isEnable  = 0, isValid = 0, zoneOffset = 0;
	int size = 0	;

	if(params == NULL || deviceCode == NULL){
		return INVALID_PARAMETER;
	}
	res = dm_mgr_get_device_by_devicecode(deviceCode,&search_node);	
    if (res < SUCCESS_RETURN) {
		ERROR_PRINT("dm_mgr_get_device_by_devicecode failed\n");
        return res;
    }

	size = kk_service_get_array_size(search_node->dev_shadow);
	
	cJSON *LocalTimerArray = cJSON_GetObjectItem(params, MSG_TIMER_SETLOCALTIMER_LOCALTIMER);	
	if(LocalTimerArray == NULL){
		return FAIL_RETURN;
	}
	cJSON * item = LocalTimerArray->child;
	while(item != NULL){

		timer = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_TIMER)->valuestring;
	    isEnable = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_ENABLE)->valueint;
		isValid = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_ISVALID)->valueint;
		zoneOffset = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_ZONEOFFSET)->valueint;
		targets = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_TARGETS)->valuestring;
		kk_service_localtimer_set(search_node->dev_shadow,timer,isEnable,isValid,zoneOffset,targets,size);
		item = item->next;
	}
	return SUCCESS_RETURN;
}
static int kk_service_getLocalTimer_handle(const char *deviceCode)
{
	if(deviceCode == NULL){
		return INVALID_PARAMETER;
	}
	dm_msg_thing_service_post(deviceCode,MSG_TIMER_GETLOCALTIMER_GETLOCALTIMER);

	return SUCCESS_RETURN;
}

static int kk_service_setCountDown_handle(cJSON *params,const char *deviceCode)
{
	int res = 0;
	kk_dev_list_t *pList = NULL;
	dm_mgr_dev_node_t *search_node = NULL;	
	char *targets = NULL;
	int isEnable  = 0, isValid = 0, delaytimer = 0,current = 0;
	int size = 0	;

	if(params == NULL || deviceCode == NULL){
		return INVALID_PARAMETER;
	}
	res = dm_mgr_get_device_by_devicecode(deviceCode,&search_node);	
    if (res < SUCCESS_RETURN) {
		ERROR_PRINT("dm_mgr_get_device_by_devicecode failed\n");
        return res;
    }

	size = kk_service_get_array_size(search_node->dev_shadow);
	printf("[%s][%d]size:%d\n",__FUNCTION__,__LINE__,size);
	cJSON *LocalTimerArray = cJSON_GetObjectItem(params, MSG_TIMER_SETCOUNTDOWN_COUNTDOWN);	
	if(LocalTimerArray == NULL){
		return FAIL_RETURN;
	}
	cJSON * item = LocalTimerArray->child;
	while(item != NULL){
		delaytimer = cJSON_GetObjectItem(item,MSG_TIMER_SETCOUNTDOWN_DELAYTIME)->valueint;
	    current = cJSON_GetObjectItem(item,MSG_TIMER_SETCOUNTDOWN_CURRENTTIME)->valueint;
		isValid = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_ISVALID)->valueint;
		isEnable = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_ENABLE)->valueint;
		targets = cJSON_GetObjectItem(item,MSG_TIMER_SETLOCALTIMER_TARGETS)->valuestring;
		kk_service_setCountDown_set(search_node->dev_shadow,delaytimer,current,isEnable,isValid,targets,size);
		item = item->next;
	}
	return SUCCESS_RETURN;
}

static int kk_service_getCountDown_handle(const char *deviceCode)
{
	if(deviceCode == NULL){
		return INVALID_PARAMETER;
	}
	dm_msg_thing_service_post(deviceCode,MSG_TIMER_SETCOUNTDOWN_GETCOUNTDOWN);

	return SUCCESS_RETURN;
}

static int kk_service_getLockKeylist_handle(const char *deviceCode)
{
	if(deviceCode == NULL){
		return INVALID_PARAMETER;
	}

	return SUCCESS_RETURN;
}

static int kk_service_addKey_handle(const char *deviceCode,cJSON *param)
{
	char keyId[32] = {0};
	uint64_t u64KeyId = 0;
	int res = 0;
	dm_mgr_dev_node_t *node = NULL;	
	if(deviceCode == NULL || param == NULL){
		return INVALID_PARAMETER;
	}
    res = dm_mgr_get_device_by_devicecode(deviceCode, &node);
    if (res < SUCCESS_RETURN) {
		ERROR_PRINT("dm_mgr_get_device_by_devicecode failed\n");
        return res;
    }

	cJSON *KeyType = cJSON_GetObjectItem(param,MSG_KEYADD_KEYTYPE);
	if(KeyType == NULL) return FAIL_RETURN;
	cJSON *KeyRole = cJSON_GetObjectItem(param,MSG_KEYADD_KEYROLE);	
	if(KeyRole == NULL) return FAIL_RETURN;
	cJSON *IsValid = cJSON_GetObjectItem(param,MSG_KEYADD_KEYISVALID);	
	if(IsValid == NULL) return FAIL_RETURN;
	cJSON *KeyName = cJSON_GetObjectItem(param,MSG_KEYADD_KEYNAME);
	if(KeyName == NULL) return FAIL_RETURN;;
	cJSON *KeyEffectiveTime = cJSON_GetObjectItem(param,MSG_KEYADD_KEYEFFECTIVE); 
	if(KeyEffectiveTime == NULL) return FAIL_RETURN;;
	cJSON *KeyExpiryTime = cJSON_GetObjectItem(param,MSG_KEYADD_KEYEXPIRE);
	if(KeyExpiryTime == NULL) return FAIL_RETURN;;
	u64KeyId = get_unique_id();
	sprintf(keyId,"%u",u64KeyId);
	kk_property_update_lockkeys(deviceCode,keyId,KeyType->valueint,KeyRole->valueint,IsValid->valueint,
				KeyName->valuestring,KeyEffectiveTime->valueint,KeyExpiryTime->valueint);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYADD_NOTIFICATION_KEYID,NULL,keyId);		
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYADD_NOTIFICATION_KEYTYPE,&KeyType->valueint,NULL);	
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYADD_NOTIFICATION_KEYROLE,&KeyRole->valueint,NULL);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYADD_NOTIFICATION_KEYISVALID,&IsValid->valueint,NULL);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYADD_NOTIFICATION_KEYNAME,NULL,KeyName->valuestring);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYADD_NOTIFICATION_KEYEFFECTIVE,&IsValid->valueint,NULL);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYADD_NOTIFICATION_KEYEXPIRE,&IsValid->valueint,NULL);

	return SUCCESS_RETURN;
}

static int kk_service_modifyKey_handle(const char *deviceCode,cJSON *param)
{
	int res = 0;
	dm_mgr_dev_node_t *node = NULL;	
	if(deviceCode == NULL || param == NULL){
		return INVALID_PARAMETER;
	}
    res = dm_mgr_get_device_by_devicecode(deviceCode, &node);
    if (res < SUCCESS_RETURN) {
		ERROR_PRINT("dm_mgr_get_device_by_devicecode failed\n");
        return res;
    }
	cJSON *keyId = cJSON_GetObjectItem(param,MSG_KEYADD_KEYID);	
	if(keyId == NULL) return FAIL_RETURN;
	cJSON *KeyType = cJSON_GetObjectItem(param,MSG_KEYADD_KEYTYPE);
	if(KeyType == NULL) return FAIL_RETURN;
	cJSON *KeyRole = cJSON_GetObjectItem(param,MSG_KEYADD_KEYROLE);	
	if(KeyRole == NULL) return FAIL_RETURN;
	cJSON *IsValid = cJSON_GetObjectItem(param,MSG_KEYADD_KEYISVALID);	
	if(IsValid == NULL) return FAIL_RETURN;
	cJSON *KeyName = cJSON_GetObjectItem(param,MSG_KEYADD_KEYNAME);
	if(KeyName == NULL) return FAIL_RETURN;;
	cJSON *KeyEffectiveTime = cJSON_GetObjectItem(param,MSG_KEYADD_KEYEFFECTIVE); 
	if(KeyEffectiveTime == NULL) return FAIL_RETURN;;
	cJSON *KeyExpiryTime = cJSON_GetObjectItem(param,MSG_KEYADD_KEYEXPIRE);
	if(KeyExpiryTime == NULL) return FAIL_RETURN;;

	kk_property_update_lockkeys(deviceCode,keyId->valuestring,KeyType->valueint,KeyRole->valueint,IsValid->valueint,
				KeyName->valuestring,KeyEffectiveTime->valueint,KeyExpiryTime->valueint);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYMODIFY_NOTIFICATION_KEYID,NULL,keyId->valuestring);		
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYMODIFY_NOTIFICATION_KEYTYPE,&KeyType->valueint,NULL);	
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYMODIFY_NOTIFICATION_KEYROLE,&KeyRole->valueint,NULL);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYMODIFY_NOTIFICATION_KEYISVALID,&IsValid->valueint,NULL);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYMODIFY_NOTIFICATION_KEYNAME,NULL,KeyName->valuestring);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYMODIFY_NOTIFICATION_KEYEFFECTIVE,&IsValid->valueint,NULL);
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYMODIFY_NOTIFICATION_KEYEXPIRE,&IsValid->valueint,NULL);

	return SUCCESS_RETURN;
}

static int kk_service_deleteKey_handle(const char *deviceCode,cJSON *param)
{
	int res = 0;
	dm_mgr_dev_node_t *node = NULL;	
	if(deviceCode == NULL || param == NULL){
		return INVALID_PARAMETER;
	}
    res = dm_mgr_get_device_by_devicecode(deviceCode, &node);
    if (res < SUCCESS_RETURN) {
		ERROR_PRINT("dm_mgr_get_device_by_devicecode failed\n");
        return res;
    }
	cJSON *KeyType = cJSON_GetObjectItem(param,MSG_KEYADD_KEYTYPE);
	if(KeyType == NULL) return FAIL_RETURN;
	cJSON *KeyRole = cJSON_GetObjectItem(param,MSG_KEYADD_KEYROLE);	
	if(KeyRole == NULL) return FAIL_RETURN;
	cJSON *keyId = cJSON_GetObjectItem(param,MSG_KEYADD_KEYID);	
	if(keyId == NULL) return FAIL_RETURN;
	kk_property_delete_lockkeys(deviceCode,keyId->valuestring);
	
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYDELETE_NOTIFICATION_KEYID,NULL,keyId->valuestring);		
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYDELETE_NOTIFICATION_KEYTYPE,&KeyType->valueint,NULL);	
	kk_tsl_set_value(kk_tsl_set_event_output_value,node->dev_shadow,MSG_KEYDELETE_NOTIFICATION_KEYROLE,&KeyRole->valueint,NULL);

	return SUCCESS_RETURN;
}

static void _iotx_linkkit_event_callback(iotx_dm_event_types_t type, char *data)
{
    //INFO_PRINT("_iotx_linkkit_event_callback ================== [%s]\n",data);
    char *out;
    int res = 0;
    cJSON *json;
    cJSON *info_root;
    cJSON *payload,*typeJson;
	char *payload_Str = NULL;
    json=cJSON_Parse(data);
	if (json == NULL) {
        WARNING_PRINT("Error before: [%s]\n","cJSON_Parse");
		return;
    }
    info_root = cJSON_GetObjectItem(json, MSG_INFO_STR);
	typeJson = cJSON_GetObjectItem(info_root, MSG_TYPE_STR);
	payload = cJSON_GetObjectItem(json, MSG_PAYLOAD_STR);
	payload_Str = cJSON_Print(payload);

    if (strstr(typeJson->valuestring,KK_REGISTER_TOPIC_REPLY)){
        INFO_PRINT(" topic:register_reply  \n");
        dm_msg_response_payload_t response;
        res = dm_msg_response_parse((char *)payload_Str, strlen(payload->valuestring)+1, &response);
        if (res != SUCCESS_RETURN) {
            goto directReturn;
        }
          
        _iotx_linkkit_upstream_mutex_lock();
        _iotx_linkkit_upstream_callback_remove(atoi(response.id.value), response.code.value_int);
        _iotx_linkkit_upstream_mutex_unlock();

   }else if (strstr(typeJson->valuestring,KK_ADD_TOPIC_REPLY)){
        //====todo======
        //
        INFO_PRINT(" topic:add_reply  \n");
        dm_msg_response_payload_t response;
        res = dm_msg_response_parse((char *)payload_Str, strlen(payload->valuestring)+1, &response);
        if (res != SUCCESS_RETURN) {
            goto directReturn;
        }
          
        _iotx_linkkit_upstream_mutex_lock();
        _iotx_linkkit_upstream_callback_remove(atoi(response.id.value), response.code.value_int);
        _iotx_linkkit_upstream_mutex_unlock();
        
   }else if (strstr(typeJson->valuestring,KK_LOGIN_TOPIC_REPLY)){
        INFO_PRINT(" topic:login_reply  \n");
        dm_msg_response_payload_t response;
        res = dm_msg_response_parse((char *)payload_Str, strlen(payload->valuestring)+1, &response);
        if (res != SUCCESS_RETURN) {
            goto directReturn;
        }
          
        _iotx_linkkit_upstream_mutex_lock();
        _iotx_linkkit_upstream_callback_remove(atoi(response.id.value), response.code.value_int);
        _iotx_linkkit_upstream_mutex_unlock();
   }else if (strstr(typeJson->valuestring,KK_THING_SERVICE_PROPERTY_SET)){
        INFO_PRINT("property set \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);	
        dm_msg_thing_property_set_reply(deviceCode->valuestring,payload_Str, strlen(payload_Str), NULL);
   }else if (strstr(typeJson->valuestring,KK_THING_CLOUDSTATE_MSG)){
        INFO_PRINT("cloud state notify \n");
		s_CloudStatusRecv = 1;
		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
		cJSON *state = cJSON_GetObjectItem(paramStr, MSG_IOTClOUDSTATE_STR);
		s_CloudStatus = atoi(state->valuestring);
		dm_mgr_dev_node_t *node = NULL;
		dm_mgr_search_dev_by_devid(KK_DM_DEVICE_CCU_DEVICEID,&node);
		res = kk_tsl_set_value(kk_tsl_set_property_value,node->dev_shadow,KK_TSL_CCU_WANSTATE_IDENTIFIER,&s_CloudStatus,NULL);
		if(res != SUCCESS_RETURN)
		{
			ERROR_PRINT("[%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		}	
		res = kk_tsl_set_value(kk_tsl_set_property_value,node->dev_shadow,KK_TSL_CCU_IOTCLOUD_IDENTIFIER,&s_CloudStatus,NULL);
		if(res != SUCCESS_RETURN)
		{
			ERROR_PRINT("[%s][%d] res:%d\n",__FUNCTION__,__LINE__,res);
		}		
		kk_property_db_update("CCU_66666");
		if(s_CloudStatus){
			iotx_dm_dev_online(KK_DM_DEVICE_CCU_DEVICEID);//first online,report the online status
			usleep(200000);
			char *payload_property = kk_tsl_get_post_property_str(node->dev_shadow,NULL);
			if(payload_property != NULL){
				dm_mgr_upstream_thing_property_post(node->devid, payload_property, strlen(payload_property),0);
				free(payload_property);
				payload_property = NULL;
			}			
		}
   }else if (strstr(typeJson->valuestring,KK_THING_OTA_DEVICE_UPGRADE)){
        INFO_PRINT("ota upgrade... \n");
        kk_dm_ota_send(data, strlen(data)+1);
        
   }else if(strcmp(typeJson->valuestring,KK_THING_TOPO_CHANGE_MSG) == 0){
   		INFO_PRINT(" topo change  \n");
		kk_topo_delete_handle(payload);

   }else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_REBOOT) == 0){
   		INFO_PRINT(" reboot called!!!\n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);	
		dm_msg_thing_event_post(deviceCode->valuestring,MSG_REBOOT_REBOOTNOTIFICATION);
		sleep(3);
		HAL_Reboot();
   }
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_ADDROOM) == 0){
		INFO_PRINT(" add room!!!\n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
		kk_service_addRoom_handle(deviceCode->valuestring,paramStr);
		dm_msg_thing_event_post(deviceCode->valuestring,MSG_AREA_ADDROOM_NOTIFICATION);
   }
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_DELETEROOM) == 0){
   	    INFO_PRINT(" delete room  \n");
   		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
   		kk_service_deleteRoom_handle(paramStr);

   }
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_ADDDEVICETOROOM) == 0){
   	    INFO_PRINT(" adddevicetoroom  \n");
   		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
   		kk_service_addDeviceToRoom_handle(paramStr);
   }  
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_REMOVEDEVICEFROMROOM) == 0){
   		INFO_PRINT(" removedevicefromroom  \n");
   		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
   		kk_service_removeDeviceFromRoom_handle(paramStr);
   }   
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_EXECUTEROOM) == 0){
   	    INFO_PRINT(" executeroom  \n");
	    cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR); 
	    kk_service_executeRoom_handle(paramStr);

   }
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_SETLOCALTIMER) == 0){
   		INFO_PRINT(" setlocaltimer  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);
		
		kk_service_setLocalTimer_handle(paramStr,deviceCode->valuestring);
   }
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_GETLOCALTIMER) == 0){
   		INFO_PRINT(" getlocaltimer  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
		kk_service_getLocalTimer_handle(deviceCode->valuestring);
   }   
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_SETCOUNTDOWN) == 0){
   		INFO_PRINT(" set count down  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
   		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);
		kk_service_setCountDown_handle(paramStr,deviceCode->valuestring);
   }   
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_GETCOUNTDOWN) == 0){
   		INFO_PRINT(" get count down  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
		kk_service_getCountDown_handle(deviceCode->valuestring);
   }  
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_GETKEYLIST) == 0){
   		INFO_PRINT(" get key list  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
		kk_service_getLockKeylist_handle(deviceCode->valuestring);
   }  
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_ADDKEY) == 0){
   		INFO_PRINT(" add key  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
   		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
		kk_service_addKey_handle(deviceCode->valuestring,paramStr);
		dm_msg_thing_event_post(deviceCode->valuestring,MSG_KEYADD_NOTIFICATION);
   }   
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_MODIFYKEY) == 0){
   		INFO_PRINT(" modify key  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
   		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
		kk_service_modifyKey_handle(deviceCode->valuestring,paramStr);
		dm_msg_thing_event_post(deviceCode->valuestring,MSG_KEYMODIFY_NOTIFICATION);
   }     
   else if(strcmp(typeJson->valuestring,KK_THING_SERVICE_DELETEKEY) == 0){
   		INFO_PRINT(" delete key  \n");
		cJSON *deviceCode = cJSON_GetObjectItem(info_root, MSG_DEVICE_CODE_STR);
   		cJSON *paramStr = cJSON_GetObjectItem(payload, MSG_PARAMS_STR);	
		kk_service_deleteKey_handle(deviceCode->valuestring,paramStr);
		dm_msg_thing_event_post(deviceCode->valuestring,MSG_KEYDELETE_NOTIFICATION);
   }     
   else{
        INFO_PRINT("Error msgtype!!! \n");
        
   }
   
directReturn:
   free(payload_Str);
   cJSON_Delete(json);

            
   
#if 0
    int res = 0;
    void *callback;
#ifdef LOG_REPORT_TO_CLOUD
    lite_cjson_t msg_id;
#endif
    lite_cjson_t lite, lite_item_id, lite_item_devid, lite_item_serviceid, lite_item_payload, lite_item_ctx;
    lite_cjson_t lite_item_code, lite_item_eventid, lite_item_utc, lite_item_rrpcid, lite_item_topo;
    lite_cjson_t lite_item_pk, lite_item_time;
    lite_cjson_t lite_item_version, lite_item_configid, lite_item_configsize, lite_item_gettype, lite_item_sign,
                 lite_item_signmethod, lite_item_url;

    dm_log_info("Receive Message Type: %d", type);
    if (payload) {
        dm_log_info("Receive Message: %s", payload);
        res = dm_utils_json_parse(payload, strlen(payload), cJSON_Invalid, &lite);
        if (res != SUCCESS_RETURN) {
            return;
        }
#ifdef LOG_REPORT_TO_CLOUD
        dm_utils_json_object_item(&lite, "msgid", 5, cJSON_Invalid, &msg_id);
#endif
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_ID, strlen(IOTX_LINKKIT_KEY_ID), cJSON_Invalid, &lite_item_id);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_DEVID, strlen(IOTX_LINKKIT_KEY_DEVID), cJSON_Invalid,
                                  &lite_item_devid);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_SERVICEID, strlen(IOTX_LINKKIT_KEY_SERVICEID), cJSON_Invalid,
                                  &lite_item_serviceid);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_PAYLOAD, strlen(IOTX_LINKKIT_KEY_PAYLOAD), cJSON_Invalid,
                                  &lite_item_payload);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_CTX, strlen(IOTX_LINKKIT_KEY_CTX), cJSON_Invalid, &lite_item_ctx);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_CODE, strlen(IOTX_LINKKIT_KEY_CODE), cJSON_Invalid, &lite_item_code);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_EVENTID, strlen(IOTX_LINKKIT_KEY_EVENTID), cJSON_Invalid,
                                  &lite_item_eventid);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_UTC, strlen(IOTX_LINKKIT_KEY_UTC), cJSON_Invalid, &lite_item_utc);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_RRPCID, strlen(IOTX_LINKKIT_KEY_RRPCID), cJSON_Invalid,
                                  &lite_item_rrpcid);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_TOPO, strlen(IOTX_LINKKIT_KEY_TOPO), cJSON_Invalid,
                                  &lite_item_topo);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_PRODUCT_KEY, strlen(IOTX_LINKKIT_KEY_PRODUCT_KEY), cJSON_Invalid,
                                  &lite_item_pk);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_TIME, strlen(IOTX_LINKKIT_KEY_TIME), cJSON_Invalid,
                                  &lite_item_time);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_VERSION, strlen(IOTX_LINKKIT_KEY_VERSION), cJSON_Invalid,
                                  &lite_item_version);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_CONFIG_ID, strlen(IOTX_LINKKIT_KEY_CONFIG_ID), cJSON_Invalid,
                                  &lite_item_configid);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_CONFIG_SIZE, strlen(IOTX_LINKKIT_KEY_CONFIG_SIZE), cJSON_Invalid,
                                  &lite_item_configsize);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_GET_TYPE, strlen(IOTX_LINKKIT_KEY_GET_TYPE), cJSON_Invalid,
                                  &lite_item_gettype);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_SIGN, strlen(IOTX_LINKKIT_KEY_SIGN), cJSON_Invalid,
                                  &lite_item_sign);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_SIGN_METHOD, strlen(IOTX_LINKKIT_KEY_SIGN_METHOD), cJSON_Invalid,
                                  &lite_item_signmethod);
        dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_URL, strlen(IOTX_LINKKIT_KEY_URL), cJSON_Invalid,
                                  &lite_item_url);

    }

    switch (type) {
        case IOTX_DM_EVENT_CLOUD_CONNECTED: {
            callback = iotx_event_callback(ITE_CONNECT_SUCC);
            if (callback) {
                ((int (*)(void))callback)();
            }
        }
        break;
        case IOTX_DM_EVENT_CLOUD_DISCONNECT: {
            //callback = iotx_event_callback(ITE_DISCONNECTED);
            if (callback) {
                ((int (*)(void))callback)();
            }
        }
        break;
        case IOTX_DM_EVENT_INITIALIZED: {
            if (payload == NULL || lite_item_devid.type != cJSON_Number) {
                return;
            }

            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);

            //callback = iotx_event_callback(ITE_INITIALIZE_COMPLETED);
            if (callback) {
                ((int (*)(const int))callback)(lite_item_devid.value_int);
            }
        }
        break;
        case IOTX_DM_EVENT_MODEL_DOWN_RAW: {
            int raw_data_len = 0;
            unsigned char *raw_data = NULL;

            if (payload == NULL || lite_item_devid.type != cJSON_Number || lite_item_payload.type != cJSON_String) {
                return;
            }

            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current Raw Data: %.*s", lite_item_payload.value_length, lite_item_payload.value);

            raw_data_len = lite_item_payload.value_length / 2;
            raw_data = IMPL_LINKKIT_MALLOC(raw_data_len);
            if (raw_data == NULL) {
                dm_log_err("No Enough Memory");
                return;
            }
            LITE_hexstr_convert(lite_item_payload.value, lite_item_payload.value_length, raw_data, raw_data_len);

            HEXDUMP_DEBUG(raw_data, raw_data_len);
            //callback = iotx_event_callback(ITE_RAWDATA_ARRIVED);
            if (callback) {
                ((int (*)(const int, const unsigned char *, const int))callback)(lite_item_devid.value_int, raw_data, raw_data_len);
            }

            IMPL_LINKKIT_FREE(raw_data);
        }
        break;
        case IOTX_DM_EVENT_MODEL_UP_RAW_REPLY: {
            int raw_data_len = 0;
            unsigned char *raw_data = NULL;

            if (payload == NULL || lite_item_devid.type != cJSON_Number || lite_item_payload.type != cJSON_String) {
                return;
            }

            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current Raw Data: %.*s", lite_item_payload.value_length, lite_item_payload.value);

            raw_data_len = lite_item_payload.value_length / 2;
            raw_data = IMPL_LINKKIT_MALLOC(raw_data_len);
            if (raw_data == NULL) {
                dm_log_err("No Enough Memory");
                return;
            }
            memset(raw_data, 0, raw_data_len);
            LITE_hexstr_convert(lite_item_payload.value, lite_item_payload.value_length, raw_data, raw_data_len);

            HEXDUMP_DEBUG(raw_data, raw_data_len);

            //callback = iotx_event_callback(ITE_RAWDATA_ARRIVED);
            if (callback) {
                ((int (*)(const int, const unsigned char *, const int))callback)(lite_item_devid.value_int, raw_data, raw_data_len);
            }

            IMPL_LINKKIT_FREE(raw_data);
        }
        break;
#if !defined(DEVICE_MODEL_RAWDATA_SOLO)
        case IOTX_DM_EVENT_THING_SERVICE_REQUEST: {
            int response_len = 0;
            char *request = NULL, *response = NULL;

            uintptr_t property_get_ctx_num = 0;
            void *property_get_ctx = NULL;

            if (payload == NULL || lite_item_id.type != cJSON_String || lite_item_devid.type != cJSON_Number ||
                lite_item_serviceid.type != cJSON_String || lite_item_payload.type != cJSON_Object) {
                return;
            }

            dm_log_debug("Current Id: %.*s", lite_item_id.value_length, lite_item_id.value);
            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current ServiceID: %.*s", lite_item_serviceid.value_length, lite_item_serviceid.value);
            dm_log_debug("Current Payload: %.*s", lite_item_payload.value_length, lite_item_payload.value);
            dm_log_debug("Current Ctx: %.*s", lite_item_ctx.value_length, lite_item_ctx.value);

            LITE_hexstr_convert(lite_item_ctx.value, lite_item_ctx.value_length, (unsigned char *)&property_get_ctx_num,
                                sizeof(uintptr_t));
            property_get_ctx = (void *)property_get_ctx_num;

            request = IMPL_LINKKIT_MALLOC(lite_item_payload.value_length + 1);
            if (request == NULL) {
                dm_log_err("Not Enough Memory");
                return;
            }
            memset(request, 0, lite_item_payload.value_length + 1);
            memcpy(request, lite_item_payload.value, lite_item_payload.value_length);

            //callback = iotx_event_callback(ITE_SERVICE_REQUEST);
            if (callback) {
                res = ((int (*)(const int, const char *, const int, const char *, const int, char **,
                                int *))callback)(lite_item_devid.value_int, lite_item_serviceid.value,
                                                 lite_item_serviceid.value_length, request, lite_item_payload.value_length, &response, &response_len);
                if (response != NULL && response_len > 0) {
                    /* service response exist */
                    iotx_dm_error_code_t code = (res == 0) ? (IOTX_DM_ERR_CODE_SUCCESS) : (IOTX_DM_ERR_CODE_REQUEST_ERROR);
                    iotx_dm_send_service_response(lite_item_devid.value_int, lite_item_id.value, lite_item_id.value_length, code,
                                                  lite_item_serviceid.value,
                                                  lite_item_serviceid.value_length,
                                                  response, response_len, property_get_ctx);
                    HAL_Free(response);
                }
            }
#ifdef ALCS_ENABLED
            if (property_get_ctx) {
                dm_server_free_context(property_get_ctx);
            }
#endif
            IMPL_LINKKIT_FREE(request);
        }
        break;
        case IOTX_DM_EVENT_PROPERTY_SET: {
            char *property_payload = NULL;

            if (payload == NULL || lite_item_devid.type != cJSON_Number || lite_item_payload.type != cJSON_Object) {
                return;
            }

            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current Payload: %.*s", lite_item_payload.value_length, lite_item_payload.value);

            property_payload = IMPL_LINKKIT_MALLOC(lite_item_payload.value_length + 1);
            if (property_payload == NULL) {
                dm_log_err("No Enough Memory");
                return;
            }
            memset(property_payload, 0, lite_item_payload.value_length + 1);
            memcpy(property_payload, lite_item_payload.value, lite_item_payload.value_length);
#ifdef LOG_REPORT_TO_CLOUD
            if (SUCCESS_RETURN == check_target_msg(msg_id.value, msg_id.value_length)) {
                report_sample = 1;
                send_permance_info(msg_id.value, msg_id.value_length, "3", 1);
            }
#endif
            //callback = iotx_event_callback(ITE_PROPERTY_SET);
            if (callback) {
                ((int (*)(const int, const char *, const int))callback)(lite_item_devid.value_int, property_payload,
                        lite_item_payload.value_length);
            }
#ifdef LOG_REPORT_TO_CLOUD
            if (1 == report_sample) {
                send_permance_info(NULL, 0, "5", 2);
                report_sample = 0;
            }
#endif

            IMPL_LINKKIT_FREE(property_payload);
        }
        break;
#ifdef DEVICE_MODEL_SHADOW
        case IOTX_DM_EVENT_PROPERTY_DESIRED_GET_REPLY: {
            char *property_data = NULL;
            lite_cjson_t lite_item_data;

            memset(&lite_item_data, 0, sizeof(lite_cjson_t));
            dm_utils_json_object_item(&lite, IOTX_LINKKIT_KEY_DATA, strlen(IOTX_LINKKIT_KEY_DATA), cJSON_Invalid,
                                      &lite_item_data);
            if (payload == NULL || lite_item_data.type != cJSON_Object) {
                return;
            }
            dm_log_debug("Current Data: %.*s", lite_item_data.value_length, lite_item_data.value);

            property_data = IMPL_LINKKIT_MALLOC(lite_item_data.value_length + 1);
            if (property_data == NULL) {
                dm_log_err("No Enough Memory");
                return;
            }
            memset(property_data, 0, lite_item_data.value_length + 1);
            memcpy(property_data, lite_item_data.value, lite_item_data.value_length);

            //callback = iotx_event_callback(ITE_PROPERTY_DESIRED_GET_REPLY);
            if (callback) {
                ((int (*)(const char *, const int))callback)(property_data,
                        lite_item_data.value_length);
            }

            IMPL_LINKKIT_FREE(property_data);
        }
        break;
#endif
        case IOTX_DM_EVENT_PROPERTY_GET: {
            int response_len = 0;
            char *request = NULL, *response = NULL;
            uintptr_t property_get_ctx_num = 0;
            void *property_get_ctx = NULL;

            if (payload == NULL || lite_item_id.type != cJSON_String || lite_item_devid.type != cJSON_Number ||
                lite_item_payload.type != cJSON_Array) {
                return;
            }

            dm_log_debug("Current Id: %.*s", lite_item_id.value_length, lite_item_id.value);
            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current Payload: %.*s", lite_item_payload.value_length, lite_item_payload.value);
            dm_log_debug("Current Ctx: %.*s", lite_item_ctx.value_length, lite_item_ctx.value);

            LITE_hexstr_convert(lite_item_ctx.value, lite_item_ctx.value_length, (unsigned char *)&property_get_ctx_num,
                                sizeof(uintptr_t));
            property_get_ctx = (void *)property_get_ctx_num;
            dm_log_debug("property_get_ctx_num: %0x016llX", (unsigned int)property_get_ctx_num);
            dm_log_debug("property_get_ctx: %p", property_get_ctx);

            request = IMPL_LINKKIT_MALLOC(lite_item_payload.value_length + 1);
            if (request == NULL) {
                dm_log_err("No Enough Memory");
                return;
            }
            memset(request, 0, lite_item_payload.value_length + 1);
            memcpy(request, lite_item_payload.value, lite_item_payload.value_length);

            //callback = iotx_event_callback(ITE_PROPERTY_GET);
            if (callback) {
                res = ((int (*)(const int, const char *, const int, char **, int *))callback)(lite_item_devid.value_int, request,
                        lite_item_payload.value_length, &response, &response_len);

                if (response != NULL && response_len > 0) {
                    /* property get response exist */
                    iotx_dm_error_code_t code = (res == 0) ? (IOTX_DM_ERR_CODE_SUCCESS) : (IOTX_DM_ERR_CODE_REQUEST_ERROR);
                    iotx_dm_send_property_get_response(lite_item_devid.value_int, lite_item_id.value, lite_item_id.value_length, code,
                                                       response, response_len, property_get_ctx);
                    HAL_Free(response);
                }
            }

            IMPL_LINKKIT_FREE(request);
        }
        break;
        case IOTX_DM_EVENT_EVENT_PROPERTY_POST_REPLY:
        case IOTX_DM_EVENT_DEVICEINFO_UPDATE_REPLY:
#ifdef DEVICE_MODEL_SHADOW
        case IOTX_DM_EVENT_PROPERTY_DESIRED_DELETE_REPLY:
#endif
        case IOTX_DM_EVENT_DEVICEINFO_DELETE_REPLY: {
            char *user_payload = NULL;
            int user_payload_length = 0;

            if (payload == NULL || lite_item_id.type != cJSON_Number || lite_item_code.type != cJSON_Number
                || lite_item_devid.type != cJSON_Number) {
                return;
            }
            dm_log_debug("Current Id: %d", lite_item_id.value_int);
            dm_log_debug("Current Code: %d", lite_item_code.value_int);
            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);

            if (lite_item_payload.type == cJSON_Object && lite_item_payload.value_length > 0) {
                user_payload = IMPL_LINKKIT_MALLOC(lite_item_payload.value_length + 1);
                if (user_payload == NULL) {
                    dm_log_err("No Enough Memory");
                    return;
                }
                memset(user_payload, 0, lite_item_payload.value_length + 1);
                memcpy(user_payload, lite_item_payload.value, lite_item_payload.value_length);
                user_payload_length = lite_item_payload.value_length;
            }

            //callback = iotx_event_callback(ITE_REPORT_REPLY);
            if (callback) {
                ((int (*)(const int, const int, const int, const char *, const int))callback)(lite_item_devid.value_int,
                        lite_item_id.value_int, lite_item_code.value_int, user_payload,
                        user_payload_length);
            }

            if (user_payload) {
                IMPL_LINKKIT_FREE(user_payload);
            }
        }
        break;
        case IOTX_DM_EVENT_EVENT_SPECIFIC_POST_REPLY: {
            char *user_eventid = NULL;
            char *user_payload = NULL;

            if (payload == NULL || lite_item_id.type != cJSON_Number || lite_item_code.type != cJSON_Number ||
                lite_item_devid.type != cJSON_Number || lite_item_eventid.type != cJSON_String
                || lite_item_payload.type != cJSON_String) {
                return;
            }

            dm_log_debug("Current Id: %d", lite_item_id.value_int);
            dm_log_debug("Current Code: %d", lite_item_code.value_int);
            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current EventID: %.*s", lite_item_eventid.value_length, lite_item_eventid.value);
            dm_log_debug("Current Message: %.*s", lite_item_payload.value_length, lite_item_payload.value);

            user_eventid = IMPL_LINKKIT_MALLOC(lite_item_eventid.value_length + 1);
            if (user_eventid == NULL) {
                dm_log_err("Not Enough Memory");
                return;
            }
            memset(user_eventid, 0, lite_item_eventid.value_length + 1);
            memcpy(user_eventid, lite_item_eventid.value, lite_item_eventid.value_length);

            user_payload = IMPL_LINKKIT_MALLOC(lite_item_payload.value_length + 1);
            if (user_payload == NULL) {
                dm_log_err("Not Enough Memory");
                IMPL_LINKKIT_FREE(user_eventid);
                return;
            }
            memset(user_payload, 0, lite_item_payload.value_length + 1);
            memcpy(user_payload, lite_item_payload.value, lite_item_payload.value_length);


            //callback = iotx_event_callback(ITE_TRIGGER_EVENT_REPLY);
            if (callback) {
                ((int (*)(const int, const int, const int, const char *, const int, const char *,
                          const int))callback)(lite_item_devid.value_int,
                                               lite_item_id.value_int, lite_item_code.value_int,
                                               user_eventid, lite_item_eventid.value_length, user_payload, lite_item_payload.value_length);
            }

            IMPL_LINKKIT_FREE(user_eventid);
            IMPL_LINKKIT_FREE(user_payload);
        }
        break;
        case IOTX_DM_EVENT_NTP_RESPONSE: {
            char *utc_payload = NULL;

            if (payload == NULL || lite_item_utc.type != cJSON_String) {
                return;
            }

            dm_log_debug("Current UTC: %.*s", lite_item_utc.value_length, lite_item_utc.value);

            utc_payload = IMPL_LINKKIT_MALLOC(lite_item_utc.value_length + 1);
            if (utc_payload == NULL) {
                dm_log_err("Not Enough Memory");
                return;
            }
            memset(utc_payload, 0, lite_item_utc.value_length + 1);
            memcpy(utc_payload, lite_item_utc.value, lite_item_utc.value_length);

            //callback = iotx_event_callback(ITE_TIMESTAMP_REPLY);
            if (callback) {
                ((int (*)(const char *))callback)(utc_payload);
            }

            IMPL_LINKKIT_FREE(utc_payload);
        }
        break;
        case IOTX_DM_EVENT_RRPC_REQUEST: {
            int rrpc_response_len = 0;
            char *rrpc_request = NULL, *rrpc_response = NULL;

            if (payload == NULL || lite_item_id.type != cJSON_String || lite_item_devid.type != cJSON_Number ||
                lite_item_serviceid.type != cJSON_String || lite_item_rrpcid.type != cJSON_String
                || lite_item_payload.type != cJSON_Object) {
                return;
            }

            dm_log_debug("Current Id: %.*s", lite_item_id.value_length, lite_item_id.value);
            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current ServiceID: %.*s", lite_item_serviceid.value_length, lite_item_serviceid.value);
            dm_log_debug("Current RRPC ID: %.*s", lite_item_rrpcid.value_length, lite_item_rrpcid.value);
            dm_log_debug("Current Payload: %.*s", lite_item_payload.value_length, lite_item_payload.value);

            rrpc_request = IMPL_LINKKIT_MALLOC(lite_item_payload.value_length + 1);
            if (rrpc_request == NULL) {
                dm_log_err("Not Enough Memory");
                return;
            }
            memset(rrpc_request, 0, lite_item_payload.value_length + 1);
            memcpy(rrpc_request, lite_item_payload.value, lite_item_payload.value_length);

            //callback = iotx_event_callback(ITE_SERVICE_REQUEST);
            if (callback) {
                res = ((int (*)(const int, const char *, const int, const char *, const int, char **,
                                int *))callback)(lite_item_devid.value_int, lite_item_serviceid.value,
                                                 lite_item_serviceid.value_length,
                                                 rrpc_request, lite_item_payload.value_length, &rrpc_response, &rrpc_response_len);
                if (rrpc_response != NULL && rrpc_response_len > 0) {
                    iotx_dm_error_code_t code = (res == 0) ? (IOTX_DM_ERR_CODE_SUCCESS) : (IOTX_DM_ERR_CODE_REQUEST_ERROR);
                    iotx_dm_send_rrpc_response(lite_item_devid.value_int, lite_item_id.value, lite_item_id.value_length, code,
                                               lite_item_rrpcid.value,
                                               lite_item_rrpcid.value_length,
                                               rrpc_response, rrpc_response_len);
                    HAL_Free(rrpc_response);
                }
            }

            IMPL_LINKKIT_FREE(rrpc_request);
        }
        break;
#endif
        case IOTX_DM_EVENT_FOTA_NEW_FIRMWARE: {
            char *version = NULL;

            if (payload == NULL || lite_item_version.type != cJSON_String) {
                return;
            }

            dm_log_debug("Current Firmware Version: %.*s", lite_item_version.value_length, lite_item_version.value);

            version = IMPL_LINKKIT_MALLOC(lite_item_version.value_length + 1);
            if (version == NULL) {
                return;
            }
            memset(version, 0, lite_item_version.value_length + 1);
            memcpy(version, lite_item_version.value, lite_item_version.value_length);

            //callback = iotx_event_callback(ITE_FOTA);
            if (callback) {
                ((int (*)(const int, const char *))callback)(0, version);
            }

            if (version) {
                IMPL_LINKKIT_FREE(version);
            }
        }
        break;
        case IOTX_DM_EVENT_COTA_NEW_CONFIG: {
            char *config_id = NULL, *get_type = NULL, *sign = NULL, *sign_method = NULL, *url = NULL;

            if (payload == NULL || lite_item_configid.type != cJSON_String || lite_item_configsize.type != cJSON_Number ||
                lite_item_gettype.type != cJSON_String || lite_item_sign.type != cJSON_String
                || lite_item_signmethod.type != cJSON_String ||
                lite_item_url.type != cJSON_String) {
                return;
            }

            dm_log_debug("Current Config ID: %.*s", lite_item_configid.value_length, lite_item_configid.value);
            dm_log_debug("Current Config Size: %d", lite_item_configsize.value_int);
            dm_log_debug("Current Get Type: %.*s", lite_item_gettype.value_length, lite_item_gettype.value);
            dm_log_debug("Current Sign: %.*s", lite_item_sign.value_length, lite_item_sign.value);
            dm_log_debug("Current Sign Method: %.*s", lite_item_signmethod.value_length, lite_item_signmethod.value);
            dm_log_debug("Current URL: %.*s", lite_item_url.value_length, lite_item_url.value);

            _impl_copy(lite_item_configid.value, lite_item_configid.value_length, (void **)&config_id,
                       lite_item_configid.value_length + 1);
            _impl_copy(lite_item_gettype.value, lite_item_gettype.value_length, (void **)&get_type,
                       lite_item_gettype.value_length + 1);
            _impl_copy(lite_item_sign.value, lite_item_sign.value_length, (void **)&sign, lite_item_sign.value_length + 1);
            _impl_copy(lite_item_signmethod.value, lite_item_signmethod.value_length, (void **)&sign_method,
                       lite_item_signmethod.value_length + 1);
            _impl_copy(lite_item_url.value, lite_item_url.value_length, (void **)&url, lite_item_url.value_length + 1);

            if (config_id == NULL || get_type == NULL || sign == NULL || sign_method == NULL || url == NULL) {
                if (config_id) {
                    IMPL_LINKKIT_FREE(config_id);
                }
                if (get_type) {
                    IMPL_LINKKIT_FREE(get_type);
                }
                if (sign) {
                    IMPL_LINKKIT_FREE(sign);
                }
                if (sign_method) {
                    IMPL_LINKKIT_FREE(sign_method);
                }
                if (url) {
                    IMPL_LINKKIT_FREE(url);
                }
                return;
            }

            //callback = iotx_event_callback(ITE_COTA);
            if (callback) {
                ((int (*)(const int, const char *, int, const char *, const char *, const char *, const char *))callback)(0, config_id,
                        lite_item_configsize.value_int, get_type, sign, sign_method, url);
            }

            if (config_id) {
                IMPL_LINKKIT_FREE(config_id);
            }
            if (get_type) {
                IMPL_LINKKIT_FREE(get_type);
            }
            if (sign) {
                IMPL_LINKKIT_FREE(sign);
            }
            if (sign_method) {
                IMPL_LINKKIT_FREE(sign_method);
            }
            if (url) {
                IMPL_LINKKIT_FREE(url);
            }
        }
        break;
#ifdef 1//DEVICE_MODEL_GATEWAY
        case IOTX_DM_EVENT_TOPO_GET_REPLY: {
            char *topo_list = NULL;

            if (payload == NULL || lite_item_id.type != cJSON_Number || lite_item_devid.type != cJSON_Number ||
                lite_item_code.type != cJSON_Number || lite_item_topo.type != cJSON_Array) {
                return;
            }
            dm_log_debug("Current Id: %d", lite_item_id.value_int);
            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);
            dm_log_debug("Current Code: %d", lite_item_code.value_int);
            dm_log_debug("Current Topo List: %.*s", lite_item_topo.value_length, lite_item_topo.value);

            topo_list = IMPL_LINKKIT_MALLOC(lite_item_topo.value_length + 1);
            if (topo_list == NULL) {
                dm_log_err("Not Enough Memory");
                return;
            }
            memset(topo_list, 0, lite_item_topo.value_length + 1);
            memcpy(topo_list, lite_item_topo.value, lite_item_topo.value_length);

            //callback = iotx_event_callback(ITE_TOPOLIST_REPLY);
            if (callback) {
                ((int (*)(const int, const int, const int, const char *, const int))callback)(lite_item_devid.value_int,
                        lite_item_id.value_int,
                        lite_item_code.value_int, topo_list, lite_item_topo.value_length);
            }

            IMPL_LINKKIT_FREE(topo_list);
        }
        break;
        case IOTX_DM_EVENT_TOPO_DELETE_REPLY:
        case IOTX_DM_EVENT_TOPO_ADD_REPLY:
        case IOTX_DM_EVENT_SUBDEV_REGISTER_REPLY:
        case IOTX_DM_EVENT_COMBINE_LOGIN_REPLY:
        case IOTX_DM_EVENT_COMBINE_LOGOUT_REPLY: {
            if (payload == NULL || lite_item_id.type != cJSON_Number || lite_item_devid.type != cJSON_Number ||
                lite_item_code.type != cJSON_Number) {
                return;
            }
            dm_log_debug("Current Id: %d", lite_item_id.value_int);
            dm_log_debug("Current Code: %d", lite_item_code.value_int);
            dm_log_debug("Current Devid: %d", lite_item_devid.value_int);

            _iotx_linkkit_upstream_mutex_lock();
            _iotx_linkkit_upstream_callback_remove(lite_item_id.value_int, lite_item_code.value_int);
            _iotx_linkkit_upstream_mutex_unlock();
        }
        break;
        case IOTX_DM_EVENT_GATEWAY_PERMIT: {
            char *product_key = "";

            if (payload == NULL || lite_item_time.type != cJSON_Number) {
                return;
            }
            dm_log_debug("Current Time: %d", lite_item_time.value_int);

            if (lite_item_pk.type == cJSON_String) {
                dm_log_debug("Current Product Key: %.*s", lite_item_pk.value_length, lite_item_pk.value);
                product_key = IMPL_LINKKIT_MALLOC(lite_item_pk.value_length + 1);
                if (product_key == NULL) {
                    dm_log_err("Not Enough Memory");
                    return;
                }
                memset(product_key, 0, lite_item_pk.value_length + 1);
                memcpy(product_key, lite_item_pk.value, lite_item_pk.value_length);
            }

            //callback = iotx_event_callback(ITE_PERMIT_JOIN);
            if (callback) {
                ((int (*)(const char *, int))callback)((const char *)product_key, (const int)lite_item_time.value_int);
            }

            if (lite_item_pk.type == cJSON_String) {
                IMPL_LINKKIT_FREE(product_key);
            }
        }
        break;
#endif
        default: {
        }
        break;
    }
#endif    
}

int kk_init_dmproc(){
    int res = 0;
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    res = iotx_dm_open();
    if (res != SUCCESS_RETURN) {
        dm_log_err("DM iotx_dm_open Failed");

        return FAIL_RETURN;
    }

    res = iotx_dm_connect(_iotx_linkkit_event_callback);
    if (res != SUCCESS_RETURN) {
        dm_log_err("DM Start Failed");
        //ctx->is_connected = 0;
        return FAIL_RETURN;
    }
    
    if (ctx->is_opened) {
        return FAIL_RETURN;
    }
    ctx->is_opened = 1;


    /* Create Mutex */
    ctx->mutex = HAL_MutexCreate();
    if (ctx->mutex == NULL) {
        dm_log_err("Not Enough Memory");
        ctx->is_opened = 0;
        return FAIL_RETURN;
    }


    ctx->upstream_mutex = HAL_MutexCreate();
    if (ctx->upstream_mutex == NULL) {
        HAL_MutexDestroy(ctx->mutex);
        dm_log_err("Not Enough Memory");
        ctx->is_opened = 0;
        return FAIL_RETURN;
    }


    INIT_LIST_HEAD(&ctx->upstream_sync_callback_list);

    return SUCCESS_RETURN;
}

int _iotx_linkkit_slave_connect(int devid)
{
    int res = 0, msgid = 0, code = 0;
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    iotx_linkkit_upstream_sync_callback_node_t *node = NULL;
    void *semaphore = NULL;

    /*if (ctx->is_connected == 0) {
        dm_log_err("master isn't start");
        return FAIL_RETURN;
    }*/


    if (devid <= 0) {
        dm_log_err("devid invalid");
        return FAIL_RETURN;
    }


    /* Subdev Register */
    /*res = kk_dm_subdev_register(devid);
    if (res < SUCCESS_RETURN) {
        return FAIL_RETURN;
    }*/
    
#if 0
    if (res > SUCCESS_RETURN) {
        semaphore = HAL_SemaphoreCreate();
        if (semaphore == NULL) {
            return FAIL_RETURN;
        }
        msgid = res;

        _iotx_linkkit_upstream_mutex_lock();
        res = _iotx_linkkit_upstream_sync_callback_list_insert(msgid, semaphore, &node);
        if (res != SUCCESS_RETURN) {
            HAL_SemaphoreDestroy(semaphore);
            _iotx_linkkit_upstream_mutex_unlock();
            return FAIL_RETURN;
        }
        
        _iotx_linkkit_upstream_mutex_unlock();
        res = HAL_SemaphoreWait(semaphore, IOTX_LINKKIT_SYNC_DEFAULT_TIMEOUT_MS);
        if (res < SUCCESS_RETURN) {
            _iotx_linkkit_upstream_mutex_lock();
            _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
            _iotx_linkkit_upstream_mutex_unlock();
            return FAIL_RETURN;
        }

        _iotx_linkkit_upstream_mutex_lock();
        code = node->code;
        _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
        if (code != SUCCESS_RETURN) {
            _iotx_linkkit_upstream_mutex_unlock();
            return FAIL_RETURN;
        }

        _iotx_linkkit_upstream_mutex_unlock();
    }
#endif

    /* Subdev Add Topo */
    res = kk_dm_subdev_topo_add(devid);
    if (res < SUCCESS_RETURN) {
        _iotx_linkkit_mutex_unlock();
        return FAIL_RETURN;
    }

#if 0
    semaphore = HAL_SemaphoreCreate();
    if (semaphore == NULL) {
        _iotx_linkkit_mutex_unlock();
        return FAIL_RETURN;
    }

    msgid = res;
    _iotx_linkkit_upstream_mutex_lock();
    res = _iotx_linkkit_upstream_sync_callback_list_insert(msgid, semaphore, &node);
    if (res != SUCCESS_RETURN) {
        HAL_SemaphoreDestroy(semaphore);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();

    res = HAL_SemaphoreWait(semaphore, IOTX_LINKKIT_SYNC_DEFAULT_TIMEOUT_MS);
    if (res < SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_lock();
        _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }

    _iotx_linkkit_upstream_mutex_lock();
    code = node->code;
    _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
    if (code != SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();
#endif

    return SUCCESS_RETURN;
}

static int _iotx_linkkit_subdev_delete_topo(int devid)
{
    int res = 0, msgid = 0, code = 0;
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();
    iotx_linkkit_upstream_sync_callback_node_t *node = NULL;
    void *semaphore = NULL;

    if (ctx->is_connected == 0) {
        dm_log_err("master isn't start");
        return FAIL_RETURN;
    }

    if (devid <= 0) {
        dm_log_err("devid invalid");
        return FAIL_RETURN;
    }

    /* Subdev Delete Topo */
    res = iotx_dm_subdev_topo_del(devid);
    if (res < SUCCESS_RETURN) {
        return FAIL_RETURN;
    }
    msgid = res;

    semaphore = HAL_SemaphoreCreate();
    if (semaphore == NULL) {
        return FAIL_RETURN;
    }

    _iotx_linkkit_upstream_mutex_lock();
    res = _iotx_linkkit_upstream_sync_callback_list_insert(msgid, semaphore, &node);
    if (res != SUCCESS_RETURN) {
        HAL_SemaphoreDestroy(semaphore);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();

    res = HAL_SemaphoreWait(semaphore, IOTX_LINKKIT_SYNC_DEFAULT_TIMEOUT_MS);
    if (res < SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_lock();
        _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }

    _iotx_linkkit_upstream_mutex_lock();
    code = node->code;
    _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
    if (code != SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();

    return SUCCESS_RETURN;
}

static int _iotx_linkkit_master_close(void)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    _iotx_linkkit_mutex_lock();
    if (ctx->is_opened == 0) {
        _iotx_linkkit_mutex_unlock();
        return FAIL_RETURN;
    }
    ctx->is_opened = 0;

    //iotx_dm_close();
#if 1//DEVICE_MODEL_GATEWAY
    _iotx_linkkit_upstream_sync_callback_list_destroy();
    HAL_MutexDestroy(ctx->upstream_mutex);
#endif
    _iotx_linkkit_mutex_unlock();
    HAL_MutexDestroy(ctx->mutex);
    memset(ctx, 0, sizeof(iotx_linkkit_ctx_t));

    return SUCCESS_RETURN;
}

#if 1//DEVICE_MODEL_GATEWAY
static int _iotx_linkkit_slave_close(int devid)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    _iotx_linkkit_mutex_lock();
    if (ctx->is_opened == 0) {
        _iotx_linkkit_mutex_unlock();
        return FAIL_RETURN;
    }

    /* Release Subdev Resources */
    //iotx_dm_subdev_destroy(devid);

    _iotx_linkkit_mutex_unlock();

    return SUCCESS_RETURN;
}
#endif

/*int IOT_Linkkit_Open(iotx_linkkit_dev_type_t dev_type, iotx_linkkit_dev_meta_info_t *meta_info)
{
    int res = 0;

    if (dev_type < 0 || dev_type >= IOTX_LINKKIT_DEV_TYPE_MAX || meta_info == NULL) {
        dm_log_err("Invalid Parameter");
        return FAIL_RETURN;
    }

    switch (dev_type) {
        case IOTX_LINKKIT_DEV_TYPE_MASTER: {
            res = _iotx_linkkit_master_open(meta_info);
            if (res == SUCCESS_RETURN) {
                res = IOTX_DM_LOCAL_NODE_DEVID;
            }
        }
        break;
        case IOTX_LINKKIT_DEV_TYPE_SLAVE: {
#if 1//DEVICE_MODEL_GATEWAY
            res = _iotx_linkkit_slave_open(meta_info);
#else
            res = FAIL_RETURN;
#endif
        }
        break;
        default: {
            dm_log_err("Unknown Device Type");
            res = FAIL_RETURN;
        }
        break;
    }

    return res;
}*/

/*int IOT_Linkkit_Connect(int devid)
{
    int res = 0;
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    if (devid < 0) {
        dm_log_err("Invalid Parameter");
        return FAIL_RETURN;
    }

    if (ctx->is_opened == 0) {

        return FAIL_RETURN;
    }

    _iotx_linkkit_mutex_lock();

    if (devid == IOTX_DM_LOCAL_NODE_DEVID) {
        res = _iotx_linkkit_master_connect();
    } else {
        res = _iotx_linkkit_slave_connect(devid);

    }
    _iotx_linkkit_mutex_unlock();

    return res;
}*/

void IOT_Linkkit_Yield(int timeout_ms)
{
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    if (timeout_ms <= 0) {
        dm_log_err("Invalid Parameter");
        return;
    }

    //if (ctx->is_opened == 0 || ctx->is_connected == 0) {
    //    return;
    //}

    //iotx_dm_yield(timeout_ms);
    iotx_dm_dispatch();

#if 1//DEVICE_MODEL_GATEWAY
    HAL_SleepMs(timeout_ms);
#endif
}

int IOT_Linkkit_Close(int devid)
{
    int res = 0;

    if (devid < 0) {
        dm_log_err("Invalid Parameter");
        return FAIL_RETURN;
    }

    if (devid == IOTX_DM_LOCAL_NODE_DEVID) {
        res = _iotx_linkkit_master_close();
#ifdef DEV_BIND_ENABLED
        awss_bind_deinit();
#endif
    } else {
#if 1//DEVICE_MODEL_GATEWAY
        res = _iotx_linkkit_slave_close(devid);
#else
        res = FAIL_RETURN;
#endif
    }

    return res;
}

#if 1//DEVICE_MODEL_GATEWAY
static int _iotx_linkkit_subdev_login(int devid)
{
    int res = 0, msgid = 0, code = 0;
    iotx_linkkit_upstream_sync_callback_node_t *node = NULL;
    void *semaphore = NULL;
    void *callback = NULL;

    res = iotx_dm_dev_online(devid);//iotx_dm_subdev_login(devid);
    if (res < SUCCESS_RETURN) {
        return FAIL_RETURN;
    }

#ifdef MSG_NEED_RESP
    msgid = res;
    semaphore = HAL_SemaphoreCreate();
    if (semaphore == NULL) {
        return FAIL_RETURN;
    }

    _iotx_linkkit_upstream_mutex_lock();
    res = _iotx_linkkit_upstream_sync_callback_list_insert(msgid, semaphore, &node);
    if (res != SUCCESS_RETURN) {
        HAL_SemaphoreDestroy(semaphore);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();

    res = HAL_SemaphoreWait(semaphore, IOTX_LINKKIT_SYNC_DEFAULT_TIMEOUT_MS);
    if (res < SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_lock();
        _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }

    _iotx_linkkit_upstream_mutex_lock();
    code = node->code;
    _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
    if (code != SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();
#endif
     
    res = iotx_dm_subscribe(devid);
    if (res != SUCCESS_RETURN) {
        return FAIL_RETURN;
    }

    /*iotx_dm_send_aos_active(devid);
    callback = iotx_event_callback(ITE_INITIALIZE_COMPLETED);
    if (callback) {
        ((int (*)(const int))callback)(devid);
    }*/

    return res;
}

static int _iotx_linkkit_subdev_logout(int devid)
{
    int res = 0, msgid = 0, code = 0;
    iotx_linkkit_upstream_sync_callback_node_t *node = NULL;
    void *semaphore = NULL;

    res = iotx_dm_subdev_logout(devid);
    if (res < SUCCESS_RETURN) {
        return FAIL_RETURN;
    }

    msgid = res;
    semaphore = HAL_SemaphoreCreate();
    if (semaphore == NULL) {
        return FAIL_RETURN;
    }

    _iotx_linkkit_upstream_mutex_lock();
    res = _iotx_linkkit_upstream_sync_callback_list_insert(msgid, semaphore, &node);
    if (res != SUCCESS_RETURN) {
        HAL_SemaphoreDestroy(semaphore);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();

    res = HAL_SemaphoreWait(semaphore, IOTX_LINKKIT_SYNC_DEFAULT_TIMEOUT_MS);
    if (res < SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_lock();
        _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }

    _iotx_linkkit_upstream_mutex_lock();
    code = node->code;
    _iotx_linkkit_upstream_sync_callback_list_remove(msgid);
    if (code != SUCCESS_RETURN) {
        _iotx_linkkit_upstream_mutex_unlock();
        return FAIL_RETURN;
    }
    _iotx_linkkit_upstream_mutex_unlock();

    return res;
}
#endif

/*int IOT_Linkkit_Report(int devid, iotx_linkkit_msg_type_t msg_type, unsigned char *payload, int payload_len)
{
    int res = 0;
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    if (devid < 0 || msg_type < 0 || msg_type >= IOTX_LINKKIT_MSG_MAX) {
        dm_log_err("Invalid Parameter");
        return FAIL_RETURN;
    }

    if (ctx->is_opened == 0 || ctx->is_connected == 0) {
        return FAIL_RETURN;
    }

    _iotx_linkkit_mutex_lock();
    switch (msg_type) {
#if !defined(DEVICE_MODEL_RAWDATA_SOLO)
        case ITM_MSG_POST_PROPERTY: {
            if (payload == NULL || payload_len <= 0) {
                dm_log_err("Invalid Parameter");
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
            res = iotx_dm_post_property(devid, (char *)payload, payload_len);
#ifdef LOG_REPORT_TO_CLOUD
            if (1 == report_sample) {
                send_permance_info(NULL, 0, "4", 1);
            }
#endif
        }
        break;
#ifdef DEVICE_MODEL_SHADOW
        case ITM_MSG_PROPERTY_DESIRED_GET: {
            if (payload == NULL || payload_len <= 0) {
                dm_log_err("Invalid Parameter");
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
            res = iotx_dm_property_desired_get(devid, (char *)payload, payload_len);
        }
        break;
        case ITM_MSG_PROPERTY_DESIRED_DELETE: {
            if (payload == NULL || payload_len <= 0) {
                dm_log_err("Invalid Parameter");
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
            res = iotx_dm_property_desired_delete(devid, (char *)payload, payload_len);
        }
        break;
#endif
        case ITM_MSG_DEVICEINFO_UPDATE: {
            if (payload == NULL || payload_len <= 0) {
                dm_log_err("Invalid Parameter");
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
            res = iotx_dm_deviceinfo_update(devid, (char *)payload, payload_len);
        }
        break;
        case ITM_MSG_DEVICEINFO_DELETE: {
            if (payload == NULL || payload_len <= 0) {
                dm_log_err("Invalid Parameter");
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
            res = iotx_dm_deviceinfo_delete(devid, (char *)payload, payload_len);
        }
        break;
#endif
        case ITM_MSG_POST_RAW_DATA: {
            if (payload == NULL || payload_len <= 0) {
                dm_log_err("Invalid Parameter");
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
            res = iotx_dm_post_rawdata(devid, (char *)payload, payload_len);
        }
        break;
        case ITM_MSG_LOGIN: {
#if 1//DEVICE_MODEL_GATEWAY
            res = _iotx_linkkit_subdev_login(devid);
            if (res != SUCCESS_RETURN) {
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
#else
            res = FAIL_RETURN;
#endif
        }
        break;
        case ITM_MSG_LOGOUT: {
#if 1//DEVICE_MODEL_GATEWAY
            res = _iotx_linkkit_subdev_logout(devid);
            if (res != SUCCESS_RETURN) {
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
#else
            res = FAIL_RETURN;
#endif
        }
        break;
        case ITM_MSG_DELETE_TOPO: {
#if 1//DEVICE_MODEL_GATEWAY
            res = _iotx_linkkit_subdev_delete_topo(devid);
            if (res != SUCCESS_RETURN) {
                _iotx_linkkit_mutex_unlock();
                return FAIL_RETURN;
            }
#else
            res = FAIL_RETURN;
#endif
        }
        break;
#if 1//DEVICE_MODEL_GATEWAY
#ifdef DEVICE_MODEL_SUBDEV_OTA
        case ITM_MSG_REPORT_SUBDEV_FIRMWARE_VERSION: {
            res = iotx_dm_send_firmware_version(devid, (const char *)payload);
        }
        break;
#endif
#endif
        default: {
            dm_log_err("Unknown Message Type");
            res = FAIL_RETURN;
        }
        break;
    }
    _iotx_linkkit_mutex_unlock();
    return res;
}

int IOT_Linkkit_Query(int devid, iotx_linkkit_msg_type_t msg_type, unsigned char *payload, int payload_len)
{
    int res = 0;
#if 1
iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    if (devid < 0 || msg_type < 0 || msg_type >= IOTX_LINKKIT_MSG_MAX) {
        dm_log_err("Invalid Parameter");
        return FAIL_RETURN;
    }

    if (ctx->is_opened == 0 || ctx->is_connected == 0) {
        return FAIL_RETURN;
    }

    _iotx_linkkit_mutex_lock();
    switch (msg_type) {
#if !defined(DEVICE_MODEL_RAWDATA_SOLO)
        case ITM_MSG_QUERY_TIMESTAMP: {
            res = iotx_dm_qurey_ntp();
        }
        break;
#endif
        case ITM_MSG_QUERY_TOPOLIST: {
#if 1//DEVICE_MODEL_GATEWAY
            res = iotx_dm_query_topo_list();
#else
            res = FAIL_RETURN;
#endif
        }
        break;
        case ITM_MSG_QUERY_FOTA_DATA: {
            res = iotx_dm_fota_perform_sync((char *)payload, payload_len);
        }
        break;
        case ITM_MSG_QUERY_COTA_DATA: {
            res = iotx_dm_cota_perform_sync((char *)payload, payload_len);
        }
        break;
        case ITM_MSG_REQUEST_COTA: {
            res = iotx_dm_cota_get_config("product", "file", "");
        }
        break;
        case ITM_MSG_REQUEST_FOTA_IMAGE: {
            res = iotx_dm_fota_request_image((const char *)payload, payload_len);
        }
        break;
        default: {
            dm_log_err("Unknown Message Type");
            res = FAIL_RETURN;
        }
        break;
    }
    _iotx_linkkit_mutex_unlock();
    return res;
}

int IOT_Linkkit_TriggerEvent(int devid, char *eventid, int eventid_len, char *payload, int payload_len)
{
#if !defined(DEVICE_MODEL_RAWDATA_SOLO)
    int res = 0;
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    if (devid < 0 || eventid == NULL || eventid_len <= 0 || payload == NULL || payload_len <= 0) {
        dm_log_err("Invalid Parameter");
        return FAIL_RETURN;
    }

    if (ctx->is_opened == 0 || ctx->is_connected == 0) {
        return FAIL_RETURN;
    }

    _iotx_linkkit_mutex_lock();
    res = iotx_dm_post_event(devid, eventid, eventid_len, payload, payload_len);
    _iotx_linkkit_mutex_unlock();

    return res;
#else
    return -1;
#endif
#endif
    return -1;

}*/

#if 0//DEVICE_MODEL_GATEWAY
int iot_linkkit_subdev_query_id(char product_key[IOTX_PRODUCT_KEY_LEN + 1], char device_name[IOTX_DEVICE_NAME_LEN + 1])
{
    int res = -1;
    iotx_linkkit_ctx_t *ctx = _iotx_linkkit_get_ctx();

    if (ctx->is_opened == 0) {
        return res;
    }

    iotx_dm_subdev_query(product_key, device_name, &res);
    return res;
}
#endif /* #ifdef DEVICE_MODEL_GATEWAY */


int kk_mid_subdev_add(int devType, char productCode[PRODUCT_CODE_MAXLEN], char deviceCode[DEVICE_CODE_MAXLEN],char mac[DEVICE_MAC_MAXLEN],char fatherDeviceCode[DEVICE_CODE_MAXLEN]){
    int res = 0;
    int devid = 0;
	int heartbeat = 0;
    res = dm_mgr_subdev_create(devType,productCode,deviceCode,mac,fatherDeviceCode,0,&devid,&heartbeat);
	if (res != SUCCESS_RETURN && TSL_ALREADY_EXIST != res) {
        ERROR_PRINT("subdev create Failed\n");
        return FAIL_RETURN;
    }
    INFO_PRINT("subdev open susseed, devid = %d\n", devid);

    if (TSL_ALREADY_EXIST == res){
        //todo
    }else{
        res = kk_subDev_insert_db(devType,productCode,deviceCode,fatherDeviceCode,mac,"1.1.0",heartbeat);
        if (res != SUCCESS_RETURN) {
            return FAIL_RETURN;
        }
    }
		
	_iotx_linkkit_mutex_lock();
    res = _iotx_linkkit_slave_connect(devid);
    if (res != SUCCESS_RETURN) {
        _iotx_linkkit_mutex_unlock();
        return FAIL_RETURN;
    }
    
    res = _iotx_linkkit_subdev_login(devid);
    if (res != SUCCESS_RETURN) {
        _iotx_linkkit_mutex_unlock();
        return FAIL_RETURN;
    }
	_iotx_linkkit_mutex_unlock();
    return SUCCESS_RETURN;
}

int kk_mid_subdev_batch_add( char productCode[PRODUCT_CODE_MAXLEN], char deviceCode[DEVICE_CODE_MAXLEN],char mac[DEVICE_MAC_MAXLEN],char fatherDeviceCode[DEVICE_CODE_MAXLEN]){
    int res = 0;
    int devid = 0;
	int heartbeat = 0;
    res = dm_mgr_subdev_create(KK_DM_DEVICE_SUBDEV,productCode,deviceCode,mac,fatherDeviceCode,0,&devid,&heartbeat);
	if (res != SUCCESS_RETURN && TSL_ALREADY_EXIST != res) {
        ERROR_PRINT("subdev create Failed\n");
        return FAIL_RETURN;
    }
    INFO_PRINT("subdev open susseed, devid = %d\n", devid);

    if (TSL_ALREADY_EXIST == res){
        //todo
    }else{
        res = kk_subDev_insert_db(KK_DM_DEVICE_SUBDEV,productCode,deviceCode,fatherDeviceCode,mac,"1.1.0",heartbeat);
        if (res != SUCCESS_RETURN) {
            return FAIL_RETURN;
        }
    }

    res = _iotx_linkkit_subdev_login(devid);
    if (res != SUCCESS_RETURN) {

        return FAIL_RETURN;
    }
	_iotx_linkkit_mutex_unlock();
    return SUCCESS_RETURN;

}


