#ifndef __RPC_ONOFF_H
#define __RPC_ONOFF_H
#include "RPC_API.h"


EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep);
EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep);
EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep);
EmberStatus WindowCover_GotoLiftPercentage(uint16_t node,uint8_t ep,uint8_t position);

EmberStatus zclOnOff_On(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Off(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_Toggle(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OffWithEffect(uint16_t node,uint8_t ep,uint8_t id,uint8_t var);
EmberStatus zclOnOff_OnWithRecallGlobalScene(uint16_t node,uint8_t ep);
EmberStatus zclOnOff_OnWithTimedOff(uint16_t node,uint8_t ep,uint8_t Control,uint16_t OnTime,uint16_t OffWaitTime);


cJSON *rpc_zclOnOff_On(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclOnOff_Off(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclOnOff_Toggle(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclOnOff_OffWithEffect(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclOnOff_OnWithRecallGlobalScene(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclOnOff_OnWithTimedOff(jrpc_context * ctx, cJSON * params, cJSON *id);



#define RPC_OnOff_COMMAND_FUNCTION_TABLE	\
	{rpc_zclOnOff_On,"zclOnOff_On"},\
	{rpc_zclOnOff_Off,"zclOnOff_Off"},\
	{rpc_zclOnOff_Toggle,"zclOnOff_Toggle"},\
	{rpc_zclOnOff_OffWithEffect,"zclOnOff_OffWithEffect"},\
	{rpc_zclOnOff_OnWithRecallGlobalScene,"zclOnOff_OnWithRecallGlobalScene"},\
	{rpc_zclOnOff_OnWithTimedOff,"zclOnOff_OnWithTimedOff"}\







#endif
