#include "kk_ncp_common.h"
#include "kk_tsl_property_get.h"
#include "kk_ncp_queue.h"

#define MAX_ATTRIBUTE_SIZE							10
#define MAX_CLUSTER_SIZE							10

typedef struct{
	uint8_t ep;
	uint16_t clu;
	uint8_t len;
	uint16_t attr[MAX_ATTRIBUTE_SIZE];
}property_s;
typedef struct
{
	uint16_t node;
	property_s property[MAX_CLUSTER_SIZE];
}get_property_s;

static get_property_s g_property;





static get_property_s *_get_g_property(void)
{
	return &g_property;
}

void kk_tsl_get_property_s(uint16_t node)
{
	uint8_t i,j;
	get_property_s *pery = _get_g_property();
	property_s *property = pery->property;
	memset(pery,0,sizeof(get_property_s));

	pery->node = node;
}


void kk_tsl_get_property_print(void)
{
	uint8_t i,j;
	get_property_s *pery = _get_g_property();
	property_s *property = pery->property;
	for(i=0;i<MAX_CLUSTER_SIZE;i++){
		if(property[i].ep !=0){
			for(j=0;j<property[i].len;j++){
				printf("i=%d,j=%d,ep=%d,clu=0x%04X,attr=0x%04X\n",i,j,property[i].ep,property[i].clu,property[i].attr[j]);
			}
		}
	}
	return false;
}
/*

void kk_tsl_get_property(uint16_t node)
{
	status = zclGRead(ptr->nodeId,
						1,
						1,
						false,
						ZCL_BASIC_CLUSTER_ID,
						ZCL_MODEL_IDENTIFIER_ATTRIBUTE_ID,
						true);


}
*/

void kk_tsl_get_property_e(uint16_t node)
{
	uint8_t i,j;
	get_property_s *pery = _get_g_property();
	property_s *property = pery->property;
	get_property_data_s *data;


	kk_tsl_get_property_print();

	for(i=0;i<MAX_CLUSTER_SIZE;i++){
		if(property[i].ep !=0 &&property[i].len!=0){
			data = (get_property_data_s *)malloc(sizeof(get_property_data_s));
			data->node = pery->node;
		
			data->ep = property[i].ep;
			data->clu = property[i].clu;
			data->len = property[i].len;
			data->attr = (get_property_data_s *)malloc(sizeof(uint16_t)*data->len);
			for(j=0;j<data->len;j++){
				data->attr[j] = property[i].attr[j];
				printf("ep=%d,clu=0x%04X,attr=0x%04X\n",data->ep,data->clu,data->attr[j]);
				ncp_queue_enqueue(GET_PROPERTY,data);
			}
		}
	}
}


uint8_t kk_tsl_get_pery_ix(uint8_t ep,uint16_t clu)
{
	uint8_t i = 0;
	get_property_s *pery = _get_g_property();
	for (; i<MAX_CLUSTER_SIZE; i++) {
		if(pery->property[i].ep == 0){
			return i;
		}
		if(pery->property[i].ep==ep && pery->property[i].clu==clu)
			break;
	}
	return i;
}

bool kk_tsl_get_pery_isExist(uint8_t ep,uint16_t clu,uint16_t attr)
{
	uint8_t i,j;
	get_property_s *pery = _get_g_property();
	property_s *property = pery->property;
	for(i=0;i<MAX_CLUSTER_SIZE;i++){
		if(property[i].ep == ep && property[i].clu == clu){
			for(j=0;j<MAX_ATTRIBUTE_SIZE;j++){
				if(property[i].attr[j]==attr) return true;
			}
		}
	}
	return false;
}
bool kk_tsl_get_pery_attr_isExist(uint16_t *pAttr,uint16_t attr)
{
	uint8_t i = 0;
	
	for(;i<MAX_ATTRIBUTE_SIZE;i++,pAttr++){
		if(pAttr==attr && pAttr!=0xffff){
			return true;
		}
	}

	return false;
}

uint8_t kk_tsl_get_pery_add(uint8_t ep,uint16_t clu,uint16_t attr)
{
	uint8_t ix;
	get_property_s *pery;
	property_s *property;
	uint16_t *pAttr;

	if(kk_tsl_get_pery_isExist(ep,clu,attr)==true){
		printf("property already add in array!!!\n");
		return 0;
	}

	pery = _get_g_property();
	ix = kk_tsl_get_pery_ix(ep,clu);
	if(ix>=MAX_CLUSTER_SIZE){
		printf("not find ix\n");
		return -1;
	}
	property = &pery->property[ix];
	property->ep = ep;
	property->clu = clu;
	pAttr = property->attr;
	if(kk_tsl_get_pery_attr_isExist(pAttr,attr)==true){
		printf("attr already add in array!!!\n");
		return 0;
	}

	if(property->len>=MAX_ATTRIBUTE_SIZE){
		printf("full!!!,len=%d,max attr array size = %d!!!\n",MAX_ATTRIBUTE_SIZE,property->len);
		return -2;
	}
	property->attr[property->len++] = attr;
	printf("[add]ep=%d,clu=0x%04X,attr=0x%04X\n",property->ep,property->clu,attr);
	return 0;

}

void kk_tsl_get_property(uint8_t ep,uint16_t clu,uint16_t attr)
{
	kk_tsl_get_pery_add(ep,clu,attr);
}






































