#ifndef _KK_CCU_MSG_H
#define _KK_CCU_MSG_H
#include "kk_log.h"

#include "klist.h"
#include "kk_product.h"
#include "com_api.h"
#include "kk_opcode.h"
#include "kk_lan_ctrl.h"
#include "kk_data_mng.h"
#include "cJSON.h"

#define WILDCARD_CHARACTER_STR									"*"
#define SUCCESS_STR												"success"

#define GUARD_STATUS_ARMING_LEAVE_HOME							"ARMING_LEAVE_HOME"
#define GUARD_STATUS_DISARMING									"DISARMING"
#define GUARD_STATUS_ARMING_IN_HOME								"ARMING_IN_HOME"
#define ARMING_STATUS_GUARD_ZONE								"ARMING_CUSTOM_GUARD_ZONE"



#define EMPTY_STR										""

#define FLOOR_ID_STR									"floor_id"
#define ID_STR											"id"
#define ROOM_ICON_STR									"room_icon"
#define NAME_STR										"name"
#define	ROOM_STATUS_STR									"room_status"
#define DATA_STR										"data"
#define ROOMS_STR										"rooms"
#define ROOMS_ID_STR									"roomId"
#define DEVICES_STR										"devices"
#define SCENES_STR										"scenes"

#define ACTIONS_STR										"actions"
#define ENABLE_STR										"enable"
#define SCENE_ID_STR									"sceneId"
#define SCENE_TYPE_STR									"sceneType"
#define SCENE_TRIGGER_STR								"trigger"
#define CONDITION_STR									"condition"




#define SWITCH_ARG_ON					"ON"
#define SWITCH_ARG_OFF					"OFF"
#define HJ_SERVER						"HJ_Server"
#define HJ_PROFILE						"HJ_Profile"


#define SUCCESS_STATUS_STR				"success"
#define NODEID_STR						"nodeid"
#define OPCODE_STR						"opcode"
#define ARG_STR							"arg"
#define REQUEST_STR						"requester"


#define INFO_STRING						"info"
#define PAYLOAD_STRING					"payload"

#define PARAMS_STRING					"params"



#define KK_LAN_VERSION					"1.0.0"

cJSON * msg_convert_value(cJSON *d_type,cJSON *s_type,cJSON *value);
cJSON *map_type_convert(cJSON *s_dataType,cJSON *s_valueRange,cJSON *value,cJSON *d_valueRange);


int kk_lan_get_msg_id(void);
int kk_lan_get_msg_id_str(char *msgId,int size);


void add_val_to_obj(cJSON *obj,cJSON *val,const char *identifier);

cJSON *ccu_value_convert(cJSON *s_dType,cJSON *s_range,cJSON *d_dType,cJSON *d_range,cJSON *value);

#endif


