#include "kk_ccu_msg.h"

cJSON *bool_type_convert(cJSON *n_id,cJSON *n_dataType);
cJSON *int_type_convert(cJSON *n_id,cJSON *n_dataType);
cJSON *double_type_convert(cJSON *n_id,cJSON *n_dataType);
cJSON *string_bool_type_convert(cJSON *n_id,cJSON *n_dataType);
cJSON *string_int_type_convert(cJSON *n_id,cJSON *n_dataType);
cJSON *string_double_type_convert(cJSON *n_id,cJSON *n_dataType);
cJSON *string_time_type_convert(cJSON *n_id,cJSON *n_dataType);

typedef cJSON *(*convert_func)(cJSON *,cJSON *);

typedef struct
{
	char *type;
	convert_func func;
}CONVERT_ITEM_S;


static CONVERT_ITEM_S convert_table[] = {
	{"bool",bool_type_convert},
	{"int",int_type_convert},
	{"double",double_type_convert},
	{"string_bool",string_bool_type_convert},
	{"string_int",string_int_type_convert},
	{"string_double",string_double_type_convert},
	{"string_time",string_time_type_convert}
};
	

cJSON *bool_type_convert(cJSON *n_id,cJSON *n_dataType)
{
	cJSON *args = NULL;
	int bVal = 0;
	
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);

	if(strcmp(n_dataType->valuestring,"dummy")==0) {
		return NULL;
	}
	
	if((strcmp(n_dataType->valuestring,"int")==0) ||
		(strcmp(n_dataType->valuestring,"bool")==0)){
		args = cJSON_CreateBool(n_id->valueint);
	}else if(strcmp(n_dataType->valuestring,"double")==0) {
		bVal = (n_id->valuedouble>0) ? 1 : 0;
		args = cJSON_CreateBool(bVal);
	}else if(strcmp(n_dataType->valuestring,"string_bool")==0) {
		if(strcmp(n_id->valuestring,"true")==0 ||
			strcmp(n_id->valuestring,"TRUE")==0){
			args = cJSON_CreateBool(1);
		}else if(strcmp(n_id->valuestring,"true")==0 ||
			strcmp(n_id->valuestring,"TRUE")==0){
			args = cJSON_CreateBool(0);
		}
	}else if(strcmp(n_dataType->valuestring,"string_int")==0) {
		int iVal = atoi(n_id->valuestring);
		bVal = (iVal>0) ? 1 : 0;
		args = cJSON_CreateBool(bVal);
	}else if(strcmp(n_dataType->valuestring,"string_double")==0) {
		double dVal = atof(n_id->valuestring);
		bVal = (dVal>0) ? 1 : 0;
		args = cJSON_CreateBool(bVal);
	}
	return args;
}

cJSON *int_type_convert(cJSON *n_id,cJSON *n_dataType)
{
	cJSON *args = NULL;
	
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);

	if(strcmp(n_dataType->valuestring,"dummy")==0) {
		return NULL;
	}

	if((strcmp(n_dataType->valuestring,"int")==0) ||
		(strcmp(n_dataType->valuestring,"bool")==0)){
		args = cJSON_CreateNumber(n_id->valueint);
	}else if(strcmp(n_dataType->valuestring,"double")==0) {
		args = cJSON_CreateNumber(n_id->valuedouble);
	}else if(strcmp(n_dataType->valuestring,"string_bool")==0) {
		if(strcmp(n_id->valuestring,"true")==0 ||
			strcmp(n_id->valuestring,"TRUE")==0){
			args = cJSON_CreateNumber(1);
		}else if(strcmp(n_id->valuestring,"true")==0 ||
			strcmp(n_id->valuestring,"TRUE")==0){
			args = cJSON_CreateNumber(0);
		}
	}else if(strcmp(n_dataType->valuestring,"string_int")==0) {
		args = cJSON_CreateNumber(atoi(n_id->valuestring));
	}else if(strcmp(n_dataType->valuestring,"string_double")==0) {
		args = cJSON_CreateNumber((int)atof(n_id->valuestring));
	}
	return args;
}

cJSON *double_type_convert(cJSON *n_id,cJSON *n_dataType)
{
	return int_type_convert(n_id,n_dataType);
}

cJSON *string_bool_type_convert(cJSON *n_id,cJSON *n_dataType)
{
	cJSON *args = NULL;
	int flag = -1;
	
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);

	if(strcmp(n_dataType->valuestring,"dummy")==0) {
		return NULL;
	}
		
	if((strcmp(n_dataType->valuestring,"int")==0) ||
		(strcmp(n_dataType->valuestring,"bool")==0)){
		flag = (n_id->valueint>0) ? 1 : 0;
	}else if(strcmp(n_dataType->valuestring,"double")==0) {
		flag = (n_id->valuedouble>0) ? 1 : 0;
	}else if(strcmp(n_dataType->valuestring,"string_bool")==0) {
		if(strcmp(n_id->valuestring,"true")==0 ||
			strcmp(n_id->valuestring,"TRUE")==0){
			flag = 1;
		}else if(strcmp(n_id->valuestring,"false")==0 ||
			strcmp(n_id->valuestring,"FALSE")==0){
			flag = 0;
		}
	}else if(strcmp(n_dataType->valuestring,"string_int")==0) {
		flag = (atoi(n_id->valuestring)>0) ? 1 : 0;
	}else if(strcmp(n_dataType->valuestring,"string_double")==0) {
		flag = ( atof(n_id->valuestring)>0) ? 1 : 0;
	}

	if(flag==1) {
		args = cJSON_CreateString("true");
	}else if(flag==0){
		args = cJSON_CreateString("false");
	}
	
	return args;
}

static cJSON *string_val_type_convert(int type,cJSON *n_id,cJSON *n_dataType)
{
	cJSON *args = NULL;
	char sVal[32] = {0};
	union {
		int iVal;
		double dVal;
	}val = {0};
	memset(sVal,0,sizeof(sVal));
	
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);

	if(strcmp(n_dataType->valuestring,"dummy")==0) {
		return NULL;
	}
		
	if((strcmp(n_dataType->valuestring,"int")==0) ||
		(strcmp(n_dataType->valuestring,"bool")==0)){
		if(type==1){
			val.dVal = (n_id->valueint>0) ? 1 : 0;
		}else{
			val.iVal = (n_id->valueint>0) ? 1 : 0;
		}
	}else if(strcmp(n_dataType->valuestring,"double")==0) {
		if(type==1){
			val.dVal = n_id->valuedouble;
		}else{
			val.iVal = n_id->valueint;
		}
	}else if(strcmp(n_dataType->valuestring,"string_bool")==0) {
		if(strcmp(n_id->valuestring,"true")==0 ||
			strcmp(n_id->valuestring,"TRUE")==0){
			if(type==1){
				val.dVal = 1;
			}else{
				val.iVal = 1;
			}
		}else if(strcmp(n_id->valuestring,"false")==0 ||
			strcmp(n_id->valuestring,"FALSE")==0)
			if(type==1){
				val.dVal = 0;
			}else{
				val.iVal = 0;
			}
	}else if(strcmp(n_dataType->valuestring,"string_int")==0) {
		if(type==1){
			val.dVal = atoi(n_id->valuestring);
		}else{
			val.iVal = atoi(n_id->valuestring);
		}
	}else if(strcmp(n_dataType->valuestring,"string_double")==0) {
		if(type==1){
			val.dVal = atof(n_id->valuestring);
		}else{
			val.iVal = atof(n_id->valuestring);
		}
	}
	
	if(type==1){
		snprintf(sVal,sizeof(sVal),"%f",val.dVal);
	}else{
		snprintf(sVal,sizeof(sVal),"%d",val.iVal);
	}

	args = cJSON_CreateString(sVal);

	return args;
}

cJSON *string_int_type_convert(cJSON *n_id,cJSON *n_dataType)
{
	return string_val_type_convert(0,n_id,n_dataType);
}
cJSON *string_double_type_convert(cJSON *n_id,cJSON *n_dataType)
{
	return string_val_type_convert(1,n_id,n_dataType);
}

cJSON *string_time_type_convert(cJSON *n_id,cJSON *n_dataType)
{
	cJSON *args = NULL;
	int val;
	char tm[10] = {0};
	printf("[%s][%d]\n",__FUNCTION__,__LINE__);

	if(strcmp(n_dataType->valuestring,"dummy")==0) {
		return NULL;
	}


	if(strcmp(n_dataType->valuestring,"double")==0){
		val = n_id->valuedouble * 10;

		memset(tm,0,sizeof(tm));
		snprintf(tm,sizeof(tm),"%02d:%2s",(int)n_id->valuedouble,((val%10>=5)?"30":"00"));
		args = cJSON_CreateString(tm);
	}

	
	return args;
}








cJSON * msg_convert_value(cJSON *d_type,cJSON *s_type,cJSON *value)
{
	int i,size;
	cJSON *rlt = NULL;
	CONVERT_ITEM_S *crt;

	printf("[%s][%d]%s->%s,val=%s\n",__FUNCTION__,__LINE__,cJSON_Print(s_type),cJSON_Print(d_type),cJSON_Print(value));
	
	size = sizeof(convert_table)/sizeof(CONVERT_ITEM_S);
	crt = &convert_table[0];
	
	for(i=0;i<size;i++,crt++){
		if(strcmp(d_type->valuestring,crt->type)==0) {
			if(crt->func){
				rlt = crt->func(value,s_type);
			}
			break;
		}
	}
	return rlt;
}

cJSON *map_type_convert(cJSON *s_dataType,cJSON *s_valueRange,cJSON *value,cJSON *d_valueRange)
{
	cJSON *args = NULL;
	cJSON *rlt;
	int j;

	int vra_size = cJSON_GetArraySize(s_valueRange);
	
	for(j=0;j<vra_size;j++){
		if(strcmp(s_dataType->valuestring,"dummy")==0){
			continue ;
		}
		rlt = cJSON_GetArrayItem(s_valueRange,j);
	
		if(strcmp(s_dataType->valuestring,"bool")==0 ||
			strcmp(s_dataType->valuestring,"int")==0) {
			if(rlt->valueint == value->valueint) {
				args = cJSON_GetArrayItem(d_valueRange,j);
				break ;
			}
		}else if(strcmp(s_dataType->valuestring,"double")==0){
			if(rlt->valuedouble == value->valuedouble) {
				args = cJSON_GetArrayItem(d_valueRange,j);
				break ;
			}
		}else if(strstr(s_dataType->valuestring,"string")){
			if(strcmp(rlt->valuestring,value->valuestring)==0){
				args = cJSON_GetArrayItem(d_valueRange,j);
				break ;
			}
		}else if(strstr(s_dataType->valuestring,"map")){
			
			if(rlt->type==cJSON_String){
				
				if(strcmp(rlt->valuestring,value->valuestring)==0){
				
					args = cJSON_GetArrayItem(d_valueRange,j);
					break ;
				}
			}else if(rlt->type==cJSON_Number){
			
				if(rlt->valueint == value->valueint) {
			
					args = cJSON_GetArrayItem(d_valueRange,j);
					break ;
				}
			}
			
		}
	}
	return args;
}




void add_val_to_obj(cJSON *obj,cJSON *val,const char *identifier)
{
	if(val->type==cJSON_False){
		cJSON_AddFalseToObject(obj,identifier);
	}else if(val->type==cJSON_True){
		cJSON_AddTrueToObject(obj,identifier);
	}else if(val->type==cJSON_NULL){
		cJSON_AddNullToObject(obj,identifier);
	}else if(val->type==cJSON_Number){
		cJSON_AddNumberToObject(obj,identifier,val->valuedouble);
	}else if(val->type==cJSON_String){
		cJSON_AddStringToObject(obj,identifier,val->valuestring);
	}else if(val->type==cJSON_Array){
		printf("......................\n");
	}
}

cJSON *ccu_value_convert(cJSON *s_dType,cJSON *s_range,cJSON *d_dType,cJSON *d_range,cJSON *value)
{
	cJSON *val = NULL;
	printf("[ccu val convert] s_dType=%s,s_range=%s,d_dType=%s,d_range=%s,value=%s\n",
		cJSON_Print(s_dType),cJSON_Print(s_range),cJSON_Print(d_dType),cJSON_Print(d_range),cJSON_Print(value));

	if(strcmp(d_dType->valuestring,"map")==0){
		val = map_type_convert(s_dType,s_range,value,d_range);
	}else{
		val = msg_convert_value(d_dType,s_dType,value);
	}

	//printf("[val]%s\n",cJSON_Print(val));

	return val;
}


int kk_lan_get_msg_id(void)
{
	static int id;
	return ++id;
}

int kk_lan_get_msg_id_str(char *msgId,int size)
{
	memset(msgId,0,size);
	snprintf(msgId,size,"%d",kk_lan_get_msg_id());
}




















