#ifndef __KK_ZB_COM_H
#define __KK_ZB_COM_H
#include "app/framework/include/af.h"
#include "zb_device_id.h"
typedef struct 
{
	unsigned char CloorModeFlag;
	unsigned char CapabilitiesFlag;
	unsigned char CloorMode;
	unsigned char Capabilities;
	unsigned int time;
	unsigned char CloorSetFlag;
	union{
		struct {
			unsigned char HSL_flag;//bit 0:H; bit 1:S; bit 2:L
			unsigned short H;
			unsigned char S;
			unsigned char L;
		}HSL;
	}color;
}ColorLighting_s;


typedef struct{
	union{
		ColorLighting_s ColorLighting;
	}dev;
}SubDevManage_s;

typedef struct kk_device_table_s{
	EmberEUI64 mac;
	EmberNodeId nodeId;
	uint16_t deviceId;
	uint16_t identifyCnt;
	char productCode[33];
	SubDevManage_s manage;
	struct kk_device_table_s *next;
}kk_device_table_s;


#define RPC_APPVERSION_STRING_LENGTH 3 //

#define RPC_ENDPOINT_STRING_LENGTH 4 //0-255 + NULL
#define RPC_EUI64_STRING_LENGTH 19 //"0x" + 16 characters + NULL
#define RPC_NODEID_STRING_LENGTH 7 //"0x" + 4 characters + NULL
#define RPC_CLUSTERID_STRING_LENGTH 7 // "0x" + 4 chars + NULL
#define RPC_ATTRIBUTE_STRING_LENGTH 7 // "0x" + 4 chars + NULL
#define RPC_DATATYPE_STRING_LENGTH 4 //0-255 + NULL
#define RPC_LENGTH_STRING_LENGTH 4 //0-255 + NULL
#define RPC_STATUS_STRING_LENGTH 4 //0-255 + NULL

enum {
	WC_normal_dir								= 0,//"正转"
	WC_reversed_dir 							= 1,//"反转"
	WC_calibration_mode 						= 2,//"校验"
}windowCoveringMode;

#define KK_EUI64_STRING_LENGTH 17 //16 characters + NULL




#define KK_GET_U16( x )					(int16u)( (x[1]<<8)+x[0] )
#define	KK_GET_U24( x )					(int32u)( (x[2]<<16)+(x[1]<<8)+x[0] )
#define	KK_GET_U32( x )					(int32u)( (x[3]<<24)+(x[2]<<16)+(x[1]<<8)+x[0] )
#define	KK_GET_U48( x )					(int64u)( ((int64u)(x[4])<<32)+(x[3]<<24)+(x[2]<<16)+(x[1]<<8)+x[0] )





#endif








