#ifndef __RPC_COLOR_CONTROL_H
#define __RPC_COLOR_CONTROL_H
#include "RPC_API.h"

EmberStatus zclColorControlMovetohue(uint16_t node,
										uint8_t ep,
										uint8_t hue,
										uint8_t dir,
										uint16_t trsTime,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlMovehue(uint16_t node,
										uint8_t ep,
										uint8_t mode,
										uint8_t rate,
										bool options,
										uint8_t mask,
										uint8_t Override);
EmberStatus zclColorControlStephue(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlMovetosat(uint16_t node,
												uint8_t ep,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlMovesat(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint8_t rate,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepsat(uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint8_t size,
											uint8_t trsTime,
											bool options,
											uint8_t mask,
											uint8_t Override);

EmberStatus zclColorControlMovetohueandsat(uint16_t node,
														uint8_t ep,
														uint8_t hue,
														uint8_t saturation,
														uint16_t trsTime,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlMovetocolor(uint16_t node,
													uint8_t ep,
													uint16_t colorX,
													uint16_t colorY,
													uint16_t trsTime,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolor(uint16_t node,
												uint8_t ep,
												uint16_t rateX,
												uint16_t rateY,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlStepcolor(uint16_t node,
												uint8_t ep,
												uint16_t stepX,
												uint16_t stepY,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlMovetocolortemp(uint16_t node,
															uint8_t ep,
															uint16_t colorTemp,
															uint16_t trsTime,
															bool options,
															uint8_t mask,
															uint8_t Override);

EmberStatus zclColorControlEmovetohue(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t dir,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlEmovehue( uint16_t node,
											uint8_t ep,
											uint8_t mode,
											uint16_t rate,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlEstephue(uint16_t node,
												uint8_t ep,
												uint8_t mode,
												uint16_t size,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);

EmberStatus zclColorControlEmovetohueandsat(uint16_t node,
												uint8_t ep,
												uint16_t hue,
												uint8_t saturation,
												uint16_t trsTime,
												bool options,
												uint8_t mask,
												uint8_t Override);
EmberStatus zclColorControlLoopSet(uint16_t node,
											uint8_t ep,
											uint8_t flags,
											uint8_t action,
											uint8_t dir,
											uint16_t time,
											uint16_t sHue,
											bool options,
											uint8_t mask,
											uint8_t Override);
EmberStatus zclColorControlStopmovestep(uint16_t node,
													uint8_t ep,
													bool options,
													uint8_t mask,
													uint8_t Override);
EmberStatus zclColorControlMovecolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t rate,
														uint16_t Tmin,
														uint16_t Tmax,
														bool options,
														uint8_t mask,
														uint8_t Override);
EmberStatus zclColorControlStepcolortemp(uint16_t node,
														uint8_t ep,
														uint8_t mode,
														uint16_t size,
														uint16_t trsTime,
														uint16_t minimum,
														uint16_t maximum,
														bool options,
														uint8_t mask,
														uint8_t Override);


cJSON *rpc_zclColorControlMovetohue(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovehue(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlStephue(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovetosat(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovesat(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlStepsat(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovetohueandsat(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovetocolor(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovecolor(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlStepcolor(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovetocolortemp(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlEmovetohue(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlEmovehue(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlEstephue(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlEmovetohueandsat(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlLoopSet(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlStopmovestep(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlMovecolortemp(jrpc_context * ctx, cJSON * params, cJSON *id);
cJSON *rpc_zclColorControlStepcolortemp(jrpc_context * ctx, cJSON * params, cJSON *id);















#define RPC_COLOR_CONTROL_COMMAND_FUNCTION_TABLE	\
	{rpc_zclColorControlMovetohue,"zclColorControlMovetohue"},\
	{rpc_zclColorControlMovehue,"zclColorControlMovehue"},\
	{rpc_zclColorControlStephue,"zclColorControlStephue"},\
	{rpc_zclColorControlMovetosat,"zclColorControlMovetosat"},\
	{rpc_zclColorControlMovesat,"zclColorControlMovesat"},\
	{rpc_zclColorControlStepsat,"zclColorControlStepsat"},\
	{rpc_zclColorControlMovetohueandsat,"zclColorControlMovetohueandsat"},\
	{rpc_zclColorControlMovetocolor,"zclColorControlMovetocolor"},\
	{rpc_zclColorControlMovecolor,"zclColorControlMovecolor"},\
	{rpc_zclColorControlStepcolor,"zclColorControlStepcolor"},\
	{rpc_zclColorControlMovetocolortemp,"zclColorControlMovetocolortemp"},\
	{rpc_zclColorControlEmovetohue,"zclColorControlEmovetohue"},\
	{rpc_zclColorControlEmovehue,"zclColorControlEmovehue"},\
	{rpc_zclColorControlEstephue,"zclColorControlEstephue"},\
	{rpc_zclColorControlEmovetohueandsat,"zclColorControlEmovetohueandsat"},\
	{rpc_zclColorControlLoopSet,"zclColorControlLoopSet"},\
	{rpc_zclColorControlStopmovestep,"zclColorControlStopmovestep"},\
	{rpc_zclColorControlMovecolortemp,"zclColorControlMovecolortemp"},\
	{rpc_zclColorControlStepcolortemp,"zclColorControlStepcolortemp"}\























#endif

