#include "kk_test.h"



static void kk_rpc_send_message(cJSON *data,char *method,EmberEUI64 mac)
{
	static uint16_t msgid;
	cJSON *item = rpc_cJSON_CreateObject();
	char msgIdString[10];
	sprintf(msgIdString,"%d",++msgid);
	rpc_cJSON_AddStringToObject(item, "msgId",msgIdString);
	rpc_cJSON_AddStringToObject(item, "version", KK_IPC_VERSION);
	if(mac!=NULL){
		rpc_cJSON_AddMACToObject(item,mac); 
	}
	rpc_cJSON_AddStringToObject(item, "method",method);

	rpc_cJSON_AddItemToObject(item, "params", data);

	char* p = rpc_cJSON_Print(item);
	emberAfAppPrintln("send json:\n%s\n",p);
	free(p);
	
	jrpc_send_msg(item);
}
void kk_rpc_report_devices(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_DEVICE_JOINED_METHOD,mac);
}
void kk_rpc_report_status(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_ATTRIBUTE_METHOD,mac);
}

typedef struct{
	EmberEUI64 mac;
	uint8_t AppVersion;
	uint8_t deviceType;
	uint8_t deviceCode;
	uint8_t productType;
	uint8_t productCode;
}kk_report_device_s;



void kk_rpc_reportDevices(kk_report_device_s device)
{
	cJSON* devicesJson;

	devicesJson = rpc_cJSON_CreateObject();
	
	rpc_cJSON_AddAppVersionToObject(devicesJson,device.AppVersion); 
	rpc_cJSON_AddStringToObject(devicesJson, "deviceType","1");
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode","2");
	rpc_cJSON_AddStringToObject(devicesJson, "productType","3");
	rpc_cJSON_AddStringToObject(devicesJson, "productCode","4");

	kk_rpc_report_devices(devicesJson,device.mac);
}
bool kk_rpc_report_LightStatus(EmberEUI64 mac,bool LightStatus)
{
	cJSON* root;
	
	root = rpc_cJSON_CreateObject();
	if(LightStatus==true){
		rpc_cJSON_AddStringToObject(root, "LightStatus","1");
	}else{
		rpc_cJSON_AddStringToObject(root, "LightStatus","0");
	}

	kk_rpc_report_status(root,mac);
}

cJSON *rpc_read_attribue(jrpc_context * ctx, cJSON *params, cJSON *id,cJSON *mac)
{
	rpc_nwk_info_s info;
	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		cJSON *LightStatus_item = rpc_cJSON_GetObjectItem(params, "LightStatus");

		
		uint8_t LightStatus = rpc_get_u8(LightStatus_item->valuestring);
		uint8_t eui64[EUI64_SIZE];
		bool flag= rpc_get_mac(mac->valuestring,eui64);
		emberAfCorePrintBuffer(eui64,EUI64_SIZE,true);
		for(int i=0;i<EUI64_SIZE;i++){
			emberAfCorePrintln("i=%d,val=%02x",i,eui64[i]);
		}
		EmberNodeId node = emberAfDeviceTableGetNodeIdFromEui64(eui64);
		if(node==0xffff){
			emberAfCorePrintln("\r\n not find device!\r\n" );
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}

		emberAfCorePrintln("\r\nnode=0x%02X,LightStatus=%d\r\n",node,LightStatus);
		if(flag){
			EmberStatus status;
			if(LightStatus==1){
				status = zclOnOff_On(node,1);
				emberAfCorePrintln("\r\nzclOnOff_On\r\n" );
			}else if(LightStatus==0){
				status = zclOnOff_Off(node,1);
				emberAfCorePrintln("\r\nzclOnOff_Off\r\n" );
			}else{
				set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
				goto error_return;
			}
		}else{
			emberAfCorePrintln("\r\n22222\r\n" );
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
		return rpc_cJSON_CreateNumber(status);
	}
	error_return:
	return rpc_cJSON_CreateNull();

}


cJSON *rpc_Control(jrpc_context * ctx, cJSON *params, cJSON *id,cJSON *mac)
{
	rpc_nwk_info_s info;
	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		cJSON *LightStatus_item = rpc_cJSON_GetObjectItem(params, "LightStatus");

		
		uint8_t LightStatus = rpc_get_u8(LightStatus_item->valuestring);
		uint8_t eui64[EUI64_SIZE];
		bool flag= rpc_get_mac(mac->valuestring,eui64);
		emberAfCorePrintBuffer(eui64,EUI64_SIZE,true);
		for(int i=0;i<EUI64_SIZE;i++){
			emberAfCorePrintln("i=%d,val=%02x",i,eui64[i]);
		}
		EmberNodeId node = emberAfDeviceTableGetNodeIdFromEui64(eui64);
		if(node==0xffff){
			emberAfCorePrintln("\r\n not find device!\r\n" );
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}

		emberAfCorePrintln("\r\nnode=0x%02X,LightStatus=%d\r\n",node,LightStatus);
		if(flag){
			EmberStatus status;
			if(LightStatus==1){
				status = zclOnOff_On(node,1);
				emberAfCorePrintln("\r\nzclOnOff_On\r\n" );
			}else if(LightStatus==0){
				status = zclOnOff_Off(node,1);
				emberAfCorePrintln("\r\nzclOnOff_Off\r\n" );
			}else{
				set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
				goto error_return;
			}
		}else{
			emberAfCorePrintln("\r\n22222\r\n" );
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
		return rpc_cJSON_CreateNumber(status);
	}
	error_return:
	return rpc_cJSON_CreateNull();
}

cJSON *rpc_nwkPermitJoin(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON * OpenOrClose;
	EmberStatus status;
	uint8_t isEnable;
	
	if(params == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else if(params->type == cJSON_Object){
		OpenOrClose = rpc_cJSON_GetObjectItem(params, "NetChannelState");
	}else{
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}

	isEnable = rpc_get_u8(OpenOrClose->valuestring);

	if(isEnable == 0){
		status = nwkPermitJoinCMD(FALSE);
		emberAfCorePrintln("Disable Permit join\r\n");
	}else if(isEnable == 1){
		status = nwkPermitJoinCMD(TRUE);
		emberAfCorePrintln("Enable Permit join 180s\r\n");
	}else{
		emberAfCorePrintln("item type error[%d]\r\n",OpenOrClose->type);
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}

	return rpc_cJSON_CreateNumber(status);
	
	error_return:
	return rpc_cJSON_CreateNull();

}





void emberAfPluginDeviceTableNewDeviceCallback(EmberEUI64 nodeEui64)
{
	uint16_t deviceTableIndex = emberAfDeviceTableGetFirstIndexFromEui64(nodeEui64);
	if(deviceTableIndex == 0xffff){
		kk_print_info("not find item!");
		return ;
	}

	//EmberAfPluginDeviceTableEntry *deviceTable = emberAfDeviceTablePointer();

	//cJSON* nodeJson = rpc_reportDeviceState("joined",deviceTable[deviceTableIndex].eui64);
	//rpc_printfJSON("joined",nodeJson);
	//rpc_send_message(nodeJson,"device joined");

	//rpc_add_device(deviceTable[deviceTableIndex].nodeId);

	kk_report_device_s device;
	//device.mac = nodeEui64;
	device.AppVersion = 0x10;
	memcpy(device.mac,nodeEui64,EUI64_SIZE);
	kk_rpc_reportDevices(device);
}

