#include "stddef.h"
#include <string.h>
#include <stdio.h>
#include "kk_tsl_common.h"

typedef struct{
	char product_key[PRODUCT_KEY_MAXLEN];
	char name[TSL_PATH_MAXLEN];
}kk_json_map_t;

kk_json_map_t s_tsl_list[];
int s_tsl_num = 0;

int kk_set_tsl_by_productKey(const char* key,const char* name)
{
	if(key == NULL || name == NULL)
	{
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		return FAIL_RETURN;
	}
	if(strlen(key) >= PRODUCT_KEY_MAXLEN || strlen(name) >= TSL_PATH_MAXLEN)
	{
		printf("[%s][%d]length error!!!\n",__FUNCTION__,__LINE__);
		return FAIL_RETURN;
	}
	memset(s_tsl_list[s_tsl_num].product_key,0x0,sizeof(s_tsl_list[s_tsl_num].product_key));
	memset(s_tsl_list[s_tsl_num].name,0x0,sizeof(s_tsl_list[s_tsl_num].name));
	memcpy(s_tsl_list[s_tsl_num].product_key,key,strlen(key));
	memcpy(s_tsl_list[s_tsl_num].name,name,strlen(name));
	s_tsl_num++;
	return SUCCESS_RETURN;
}
int kk_get_tsl_by_productKey(const char* key, char* name)
{
	int index = 0;
	if(key == NULL)
	{
		printf("[%s][%d]\n",__FUNCTION__,__LINE__);
		return FAIL_RETURN;
	}
	for(index = 0;index < s_tsl_num;index++)
	{
		if((strlen(key) == strlen(s_tsl_list[index].product_key))&&
			(memcmp(s_tsl_list[index].product_key,key,strlen(key)) == 0))
		{
			memcpy(name,s_tsl_list[index].name,strlen(s_tsl_list[index].name));
			return SUCCESS_RETURN;
		}
	}
	printf("[%s][%d]Not exist!!!\n",__FUNCTION__,__LINE__);
	return FAIL_RETURN;
}


char* kk_load_json(const char *tslFile)
{
	FILE *fp;
	char *buf = NULL;
	unsigned int filesize;
	printf("[%s][%d]tslFile:%s!!!\n",__FUNCTION__,__LINE__,tslFile);
	if(!(fp =  fopen(tslFile,"a+")))
	{
		printf("can't open the file account.txt\n");
		return -1;
	}
    fseek(fp, 0L, SEEK_END);
    filesize = ftell(fp);	
	printf("filesize :%d\n",filesize);
	buf = malloc(filesize+1);
	if(buf == NULL)
	{
		printf("MALLOC FAIL!!!\n");
		return -1;

	}
	memset(buf,0x0,filesize+1);
	fseek(fp, 0L, SEEK_SET);
	fread(buf, 1, filesize, fp);
	//printf("%s!!!\n",buf);	
	//free(buf);
	return buf;
}

