#ifndef _TSL_API_H__
#define _TSL_API_H__
#include "lite-cjson.h"
#include "kk_tsl_common.h"
#include "../../midware/dm/iotx_dm.h"



#define KK_MSG_KEY_ID                   "id"
#define KK_MSG_KEY_VERSION              "version"
#define KK_MSG_KEY_METHOD               "method"
#define KK_MSG_KEY_PARAMS               "params"
#define KK_MSG_KEY_CODE                 "code"
#define KK_MSG_KEY_DATA                 "data"
#define KK_MSG_KEY_MESSAGE              "message"


/*typedef enum {
    IOTX_DM_ERR_CODE_SUCCESS              = 200,
    IOTX_DM_ERR_CODE_REQUEST_ERROR        = 400,
    IOTX_DM_ERR_CODE_REQUEST_PARAMS_ERROR = 460,
    IOTX_DM_ERR_CODE_REQUEST_TOO_MANY     = 429,
    IOTX_DM_ERR_CODE_NO_ACTIVE_SESSION    = 520,
    IOTX_DM_ERR_CODE_TIMEOUT              = 100000
} iotx_dm_error_code_t;*/

typedef struct {
    const char *uri;
    unsigned char *payload;
    unsigned int payload_len;
    void *context;
} kk_msg_source_t;

typedef struct {
    const char *uri_name;
} kk_msg_dest_t;

typedef struct {
    lite_cjson_t id;
    lite_cjson_t version;
    lite_cjson_t method;
    lite_cjson_t params;
} kk_msg_request_payload_t;

typedef struct {
    lite_cjson_t id;
    lite_cjson_t code;
    lite_cjson_t data;
    lite_cjson_t message;
} kk_msg_response_payload_t;

typedef struct {
    int msgid;
    int devid;
    const char *service_prefix;
    const char *service_name;
    char product_key[PRODUCT_KEY_MAXLEN];
    char device_name[DEVICE_NAME_MAXLEN];
    char *params;
    int params_len;
    char *method;
    //iotx_cm_data_handle_cb callback;
} kk_msg_request_t;
typedef struct {
    const char *service_prefix;
    const char *service_name;
    char product_key[PRODUCT_KEY_MAXLEN];
    char device_name[DEVICE_NAME_MAXLEN];
    iotx_dm_error_code_t code;
} kk_msg_response_t;

typedef enum {
    kk_tsl_set_property_value = 0,
    kk_tsl_set_event_output_value,
    kk_tsl_set_service_output_value,
    kk_tsl_set_number,
} kk_tsl_set_t;
typedef enum {
	kk_tsl_get_property_value = 0,
	kk_tsl_get_event_output_value,
	kk_tsl_get_service_input_value,
	kk_tsl_get_service_output_value,
	kk_tsl_get_number,
} kk_tsl_get_t;

typedef struct {
    int devid;
    lite_cjson_item_t *lite;
} dm_api_property_t;
extern int kk_tsl_api_init(void);
extern int kk_tsl_set_value(kk_tsl_set_t set, int devId, const char *identifier, \
                                       const void *value, \
                                       const char *value_str);
extern int kk_tsl_get_value(kk_tsl_get_t method_get, int devId, const char *identifier, \
                                       void *value, \
                                       char **value_str);

extern int kk_msg_uri_parse_pkdn(_IN_ char *uri, _IN_ int uri_len, _IN_ int start_deli, _IN_ int end_deli, \
                          _OU_ char product_key[PRODUCT_KEY_MAXLEN], _OU_ char device_name[DEVICE_NAME_MAXLEN]);
extern int kk_tsl_service_property_set(const char *topic, const char *payload, unsigned int payload_len,
        void *context);
extern int kk_tsl_post_property(int devId, const char *property_identifier);
extern int kk_tsl_post_event(int devId, const char *event_identifier);
extern int kk_tsl_post_service(int devId, const char *service_identifier, int response_id,int code);
#endif
