#ifndef __KK_DM_MSG__
#define __KK_DM_MSG__
#include "kk_tsl_common.h"

#include "../tsl_handle/lite-cjson.h"


#define DM_MSG_KEY_ID                   "id"
#define DM_MSG_KEY_VERSION              "version"
#define DM_MSG_KEY_METHOD               "method"
#define DM_MSG_KEY_PARAMS               "params"
#define DM_MSG_KEY_CODE                 "code"
#define DM_MSG_KEY_DATA                 "data"
#define DM_MSG_KEY_MESSAGE              "message"

#define DM_MSG_VERSION                  "1.0"

#define DM_MSG_KEY_PRODUCT_KEY          "productKey"
#define DM_MSG_KEY_DEVICE_NAME          "deviceName"
#define DM_MSG_KEY_DEVICE_SECRET        "deviceSecret"
#define DM_MSG_KEY_TIME                 "time"


#define DM_MSG_SIGN_METHOD_SHA256       "Sha256"
#define DM_MSG_SIGN_METHOD_HMACMD5      "hmacMd5"
#define DM_MSG_SIGN_METHOD_HMACSHA1     "hmacSha1"
#define DM_MSG_SIGN_METHOD_HMACSHA256   "hmacSha256"


typedef struct {
    lite_cjson_t id;
    lite_cjson_t code;
    lite_cjson_t data;
    lite_cjson_t message;
} dm_msg_response_payload_t;


#ifndef DM_READ_ONLY
    #define DM_READ_ONLY
#endif
#define DM_MSG_VERSION                  "1.0"

extern const char DM_URI_SYS_PREFIX[]          DM_READ_ONLY;
extern const char DM_URI_THING_EVENT_PROPERTY_POST[]		 DM_READ_ONLY;
const char DM_URI_THING_SERVICE_PROPERTY_SET_REPLY[]  DM_READ_ONLY;
const char DM_URI_THING_EVENT_POST[]				  DM_READ_ONLY;
const char DM_URI_THING_SERVICE_RESPONSE[]			  DM_READ_ONLY;
const char DM_URI_THING_EVENT_PROPERTY_POST_METHOD[]  DM_READ_ONLY;
//const char DM_URI_SYS_PREFIX[]                        DM_READ_ONLY = "/sys/%s/%s/";


#endif
