#ifndef __KK_DM_MNG__
#define __KK_DM_MNG__
#include "kk_tsl_common.h"
#include "klist.h"

#include "iotx_dm.h"

#define KK_DM_DEVICE_SINGLE  (0x01)
#define KK_DM_DEVICE_SUBDEV  (0x02)
#define KK_DM_DEVICE_GATEWAY (0x04)
#define KK_MID_SYNC_DEFAULT_TIMEOUT_MS (200)

typedef struct {
    int devid;
    int dev_type;
    kk_tsl_t *dev_shadow;
    char product_key[PRODUCT_KEY_MAXLEN];
    char device_name[DEVICE_NAME_MAXLEN];
    char device_secret[DEVICE_SECRET_MAXLEN];
	char device_mac[DEVICE_MAC_MAXLEN];
    struct list_head linked_list;
} dm_mgr_dev_node_t;

typedef struct {
    void *mutex;
    int global_devid;
    struct list_head dev_list;
} dm_mgr_ctx;

typedef struct {
    int msgid;
    int devid;
    const char *service_prefix;
    const char *service_name;
    char product_key[PRODUCT_KEY_MAXLEN];
    char device_name[DEVICE_NAME_MAXLEN];
    char *params;
    int params_len;
    char *method;
    //iotx_cm_data_handle_cb callback;
} dm_msg_request_t;

#endif
