/*
 * Copyright (C) 2020-2020 ikonke
 */



#include "kk_dm_api.h"
#include "kk_tsl_common.h"
#include "kk_dm_mng.h"
#include "com_api.h"

static dm_api_ctx_t g_dm_api_ctx;

static dm_api_ctx_t *_dm_api_get_ctx(void)
{
    return &g_dm_api_ctx;
}

static void _dm_api_lock(void)
{
    dm_api_ctx_t *ctx = _dm_api_get_ctx();
    if (ctx->mutex) {
        HAL_MutexLock(ctx->mutex);
    }
}

static void _dm_api_unlock(void)
{
    dm_api_ctx_t *ctx = _dm_api_get_ctx();
    if (ctx->mutex) {
        HAL_MutexUnlock(ctx->mutex);
    }
}

int kk_dm_subdev_register(_IN_ int devid)
{
    int res = 0;
    dm_mgr_dev_node_t *search_node = NULL;

    if (devid < 0) {
        return INVALID_PARAMETER;
    }

    _dm_api_lock();
    res = dm_mgr_search_dev_by_devid(devid, (void **)&search_node);
    if (res != SUCCESS_RETURN) {
        _dm_api_unlock();
        return FAIL_RETURN;
    }

    if ((strlen(search_node->device_secret) > 0) && (strlen(search_node->device_secret) < DEVICE_SECRET_MAXLEN)) {
        _dm_api_unlock();
        return SUCCESS_RETURN;
    }

    res = dm_mgr_upstream_thing_sub_register(devid);

    _dm_api_unlock();
    return res;
}

int kk_dm_subdev_unregister(_IN_ int devid)
{
    int res = 0;

    if (devid < 0) {
        return INVALID_PARAMETER;
    }

    _dm_api_lock();

    res = dm_mgr_upstream_thing_sub_unregister(devid);

    _dm_api_unlock();
    return res;
}

int kk_dm_subdev_topo_add(_IN_ int devid)
{
    int res = 0;

    if (devid < 0) {
        return INVALID_PARAMETER;
    }

    _dm_api_lock();

    res = dm_mgr_upstream_thing_topo_add(devid);

    _dm_api_unlock();
    return res;
}

int iotx_dm_subdev_topo_del(_IN_ int devid)
{
    int res = 0;

    if (devid < 0) {
        return DM_INVALID_PARAMETER;
    }

    _dm_api_lock();

    res = dm_mgr_upstream_thing_topo_delete(devid);

    _dm_api_unlock();
    return res;
}

int iotx_dm_subdev_login(_IN_ int devid)
{
    int res = 0;

    if (devid < 0) {
        return INVALID_PARAMETER;
    }

    _dm_api_lock();

    res = dm_mgr_upstream_combine_login(devid);

    _dm_api_unlock();
    return res;
}

int iotx_dm_subdev_logout(_IN_ int devid)
{
    int res = 0;

    if (devid < 0) {
        return DM_INVALID_PARAMETER;
    }

    _dm_api_lock();

    res = dm_mgr_upstream_combine_logout(devid);

    _dm_api_unlock();
    return res;
}


void iotx_dm_dispatch(void)
{
    int count = 0;
    void *data = NULL;
    dm_api_ctx_t *ctx = _dm_api_get_ctx();

#if defined(OTA_ENABLED) && !defined(BUILD_AOS)
    dm_cota_status_check();
    dm_fota_status_check();
#endif
    while (CONFIG_DISPATCH_QUEUE_MAXLEN == 0 || count++ < CONFIG_DISPATCH_QUEUE_MAXLEN) {
        //printf("iotx_dm_dispatch time=%d \n", HAL_UptimeMs());
        if (dm_queue_msg_next(&data) == SUCCESS_RETURN) {
            //dm_queue_msg_t *msg = (dm_queue_msg_t *)data;
            printf("dm_queue_msg_next call \n");
            if (ctx->event_callback) {
                ctx->event_callback(1, data);
            }

            
            free(data);
            data = NULL;
        } else {
            break;
        }
    }
}

int iotx_dm_connect(_IN_ iotx_dm_event_callback cb)
{
    int res = 0;
    dm_api_ctx_t *ctx = _dm_api_get_ctx();

    if (cb == NULL) {
        return INVALID_PARAMETER;
    }

    /* DM Event Callback */

    ctx->event_callback = cb;


    /*res = dm_client_connect(IOTX_DM_CLIENT_CONNECT_TIMEOUT_MS);
    if (res != SUCCESS_RETURN) {
        return FAIL_RETURN;
    }

#ifdef ALCS_ENABLED

    res = dm_server_connect();
    if (res != SUCCESS_RETURN) {
        return FAIL_RETURN;
    }
#endif*/

    return SUCCESS_RETURN;
}

int iotx_dm_subscribe(_IN_ int devid)
{
    int res = 0, dev_type = 0;
    char product_key[PRODUCT_KEY_MAXLEN] = {0};
    char device_name[DEVICE_NAME_MAXLEN] = {0};
    char device_secret[DEVICE_SECRET_MAXLEN] = {0};

    if (devid < 0) {
        return INVALID_PARAMETER;
    }

    dm_mgr_dev_node_t *node = NULL;
    _dm_api_lock();
    res = dm_mgr_search_dev_by_devid(devid, &node);
    if (res != SUCCESS_RETURN) {
        _dm_api_unlock();
        return FAIL_RETURN;
    }
    _dm_api_unlock();
    
    //send app to subscribe mqtt
    const char subscribe_cmd[]  =
            "{\"cmd\":\"subscribe\",\"data\":{\"productType\":\"%s\",\"productCode\":\"%s\"}}";
    int len = strlen(subscribe_cmd) + strlen(node->product_key) + strlen(node->device_name) + 1;
    void* buf = malloc(len);
    
    if (buf){
        HAL_Snprintf(buf, len, subscribe_cmd, node->product_key, node->device_name);
        kk_ipc_send(IPC_MID2APP, buf, len);
        free(buf);
    }else{
        
        printf("\n [%d][%s] malloc faild kk_ipc_send \n", __LINE__, __FUNCTION__);
        return FAIL_RETURN;
    }
    printf("\n [%d][%s] [%d] send app to subscribe mqtt  \n", __LINE__, __FUNCTION__, HAL_UptimeMs());


   

    return SUCCESS_RETURN;
}


