#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mqtt_api.h"
#include "com_api.h"
#include "cJSON.h"

#define KK_FILTER_ADD_TOPIC 		           "/thing/topo/add"
#define KK_FILTER_ADD_TOPIC_REPLY              "/thing/topo/add_reply"
#define KK_FILTER_DELETE_TOPIC                 "/thing/topo/delete"
#define KK_FILTER_DELETE_TOPIC_REPLY           "/thing/topo/delete_reply"
#define KK_FILTER_REGISTER_TOPIC               "/thing/sub/register"
#define KK_FILTER_REGISTER_TOPIC_REPLY         "/thing/sub/register_reply"
#define KK_FILTER_LOGIN_TOPIC                  "/thing/combine/login"
#define KK_FILTER_LOGIN_TOPIC_REPLY            "/thing/combine/login_reply"
#define KK_FILTER_SET_TOPIC                  "/thing/service/property/set"
#define KK_FILTER_SET_TOPIC_REPLY            "/thing/service/property/set_reply"
#define KK_FILTER_EVENT_POST_TOPIC            "/thing/event/property/post"
#define KK_FILTER_EVENT_POST_REPLY            "/thing/event/property/post_reply"


int _kk_sendto_cloud(cJSON *root)
{
	cJSON *pTopic,*pData;
	char *topic = NULL;
	char *payload = NULL;

	pTopic = cJSON_GetObjectItem(root, "topic");
	if(pTopic == NULL){
		return;
	}
	pData = cJSON_GetObjectItem(root, "payload");
	if(pData == NULL){
		return;
	}
	printf("[%s][%d] topic:%s\n",__FUNCTION__,__LINE__,pTopic->valuestring);
	printf("[%s][%d] payload:%s\n",__FUNCTION__,__LINE__,pData->valuestring);	
	KK_MQTT_SendMsg(pTopic->valuestring,(const char*)pData->valuestring);	
}

void KK_Data_FromDev(void* str,int len)
{
	cJSON *root,*cmd;
	if(str == NULL){
		return;
	}
	root=cJSON_Parse((char*)str);
	if(root == NULL){
		return;
	}
	cmd = cJSON_GetObjectItem(root, "cmd");
	if(cmd == NULL){
		_kk_sendto_cloud(root);
	}
	else{
		KK_Subdev_Subscribe(root);
	}
	cJSON_Delete(root);

}
static int _check_invalid_topic(const char* topic)
{
	if(strstr(topic, KK_FILTER_ADD_TOPIC) != NULL && \
		strstr(topic,KK_FILTER_ADD_TOPIC_REPLY) == NULL){
		return 1;
	}
	else if(strstr(topic, KK_FILTER_DELETE_TOPIC) != NULL && \
		strstr(topic,KK_FILTER_DELETE_TOPIC_REPLY) == NULL){
		return 1;
	}
	else if(strstr(topic, KK_FILTER_REGISTER_TOPIC) != NULL && \
		strstr(topic,KK_FILTER_REGISTER_TOPIC_REPLY) == NULL){
		return 1;
	}		
	else if(strstr(topic, KK_FILTER_LOGIN_TOPIC) != NULL && \
		strstr(topic,KK_FILTER_LOGIN_TOPIC_REPLY) == NULL){
		return 1;
	}	
		else if(strstr(topic, KK_FILTER_SET_TOPIC_REPLY) != NULL){
		return 1;
	}		
	else if(strstr(topic, KK_FILTER_EVENT_POST_TOPIC) != NULL && \
		strstr(topic,KK_FILTER_LOGIN_TOPIC_REPLY) == NULL){
		return 1;
	}
	return 0;
}
static char * _kk_data_create(const char *topic,const char *data)
{
	cJSON *root;
	char *out;
	root=cJSON_CreateObject();
	cJSON_AddStringToObject(root,"topic",topic);
	cJSON_AddStringToObject(root,"payload",data);
	out=cJSON_Print(root);	
	cJSON_Delete(root);	
	printf("[%s][%d]%s\n",__FUNCTION__,__LINE__,out);	
	return out;
	//free(out);	/* Print to text, Delete the cJSON, print it, release the string. */
}

void KK_Sendto_DevData(const char *topic,const char *data)
{
	if(_check_invalid_topic(topic))
	{
		return;//ingore the message
	}
	char *send_data = _kk_data_create(topic,data);
	
	kk_ipc_send(IPC_APP2MID, send_data, strlen(send_data)+1);
}
