#include "RPC_API.h"
#include "rpc_colorControl.h"


cJSON *rpc_zclColorControlMovetohue(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_hue;
	cJSON *item_dir;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_override;
	
	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_hue = cJSON_GetObjectItem(params, "hue");
		item_dir = cJSON_GetObjectItem(params, "dir");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_hue==NULL ||
		item_dir==NULL ||
		item_trsTime == NULL || 
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_hue->type!=cJSON_String ||
		item_dir->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("hue=%s\n",(item_hue->type==cJSON_True)?"":"not ");
	kk_print_debug("dir=%s\n",item_dir->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t hue = rpc_get_u8(item_hue->valuestring);
	uint8_t dir = rpc_get_u8(item_dir->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_override->valuestring);
	}

	status = zclColorControlMovetohue(node,ep,hue,dir,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlMovehue(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_mode;
	cJSON *item_rate;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_mode = cJSON_GetObjectItem(params, "mode");
		item_rate = cJSON_GetObjectItem(params, "rate");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_mode==NULL ||
		item_rate==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_rate->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("rate=%s\n",item_rate->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint8_t rate = rpc_get_u8(item_rate->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}

	status = zclColorControlMovehue(node,ep,mode,rate,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlStephue(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_mode;
	cJSON *item_size;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_mode = cJSON_GetObjectItem(params, "mode");
		item_size = cJSON_GetObjectItem(params, "size");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_mode==NULL ||
		item_size==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_size->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("size=%s\n",item_size->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint8_t size = rpc_get_u8(item_size->valuestring);
	uint8_t trsTime = rpc_get_u8(item_trsTime->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}

	status = zclColorControlStephue(node,ep,mode,size,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlMovetosat(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_saturation;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_saturation = cJSON_GetObjectItem(params, "saturation");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_saturation==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_saturation->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("saturation=%s\n",item_saturation->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t saturation = rpc_get_u8(item_saturation->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}

	status = zclColorControlMovetosat(node,ep,saturation,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlMovesat(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_mode;
	cJSON *item_rate;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_mode = cJSON_GetObjectItem(params, "mode");
		item_rate = cJSON_GetObjectItem(params, "rate");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_mode==NULL ||
		item_rate==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_rate->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("rate=%s\n",item_rate->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint8_t rate = rpc_get_u8(item_rate->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}

	status = zclColorControlMovesat(node,ep,mode,rate,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlStepsat(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_mode;
	cJSON *item_size;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_mode = cJSON_GetObjectItem(params, "mode");
		item_size = cJSON_GetObjectItem(params, "size");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_mode==NULL ||
		item_size==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_size->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("rate=%s\n",item_size->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint8_t size = rpc_get_u8(item_size->valuestring);
	uint8_t trsTime = rpc_get_u8(item_trsTime->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlStepsat(node,ep,mode,size,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlMovetohueandsat(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_hue;
	cJSON *item_saturation;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_hue = cJSON_GetObjectItem(params, "hue");
		item_saturation = cJSON_GetObjectItem(params, "saturation");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_hue==NULL ||
		item_saturation==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_hue->type!=cJSON_String ||
		item_saturation->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("mode=%s\n",item_hue->valuestring);
	kk_print_debug("rate=%s\n",item_saturation->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t hue = rpc_get_u8(item_hue->valuestring);
	uint8_t saturation = rpc_get_u8(item_saturation->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlMovetohueandsat(node,ep,hue,saturation,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclColorControlMovetocolor(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_colorX;
	cJSON *item_colorY;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_colorX = cJSON_GetObjectItem(params, "colorX");
		item_colorY = cJSON_GetObjectItem(params, "colorY");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_colorX==NULL ||
		item_colorY==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_colorX->type!=cJSON_String ||
		item_colorY->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("colorX=%s\n",item_colorX->valuestring);
	kk_print_debug("colorY=%s\n",item_colorY->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint16_t colorX = rpc_get_u16(item_colorX->valuestring);
	uint16_t colorY = rpc_get_u16(item_colorY->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlMovetocolor(node,ep,colorX,colorY,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlMovecolor(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_rateX;
	cJSON *item_rateY;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_rateX = cJSON_GetObjectItem(params, "rateX");
		item_rateY = cJSON_GetObjectItem(params, "rateY");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_rateX==NULL ||
		item_rateY==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_rateX->type!=cJSON_String ||
		item_rateY->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("rateX=%s\n",item_rateX->valuestring);
	kk_print_debug("rateY=%s\n",item_rateY->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint16_t rateX = rpc_get_u16(item_rateX->valuestring);
	uint16_t rateY = rpc_get_u16(item_rateY->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlMovecolor(node,ep,rateX,rateY,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlStepcolor(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_stepX;
	cJSON *item_stepY;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_stepX = cJSON_GetObjectItem(params, "stepX");
		item_stepY = cJSON_GetObjectItem(params, "stepY");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_stepX==NULL ||
		item_stepY==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_stepX->type!=cJSON_String ||
		item_stepY->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("stepX=%s\n",item_stepX->valuestring);
	kk_print_debug("stepY=%s\n",item_stepY->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint16_t stepX = rpc_get_u16(item_stepX->valuestring);
	uint16_t stepY = rpc_get_u16(item_stepY->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlStepcolor(node,ep,stepX,stepY,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlMovetocolortemp(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_colorTemp;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_colorTemp = cJSON_GetObjectItem(params, "colorTemp");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_colorTemp==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_colorTemp->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("colorTemp=%s\n",item_colorTemp->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint16_t colorTemp = rpc_get_u16(item_colorTemp->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlMovetocolortemp(node,ep,colorTemp,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclColorControlEmovetohue(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_hue;
	cJSON *item_dir;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_hue = cJSON_GetObjectItem(params, "hue");
		item_dir = cJSON_GetObjectItem(params, "dir");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_hue==NULL ||
		item_dir==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_hue->type!=cJSON_String ||
		item_dir->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("hue=%s\n",item_hue->valuestring);
	kk_print_debug("dir=%s\n",item_dir->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint16_t hue = rpc_get_u16(item_hue->valuestring);
	uint8_t dir = rpc_get_u8(item_dir->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlEmovetohue(node,ep,hue,dir,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlEmovehue(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_mode;
	cJSON *item_rate;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_mode = cJSON_GetObjectItem(params, "mode");
		item_rate = cJSON_GetObjectItem(params, "rate");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_mode==NULL ||
		item_rate==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_rate->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("rate=%s\n",item_rate->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint16_t rate = rpc_get_u16(item_rate->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlEmovehue(node,ep,mode,rate,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclColorControlEstephue(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_mode;
	cJSON *item_size;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_mode = cJSON_GetObjectItem(params, "mode");
		item_size = cJSON_GetObjectItem(params, "size");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_mode==NULL ||
		item_size==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_size->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("size=%s\n",item_size->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint16_t size = rpc_get_u16(item_size->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlEstephue(node,ep,mode,size,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlEmovetohueandsat(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_hue;
	cJSON *item_saturation;
	cJSON *item_trsTime;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_hue = cJSON_GetObjectItem(params, "hue");
		item_saturation = cJSON_GetObjectItem(params, "saturation");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_hue==NULL ||
		item_saturation==NULL ||
		item_trsTime==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_hue->type!=cJSON_String ||
		item_saturation->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("hue=%s\n",item_hue->valuestring);
	kk_print_debug("saturation=%s\n",item_saturation->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint16_t hue = rpc_get_u16(item_hue->valuestring);
	uint8_t saturation = rpc_get_u8(item_saturation->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	
	status = zclColorControlEmovetohueandsat(node,ep,hue,saturation,trsTime,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlLoopSet(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_flags;
	cJSON *item_action;
	cJSON *item_dir;
	cJSON *item_time;
	cJSON *item_sHue;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_flags = cJSON_GetObjectItem(params, "flags");
		item_action = cJSON_GetObjectItem(params, "action");
		item_dir = cJSON_GetObjectItem(params, "dir");
		item_time = cJSON_GetObjectItem(params, "time");
		item_sHue = cJSON_GetObjectItem(params, "sHue");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_flags==NULL ||
		item_action==NULL ||
		item_dir==NULL ||
		item_time==NULL ||
		item_sHue==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_flags->type!=cJSON_String ||
		item_action->type!=cJSON_String ||
		item_dir->type!=cJSON_String ||
		item_time->type!=cJSON_String ||
		item_sHue->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("flags=%s\n",item_flags->valuestring);
	kk_print_debug("action=%s\n",item_action->valuestring);
	kk_print_debug("dir=%s\n",item_dir->valuestring);
	kk_print_debug("time=%s\n",item_time->valuestring);
	kk_print_debug("sHue=%s\n",item_sHue->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t flags = rpc_get_u8(item_flags->valuestring);
	uint8_t action = rpc_get_u8(item_action->valuestring);
	uint8_t dir = rpc_get_u8(item_dir->valuestring);
	uint16_t Time = rpc_get_u16(item_time->valuestring);
	uint16_t sHue = rpc_get_u16(item_sHue->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	status = zclColorControlLoopSet(node,ep,flags,action,dir,Time,sHue,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclColorControlStopmovestep(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
		
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	status = zclColorControlStopmovestep(node,ep,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}

cJSON *rpc_zclColorControlMovecolortemp(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	
	cJSON *item_mode;
	cJSON *item_rate;
	cJSON *item_min;
	cJSON *item_max;
	
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");

		item_mode = cJSON_GetObjectItem(params, "mode");
		item_rate = cJSON_GetObjectItem(params, "rate");
		item_min = cJSON_GetObjectItem(params, "minMireds");
		item_max = cJSON_GetObjectItem(params, "maxMireds");
	
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_rate->type!=cJSON_String ||
		item_max->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);

	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("rate=%s\n",item_rate->valuestring);
	kk_print_debug("minMireds=%s\n",item_min->valuestring);
	kk_print_debug("maxMireds=%s\n",item_max->valuestring);
	
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint16_t rate = rpc_get_u16(item_rate->valuestring);
	uint16_t min = rpc_get_u16(item_min->valuestring);
	uint16_t max = rpc_get_u16(item_max->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	status = zclColorControlMovecolortemp(node,ep,mode,rate,min,max,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}
cJSON *rpc_zclColorControlStepcolortemp(jrpc_context * ctx, cJSON * params, cJSON *id)
{
	cJSON *item_node;
	cJSON *item_ep;
	
	cJSON *item_mode;
	cJSON *item_size;
	cJSON *item_trsTime;
	cJSON *item_minimum;
	cJSON *item_maximum;
	
	cJSON *item_options;
	cJSON *item_mask;
	cJSON *item_Override;

	EmberStatus status;
	if(params == NULL){
		emberAfCorePrintln("\r\nparams == NULL\r\n" );
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}else{
		item_node = cJSON_GetObjectItem(params, "node");
		item_ep = cJSON_GetObjectItem(params, "dstEP");

		item_mode = cJSON_GetObjectItem(params, "mode");
		item_size = cJSON_GetObjectItem(params, "size");
		item_trsTime = cJSON_GetObjectItem(params, "trsTime");
		item_minimum = cJSON_GetObjectItem(params, "minMireds");
		item_maximum = cJSON_GetObjectItem(params, "maxMireds");
	
		item_options = cJSON_GetObjectItem(params, "options");
		item_mask = cJSON_GetObjectItem(params, "mask");
		item_Override = cJSON_GetObjectItem(params, "override");
	}
	if(item_node==NULL ||
		item_ep==NULL ||
		item_options == NULL){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug("1.....\n");
		goto error_return;
	}
	if(item_node->type!=cJSON_String ||
		item_ep->type!=cJSON_String ||
		item_mode->type!=cJSON_String ||
		item_size->type!=cJSON_String ||
		item_trsTime->type!=cJSON_String ||
		item_minimum->type!=cJSON_String ||
		item_maximum->type!=cJSON_String ||
		(item_options->type!=cJSON_True &&
			item_options->type!=cJSON_False)){
		set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		kk_print_debug(".2....\n");
		goto error_return;
	}
	if(item_options->type==cJSON_True ){
		if(item_mask == NULL || item_Override == NULL){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".3....\n");
			goto error_return;
		}
		if(item_mask->type!=cJSON_String ||item_Override->type!=cJSON_String ){
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			kk_print_debug(".4....\n");
			goto error_return;
		}
	}

	kk_print_debug("node=%s\n",item_node->valuestring);
	kk_print_debug("dstEP=%s\n",item_ep->valuestring);

	kk_print_debug("mode=%s\n",item_mode->valuestring);
	kk_print_debug("size=%s\n",item_size->valuestring);
	kk_print_debug("trsTime=%s\n",item_trsTime->valuestring);
	kk_print_debug("minMireds=%s\n",item_minimum->valuestring);
	kk_print_debug("maxMireds=%s\n",item_maximum->valuestring);
	
	kk_print_debug("%s options\n",(item_options->type==cJSON_True)?"has":"no");
	if(item_options->type==cJSON_True){
		kk_print_debug("mask=%s\n",item_mask->valuestring);
		kk_print_debug("override=%s\n",item_Override->valuestring);
	}

	uint16_t node = rpc_get_u16(item_node->valuestring);
	uint8_t ep = rpc_get_u8(item_ep->valuestring);
	uint8_t mode = rpc_get_u8(item_mode->valuestring);
	uint16_t size = rpc_get_u16(item_size->valuestring);
	uint16_t trsTime = rpc_get_u16(item_trsTime->valuestring);
	uint16_t minimum = rpc_get_u16(item_minimum->valuestring);
	uint16_t maximum = rpc_get_u16(item_maximum->valuestring);
	
	bool options = (item_options->type==cJSON_True)?true:false;
	uint8_t mask = 0;
	uint8_t Override = 0;
	if(options==true){
		mask = rpc_get_u8(item_mask->valuestring);
		Override = rpc_get_u8(item_Override->valuestring);
	}
	status = zclColorControlStepcolortemp(node,ep,mode,size,trsTime,minimum,maximum,options,mask,Override);
	if(status == EMBER_ZCL_STATUS_SUCCESS){
		kk_print_debug("send suc.");
	}else{
		kk_print_debug("send fail!status=0x%02X\r\n",status);
	}
	return rpc_cJSON_CreateNumber(status);


	error_return:
	return rpc_cJSON_CreateNull();		
}








			







									
















