#include "kk_test.h"
#include "kk_ncp_queue.h"

static void kk_rpc_send_message(cJSON *data,char *msgtype,char *method,EmberEUI64 mac)
{
	static uint16_t msgid;
	char msgIdString[10]= {0};
	char macString[19] = {0};
	int res = 0;
	kk_device_table_s *dev =NULL;

	rpc_eui64ToString(mac,macString);	
	dev = kk_device_find_by_mac(mac);
	if (dev == NULL) {
		printf("[%s][%d]kk_rpc_send_message error!!!\n",__FUNCTION__,__LINE__);
		return; 
	}	

	cJSON *info = rpc_cJSON_CreateObject();
	if(info != NULL){
		rpc_cJSON_AddStringToObject(info, "msgType",msgtype);
		rpc_cJSON_AddStringToObject(info, "productCode",dev->productCode);
		rpc_cJSON_AddStringToObject(info, "deviceCode",macString);	
	}
	cJSON *payload = rpc_cJSON_CreateObject();
	if(payload != NULL){
		sprintf(msgIdString,"%d",++msgid);
		rpc_cJSON_AddStringToObject(payload, "msgId",msgIdString);
		rpc_cJSON_AddStringToObject(payload, "version", KK_IPC_VERSION);
		rpc_cJSON_AddStringToObject(payload, "method",method);
		rpc_cJSON_AddItemToObject(payload, "params", data);		
	}
	cJSON *root = rpc_cJSON_CreateObject();
	if(root != NULL){
		rpc_cJSON_AddItemToObject(root, "info", info);	
		rpc_cJSON_AddItemToObject(root, "payload", payload);	
	}

	char* p = rpc_cJSON_Print(root);
	emberAfAppPrintln("send json:\n%s\n",p);
	free(p);
	jrpc_send_msg(root);	
	rpc_cJSON_Delete(root);	
}
void kk_rpc_report_devices(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_DEVICE_JOINED_TYPE,KK_REPORT_DEVICE_JOINED_METHOD,mac);
}
void kk_rpc_report_left_devices(cJSON *data,EmberEUI64 mac)
{
	kk_rpc_send_message(data,KK_REPORT_DEVICE_LEFT_TYPE,KK_REPORT_DEVICE_LEAVE_METHOD,mac);
}

void kk_rpc_report_status(cJSON *data,EmberEUI64 mac)
{

	kk_rpc_send_message(data,KK_REPORT_ATTRIBUTE_TYPE,KK_REPORT_ATTRIBUTE_METHOD,mac);
}

typedef struct{
	EmberEUI64 mac;
	uint8_t AppVersion;
	uint8_t deviceType;
	uint8_t deviceCode;
	uint8_t productType;
	uint8_t productCode;
}kk_report_device_s;

void kk_rpc_reportLeftDevices(EmberEUI64 mac)
{
	cJSON* devicesJson;
	char macString[RPC_EUI64_STRING_LENGTH];
	int res = 0;
	EmberEUI64 gw_eui64  = {0};
	kk_device_table_s *dev =NULL;

	rpc_eui64ToString(mac,macString);	
	dev = kk_device_find_by_mac(mac);
	if (dev == NULL) {
		printf("[%s][%d]kk_rpc_reportLeftDevices error!!!\n",__FUNCTION__,__LINE__);
		return; 
	}
	devicesJson = rpc_cJSON_CreateObject();
	rpc_cJSON_AddStringToObject(devicesJson, "productCode",dev->productCode);
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode",macString);
	emberAfGetEui64(gw_eui64);
	kk_rpc_report_left_devices(devicesJson,gw_eui64);
	kk_device_table_delete(mac);

	
}



void kk_rpc_reportDevices(EmberEUI64 mac,const char* productCode)
{
	cJSON* devicesJson;
	char macString[19] = {0};
	EmberEUI64 eui64  = {0};

	UTIL_LOG_WARNING("report tsl product code:%s\n",productCode);
	emberAfPrintBigEndianEui64(mac);
	emberAfDebugPrintln("");

	devicesJson = rpc_cJSON_CreateObject();
	rpc_eui64ToString(mac,macString);
	rpc_cJSON_AddStringToObject(devicesJson, "productCode",productCode);
	rpc_cJSON_AddStringToObject(devicesJson, "deviceCode",macString);
	rpc_cJSON_AddStringToObject(devicesJson, "mac",macString);
	//
	emberAfGetEui64(eui64);
	kk_rpc_report_devices(devicesJson,eui64);
}



int kk_zcl_onoff_set(jrpc_context * ctx,const char *mac,unsigned char ep,void* data)
{
	uint8_t eui64[EUI64_SIZE];
    uint8_t OnOffStatus	= 0;
	EmberStatus status = 0;
	EmberNodeId node = 0xffff;

	OnOffStatus = *(uint8_t*)data;
	bool macMatch= rpc_get_mac(mac,eui64);
	emberAfCorePrintBuffer(eui64,EUI64_SIZE,true);
	for(int i=0;i<EUI64_SIZE;i++){
		emberAfCorePrintln("i=%d,val=%02x",i,eui64[i]);
	}


	if(macMatch){
		node = emberAfDeviceTableGetNodeIdFromEui64(eui64);
		if(node==0xffff){
			emberAfCorePrintln("\r\n not find device by node!\r\n" );
			if(ctx)
				set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
		emberAfCorePrintln("\r\nnode=0x%02X,ep=%d,OnOffStatus=%d\r\n",node,ep,OnOffStatus);

		if(OnOffStatus==1){
			status = zclOnOff_On(node,ep);
			emberAfCorePrintln("\r\nzclOnOff_On,status=0x%x\r\n",status);
		}else if(OnOffStatus==0){
			status = zclOnOff_Off(node,ep);
			emberAfCorePrintln("\r\nzclOnOff_Off,status=0x%x\r\n",status);
		}else{
			if(ctx)
				set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
			goto error_return;
		}
	}else{
		emberAfCorePrintln("\r\n not find device by mac!\r\n" );
		if(ctx)
			set_json_error_type(ctx,JRPC_INVALID_PARAMS,MSG_INVALID_PARAMS);
		goto error_return;
	}	
	return status;
error_return:
	return -1;
}
//EmberStatus WindowCover_UpOpen(uint16_t node,uint8_t ep);
//EmberStatus WindowCover_DownClose(uint16_t node,uint8_t ep);
//EmberStatus WindowCover_Stop(uint16_t node,uint8_t ep);





























extern void ncp_queue_tick(void);





void emberAfMainTickCallback(void)
{

	static unsigned int last_time;
	unsigned int time = halCommonGetInt32uMillisecondTick();
	kk_sub_dev_manage();
	
	ncp_queue_tick();

	if((time-last_time)>=3000){
		last_time = time;
		kk_productCode_tick();
		//printf("kk_productCode_tick!\n");
	}
}




