#include "sub_device_manage.h"
#include "kk_device_manager.h"
#include "kk_zb_com.h"

typedef void(*subDevManageFunc)(kk_device_table_s* dev);

typedef struct{
	uint16_t deviceId;
	subDevManageFunc func;
}SubDevDispatch_s;


void kk_ColorLighting_manage(kk_device_table_s* dev);

SubDevDispatch_s SubDevDispatch[] = {
	{DEVICE_ID_HA_DIMMABLE_LIGHT,kk_ColorLighting_manage},
	{DEVICE_ID_HA_COLOR_DIMMABLE_LIGHT,kk_ColorLighting_manage},
};
static int report_colorLighting_RGB(kk_device_table_s* dev)
{
	kk_dev_config_map *dev_info = NULL;
	kk_dev_config_item *item = NULL;	
	cJSON *root;
	int rev = 0;
	int startIdx = 0;
	cJSON* root_color = NULL;
	char tmp_Identity[64] = {0};
	emberAfCorePrintln("[report_colorLighting_RGB] %d",__LINE__);

	unsigned short H = dev->manage.dev.ColorLighting.color.HSL.H;
	unsigned char S = dev->manage.dev.ColorLighting.color.HSL.S;
	unsigned char L = dev->manage.dev.ColorLighting.color.HSL.L;
	unsigned char red,green,blue;
	HSL_to_RGB(H,S,L,&red,&green,&blue);
	emberAfAppPrintln("%d,%d,%d",H,S,L);
	emberAfAppPrintln("%d,%d,%d",red,green,blue);

		dev_info = kk_device_config_find(dev->productCode);
		if(dev_info == NULL){
			return tsl_rpt_err;
		}		
		item = &dev_info->item;
		while(item!=NULL){
			if(strstr(item->identity,".red") != NULL){
				if(root_color == NULL){
					root_color = rpc_cJSON_CreateObject();
				}
				rev = kk_tsl_utils_memtok(item->identity,'.',1,&startIdx);
				if(!rev){
					memcpy(tmp_Identity,item->identity,startIdx);
					rpc_cJSON_AddNumberToObject(root_color, item->identity + 1 + startIdx,red);
				}
			}
			else if(strstr(item->identity,".green") != NULL){
				if(root_color == NULL){
					root_color = rpc_cJSON_CreateObject();
				}				
				rev = kk_tsl_utils_memtok(item->identity,'.',1,&startIdx);
				if(!rev){
					memcpy(tmp_Identity,item->identity,startIdx);
					rpc_cJSON_AddNumberToObject(root_color, item->identity + 1 + startIdx,green);
				}
			}		
			else if(strstr(item->identity,".blue") != NULL){
				if(root_color == NULL){
					root_color = rpc_cJSON_CreateObject();
				}					
				rev = kk_tsl_utils_memtok(item->identity,'.',1,&startIdx);
				if(!rev){
					memcpy(tmp_Identity,item->identity,startIdx);
					rpc_cJSON_AddNumberToObject(root_color, item->identity + 1 + startIdx,blue);
				}
			}		
			item = item->next;
		}
		if(root_color != NULL){
			root = rpc_cJSON_CreateObject();
			rpc_cJSON_AddItemToObject(root,tmp_Identity,root_color);
			kk_msg_report_property(root,dev->mac);
			return tsl_rpt_success;
		}
	
	return tsl_rpt_err;
}

void kk_colorlight_attr_read(uint16_t nodeId,
							uint8_t ep,
							uint16_t cluster,
							uint16_t attribute,
							uint8_t status,
							uint8_t dataType,
							uint8_t dataSize,
							uint8_t *data)
{
	kk_device_table_s* dev;
	ColorLighting_s *ptr;

	if(cluster!=ZCL_COLOR_CONTROL_CLUSTER_ID) return ;
	if(ep!=KK_PRIMARY_EP) return ;
	
	UTIL_LOG_INFO("\n********************kk_colorlight_attr_read********************\n");
	dev = kk_device_find_by_node(nodeId);
	if(dev ==NULL) return ;

	ptr = &dev->manage.dev.ColorLighting;

	if(attribute==ZCL_COLOR_CONTROL_COLOR_MODE_ATTRIBUTE_ID){
		if(status == EMBER_ZCL_STATUS_SUCCESS){
			ptr->CloorModeFlag = DevManage_Success;
			ptr->CloorMode = *data;
			emberAfCorePrintln("[CloorMode]val:%d",*data);
		}else if(status == EMBER_ZCL_STATUS_UNSUPPORTED_ATTRIBUTE){
			ptr->CloorModeFlag = DevManage_NotSupport;
			emberAfCorePrintln("[CloorMode]not support!!!");
		}else{ 
			ptr->CloorModeFlag = DevManage_Fail;
			emberAfCorePrintln("[CloorMode]fail,status=0X%X!!!",status);
		}
	}
	if(attribute==ZCL_COLOR_CONTROL_COLOR_CAPABILITIES_ATTRIBUTE_ID){
		if(status == EMBER_ZCL_STATUS_SUCCESS){
			ptr->CapabilitiesFlag = DevManage_Success;
			ptr->Capabilities = *data;
			emberAfCorePrintln("[Capabilities]val:%d",*data);
		}else if(status == EMBER_ZCL_STATUS_UNSUPPORTED_ATTRIBUTE){
			ptr->CapabilitiesFlag = DevManage_NotSupport;
			emberAfCorePrintln("[Capabilities]not support!!!");
		}else{ 
			ptr->CapabilitiesFlag = DevManage_Fail;
			emberAfCorePrintln("[Capabilities]fail,status=0X%X!!!",status);
		}
	}
		

}
void kk_ColorLighting_manage(kk_device_table_s* dev)
{
	EmberAfStatus status;
	ColorLighting_s *ptr;

	if(dev == NULL) return ;
	
	ptr = &dev->manage.dev.ColorLighting;
	uint32_t time = halCommonGetInt32uMillisecondTick();

	if(ptr->CloorModeFlag==DevManage_Unkown ||
		ptr->CapabilitiesFlag==DevManage_Unkown){
		uint16_t attr[2] = {ZCL_COLOR_CONTROL_COLOR_MODE_ATTRIBUTE_ID,ZCL_COLOR_CONTROL_COLOR_CAPABILITIES_ATTRIBUTE_ID};
		status = zclGReadAttrs(dev->nodeId,1,1,false,ZCL_COLOR_CONTROL_CLUSTER_ID,2,attr,true);
		emberAfCorePrintln("[ColorLighting_manage] read mode and capabilities from 0x%04X",dev->nodeId);
	}
	
	if(ptr->color.HSL.HSL_flag!=0){
		if(ptr->time != 0){
			if((time-ptr->time) >= 1000*3){
				if(ptr->CloorSetFlag==true && ptr->color.HSL.HSL_flag==0x03){
					report_colorLighting_RGB(dev);
					ptr->CloorSetFlag = false;
					emberAfCorePrintln("$$$$$$$$[ColorLighting_manage] %d",__LINE__);
					return;
				}
				ptr->time = 0;
				ptr->color.HSL.HSL_flag = 0;
				ptr->CloorSetFlag = false;
				emberAfCorePrintln("!!!!!!!!!![ColorLighting_manage] %d",__LINE__);
				return;
			}
		}
		
		if(ptr->CloorSetFlag==true && ptr->color.HSL.HSL_flag==0x07){
			report_colorLighting_RGB(dev);
			ptr->CloorSetFlag = false;
			ptr->color.HSL.HSL_flag = 0;
			ptr->time = 0;
			emberAfCorePrintln("@@@@@@@@@@[ColorLighting_manage] %d",__LINE__);
			return;
		}
	}
}

void kk_sub_dev_manage(void)
{
	static uint32_t LastTime;
	uint32_t time = halCommonGetInt32uMillisecondTick();

	kk_device_table_s *ptr = kk_get_device_table_pointer();
	if((time-LastTime)>=1000){
		LastTime = time;
		while(ptr!=NULL){
			for(int i=0;i<sizeof(SubDevDispatch)/sizeof(SubDevDispatch_s);i++){
				if(ptr->deviceId == SubDevDispatch[i].deviceId && SubDevDispatch[i].func!=NULL){
					SubDevDispatch[i].func(ptr);
				}
			}
			ptr = ptr->next;
		}
	}
}




























