#include "yjq_ezsp.h"




static EmberVersion kk_ember_ver;
kk_EZSP_version_s kk_EZSP_ver;

#define EMBER_AF_PRINT_ENABLE
#define EMBER_AF_PRINT_APP 0x0002

void kk_set_ezsp_version_info(uint8_t hostEzspProtocolVer,
										uint8_t ncpEzspProtocolVer,
										uint8_t stackType,
										uint16_t stackVersion,
										EmberVersion *emberVer)
{
	kk_EZSP_ver.hostEzspProtocolVer = hostEzspProtocolVer;
	kk_EZSP_ver.ncpEzspProtocolVer = ncpEzspProtocolVer;
	kk_EZSP_ver.stackType = stackType;
	kk_EZSP_ver.stackVersion = stackVersion;
	if(emberVer!=NULL){
		MEMCOPY(&kk_ember_ver,emberVer,sizeof(EmberVersion));
		kk_EZSP_ver.emberVer = &kk_ember_ver;
	}else{
		MEMSET(&kk_ember_ver,0,sizeof(EmberVersion));
		kk_EZSP_ver.emberVer = NULL;
	}
	kk_EZSP_ver.emberVer = &kk_ember_ver;
}


void kk_print_version(void)
{
	kk_print_error("\r\nkk_print_version!!!!\r\n");

	if(kk_EZSP_ver.emberVer==NULL){

	}else{

	}
	
}

void kk_read_configuration_value(EzspConfigId id,const char* idStr)
{
	uint16_t value;
	EzspStatus status;
	status = ezspGetConfigurationValue(EZSP_CONFIG_BINDING_TABLE_SIZE,&value);
	if(idStr!=NULL){
		emberAfAppPrint("get %s ",idStr);
		if(status == EZSP_SUCCESS){
			emberAfAppPrintln("success,value=0x%04X",value);
		}else{
			emberAfAppPrintln("fail,status=%d",status);
		}
	}
}

void kk_read_ncp_configuration_with_memory_allocation(void)
{
	kk_read_configuration_value(EZSP_CONFIG_BINDING_TABLE_SIZE,"binding table size");

	kk_read_configuration_value(EZSP_CONFIG_KEY_TABLE_SIZE,"key table size");

	kk_read_configuration_value(EZSP_CONFIG_MAX_END_DEVICE_CHILDREN,"max end device children");

	kk_read_configuration_value(EZSP_CONFIG_APS_UNICAST_MESSAGE_COUNT,"aps unicast message count");

	kk_read_configuration_value(EZSP_CONFIG_BROADCAST_TABLE_SIZE,"broadcast table size");

	kk_read_configuration_value(EZSP_CONFIG_NEIGHBOR_TABLE_SIZE,"neighbor table size");
}

void kk_read_ncp_configuration_without_memory_allocation(void)
{
	kk_read_configuration_value(EZSP_CONFIG_END_DEVICE_POLL_TIMEOUT,"end device poll timeout");

	kk_read_configuration_value(EZSP_CONFIG_END_DEVICE_POLL_TIMEOUT_SHIFT,"end device poll timeout shift");
	
	kk_read_configuration_value(EZSP_CONFIG_ZLL_GROUP_ADDRESSES,"zll group addresses");
	
	kk_read_configuration_value(EZSP_CONFIG_ZLL_RSSI_THRESHOLD,"zll rssi threshold");
	
	kk_read_configuration_value(EZSP_CONFIG_TRANSIENT_KEY_TIMEOUT_S,"transient key timeout");
}



extern void kk_print_network_info(void);

void kk_message_process(char *messageString)
{
	if(messageString==NULL) return ;
	uint8_t len = strlen(messageString);

	emberAfAppPrintln("len=%d,messageString=%s",len,messageString);
	if(MEMCOMPARE(messageString,"AT+TXPOWER=",11)==0&&len==15){
		emberAfAppPrint("set txpower = 10\r\n" );
		setTxPower(10);
	}


	if(MEMCOMPARE(messageString,"AT+GETINFO\r\n",len)==0){
		kk_print_network_info();
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//api
/*
void printSourceRouteTable(void)
{
	uint8_t i;
	for (i = 0; i < sourceRouteTableSize; i++) {
		if (sourceRouteTable[i].destination != 0x0000) {
			emberAfCorePrintln("[ind]%x[dest]%2x[closer]%x[older]%x",
								i,
								sourceRouteTable[i].destination,
								sourceRouteTable[i].closerIndex,
								sourceRouteTable[i].olderIndex);
		}
		emberSerialWaitSend(APP_SERIAL);
	}
	emberAfCorePrintln("<print srt>");
	emberSerialWaitSend(APP_SERIAL);
}*/

//设置发射功率
void setTxPower(signed char dBm)
{
	if(emberSetRadioPower(dBm)==EMBER_SUCCESS){
		emberAfCorePrintln("set tx power suc,%d dbm",dBm);
	}else{
		emberAfCorePrintln("out of range,%d dbm",dBm);
	}
}
//clu cmd.clu=0x0000,cmd = 0x01,未知
/*
void zclBasicGlsCMD(void) {
	zclSimpleClientCommand( ZCL_BASIC_CLUSTER_ID,
							ZCL_GET_LOCALES_SUPPORTED_COMMAND_ID);
}

static void zclBasicGlsrCommand(void) {
	zclSimpleServerCommand( ZCL_BASIC_CLUSTER_ID,
							ZCL_GET_LOCALES_SUPPORTED_RESPONSE_COMMAND_ID);
}

static void zclBasicRtfdCommand(void) {
	zclSimpleClientCommand( ZCL_BASIC_CLUSTER_ID,
							ZCL_RESET_TO_FACTORY_DEFAULTS_COMMAND_ID);
}*/
//








