#ifndef _KK_ZIGBEE_MAP_H_
#define _KK_ZIGBEE_MAP_H_
#include "RPC_API.h"
#include "kk_tsl_common.h"

#define KK_EP(x)						(x)

#define KK_DUMMY_EP						KK_EP(0)
#define KK_PRIMARY_EP					KK_EP(1)

#define KK_DUMMY_CLUSTER_ID				0xffff
#define KK_DUMMY_ATTRIBUTE_ID			0xffff


typedef int (*zigbee_property_set)(jrpc_context * ctx,EmberNodeId node,unsigned char ep,void* data);
typedef int(*kk_zigbee_property_report)(EmberEUI64 eui64,uint8_t EP,EmberAfClusterId clusterId,EmberAfAttributeId attributeId,uint8_t dataType,uint8_t len,uint8_t *data);

typedef struct{
	char* Identity;
	unsigned char endpoint;
	zigbee_property_set zigbee_set;
	unsigned short clusterId;
	unsigned short attributeId;
	kk_zigbee_property_report zigbee_report;
}kk_tsl_zigbee_map_t;

typedef struct{
	char* ProductCode;
	kk_tsl_zigbee_map_t map;
}kk_tsl_zigbee_map_glb_t;


extern kk_tsl_zigbee_map_t g_tsl_zigbee_map[];
extern kk_tsl_zigbee_map_glb_t g_tsl_zigbee_map_glb[];

int kk_get_tsl_index(unsigned char EP,unsigned short clusterId,unsigned short attributeId);
int kk_get_tsl_num(void);
int kk_get_tsl_glb_index(const char *pCode,unsigned char EP,unsigned short clusterId,unsigned short attributeId);
int kk_get_tsl_glb_num(void);

#endif
