#include "kk_tsl_zigbee_map.h"
#include "kk_test.h"
#include "kk_product_code.h"

kk_tsl_zigbee_map_t g_tsl_zigbee_map[] = {
	{"NetChannelState",KK_DUMMY_EP,kk_permit_join,0xffff,0xffff,NULL},
	{"WorkMode",KK_PRIMARY_EP,kk_tsl_set_windowCovering_mode,ZCL_WINDOW_COVERING_CLUSTER_ID,ZCL_MODE_ATTRIBUTE_ID,kk_tsl_report_windowCovering_mode},
	{"Position",KK_PRIMARY_EP,kk_tsl_set_windowCovering_position,ZCL_WINDOW_COVERING_CLUSTER_ID,ZCL_CURRENT_LIFT_PERCENTAGE_ATTRIBUTE_ID,kk_tsl_report_windowCovering_position},
};
	
kk_tsl_zigbee_map_glb_t g_tsl_zigbee_map_glb[] = {
	{"3001","PowerSwitch_1",KK_EP(1),kk_tsl_set_gloabl_OnOff,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID,kk_tsl_report_global_onoff},//开
	{"3002","PowerSwitch_2",KK_EP(2),kk_tsl_set_gloabl_OnOff,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID,kk_tsl_report_global_onoff},//开
	{"3003","PowerSwitch_3",KK_EP(3),kk_tsl_set_gloabl_OnOff,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID,kk_tsl_report_global_onoff},//开
	{"3005","OperationMode",KK_PRIMARY_EP,kk_tsl_set_windowCovering_OperationMode,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID,kk_tsl_report_global_onoff},//开
};

int kk_get_tsl_index(unsigned char EP,unsigned short clusterId,unsigned short attributeId)
{
	int i;
	
	for(i=0;i<sizeof(g_tsl_zigbee_map)/sizeof(kk_tsl_zigbee_map_t);i++){
		if( EP == g_tsl_zigbee_map[i].endpoint &&
			clusterId == g_tsl_zigbee_map[i].clusterId &&
			attributeId == g_tsl_zigbee_map[i].attributeId){
			return i;
		}
	}
	return -1;
}
int kk_get_tsl_glb_index(const char *pCode,unsigned char EP,unsigned short clusterId,unsigned short attributeId)
{
	int i;
	
	for(i=0;i<sizeof(g_tsl_zigbee_map_glb)/sizeof(kk_tsl_zigbee_map_glb_t);i++){
		if( EP == g_tsl_zigbee_map_glb[i].map.endpoint &&
			clusterId == g_tsl_zigbee_map_glb[i].map.clusterId &&
			attributeId == g_tsl_zigbee_map_glb[i].map.attributeId &&
			strstr(g_tsl_zigbee_map_glb[i].ProductCode,pCode)!=NULL){
			return i;
		}
	}
	return -1;
}

int kk_get_tsl_num(void)
{
	return sizeof(g_tsl_zigbee_map) / sizeof(kk_tsl_zigbee_map_t);
}

int kk_get_tsl_glb_num(void)
{
	return sizeof(g_tsl_zigbee_map_glb) / sizeof(kk_tsl_zigbee_map_glb_t);
}


