#ifndef __KK_DEVICE_TABLE_DB_H
#define __KK_DEVICE_TABLE_DB_H

#include "kk_zb_com.h"
#include "kk_test.h"


#define KK_MAX_PRODUCT_CODE_SIZE		33



#define KK_DEVICE_DB_TABLE		"kk_device"
#define KK_DEVICE_DB_FILE		"kk_device.db"



void kk_device_db_init(void);

void kk_device_db_insert(EmberEUI64 mac,EmberNodeId nodeId,uint16_t deviceId,char* productCode);

void kk_device_db_delete(EmberEUI64 mac);
void kk_device_db_update(EmberEUI64 mac,EmberNodeId nodeId,uint16_t deviceId,char* productCode);
bool kk_device_db_check(EmberEUI64 mac);
int kk_device_db_get_num();



kk_device_table_s *kk_get_device_table_pointer(void);

void kk_print_device_table(void);

char * kk_device_find_productCode(EmberEUI64 mac);
kk_device_table_s * kk_device_find_by_mac(EmberEUI64 mac);
void kk_device_table_add(EmberEUI64 mac,EmberNodeId nodeId,const char *productCode,uint16_t deviceId);

void kk_device_table_delete(EmberEUI64 mac);

void kk_add_device_to_table(EmberEUI64 mac,EmberNodeId nodeId,uint16_t deviceId);
















#endif


