#include "kk_tsl_zigbee_map.h"
#include "kk_test.h"

kk_tsl_zigbee_map_t g_tsl_zigbee_map [] = {
	{
		TEST_PRODUCT_CODE,
		3,
		{
			{KK_TSL_DATA_TYPE_TEXT,"OperationMode",lightStatusSet,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID},
			{KK_TSL_DATA_TYPE_TEXT,"WorkMode",lightStatusSet,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID},
			{KK_TSL_DATA_TYPE_TEXT,"Position",lightStatusSet,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID},
		}
	},
	{
		"testtype",
		4,
		{
			{KK_TSL_DATA_TYPE_TEXT,"test1",lightStatusSet,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID},
			{KK_TSL_DATA_TYPE_TEXT,"test12",lightStatusSet,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID},
			{KK_TSL_DATA_TYPE_TEXT,"test123",lightStatusSet,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID},
			{KK_TSL_DATA_TYPE_TEXT,"test1234",lightStatusSet,ZCL_ON_OFF_CLUSTER_ID,ZCL_ON_OFF_ATTRIBUTE_ID},		
		}
	},	

};

int kk_find_ctrl_obj(const char *productCode)
{
	int map_num = sizeof(g_tsl_zigbee_map) / sizeof(kk_tsl_zigbee_map_t);
	int index = 0;
	for(index = 0;index < map_num; index++)
	{
		if(!strcmp(productCode,g_tsl_zigbee_map[index].productCode))
		{
			return index;
		}
	}
	return -1;
}

int kk_get_Identity_Num(int index)
{
	return g_tsl_zigbee_map[index].num;
}



